/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.ide.ceditor.CEditorArb;
import oracle.javatools.ui.ScrollableSectionView;

final class CodeEditorScrollableSectionView
extends ScrollableSectionView {
    private static final int BASE_GAP = 30;
    private Font font;
    private Stroke stroke;

    public CodeEditorScrollableSectionView(JComponent wrappedComponent) {
        super(wrappedComponent);
    }

    public Dimension getPreferredSize() {
        Dimension parentD = this.getParent().getSize();
        if (this.getWrappedComponent() == null) {
            return parentD;
        }
        Dimension d = this.getWrappedComponent().getPreferredSize();
        if (this.isRestricted()) {
            d.height = Math.min(d.height, this.viewEnd - this.viewStart + 30);
        }
        d.width = Math.max(d.width, parentD.width);
        d.height = Math.max(parentD.height, d.height);
        return d;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isRestricted()) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(UIManager.getColor("Label.disabledForeground"));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.stroke == null) {
                this.stroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{4.0f, 8.0f}, 5.0f);
            }
            g2.setStroke(this.stroke);
            g2.drawLine(0, this.viewEnd - this.viewStart + 2, this.getWidth(), this.viewEnd - this.viewStart + 2);
            if (this.font == null) {
                this.font = UIManager.getFont("Label.font").deriveFont(2);
            }
            g2.setFont(this.font);
            String msg = CEditorArb.getString(42);
            int y = this.viewEnd - this.viewStart + 14;
            g2.drawString(msg, 0, y);
        }
    }
}

