/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.gui.babelfish.AbstractBabelfishUpdater;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.javatools.db.DBException;
import oracle.sql.CLOB;

public class BabelfishUpdaterAction
extends AbstractBabelfishUpdater
implements IRaptorGridUpdater,
IRaptorGridCellUpdated {
    private static final String REGISTER = "BEGIN  dbms_sql_translator.register_sql_translation(:profile,:fingerprint,:template,sys.diutil.int_to_bool(:isEnabled)); END;";
    private static final String DEREGISTER = "BEGIN  dbms_sql_translator.deregister_sql_translation(:profile,:fingerprint); END;";

    public void insertRows(String string, String string2, String string3, String string4, String string5) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        if (string5.equalsIgnoreCase("TRUE")) {
            arrayList.add(1);
        } else {
            arrayList.add(0);
        }
        try {
            this.insertRows(string, arrayList);
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
        }
    }

    @Override
    AbstractBabelfishUpdater.IRowReader getRowReader(RaptorGridRowModel raptorGridRowModel) {
        return new SQLRowReader(raptorGridRowModel);
    }

    @Override
    List<?> getDeregisterBinds(AbstractBabelfishUpdater.IRowReader iRowReader) {
        SQLRowReader sQLRowReader = (SQLRowReader)iRowReader;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(sQLRowReader.getProfile());
        arrayList.add(sQLRowReader.getFingerprint());
        return arrayList;
    }

    @Override
    String getDeregisterSQL() {
        return DEREGISTER;
    }

    @Override
    List<?> getRegisterBinds(AbstractBabelfishUpdater.IRowReader iRowReader) {
        SQLRowReader sQLRowReader = (SQLRowReader)iRowReader;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(sQLRowReader.getProfile());
        arrayList.add(sQLRowReader.getFingerprint());
        arrayList.add(sQLRowReader.getTemplate());
        if (sQLRowReader.isEnabled().equalsIgnoreCase("TRUE") || sQLRowReader.isEnabled().equalsIgnoreCase("")) {
            arrayList.add(1);
        } else {
            arrayList.add(0);
        }
        return arrayList;
    }

    @Override
    String getRegisterSQL() {
        return REGISTER;
    }

    class SQLRowReader
    implements AbstractBabelfishUpdater.IRowReader {
        String _profile;
        String _fingerprint;
        String _template;
        String _isEnabled;

        private SQLRowReader(RaptorGridRowModel raptorGridRowModel) {
            RaptorGridCell raptorGridCell = (RaptorGridCell)raptorGridRowModel.getRow().get(0);
            RaptorGridCell raptorGridCell2 = (RaptorGridCell)raptorGridRowModel.getRow().get(1);
            RaptorGridCell raptorGridCell3 = (RaptorGridCell)raptorGridRowModel.getRow().get(2);
            RaptorGridCell raptorGridCell4 = (RaptorGridCell)raptorGridRowModel.getRow().get(3);
            Object object = raptorGridCell.getCellData();
            Object object2 = raptorGridCell2.getCellData();
            Object object3 = raptorGridCell3.getCellData();
            Object object4 = raptorGridCell4.getCellData();
            this._profile = this.getValue(object);
            if (this._profile == null || this._profile.trim().equals("")) {
                this._profile = (String)BabelfishUpdaterAction.this._parcel.getBindMap().get("NAME");
            }
            this._fingerprint = this.getValue(object2);
            this._template = this.getValue(object3);
            this._isEnabled = this.getValue(object4);
        }

        public String isEnabled() {
            return this._isEnabled;
        }

        public String getFingerprint() {
            return this._fingerprint;
        }

        public String getTemplate() {
            return this._template;
        }

        public Object getProfile() {
            return this._profile;
        }

        private String getValue(Object object) {
            try {
                if (object instanceof CLOB) {
                    return ((CLOB)object).stringValue();
                }
                return object.toString();
            }
            catch (SQLException sQLException) {
                return null;
            }
        }
    }
}

