/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URLDecoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import oracle.aurora.server.tools.loadjava.DropJavaMain;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.babelfish.ABabelfishTask;
import oracle.dbtools.migration.gui.babelfish.InstallSQLTranslatorMenu;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;

public class BabelfishDropTask
extends ABabelfishTask {
    DBObject _node = null;
    String _userName = null;
    String _packageName = null;

    public BabelfishDropTask(String string, DBObject dBObject) {
        super(string);
        this._node = dBObject;
        this._userName = dBObject.getSchemaName();
        this._packageName = dBObject.getObjectName();
    }

    public BabelfishDropTask(String string, boolean bl) {
        super(string, bl);
    }

    public BabelfishDropTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, DBObject dBObject) {
        super(string, bl, iRaptorTaskRunMode);
        this._node = dBObject;
        this._userName = dBObject.getSchemaName();
        this._packageName = dBObject.getObjectName();
    }

    protected Void doWork() throws TaskException {
        boolean bl = false;
        Connection connection = null;
        try {
            connection = this._node.getConnection();
            bl = this.dropJava(connection, this._userName);
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        if (!bl) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)"DropJava Failed");
        }
        return null;
    }

    private boolean dropJava(Connection connection, String string) {
        try {
            String string2 = connection.getMetaData().getURL();
            String string3 = Connections.getInstance().getConnectionName(connection);
            Properties properties = Connections.getInstance().getConnectionInfo(string3);
            String string4 = properties.getProperty("password");
            if (string4 == null) {
                string4 = this.getPassword(SEMessages.format("PasswordRequest", string), true);
            }
            if (string4 == null) {
                Logger.severe(((Object)((Object)this)).getClass(), (String)"no password given for connection to drop java");
            } else {
                String string5 = string + "/" + string4 + "@" + string2.substring(18);
                String[] stringArray = new String[]{"-user", string5, "-thin", "filename"};
                String string6 = InstallSQLTranslatorMenu.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String string7 = URLDecoder.decode(string6, "UTF-8");
                File file = new File(string7);
                File file2 = file.getParentFile().getParentFile();
                String string8 = file2.getAbsolutePath() + "/";
                String string9 = null;
                if (this._packageName.equalsIgnoreCase("db2_sql_fingerprinter")) {
                    string9 = "DB2 SQL Fingerprinter";
                } else if (this._packageName.equalsIgnoreCase("sqlserver_tsql_translator")) {
                    string9 = "SQL Server SQL Translator";
                } else if (this._packageName.equalsIgnoreCase("sybase_tsql_translator")) {
                    string9 = "Sybase SQL Translator";
                }
                String[] stringArray2 = BabelfishDropTask.getJarFiles(string9);
                for (String string10 : stringArray2 = this.makeGenMissingFiles(stringArray2)) {
                    File file3 = new File(string10);
                    if (!file3.exists()) continue;
                    this.getRaptorTaskProgressUpdater().getDescriptor().setMessage("Dropping jar:" + string10);
                    stringArray[3] = file3.getAbsolutePath();
                    DropJavaMain.main((String[])stringArray);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new ByteArrayOutputStream());
                ScriptExecutor scriptExecutor = new ScriptExecutor("DROP PACKAGE " + this._packageName, connection);
                scriptExecutor.setScriptRunnerContext(new ScriptRunnerContext());
                scriptExecutor.setOut(bufferedOutputStream);
                scriptExecutor.run();
            }
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        return true;
    }

    private String[] makeGenMissingFiles(String[] stringArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : stringArray) {
            String string2 = BabelfishDropTask.getInstallHome() + BabelfishDropTask.createMissingFileName(this.getFileName(string));
            arrayList.add(string);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

