/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import javax.ide.util.MetaClass;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.util.ClassUtils;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.common.ModuleContext;

public class LazyDeploymentModuleFactory
implements DeploymentModuleFactory {
    private MetaClass<DeploymentModuleFactory> factoryClass;
    private final String interfaceClass;
    private final String rule;

    public LazyDeploymentModuleFactory(MetaClass<DeploymentModuleFactory> factoryClass, String interfaceClass, String rule) {
        this.factoryClass = factoryClass;
        this.interfaceClass = interfaceClass;
        this.rule = rule;
    }

    @Override
    public DeploymentModule create(Class<?> elementClass, ModuleContext moduleContext) throws DeployException {
        RuleEngine re;
        if (this.interfaceClass != null && !ClassUtils.isInstanceOf(elementClass, (String)this.interfaceClass)) {
            return null;
        }
        if (this.rule != null && !(re = RuleEngine.getInstance()).evaluateRule(this.rule, moduleContext.getDeployShell().getContext())) {
            return null;
        }
        if (this.factoryClass != null) {
            try {
                return ((DeploymentModuleFactory)this.factoryClass.newInstance()).create(elementClass, moduleContext);
            }
            catch (InstantiationException e) {
                this.reportFactoryClassInstantiationException(e);
            }
            catch (IllegalAccessException e) {
                this.reportFactoryClassInstantiationException(e);
            }
            catch (ClassNotFoundException e) {
                this.reportFactoryClassInstantiationException(e);
            }
            this.factoryClass = null;
        }
        return null;
    }

    private void reportFactoryClassInstantiationException(Exception e) throws DeployException {
        throw new DeployException("Unable to instantiate Module Factory class: " + this.factoryClass, e);
    }
}

