/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdeveloper.deploy.Stateful;
import oracle.jdeveloper.deploy.StatefulDeployer;
import oracle.jdeveloper.deploy.common.AbstractStatefulDeployer;
import oracle.jdeveloper.deploy.contrib.Listener;
import oracle.jdeveloper.deploy.eventhub.EventHandler;
import oracle.jdeveloper.deploy.events.DeployerStateChange;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public class SequenceDeployer
extends AbstractStatefulDeployer {
    private Deployer deployer_;
    private boolean hasState_;
    StatefulDeployer.Handle listener_;

    public SequenceDeployer(int deploySequenceId, Deployer deployer) {
        super(deploySequenceId);
        this.deployer_ = deployer;
        this.hasState_ = deployer instanceof Stateful;
    }

    @Override
    protected void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        if (ShellAdapter.getInstance(shell).isStatefulDeployment() && !this.hasState_) {
            throw new DeployException("Stateful deployment not supported by deployer '" + this.deployer_.getClass().getName() + "'");
        }
        this.deployer_.prepare(deploySequenceId, shell);
    }

    @Override
    protected void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        this.deployer_.deploy(deploySequenceId, shell);
    }

    @Override
    protected void finishImpl(int deploySequenceId, DeployShell shell) {
        this.deployer_.finish(deploySequenceId, shell);
    }

    @Override
    protected void cancelImpl(int deploySequenceId, DeployShell shell) {
        this.deployer_.cancel(deploySequenceId, shell);
    }

    public Deployer getDeployer() {
        return this.deployer_;
    }

    @Override
    public String toString() {
        return "<sequenceDeployer>" + super.toString() + "<deployer>" + this.deployer_.toString() + "</deployer></sequenceDeployer>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateState() throws StateException {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.hasState_) {
                ((Stateful)((Object)this.deployer_)).invalidateState();
            }
            super.invalidateState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseState() throws StateException {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.hasState_) {
                ((Stateful)((Object)this.deployer_)).releaseState();
            }
            super.releaseState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeState() throws StateException {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.hasState_) {
                ((Stateful)((Object)this.deployer_)).initializeState();
            }
            super.initializeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addStateChangeListeners() {
        if (!this.hasState_) {
            return;
        }
        Object object = this.stateLockObject();
        synchronized (object) {
            this.listener_ = ((StatefulDeployer)this.deployer_).attachStateChangeListener(new Listener<DeployerStateChange>(){

                @EventHandler
                public void onStateChanged(Object deployer) {
                    SequenceDeployer.this.fireStateChanged();
                }

                @EventHandler
                public void onStateInvalidated(Object deployer) {
                    SequenceDeployer.this.fireStateInvalidated();
                }

                @EventHandler
                public void onStateReleased(Object deployer) {
                    SequenceDeployer.this.fireStateReleased();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeStateChangeListeners() {
        if (!this.hasState_) {
            return;
        }
        Object object = this.stateLockObject();
        synchronized (object) {
            this.listener_.release();
        }
    }
}

