/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.pattern.ChainOfR;
import oracle.jdevimpl.deploy.fwk.UpgradableDeployerFactory;
import oracle.jdevimpl.deploy.res.FwkArb;

public class DeployerFactoryStore
implements Copyable {
    ChainOfR<String, DeployerFactory, RequestProperties> impl_ = new ChainOfR(new DeployerFactoryFinder());

    public void addFactory(String clazz, String parentClazz, CustomMetaClass<DeployerFactory> factory) throws MetadataException {
        try {
            this.impl_.add(clazz, parentClazz, new UpgradableDeployerFactory(factory));
        }
        catch (ChainOfR.DuplicateIndexException e) {
            throw new MetadataException(FwkArb.format(0, clazz));
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(2, e.getMessage()));
        }
    }

    public void upgradeFactory(String clazz, CustomMetaClass<DeployerFactory> factoryClazz) throws MetadataException {
        try {
            UpgradableDeployerFactory currentFactory = (UpgradableDeployerFactory)this.impl_.get(clazz);
            currentFactory.upgradeFactory(factoryClazz);
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(1, clazz));
        }
    }

    public Deployer findDeployer(String clazz, int deploySequenceId, DeployShell shell) throws Exception {
        RequestProperties reqProps = new RequestProperties(deploySequenceId, shell);
        try {
            if (this.impl_.handle(clazz, reqProps)) {
                return reqProps.deployer_;
            }
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(3, clazz));
        }
        return null;
    }

    public String getParentClass(String clazz) throws MetadataException {
        try {
            return this.impl_.getParentLabel(clazz);
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException(FwkArb.format(1, clazz));
        }
    }

    public Deployer findDeployerFromParent(String clazz, int deploySequenceId, DeployShell shell) throws Exception {
        String parent = this.impl_.getParentLabel(clazz);
        if (parent == null) {
            return null;
        }
        return this.findDeployer(clazz, deploySequenceId, shell);
    }

    public DeployerFactoryStore copyTo(Object target) {
        if (target == null) {
            target = new DeployerFactoryStore();
        }
        return this.copyToImpl(target);
    }

    protected DeployerFactoryStore copyToImpl(Object target) {
        DeployerFactoryStore copy = (DeployerFactoryStore)target;
        this.impl_.copyTo(copy.impl_);
        return copy;
    }

    public void reset() {
        this.impl_.purge();
    }

    private static class DeployerFactoryFinder
    implements ChainOfR.RequestHandler<DeployerFactory, RequestProperties> {
        private DeployerFactoryFinder() {
        }

        @Override
        public boolean handle(DeployerFactory factory, RequestProperties reqDep) {
            reqDep.deployer_ = factory.newDeployer(reqDep.deploySequenceId_, reqDep.shell_);
            return reqDep.deployer_ != null;
        }
    }

    private static class RequestProperties {
        String request_;
        Deployer deployer_ = null;
        int deploySequenceId_;
        DeployShell shell_;

        RequestProperties(int deploySequenceId, DeployShell shell) {
            this.deploySequenceId_ = deploySequenceId;
            this.shell_ = shell;
        }
    }
}

