/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.spi.providers;

import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.HashProfileReader;
import oracle.jdeveloper.deploy.spi.HashProfileWriter;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class AbstractHashProfileIOProvider
extends AbstractToolkitProvider {
    public AbstractHashProfileIOProvider() {
        super(DefaultHashProfileIO.class);
    }

    public AbstractHashProfileIOProvider(Class<? extends Toolkit> intf) {
        super(intf);
    }

    @Override
    public AbstractToolkitBuilder create(ToolkitContext tkContext) {
        Cookie cookie;
        HashProfileWriter.SpiData spi;
        Profile profile;
        final Element element = tkContext.getElement();
        Class classOrIntf = tkContext.getToolkitClass();
        if (classOrIntf.isAssignableFrom(HashProfileReader.class)) {
            HashProfileReader.SpiData spi2 = HashProfileReader.SpiData.getInstance(tkContext.getIdeContext());
            final HashStructure hash = spi2.getHashStructure();
            if (hash == null) {
                return null;
            }
            final Cookie cookie2 = new Cookie();
            if (this.canRead(element, hash, tkContext, cookie2)) {
                return new AbstractToolkitBuilder(this, tkContext){

                    @Override
                    protected Toolkit build() {
                        return new DefaultHashProfileIO(element, hash, cookie2);
                    }
                };
            }
        } else if (classOrIntf.isAssignableFrom(HashProfileWriter.class) && this.canWrite(element, profile = (spi = HashProfileWriter.SpiData.getInstance(tkContext.getIdeContext())).getProfile(), tkContext, cookie = new Cookie())) {
            return new AbstractToolkitBuilder(this, tkContext){

                @Override
                protected Toolkit build() {
                    return new DefaultHashProfileIO(element, profile, cookie);
                }
            };
        }
        return null;
    }

    protected abstract boolean canRead(Element var1, HashStructure var2, ToolkitContext var3, Cookie var4);

    protected abstract boolean canWrite(Element var1, Profile var2, ToolkitContext var3, Cookie var4);

    protected abstract Profile read(Element var1, HashStructure var2, Cookie var3);

    protected abstract String getName(Element var1, HashStructure var2, Cookie var3);

    protected abstract void write(Element var1, Profile var2, HashStructure var3, Cookie var4);

    protected class DefaultHashProfileIO
    implements HashProfileReader,
    HashProfileWriter {
        final HashStructure hash_;
        final Element element_;
        final Profile profile_;
        final Cookie cookie_;

        DefaultHashProfileIO(Element element, Profile profile, Cookie cookie) {
            this.hash_ = null;
            this.element_ = element;
            this.profile_ = profile;
            this.cookie_ = cookie;
        }

        DefaultHashProfileIO(Element element, HashStructure hash, Cookie cookie) {
            this.hash_ = hash;
            this.cookie_ = cookie;
            this.element_ = element;
            this.profile_ = null;
        }

        @Override
        public Profile read() {
            return AbstractHashProfileIOProvider.this.read(this.element_, this.hash_, this.cookie_);
        }

        @Override
        public String getName() {
            return AbstractHashProfileIOProvider.this.getName(this.element_, this.hash_, this.cookie_);
        }

        @Override
        public void write(HashStructure hash) {
            AbstractHashProfileIOProvider.this.write(this.element_, this.profile_, hash, this.cookie_);
        }
    }
}

