/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.PrintWriter;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdevimpl.deploy.logging.DeployLogOutputStream;

public final class DeployShell
extends Namespace {
    private static final String CONTEXT_KEY = Context.class.getName();
    private static final String DEPLOY_LOGGER_KEY = "Deploy.Logger";
    private static final String DEPLOY_EXCEPTION_KEY = "Deploy.Exception";
    static final String SEQUENCE_STACK_KEY = "Deployment.SequenceStack";

    public DeployShell(Context context, Logger logger) {
        this.setContext(context);
        this.setLogger(logger);
    }

    public DeployShell(DeployShell shell) {
        super((Namespace)shell);
    }

    public DeployShell getRoot() {
        return (DeployShell)super.getRoot();
    }

    public boolean getFlag(String flag) {
        return Boolean.TRUE.equals(this.get(flag));
    }

    public boolean findFlag(String flag) {
        return Boolean.TRUE.equals(this.find(flag));
    }

    public void put(String key, Object data) {
        super.put(key, data);
    }

    public void setContext(Context context) {
        this.put(CONTEXT_KEY, context);
    }

    public Context getContext() {
        Context context = (Context)this.find(CONTEXT_KEY);
        return context;
    }

    public void setLogger(Logger logger) {
        this.put(DEPLOY_LOGGER_KEY, logger);
    }

    public Logger getLogger() {
        return (Logger)this.find(DEPLOY_LOGGER_KEY);
    }

    @Deprecated
    public PrintWriter getLog() {
        Assert.printStackTrace((boolean)Boolean.getBoolean("deployment.deprecated"), (String)"Use of obsolete method, this will be deleted in Sherman");
        return new PrintWriter(new DeployLogOutputStream(this.getLogger()), true);
    }

    public void setDeployException(DeployException exc) {
        this.put(DEPLOY_EXCEPTION_KEY, exc);
    }

    public DeployException getDeployException() {
        return (DeployException)this.find(DEPLOY_EXCEPTION_KEY);
    }

    @Deprecated
    public SequenceStack getSequenceStack() {
        SequenceStack stack = (SequenceStack)this.find(SEQUENCE_STACK_KEY);
        if (stack == null) {
            stack = new SequenceStack();
            this.getRoot().put(SEQUENCE_STACK_KEY, stack);
        }
        return stack;
    }

    @Deprecated
    public boolean isDeploying(int sequence) {
        return this.getSequenceStack().find(sequence) >= 0;
    }

    @Deprecated
    public boolean isDeploying(int[] sequences) {
        SequenceStack stack = this.getSequenceStack();
        int[] internalSequences = stack.getStack();
        int j = 0;
        for (int i = 0; i < sequences.length; ++i) {
            boolean found = false;
            for (int k = j; k < internalSequences.length; ++k) {
                if (internalSequences[k] != sequences[i]) continue;
                j = k + 1;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static class SequenceStack {
        static final int MAX_STACK_SIZE = 1024;
        int[] stack_ = new int[256];
        int len_ = 0;

        public void push(int i) {
            if (this.len_ == this.stack_.length) {
                this.grow();
            }
            this.stack_[this.len_] = i;
            ++this.len_;
        }

        public int pop() {
            --this.len_;
            if (this.len_ < 0) {
                throw new ArrayIndexOutOfBoundsException("DeploySequence stack underflow");
            }
            return this.stack_[this.len_];
        }

        private void grow() {
            if (this.stack_.length == 1024) {
                throw new ArrayIndexOutOfBoundsException("DeploySequence stack overflow");
            }
            int[] newstack_ = new int[Math.min(this.len_ * 2, 1024)];
            System.arraycopy(this.stack_, 0, newstack_, 0, this.stack_.length);
            this.stack_ = newstack_;
        }

        public int find(int sequence) {
            for (int i = 0; i < this.len_; ++i) {
                if (this.stack_[i] != sequence) continue;
                return i;
            }
            return -1;
        }

        public int getLength() {
            return this.len_;
        }

        public int[] getStack() {
            int[] copy = new int[this.len_];
            System.arraycopy(this.stack_, 0, copy, 0, this.len_);
            return copy;
        }
    }
}

