/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;

public class OracleIdentifierValidator {
    static String anonBlock2 = "declare   x varchar2 (100) := ' Hello World';   Function foo (Y VARCHAR2) RETURN VARCHAR2 IS  begin       return 'in foo ' || Y;    end foo;  begin   ? := foo ( ? )  || x ;end;";
    static String anonBlock3 = "DECLARE    MAX_IDENTIFIER_LEN NUMBER:= 128;   C_DISALLOWED_CHARS   CONSTANT NVARCHAR2(100) := ' .@`!\"%^&*()-+=[]{};:,.<>?/~|'''||UNISTR('\\00A3') ;    TYPE  C_DISALLOWED_SCHEMAS IS VARRAY(6) OF VARCHAR2(10);   SCHEMA_NAMES  C_DISALLOWED_SCHEMAS := C_DISALLOWED_SCHEMAS('SYSTEM', 'SYS', 'SYSMAN', 'DBSNMP', 'OWBSYS', 'WMSYS');      FUNCTION removeQuotes(p_work VARCHAR2) RETURN VARCHAR2 IS     v_firstChar NCHAR(1);     v_lastChar NCHAR(1);     v_quote NCHAR(200):= '\"[]';      v_work NVARCHAR2(4000) := p_work;  BEGIN     v_firstChar := SUBSTR(v_work,1,1);     v_lastChar  := SUBSTR(v_work,LENGTH(v_work),1);     if INSTR(v_quote, v_firstChar) > 0 THEN         v_work := SUBSTR(v_work, 2);         if INSTR(v_quote, v_lastChar) > 0 THEN             v_work := SUBSTR(v_work,0,LENGTH(v_work)-1);             return v_work;          END IF;          return v_work;     END IF;     return v_work;  END removeQuotes;      FUNCTION lTrimNonAlphaNumeric(p_work NVARCHAR2) RETURN NVARCHAR2  IS \tv_testChar VARCHAR2(2000); \tv_index NUMBER; \tv_work NVARCHAR2(4000):=p_work; \tv_forbiddenChars VARCHAR2(100); \tv_firstgoodchar NUMBER;  BEGIN \tv_forbiddenChars := C_DISALLOWED_CHARS ||'_$#';  \tFOR v_index in 1..LENGTH(v_work) LOOP \t\tv_testChar := SUBSTR(p_work, v_index, 1); \t\tIF INSTR(v_forbiddenChars, v_testChar) <= 0 THEN \t\t\t\tv_firstgoodchar := v_index; \t\tEXIT; \t\tEND IF; \tEND LOOP; \treturn substr(p_work,v_firstgoodchar);  END lTrimNonAlphaNumeric;    FUNCTION getDisallowedCharsNames(p_work NVARCHAR2) RETURN VARCHAR2 IS     v_work VARCHAR2(10000) := p_work;  BEGIN     v_work := ( CASE p_work     WHEN '.' THEN 'DOT'     WHEN '@' THEN 'AT'     WHEN '`' THEN 'APOSTROPHE'     WHEN '!' THEN 'EXCLAMATION'     WHEN '\"' THEN 'D_QUOTE'     WHEN '%' THEN 'PERCENT'     WHEN '^' THEN 'CARET'     WHEN '&' THEN 'AMPERSAND'     WHEN '*' THEN 'STAR'     WHEN '(' THEN 'LEFTPARENTHESIS'     WHEN ')' THEN 'RIGHTPARANTHESIS'     WHEN '-' THEN 'MINUS'     WHEN '+' THEN 'PLUS'     WHEN '=' THEN 'EQUAL'     WHEN '[' THEN 'LEFTSQUARE_B'     WHEN ']' THEN 'RIGHTSQUARE_B'     WHEN '{' THEN 'LEFTCURLY_B'     WHEN '}' THEN 'RIGHTCURLY_B'     WHEN ';' THEN 'COLON'     WHEN ':' THEN 'SEMICOLON'     WHEN ',' THEN 'COMMA'     WHEN '<' THEN 'LESSTHAN'     WHEN '>' THEN 'GREATERTHAN' \t WHEN '?' THEN 'QUESTIONMARK'     WHEN '~' THEN 'TILDE'     WHEN '/' THEN 'BACKSLASH'     WHEN '''' THEN 'S_QUOTE'     WHEN '$' THEN 'DOLLAR'     ELSE 'UNKNOWN'     END);     return v_work;  END  getDisallowedCharsNames;    FUNCTION getNameForNullCase(p_work NVARCHAR2) RETURN NVARCHAR2 IS     v_work VARCHAR2(10000);     v_testChar VARCHAR2(2000);     v_index NUMBER;  BEGIN     FOR v_index in 1..LENGTH(p_work) LOOP         v_testchar := SUBSTR(p_work,v_index,1);         v_work := v_work || getDisallowedCharsNames(v_testchar);     END LOOP;     return v_work;  END getNameForNullCase;    FUNCTION first_char_check(p_work NVARCHAR2) RETURN NVARCHAR2 IS \tv_firstChar NCHAR(1); \tv_allowed NCHAR(2000);  BEGIN \tv_allowed := C_DISALLOWED_CHARS || '0123456789_$#'; \tv_firstChar := SUBSTR(p_work,1,1); \tif INSTR(v_allowed, v_firstChar) > 0 THEN \t\treturn 'A' ||p_work; \tEND IF; \treturn p_work;  END first_char_check;    FUNCTION check_allowed_chars(p_work NVARCHAR2) RETURN NVARCHAR2 IS \tv_testChar VARCHAR2(10000); \tv_index NUMBER; \tv_forbiddenChars NVARCHAR2(100) := C_DISALLOWED_CHARS; \tv_work VARCHAR2(4000) := p_work; \tv_endswithunderscore boolean := FALSE;  BEGIN \tIF INSTR('_',SUBSTR(p_work, LENGTH(p_work))) >0 THEN \t\tv_endswithunderscore := TRUE; \tEND IF; \tFOR v_index in 1..LENGTH(v_work) LOOP \t\tv_testChar := SUBSTR(p_work, v_index, 1); \t\t\tIF v_testChar = '_' THEN \t\t\t\tv_work :=SUBSTR(v_work,1,v_index-1)||'!' || SUBSTR(v_work,v_index+1); \t\t\tELSIF INSTR(v_forbiddenChars, v_testChar) > 0 THEN \t\t\t\tv_work := SUBSTR(v_work, 1, v_index-1) || '_' || SUBSTR(v_work, v_index+1); \t\t\tEND IF; \tEND LOOP;   \tv_work := replace(replace (replace (v_work,'__','_'),'__','_'),'__','_'); \tv_work := replace(v_work,'!_','_'); \tv_work := replace(v_work,'_!','_');  \tv_work := replace(v_work,'!','_'); \tIF v_endswithunderscore=false AND INSTR('_',SUBSTR(v_Work,LENGTH(v_work))) > 0 THEN \t\tv_work := SUBSTR(v_work,0,LENGTH(v_work)-1); \tEND IF; \treturn v_work;  END check_allowed_chars;    FUNCTION truncateStringByteSize(p_work VARCHAR2, p_bsize NUMBER) RETURN VARCHAR2 IS     v_work VARCHAR2(10000);     v_bsize NUMBER(10);  BEGIN     IF LENGTHB(p_work) <= p_bsize THEN         return p_work;     END IF;     v_work := p_work;     v_work := SUBSTRB(v_work, 1, p_bsize);     WHILE INSTRC(p_work, v_work , 1, 1) <> 1 LOOP         BEGIN             v_bsize := LENGTHB(v_work);             v_work := SUBSTRB(v_work, 1, v_bsize-1);         END;     END LOOP;      return v_work;  END truncateStringByteSize;    FUNCTION check_identifier_length(p_ident VARCHAR2) RETURN VARCHAR2 IS \tv_work VARCHAR2(10000);  BEGIN \treturn truncateStringByteSize(p_ident,  MAX_IDENTIFIER_LEN);  END;        FUNCTION add_suffix(p_work VARCHAR2, p_suffix VARCHAR2, p_maxlen NUMBER) RETURN VARCHAR2 IS    v_suflen NUMBER := LENGTHB(p_suffix);     v_truncamount NUMBER;     BEGIN         IF LENGTHB(p_work) < p_maxlen - v_suflen THEN             RETURN p_work || p_suffix;         END IF;     v_truncamount := LENGTHB(p_work) + v_suflen - p_maxlen;     RETURN truncateStringByteSize(p_work, LENGTHB(p_work)-v_truncamount) || p_suffix;  END add_suffix;    FUNCTION check_reserved_word(p_work VARCHAR2) RETURN VARCHAR2  IS \tv_count NUMBER := 0;  BEGIN \tSELECT COUNT(*) INTO v_count FROM ( select column_value KEYWORD from table(sys.dbms_debug_vc2coll( \t\t'SHARE', 'LEVEL','RAW', 'DROP','BETWEEN', 'FROM','DESC', 'OPTION','PRIOR', 'LONG','THEN', 'DEFAULT','ALTER', 'IS','INTO', 'MINUS','SMALLINT','WITH', 'DELETE', \t\t'INTEGER', 'NUMBER','GRANT', 'IDENTIFIED','ALL', 'TO','ORDER', 'ON','FLOAT', 'DATE','HAVING', 'CLUSTER','NOWAIT', 'RESOURCE','ANY', 'TABLE','INDEX', 'FOR', \t\t'BY', 'ASC','REVOKE', 'LIKE','SIZE', 'RENAME','NOCOMPRESS', 'NULL','GROUP', 'VALUES','AS', 'IN','VIEW', 'EXCLUSIVE', 'UPDATE', 'WHERE','CHECK',  \t\t'COMPRESS', 'SYNONYM','SELECT', 'INSERT','EXISTS', 'NOT','TRIGGER', 'ELSE','CREATE', 'INTERSECT','PCTFREE', 'DISTINCT','CONNECT', 'SET','MODE', 'OF', \t\t'UNIQUE', 'VARCHAR2','VARCHAR', 'LOCK','OR', 'CHAR','DECIMAL', 'UNION','PUBLIC', 'AND','START', 'USER','VALIDATE', 'COMMENT','UID', 'ROWNUM', \t\t'AUDIT', 'ACCESS','FILE', 'OFFLINE','SESSION','PRIVILEGES','ADD','COLUMN','CURRENT','IMMEDIATE','INCREMENT','INITIAL','MAXEXTENTS','MLSLABEL','MODIFY', \t\t'NOAUDIT','ONLINE','ROW','ROWID','ROWS','SUCCESSFUL','SYSDATE','WHENEVER','COMMIT','EXCEPTION','WHEN OTHERS THEN', 'ROLLBACK','RAISE_APPLICATION_ERROR(-20001,SQLERRM)','END', \t\t'/' )) )    WHERE KEYWORD = UPPER(p_work);  IF v_count > 0 THEN  RETURN add_suffix(p_work, '_', MAX_IDENTIFIER_LEN);  END IF;  RETURN p_work;  END check_reserved_word;      FUNCTION sys_check(p_work VARCHAR2) RETURN VARCHAR2 IS \tBEGIN \t\tIF LENGTH(p_work) < 4 THEN \t\t\treturn p_work; \t\tEND IF; \t\tIF SUBSTR(p_work, 1, 4) <> 'SYS_' THEN \t\t\treturn p_work; \t\tEND IF; \t\tRETURN 'SIS_' || SUBSTR(p_work, 5);  END sys_check;    FUNCTION checkForSchemaNames(p_work NVARCHAR2) RETURN NVARCHAR2  IS      v_work VARCHAR2(4000);   BEGIN     FOR i in SCHEMA_NAMES.FIRST .. SCHEMA_NAMES.FIRST     LOOP         IF SCHEMA_NAMES(i) = p_work THEN             v_work := p_work || '_'  ;         ELSE              v_work := p_work ;         END IF;     END LOOP;     return v_work;  END checkForSchemaNames;    FUNCTION transform_identifier(p_identifier VARCHAR2)  RETURN VARCHAR2\tIS \tv_work VARCHAR2(10000);  BEGIN \tv_work := p_identifier; \tv_work := removeQuotes(v_work); \tv_work := lTrimNonAlphaNumeric(v_work);\tIF v_work is null THEN\t\tv_work := getNameForNullCase(p_identifier);\t\tEND IF;  \tv_work := first_char_check(v_work); \tv_work := check_allowed_chars(v_work); \tv_work := check_identifier_length(v_work);    v_work := check_reserved_word(v_work); \tv_work := sys_check(v_work); \tv_work := checkForSchemaNames(v_work); \treturn v_work;  END transform_identifier;      BEGIN    ? := transform_identifier ( ? ) ;  END ; ";
    private static CloudMigrationController cloudMigrationController;
    private static CloudMigrationModel uimodel;

    public OracleIdentifierValidator(CloudMigrationModel cloudMigrationModel) {
        uimodel = cloudMigrationModel;
        cloudMigrationController = CloudMigrationController.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOraclelizedName(String string) throws ConnectionException, SQLException, DBException {
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = null;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(uimodel.getTargetConnection());
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(anonBlock3);
            oracleCallableStatement.registerOutParameter(1, 12, "VARCHAR2");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.execute();
            string2 = oracleCallableStatement.getOracleObject(1).stringValue();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement = null;
            }
        }
        return string2;
    }

    public void oraclelizeRedshiftSchemas() throws Exception {
        Object object = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = this.getExistingTargetSchemas();
        cloudMigrationController.removePreviouslyDeployedSchemas();
        String[] stringArray = uimodel.getSelectedSchemas();
        if (stringArray != null && stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            String string2 = this.getOraclelizedName(string);
            if (arrayList4.contains(string2.toUpperCase())) {
                cloudMigrationController.addToPreviouslyDeployedSchema(string);
                arrayList.add(string);
            } else {
                cloudMigrationController.addNewDeployedSchema(string2);
                arrayList2.add(string);
            }
            cloudMigrationController.removeFromSelectedSchemas(string);
            arrayList3.add(string);
            cloudMigrationController.addToSelectedSchemas(string);
        }
        String[] stringArray2 = new String[arrayList.size()];
        if (arrayList.size() > 0) {
            object = "[ ";
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                object = (String)object + (String)arrayList.get(i) + ", ";
                stringArray2[i] = (String)arrayList.get(i);
            }
            object = (String)object + (String)arrayList.get(arrayList.size() - 1) + " ] ";
            Boolean bl = cloudMigrationController.isMigrationNow();
            if (bl.booleanValue()) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)CloudMigrationsResources.format("PREVIOUSLY_DEPLOYED_SCHEMAS", object), (String)CloudMigrationsResources.format("UILOGGER_REDSHIFT_ADWC_MIGRATION", new Object[0]), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getExistingTargetSchemas() throws ConnectionException, SQLException, DBException {
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = Connections.getInstance().getUniqueConnection(uimodel.getTargetConnection());
        try {
            DBUtil dBUtil;
            if (Connections.getInstance().lock(connection) && (resultSet = (dBUtil = DBUtil.getInstance((Connection)connection)).executeOracleQuery("SELECT username from sys.all_users", null)) != null) {
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                resultSet.close();
            }
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        return arrayList;
    }
}

