/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.core.utils.SecurePasswordGenerator;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.preferences.CloudMigrationOptions;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.migration.cloud.ui.validate.DWCSConnectionValidationException;
import oracle.dbtools.migration.cloud.ui.validate.DWCSPasswordValidationException;
import oracle.dbtools.migration.cloud.ui.validate.DWCSProcessChoiceMissingValidationException;
import oracle.dbtools.migration.cloud.ui.validate.LocalScriptDirectoryValidationException;
import oracle.dbtools.migration.cloud.ui.validate.Validator;
import oracle.dbtools.migration.cloud.ui.widgets.CheckBoxCardLayoutPanel;
import oracle.dbtools.migration.cloud.ui.wizard.CloudMigrationWizardPanel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.OracleIdentifierValidator;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.HyperlinkButton;

public class DWCSPagePanel
extends CloudMigrationWizardPanel {
    private static final String SQLDEV_MIGRATION_REPOSITORY_NAME = "SQLDEV_MIGREPOS";
    private static final String GENERATE_SCRIPT = "GENERATE_SCRIPT";
    private static final String DONOT_GENERATE_SCRIPT = "DONOT_GENERATE_SCRIPT";
    private static final String PREFERENCES_CLOUD_MIGRATION_LABEL = "Cloud Migrations";
    private static final String PREFERENCES_MIGRATION_LABEL = "Migration";
    private static final String PREFERENCES_AWS_REDSHIFT_LABEL = "AWS Redshift";
    private static final String REDACTED_STRING = "***********";
    private static final boolean DEBUG = false;
    JLabel thirdPartyDataSourceLabel;
    JLabel sqlDevRepositoryCreationLabel;
    ConnectionPanelUI dwcsConnPanel = null;
    private static CloudMigrationController cloudMigrationController;
    private JTextField directoryTextField;
    private JPanel offlineDirPanel = null;
    private JPanel migrationNowPanel = null;
    private JPanel migrationOptionPanel = null;
    private JPanel repositoryCreationNotePanel = null;
    private JPanel preferencePanel = null;
    private HyperlinkButton advancedPreferenceHyperlinkButton = null;
    private JPanel adwcPasswordPanel = null;
    private JPanel sqldevMigrationRepositoryDropPanel = null;
    private JPanel migrationRepositoryOptionPanel = null;

    @Override
    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    @Override
    protected void initGui() {
        cloudMigrationController = CloudMigrationController.getInstance();
        try {
            this.thirdPartyDataSourceLabel = new JLabel(this.nls("DWCS_TARGET_LABEL"));
            Font font = this.thirdPartyDataSourceLabel.getFont();
            Font font2 = new Font(font.getFontName(), 1, font.getSize());
            this.thirdPartyDataSourceLabel.setFont(font2);
            String[] stringArray = this.getDWCSConnectionSubType();
            this.dwcsConnPanel = new ConnectionPanelUI(stringArray, false);
            this.dwcsConnPanel.setConnectionPrompt(this.nls("DWCS_CONNECTIONS"));
            this.dwcsConnPanel.addComboListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
                    if (string != null) {
                        cloudMigrationController.setDWCSConnection(string);
                    }
                }
            });
            cloudMigrationController.setDWCSConnection(this.dwcsConnPanel.getConnectionName());
            int n = 0;
            JPanel jPanel = LayoutControl.GBC.createPanel();
            jPanel.add((Component)this.thirdPartyDataSourceLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel.add((Component)this.dwcsConnPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.repositoryCreationNotePanel = this.repositoryNodeCreationPanel();
            jPanel.add((Component)this.repositoryCreationNotePanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
            cloudMigrationController.setDWCSMetadataRepository(SQLDEV_MIGRATION_REPOSITORY_NAME);
            this.migrationRepositoryOptionPanel = this.migrationRepositoryOptionPanel();
            jPanel.add((Component)this.migrationRepositoryOptionPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            this.migrationOptionPanel = this.migrationOptionPanel();
            jPanel.add((Component)this.migrationOptionPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
            this.add(LayoutControl.GBC.createWizardPanel((Component)jPanel));
        }
        catch (Throwable throwable) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)throwable);
        }
    }

    @Override
    protected void updateUIFromModel(CloudMigrationModel cloudMigrationModel) {
    }

    @Override
    protected void updateModelFromUI(CloudMigrationModel cloudMigrationModel) {
    }

    @Override
    protected void updateModelFromController(CloudMigrationController cloudMigrationController) {
    }

    private DefaultComboBoxModel<String> getProjectComboBoxModel() {
        return Utilities.createFakeProjectsComboBoxModel(6);
    }

    private String[] getDWCSConnectionSubType() {
        String[] stringArray = Connections.getInstance().getConnNames();
        Properties properties = null;
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = null;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                properties = Connections.getInstance().getConnectionInfo(string2);
                string = properties.getProperty("subtype");
                if (!"oraJDBC".equals(string)) continue;
                arrayList.add(string);
            }
        }
        if (arrayList.isEmpty()) {
            return new String[1];
        }
        stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    @Override
    protected void validatePage(TraversableContext traversableContext) throws TraversalException {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)traversableContext.get(CloudMigrationModel.KEY));
        this.validateDWCSConnection(cloudMigrationModel);
        this.validateADWCPassword(cloudMigrationModel);
        this.validateLocalScriptDirectory(cloudMigrationModel);
        this.validateMigrationProcessChoice(cloudMigrationModel);
        this.validateOracleIdentifier(cloudMigrationModel);
    }

    private void validateOracleIdentifier(CloudMigrationModel cloudMigrationModel) throws TraversalException {
        OracleIdentifierValidator oracleIdentifierValidator = new OracleIdentifierValidator(cloudMigrationModel);
        try {
            oracleIdentifierValidator.oraclelizeRedshiftSchemas();
        }
        catch (Exception exception) {
            throw new TraversalException(exception.getMessage());
        }
    }

    private void validateMigrationProcessChoice(CloudMigrationModel cloudMigrationModel) throws DWCSProcessChoiceMissingValidationException {
        String string = cloudMigrationModel.getString("SCRIPT_DOWNLOAD_DIRECTORY_KEY");
        boolean bl = cloudMigrationModel.getBoolean("REDSHIFT_MIGRATION_DO_NOW_KEY");
        if (!bl && string.equals("")) {
            throw new DWCSProcessChoiceMissingValidationException(this.nls("VALIDATION_ERROR_PROCESS_MIGRATION_NO_VALID_CHOICE"));
        }
    }

    private void validateDWCSConnection(CloudMigrationModel cloudMigrationModel) throws DWCSConnectionValidationException {
        Validator.validateDWCSConnection(cloudMigrationModel.getTargetConnection());
    }

    private void validateLocalScriptDirectory(CloudMigrationModel cloudMigrationModel) throws LocalScriptDirectoryValidationException {
        Validator.validateLocalScriptDirectory(cloudMigrationModel.getString("SCRIPT_DOWNLOAD_DIRECTORY_KEY"));
        if (!this.validateUserTypedFilePath(this.directoryTextField.getText())) {
            throw new LocalScriptDirectoryValidationException(this.nls("VALIDATION_ERROR_LOCAL_SCRIPT_INVALID_DIRECTORY"));
        }
    }

    private JPanel repositoryNodeCreationPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JLabel jLabel = new JLabel(this.nls("DWCS_SQLDEV_MIGRATION_REPOSITORY_LABEL"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        ++n;
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)n);
        return jPanel;
    }

    private JPanel migrationRepositoryOptionPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.nls("DWCS_MIGRATION_REPOSITORY_OPTIONS"));
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setBorder(titledBorder);
        int n = 0;
        this.adwcPasswordPanel = this.createPasswordPanel();
        jPanel.add((Component)this.adwcPasswordPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.sqldevMigrationRepositoryDropPanel = this.createSqldevMigrationRepositoryDropPanel();
        jPanel.add((Component)this.sqldevMigrationRepositoryDropPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel migrationOptionPanel() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.nls("DWCS_MIGRATION_OPTIONS"));
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setBorder(titledBorder);
        int n = 0;
        this.migrationNowPanel = this.doMigrationNowPanel();
        jPanel.add((Component)this.migrationNowPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.offlineDirPanel = this.createScriptGenerationPanel();
        jPanel.add((Component)this.offlineDirPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.preferencePanel = this.getAdvancedPreferencePanel();
        jPanel.add((Component)this.preferencePanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.setCurrentPreferenceSettingsToModel();
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createPasswordPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JLabel jLabel = new JLabel(this.nls("DWCS_MIGRATION_SET_SQLDEV_MIGREPOS_PASSWD"));
        final JPasswordField jPasswordField = new JPasswordField();
        final char c = jPasswordField.getEchoChar();
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPasswordField, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JCheckBox jCheckBox = new JCheckBox(this.nls("DWCS_SHOW_PASSWORD"));
        jPanel.add((Component)jCheckBox, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jCheckBox.setSelected(false);
        cloudMigrationController.showMigrationRepositoryPassword(false);
        cloudMigrationController.setRedactMigrationRepositoryPassword(REDACTED_STRING);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    jPasswordField.setEchoChar('\u0000');
                    cloudMigrationController.showMigrationRepositoryPassword(true);
                } else {
                    jPasswordField.setEchoChar(c);
                    cloudMigrationController.showMigrationRepositoryPassword(false);
                }
            }
        });
        JButton jButton = new JButton(this.nls("DWCS_REGENERATE_PASSWORD"));
        jPanel.add((Component)jButton, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DWCSPagePanel.this.createNewPassword();
                jPasswordField.setText(string);
                cloudMigrationController.setMigrationRepositoryPassword(string);
            }
        });
        jPasswordField.setText(this.createNewPassword());
        cloudMigrationController.setMigrationRepositoryPassword(jPasswordField.getText());
        jPasswordField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setMigrationRepositoryPassword(jPasswordField.getText());
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private String createNewPasswordWithQuotes() {
        return MigrationUtilities.addDoubleQuotes(this.createNewPassword());
    }

    private String createNewPassword() {
        return SecurePasswordGenerator.getRandomPasswd();
    }

    private JPanel createSqldevMigrationRepositoryDropPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JCheckBox jCheckBox = new JCheckBox(this.nls("DWCS_MIGRATION_DROP_SQLDEV_MIGREPOS"));
        jPanel.add((Component)jCheckBox, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jCheckBox.addActionListener(new DropMigreposActionListener());
        if (jCheckBox.isSelected()) {
            cloudMigrationController.dropMigrationRepository(true);
        } else {
            cloudMigrationController.dropMigrationRepository(false);
        }
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel doMigrationNowPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JCheckBox jCheckBox = new JCheckBox(this.nls("DWCS_MIGRATE_NOW"));
        jPanel.add((Component)jCheckBox, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jCheckBox.addActionListener(new MigrateNowActionListener());
        if (jCheckBox.isSelected()) {
            cloudMigrationController.doMigrationNow(true);
        } else {
            cloudMigrationController.doMigrationNow(false);
        }
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel getAdvancedPreferencePanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        this.advancedPreferenceHyperlinkButton = new HyperlinkButton(this.nls("DWCS_MIGRATION_PREFERENCES"));
        jPanel.add((Component)this.advancedPreferenceHyperlinkButton, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        this.advancedPreferenceHyperlinkButton.addActionListener((ActionListener)new AdvancedPreferenceHyperlinkButtonActionListner());
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createOfflineDirChoicePanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JPanel jPanel2 = this.createNoScriptGenerationPanel();
        JPanel jPanel3 = this.createScriptGenerationPanel();
        LinkedHashMap<String, JPanel> linkedHashMap = new LinkedHashMap<String, JPanel>();
        linkedHashMap.put(DONOT_GENERATE_SCRIPT, jPanel2);
        linkedHashMap.put(GENERATE_SCRIPT, jPanel3);
        int n = 0;
        CheckBoxCardLayoutPanel checkBoxCardLayoutPanel = new CheckBoxCardLayoutPanel(linkedHashMap, this.nls("STORE_LOCAL_SCRIPT_DIRECTORY_LABEL"), CheckBoxCardLayoutPanel.Type.PLAIN);
        jPanel.add(checkBoxCardLayoutPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        checkBoxCardLayoutPanel.addActionListener(new CheckBoxActionListener());
        cloudMigrationController.setScriptDownloadDirectory(null);
        cloudMigrationController.setScriptDownloadDirectoryCheckboxState(false);
        this.directoryTextField.setText("");
        this.directoryTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setScriptDownloadDirectory(DWCSPagePanel.this.directoryTextField.getText());
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createEmptyPanel() {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createNoScriptGenerationPanel() {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createScriptGenerationPanel() {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel(this.nls("DWCS_MIGRATE_DIRECTORY"));
        this.directoryTextField = new JTextField();
        JButton jButton = new JButton(this.nls("DWCS_MIGRATE_BROWSE"));
        jButton.addActionListener(new FileBrowserActionListener());
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.directoryTextField, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jButton, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        cloudMigrationController.setScriptDownloadDirectory(CloudMigrationOptions.getPrefenceOutputDirectory());
        this.directoryTextField.setText(CloudMigrationOptions.getPrefenceOutputDirectory());
        this.directoryTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setScriptDownloadDirectory(DWCSPagePanel.this.directoryTextField.getText());
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private boolean validateUserTypedFilePath(String string) {
        File file = new File(string);
        if (!file.exists() || !file.canWrite()) {
            cloudMigrationController.setScriptDownloadDirectory(null);
            this.directoryTextField.setText("");
            return false;
        }
        String string2 = file.getAbsolutePath();
        cloudMigrationController.setScriptDownloadDirectory(string2);
        this.directoryTextField.setText(string2);
        return true;
    }

    private void setCurrentPreferenceSettingsToModel() {
        CloudMigrationOptions cloudMigrationOptions = CloudMigrationOptions.getInstance();
        cloudMigrationController.setSettingARSAddQuotes(this.getBoolean(cloudMigrationOptions.getValue("ARS.ADDQUOTES")));
        cloudMigrationController.setSettingARSIsEscape(this.getBoolean(cloudMigrationOptions.getValue("ARS.ESCAPE")));
        cloudMigrationController.setSettingARSParallel(this.getBoolean(cloudMigrationOptions.getValue("ARS.PARALLEL")));
        cloudMigrationController.setSettingARSEncrypt(this.getBoolean(cloudMigrationOptions.getValue("ARS.ENCRYPT")));
        cloudMigrationController.setSettingARSOverwrite(this.getBoolean(cloudMigrationOptions.getValue("ARS.OVERWRITE")));
        cloudMigrationController.setSettingARSManifest(this.getBoolean(cloudMigrationOptions.getValue("ARS.MANIFEST")));
        cloudMigrationController.setSettingARSMaxFile(this.getBoolean(cloudMigrationOptions.getValue("ARS.MAXFILE")));
        cloudMigrationController.setSettingARSCompressionMethod((String)cloudMigrationOptions.getValue("ARS.COMPRESS"));
        cloudMigrationController.setSettingARSDelimiter((String)cloudMigrationOptions.getValue("ARS.DELIMITER"));
        cloudMigrationController.setSettingARSFixedWidth((String)cloudMigrationOptions.getValue("ARS.FIXEDWIDTH"));
        cloudMigrationController.setSettingARSMaxFileSizeUnit((String)cloudMigrationOptions.getValue("ARS.MAXFILESIZEUNIT"));
        cloudMigrationController.setSettingARSNull((String)cloudMigrationOptions.getValue("ARS.NULL"));
        cloudMigrationController.setSettingARSMaxFileSize(this.getInteger(cloudMigrationOptions.getValue("ARS.MAXFILESIZE")));
        cloudMigrationController.setSettingCPDBlockAsNull(this.getBoolean(cloudMigrationOptions.getValue("CPD.BLKASNULL")));
        cloudMigrationController.setSettingCPDEscape(this.getBoolean(cloudMigrationOptions.getValue("CPD.ESCAPE")));
        cloudMigrationController.setSettingCPDIgnoreBlockLines(this.getBoolean(cloudMigrationOptions.getValue("CPD.IGNBLKLINES")));
        cloudMigrationController.setSettingCPDIgnoreMissingColumns(this.getBoolean(cloudMigrationOptions.getValue("CPD.IGNMISCOLS")));
        cloudMigrationController.setSettingCPDRemoveQuotes(this.getBoolean(cloudMigrationOptions.getValue("CPD.REMQUOTES")));
        cloudMigrationController.setSettingCPDTruncateLongColumns(this.getBoolean(cloudMigrationOptions.getValue("CPD.TRUNCLNGCOLS")));
        cloudMigrationController.setSettingCPDIsFileType(this.getBoolean(cloudMigrationOptions.getValue("CPD.ISFILETYPE")));
        cloudMigrationController.setSettingCPDRecordDelimiter((String)cloudMigrationOptions.getValue("CPD.RECDELIM"));
        cloudMigrationController.setSettingCPD_rejlim(this.getInteger(cloudMigrationOptions.getValue("CPD.REJLIM")));
        cloudMigrationController.setSettingCPDSkipHeaders((String)cloudMigrationOptions.getValue("CPD.SKIPHDRS"));
        cloudMigrationController.setSettingCPDCompress((String)cloudMigrationOptions.getValue("CPD.COMPRESS"));
        cloudMigrationController.setSettingCPDCONVERRS((String)cloudMigrationOptions.getValue("CPD.CONVERRS"));
        cloudMigrationController.setSettingCPDTrimSpaces((String)cloudMigrationOptions.getValue("CPD.TRIMSPACES"));
        cloudMigrationController.setSettingCPDFileType((String)cloudMigrationOptions.getValue("CPD.FILETYPE"));
        cloudMigrationController.setSettingCPDColumnDelimter((String)cloudMigrationOptions.getValue("CPD.COLDELIMITER"));
        cloudMigrationController.setSettingCPDQuote((String)cloudMigrationOptions.getValue("CPD.QUOTE"));
        String string = CloudMigrationOptions.getPrefenceOutputDirectory();
        cloudMigrationController.setScriptDownloadDirectory(string);
        this.directoryTextField.setText(string);
    }

    private final Boolean getBoolean(Object object) {
        return object instanceof String ? Boolean.valueOf((String)object) : (Boolean)object;
    }

    private final Integer getInteger(Object object) {
        return object instanceof String ? Integer.valueOf((String)object) : (Integer)object;
    }

    private void validateADWCPassword(CloudMigrationModel cloudMigrationModel) throws DWCSPasswordValidationException {
        String string = cloudMigrationModel.getString("MIGRATION_REPOSITORY_PASSWORD_KEY");
        int n = string.length();
        if (n < 16 || n >= 30) {
            throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_LENGTH_NOT_VALID"));
        }
        if (this.checkForNoOracleKeyword(string)) {
            throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_CANNOT_CONTAIN_ONE_ORACLE_KEYWORDS"));
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (char c : cArray) {
            if (Character.isLowerCase(c)) {
                bl = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                bl2 = true;
                continue;
            }
            if (Character.isDigit(c)) {
                bl3 = true;
                continue;
            }
            if (c == '\"') {
                throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_CANNOT_CONTAIN_DOUBLE_QUOTE_CHARACTER"));
            }
            if (c < ' ' || c >= '~') continue;
            bl4 = true;
        }
        if (bl && bl2 && bl3 && bl4) {
            bl5 = true;
        }
        if (!bl5) {
            if (!bl) {
                throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_MUST_CONTAIN_LOWERCASE"));
            }
            if (!bl2) {
                throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_MUST_CONTAIN_UPPERCASE"));
            }
            if (!bl3) {
                throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_MUST_CONTAIN_NUMERIC"));
            }
            if (!bl4) {
                throw new DWCSPasswordValidationException(this.nls("VALIDATION_PASSWORD_AT_LEAST_ONE_SPECIAL_CHARACTER"));
            }
        }
    }

    private boolean checkForNoOracleKeyword(String string) {
        return string.toLowerCase().contains("oracle");
    }

    class FileBrowserActionListener
    implements ActionListener {
        FileBrowserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL;
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.clearChooseableURLFilters();
            uRLFileChooser.setSelectionScope(1);
            uRLFileChooser.setSelectionMode(0);
            int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), DWCSPagePanel.this.nls("FILE_BROWSER_HEADER"));
            if (n == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
                File file = new File(uRL.getPath());
                if (!file.exists() || !file.canWrite()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)DWCSPagePanel.this.nls("FILE_BROWSER_INVALID_DIRECTORY"), (String)DWCSPagePanel.this.nls("FILE_BROWSER_HEADER"), null);
                } else {
                    String string = file.getAbsolutePath();
                    cloudMigrationController.setScriptDownloadDirectory(string);
                    DWCSPagePanel.this.directoryTextField.setText(string);
                }
            }
        }
    }

    class CheckBoxActionListener
    implements ActionListener {
        CheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (!jCheckBox.isSelected()) {
                cloudMigrationController.setScriptDownloadDirectory(null);
                DWCSPagePanel.this.directoryTextField.setText("");
                cloudMigrationController.setScriptDownloadDirectoryCheckboxState(false);
            } else {
                cloudMigrationController.setScriptDownloadDirectoryCheckboxState(true);
            }
        }
    }

    class AdvancedPreferenceHyperlinkButtonActionListner
    implements ActionListener {
        AdvancedPreferenceHyperlinkButtonActionListner() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
            if (!hyperlinkButton.isSelected()) {
                IdeSettings ideSettings = Ide.getSettings();
                String[] stringArray = new String[]{DWCSPagePanel.PREFERENCES_MIGRATION_LABEL, DWCSPagePanel.PREFERENCES_AWS_REDSHIFT_LABEL};
                ideSettings.showDialog((Frame)Ide.getMainWindow(), stringArray);
                DWCSPagePanel.this.setCurrentPreferenceSettingsToModel();
                hyperlinkButton.setSelected(true);
            } else {
                hyperlinkButton.setSelected(false);
            }
        }
    }

    class MigrationNowCheckBoxActionListener
    implements ActionListener {
        MigrationNowCheckBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                cloudMigrationController.doMigrationNow(true);
            } else {
                cloudMigrationController.doMigrationNow(false);
            }
        }
    }

    class MigrateNowActionListener
    implements ActionListener {
        MigrateNowActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                cloudMigrationController.doMigrationNow(true);
            } else {
                cloudMigrationController.doMigrationNow(false);
            }
        }
    }

    class DropMigreposActionListener
    implements ActionListener {
        DropMigreposActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                cloudMigrationController.dropMigrationRepository(true);
            } else {
                cloudMigrationController.dropMigrationRepository(false);
            }
        }
    }
}

