/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftQueryCapture;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.DWCSPagePanel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.RedshiftPagePanel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.SimpleSummaryPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class CloudMigrationWizard
extends AbstractMenuAction {
    private static boolean DEBUG = false;
    static final String TRANSITION_TO_SUMMARY = "TRANSITION_TO_SUMMARY";
    private CloudMigrationModel model = null;
    private static CloudMigrationController cloudMigrationController;
    private boolean BIG_WIZARD = false;
    private static final String HELP_REDSHIFT_PAGE = "f1_cloudmigrations_helpRedshift_html";
    private static final String HELP_DWCS_PAGE = "f1_cloudmigrations_helpDWCS_html";
    private static final String HELP_REDSHIFT_DWCS_SUMMARY = "f1_cloudmigrations_helpRedshiftDWCSSummary_html";

    public void launch() {
        WizardDialog wizardDialog;
        this.model = CloudMigrationModel.getInstance();
        this.model.cleanRedshiftCredentials(this.model);
        cloudMigrationController = CloudMigrationController.getInstance();
        this.setBlockOACRefresh(true);
        try {
            wizardDialog = this.getWizard();
        }
        catch (Exception exception) {
            return;
        }
        WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.requestFocusInWindow();
    }

    public WizardDialog getWizard() throws Exception {
        FSMWizard fSMWizard = new FSMWizard(this.getFSM(), this.getNamespace());
        if (this.BIG_WIZARD) {
            BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
            bigWizardDialog.setPreferredSize(new Dimension(1024, 768));
            fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        }
        fSMWizard.setWizardTitle(this.nls("CLOUD_MIGRATIONS_WIZARD_TITLE"));
        fSMWizard.setRoadmapVisible(true);
        fSMWizard.addCommitListener((CommitListener)CloudMigrationModel.getInstance());
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    private FSM getFSM() {
        return this.getSimpleFSM();
    }

    private FSM getSimpleFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(this.nls("REDSHIFT_PAGE_TITLE"), RedshiftPagePanel.class, HELP_REDSHIFT_PAGE);
        fSMBuilder.newStartState(step, (Object)"redshiftPage");
        Step step2 = new Step(this.nls("DWCS_PAGE_TITLE"), DWCSPagePanel.class, HELP_DWCS_PAGE);
        fSMBuilder.newState((Object)"redshiftPage", step2, (Object)"dwcsPage", false);
        Step step3 = new Step(this.nls("REDSHIFT_DWCS_SUMMARY_PAGE_TITLE"), SimpleSummaryPanel.class, HELP_REDSHIFT_DWCS_SUMMARY);
        fSMBuilder.newFinalState((Object)"dwcsPage", step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Namespace getNamespace() throws Exception {
        var1_1 = null;
        var2_2 = new Namespace();
        this.model = CloudMigrationModel.getInstance();
        var3_3 = this.getDBObject();
        if (var3_3 != null) {
            CloudMigrationWizard.cloudMigrationController.setRedshiftDatabase(var3_3.getConnectionName());
            CloudMigrationWizard.cloudMigrationController.setNavigatorInvocationContext();
            var4_4 = this.convertToDBObjects(this.getContext().getSelection());
            try {
                for (String var8_11 : var1_1 = RedshiftQueryCapture.getRedshiftSchemaNames(this.model.getSourceConnection())) {
                    this.model.addSchemaToAvailableSchemasList(new String(var8_11));
                }
                if (var4_4.length == 1 && (var4_4[0].getObjectType().equals("CONNECTION") || var4_4[0].getObjectType().equals("CATALOG"))) {
                    this.model.cleanSelectedSchemas();
                }
                if (var4_4.length < 1) ** GOTO lbl29
                this.model.cleanSelectedSchemas();
                for (var5_6 = 0; var5_6 < var4_4.length; ++var5_6) {
                    if (!var4_4[var5_6].getObjectType().equals("USER")) continue;
                    var6_9 = var4_4[var5_6].getSchemaName();
                    this.model.addSchemaToSelectedSchemasList(var6_9);
                    this.model.removeFromAvailableSchemas(var6_9);
                }
            }
            catch (Exception var5_7) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)var5_7.getMessage(), (String)this.nls("REDSHIFT_MIGRATION_STATUS_TITLE"), null);
                throw var5_7;
            }
        } else {
            CloudMigrationWizard.cloudMigrationController.setMenuInvocationContext();
        }
lbl29:
        // 4 sources

        if (CloudMigrationWizard.DEBUG) {
            System.out.println("from menu=" + CloudMigrationWizard.cloudMigrationController.getMenuInvocationContext());
            System.out.println("from navigator=" + CloudMigrationWizard.cloudMigrationController.getNavigatorInvocationContext());
        }
        var2_2.put(CloudMigrationModel.KEY, (Object)this.model);
        return var2_2;
    }

    private String nls(String string) {
        return CloudMigrationsResources.get(string);
    }

    DBObject[] convertToDBObjects(Element[] elementArray) {
        DBObject[] dBObjectArray = null;
        if (elementArray != null && elementArray.length > 0) {
            dBObjectArray = new DBObject[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                dBObjectArray[i] = new DBObject(elementArray[i]);
            }
        }
        return dBObjectArray;
    }
}

