/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.ui.preferences.CloudMigrationOptions;
import oracle.dbtools.migration.cloud.ui.widgets.CheckBoxCardLayoutPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class RedshiftPreferencesPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final String US_CENTRAL_TZ = "US/Central";
    private JRadioButton m_igmc_true;
    private JRadioButton m_igmc_false;
    private JRadioButton m_escOpt_true;
    private JRadioButton m_escOpt_false;
    private JTextField m_tfDateFormat = new JTextField();
    private JTextField m_tfTsFormat = new JTextField();
    private JTextField m_tfTsTzFormat = new JTextField();
    private JTextField m_tfDelimiter = new JTextField();
    private JTextField m_tfQuote = new JTextField();
    private JPanel m_rsOptPanel;
    private JCheckBox m_arsAddQuotes = new JCheckBox();
    private JTextField m_arstfdelimiter = new JTextField(5);
    private JCheckBox m_arsEscape = new JCheckBox();
    private JTextField m_arstffixedwidth = new JTextField(5);
    private JCheckBox m_arsEncrypt = new JCheckBox();
    private JCheckBox m_arsOverwrite = new JCheckBox();
    private JComboBox<String[]> m_arscbCompress = new JComboBox<String>(new String[]{"GZIP", "BZIP2"});
    private JCheckBox m_arsManifest = new JCheckBox();
    private JCheckBox m_arsMaxfilesize = new JCheckBox();
    private JSpinner m_arsFsize = new JSpinner();
    private JSpinner.NumberEditor m_arsFS = new JSpinner.NumberEditor(this.m_arsFsize);
    private JComboBox<String[]> m_arscbUnit = new JComboBox<String>(new String[]{"MB", "GB"});
    private JTextField m_arstfNull = new JTextField(5);
    private JCheckBox m_arsParallel = new JCheckBox();
    private JTextField m_migrationOutputDirectory = new JTextField();
    private boolean isMaxfilesizeSelected = false;
    private SpinnerNumberModel mbSpinnerModel = null;
    private SpinnerNumberModel gbSpinnerModel = null;
    private SpinnerNumberModel maxThreadSpinnerModel = null;
    CheckBoxCardLayoutPanel<?> cardLayoutPanel = null;
    CardLayoutPanel<?> jobsExecuteCardLayoutPanel = null;
    CheckBoxCardLayoutPanel<?> schedularCheckCardLayoutPanel = null;
    private JPanel jobExecutePanel = null;
    private JPanel jobPanel = null;
    private JCheckBox m_oraBlankasNull = new JCheckBox();
    private JCheckBox m_oraEscape = new JCheckBox();
    private JCheckBox m_oraIgnoreblankLines = new JCheckBox();
    private JCheckBox m_oraIgnoreMissingCols = new JCheckBox();
    private JCheckBox m_oraremoveQuotes = new JCheckBox();
    private JCheckBox m_oraTruncateLongCols = new JCheckBox();
    private JTextField m_oratfRecordDelim = new JTextField(5);
    private JTextField m_oratfRejectLim = new JTextField(5);
    private JTextField m_oratfSkipHeaders = new JTextField(5);
    private JComboBox<String[]> m_cbCompressList = new JComboBox<String>(new String[]{"", "GZIP", "BZIP2"});
    private JComboBox<String[]> m_cbConversionErrs = new JComboBox<String>(new String[]{"", "REJECT_RECORD ", "STORE_NULL"});
    private JComboBox<String[]> m_cbTrimSpaces = new JComboBox<String>(new String[]{"NOTRIM", "RTRIM", "LTRIM", "TRIM"});
    private JCheckBox m_oraFileType = new JCheckBox();
    private JComboBox<String[]> m_oracbFileTypes = new JComboBox<String>(new String[]{"", "CSV", "CSV WITH EMBEDDED"});
    private JTextField m_oratfDelimiter = new JTextField(5);
    private JTextField m_oratfQuote = new JTextField(5);
    private JSpinner maxThreadNumberSpinner = new JSpinner();
    private JSpinner rejectLimitNumberSpinner = new JSpinner();
    private JCheckBox useDBMSSchedulerCheck = new JCheckBox(this.nls("USE_SCHEDULER"));
    private Date dateToDeploy = null;
    private String dateToDeployTimeZone = null;
    private String formatedDateToDeploy = null;
    private String dateToDeployType = this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE");
    private TimeZone timeZone = null;
    SimpleDateFormat dateFormat = null;
    private CloudMigrationOptions options = null;
    private static final String REDSHIFT_COMPRESSION_ON = "REDSHIFT_COMPRESSION_ON";
    private static final String REDSHIFT_COMPRESSION_OFF = "REDSHIFT_COMPRESSION_OFF";
    private static final String REDSHIFT_SCHEDULAR_ON = "REDSHIFT_SCHEDULAR_ON";
    private static final String REDSHIFT_SCHEDULAR_OFF = "REDSHIFT_SCHEDULAR_OFF";
    private static final String JOBEXECUTION_CHOICE_IMMEDIATE = "JOBEXECUTION_CHOICE_IMMEDIATE";
    private static final String JOBEXECUTION_CHOICE_ONCE = "JOBEXECUTION_CHOICE_ONCE";
    private static final String TIME_FORMAT = "dd-MMM-yyyy hh.mm.ss a ";
    private JPanel jobExecutionPreferencePanel = null;
    private JSpinner dateTimeSpinner = new JSpinner();
    private JComboBox<List> timeZoneComboBox = new JComboBox();

    public RedshiftPreferencesPanel() {
        this.init();
        this.setHelpID("f1_migprefcore_html");
    }

    private void init() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(5000, 5000));
        int n = 0;
        jPanel.add((Component)this.redshiftSettingsPanel(), LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.getRedshiftOptionsPanel2(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.getADWCFormatOptionsPanel2(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        this.add(LayoutControl.GBC.createWizardPanel((Component)jPanel), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
    }

    private JPanel redshiftSettingsPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_migrationOutputDirectory, (String)this.nls("REDSHIFT_MIGRATION_OUT_DIR"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.m_migrationOutputDirectory, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.m_migrationOutputDirectory.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CloudMigrationOptions.setPrefenceOutputDirectory(RedshiftPreferencesPanel.this.m_migrationOutputDirectory.getText());
            }
        });
        JButton jButton = new JButton(this.nls("SELECT_DIRECTORY"));
        jPanel.add((Component)jButton, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jButton.addActionListener(new FileBrowserActionListener());
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.maxThreadNumberSpinner, (String)this.nls("MAX_NUMBER_OF_THREADS"));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.maxThreadNumberSpinner, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.maxThreadNumberSpinner.setModel(this.createMaxThreadSpinnerModel());
        this.jobExecutionPreferencePanel = this.getSchedulerPanel();
        jPanel.add((Component)this.jobExecutionPreferencePanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)1);
        return LayoutControl.GBC.createTitledSubPanel((String)this.nls("REDSHIFT_MIGRATION_SETTINGS"), (Component)jPanel);
    }

    private JPanel getRedshiftOptionsPanel2() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        ResourceUtils.resButton((AbstractButton)this.m_arsOverwrite, (String)this.nls("RS_UNLOAD_OPT_OW"));
        jPanel.add((Component)this.m_arsOverwrite, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        this.m_arsOverwrite.setSelected(false);
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)3);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return LayoutControl.GBC.createTitledSubPanel((String)this.nls("RS_UNLOAD_OPTIONS"), (Component)jPanel);
    }

    private JPanel getEmptyPanel(String string) {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setName(string);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private SpinnerNumberModel createMaxThreadSpinnerModel() {
        int n = 1;
        int n2 = 1000;
        int n3 = 1;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n, n2, n3);
        this.maxThreadNumberSpinner.setValue(n);
        return spinnerNumberModel;
    }

    private SpinnerNumberModel createRejectLimitSpinnerModel() {
        int n = 0;
        int n2 = 1000;
        int n3 = 1;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n, n2, n3);
        this.rejectLimitNumberSpinner.setValue(n);
        return spinnerNumberModel;
    }

    private void setDefaultSettings() {
        this.m_arsParallel.setSelected(false);
        this.m_arsOverwrite.setSelected(false);
        this.isMaxfilesizeSelected = false;
        this.m_arsAddQuotes.setSelected(false);
        this.m_arsEscape.setSelected(false);
        this.m_arsEncrypt.setSelected(false);
        this.m_arsManifest.setSelected(false);
        this.m_arstfNull.setText("");
        this.m_arsFsize.setModel(this.mbSpinnerModel);
        this.m_arscbUnit.setSelectedIndex(1);
        this.m_arsFsize.setValue(1);
        this.setDefaultDelimiter();
        this.m_oraBlankasNull.setSelected(false);
        this.m_oraEscape.setSelected(false);
        this.m_oraIgnoreblankLines.setSelected(false);
        this.m_oraIgnoreMissingCols.setSelected(true);
        this.m_oraremoveQuotes.setSelected(false);
        this.m_oraTruncateLongCols.setSelected(false);
        this.m_oratfRecordDelim.setText("\n");
        this.m_oratfRejectLim.setText("0");
        this.m_oratfSkipHeaders.setText("0");
        this.m_oratfQuote.setText("");
        this.m_cbCompressList.setSelectedIndex(1);
        this.m_cbConversionErrs.setSelectedIndex(0);
        this.m_oracbFileTypes.setSelectedIndex(0);
        this.m_cbTrimSpaces.setSelectedIndex(0);
        this.m_migrationOutputDirectory.setText(System.getProperty("user.home"));
        if (this.options != null) {
            this.traceFlow("options != null");
            this.setCloudMigrationOptionsFromUI(this.options);
        } else {
            this.traceFlow("options == null");
        }
    }

    public void setDefaultDelimiter() {
        this.m_oratfDelimiter.setText("|");
        this.m_arstfdelimiter.setText(this.m_oratfDelimiter.getSelectedText());
    }

    public String getDefaultDelimiter() {
        return this.m_oratfDelimiter.getSelectedText();
    }

    private JPanel getADWCFormatOptionsPanel2() {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.rejectLimitNumberSpinner, (String)this.nls("ORA_FORMAT_OPT_REJECTLIMIT"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.rejectLimitNumberSpinner, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.rejectLimitNumberSpinner.setModel(this.createRejectLimitSpinnerModel());
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)12);
        return LayoutControl.GBC.createTitledSubPanel((String)this.nls("ADWC_FORMAT_OPTIONS"), (Component)jPanel);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.traceFlow("onEntry ... begin ");
        this.options = RedshiftPreferencesPanel.getOptionsFromContext(traversableContext);
        this.setUIdataFromCloudMigrationOptions(this.options);
        this.traceFlow("onEntry ... exit ");
    }

    private void setUIdataFromCloudMigrationOptions(CloudMigrationOptions cloudMigrationOptions) {
        Component[] componentArray;
        this.m_arsOverwrite.setSelected(this.getBoolean(cloudMigrationOptions.getValue("ARS.OVERWRITE")));
        this.rejectLimitNumberSpinner.setValue(this.getInteger(cloudMigrationOptions.getValue("CPD.REJLIM")));
        this.m_migrationOutputDirectory.setText((String)cloudMigrationOptions.getValue("REDSHIFT_MIGRATION_DIR"));
        this.maxThreadNumberSpinner.setValue(this.getInteger(cloudMigrationOptions.getValue("MAX_NUMBER_THREADS")));
        this.useDBMSSchedulerCheck.setSelected(this.getBoolean(cloudMigrationOptions.getValue("USE_DBMS_SCHEDULER")));
        this.jobsExecuteCardLayoutPanel.setSelectedItem((Object)CloudMigrationOptions.getDateToDeployType());
        JPanel jPanel = (JPanel)this.jobsExecuteCardLayoutPanel.getCurrentCardComponent();
        for (Component component : componentArray = jPanel.getComponents()) {
            if (component instanceof JSpinner && ((JSpinner)component).getModel() instanceof SpinnerDateModel) {
                ((SpinnerDateModel)((JSpinner)component).getModel()).setValue(new Date(CloudMigrationOptions.getDateToDeploy()));
            }
            if (!(component instanceof JComboBox) || !(((JComboBox)component).getModel() instanceof ComboBoxModel)) continue;
            ((JComboBox)component).getModel().setSelectedItem(CloudMigrationOptions.getDateToDeployTimeZone());
        }
        if (this.useDBMSSchedulerCheck.isSelected()) {
            this.enableSchedularPanel(true);
        } else {
            this.enableSchedularPanel(false);
        }
        this.formatedDateToDeploy = CloudMigrationOptions.getFormattedDateToDeploy();
    }

    private void setWarnColorToDateTimeSpinner() {
        if (this.dateTimeSpinner != null) {
            Date date;
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.dateTimeSpinner.getEditor()).getTextField();
            Date date2 = new Date(CloudMigrationOptions.getDateToDeploy());
            if (date2.before(date = new Date())) {
                jFormattedTextField.setBackground(Color.YELLOW);
            } else {
                jFormattedTextField.setBackground(Color.WHITE);
            }
        }
    }

    private final boolean getBoolean(Object object) {
        return object instanceof String ? Boolean.valueOf((String)object).booleanValue() : ((Boolean)object).booleanValue();
    }

    private final int getInteger(Object object) {
        return object instanceof String ? Integer.valueOf((String)object).intValue() : ((Integer)object).intValue();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.traceFlow("onExit ... begin ");
        this.options = RedshiftPreferencesPanel.getOptionsFromContext(traversableContext);
        this.setCloudMigrationOptionsFromUI(this.options);
        this.traceFlow("onExit ... exit ");
    }

    private void setCloudMigrationOptionsFromUI(CloudMigrationOptions cloudMigrationOptions) {
        cloudMigrationOptions.setValue("ARS.OVERWRITE", new Boolean(this.m_arsOverwrite.isSelected()));
        cloudMigrationOptions.setValue("CPD.REJLIM", this.rejectLimitNumberSpinner.getValue());
        cloudMigrationOptions.setValue("REDSHIFT_MIGRATION_DIR", this.m_migrationOutputDirectory.getText());
        cloudMigrationOptions.setValue("MAX_NUMBER_THREADS", this.maxThreadNumberSpinner.getValue());
        cloudMigrationOptions.setValue("USE_DBMS_SCHEDULER", this.useDBMSSchedulerCheck.isSelected());
        cloudMigrationOptions.setValue("DATE_TO_DEPLOY", this.dateToDeploy.getTime());
        cloudMigrationOptions.setValue("DATE_TO_DEPLOY_TIME_ZONE", this.dateToDeployTimeZone);
        cloudMigrationOptions.setValue("DATE_TO_DEPLOY_TYPE", this.dateToDeployType);
        cloudMigrationOptions.setValue("FORMATTED_DATE_TO_DEPLOY", this.formatedDateToDeploy);
    }

    private static CloudMigrationOptions getOptionsFromContext(TraversableContext traversableContext) {
        return CloudMigrationOptions.getInstance(traversableContext.getPropertyStorage());
    }

    private JPanel getSchedulerPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.setName("schedulerPanel");
        JPanel jPanel2 = this.getJobExecutionPanel(REDSHIFT_SCHEDULAR_ON);
        jPanel2.setName("jobExecutionPanel");
        this.useDBMSSchedulerCheck.setSelected(true);
        if (this.useDBMSSchedulerCheck.isSelected()) {
            this.enableSchedularPanel(true);
        } else {
            this.enableSchedularPanel(false);
        }
        this.useDBMSSchedulerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JCheckBox) {
                    boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    if (bl) {
                        RedshiftPreferencesPanel.this.enableSchedularPanel(true);
                    } else {
                        RedshiftPreferencesPanel.this.enableSchedularPanel(false);
                    }
                }
            }
        });
        int n = 0;
        jPanel.add((Component)this.useDBMSSchedulerCheck, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.getJobExecutionPanel(REDSHIFT_SCHEDULAR_ON), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        return jPanel;
    }

    private void enableSchedularPanel(boolean bl) {
        this.jobsExecuteCardLayoutPanel.setEnabled(bl);
        Component component = this.jobsExecuteCardLayoutPanel.getCurrentCardComponent();
        Component[] componentArray = ((JPanel)component).getComponents();
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                component2.setEnabled(bl);
            }
        }
    }

    private JPanel getJobExecutionPanel(String string) {
        this.jobExecutePanel = LayoutControl.GBC.createPanel();
        this.jobExecutePanel.setName(string);
        LinkedHashMap<String, JPanel> linkedHashMap = new LinkedHashMap<String, JPanel>();
        linkedHashMap.put(this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE"), this.getEmptyPanel(JOBEXECUTION_CHOICE_IMMEDIATE));
        linkedHashMap.put(this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_ONCE"), this.getJobExecuteOncePanel(JOBEXECUTION_CHOICE_ONCE));
        int n = 0;
        this.jobsExecuteCardLayoutPanel = new CardLayoutPanel(linkedHashMap, this.nls("REDSHIFT_MIGRATION_JOBEXECUTION"), CardLayoutPanel.Type.TITLE_BORDER);
        this.jobsExecuteCardLayoutPanel.setName("jobsExecuteCardLayoutPanel");
        this.jobExecutePanel.add((Component)this.jobsExecuteCardLayoutPanel, LayoutControl.GBC.gbc((int)0, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.dateToDeploy = new Date();
        this.dateFormat = new SimpleDateFormat(TIME_FORMAT);
        this.timeZone = TimeZone.getTimeZone((String)this.timeZoneComboBox.getSelectedItem());
        this.dateToDeployTimeZone = this.timeZone.getID();
        this.formatedDateToDeploy = this.formatDateTimeZone(this.dateToDeploy, this.dateToDeployTimeZone);
        this.dateToDeployType = this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE");
        this.jobsExecuteCardLayoutPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (((String)itemEvent.getItem()).equals(RedshiftPreferencesPanel.this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE"))) {
                        RedshiftPreferencesPanel.this.dateToDeploy = new Date();
                        RedshiftPreferencesPanel.this.dateTimeSpinner.setValue(RedshiftPreferencesPanel.this.dateToDeploy);
                        RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                        RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
                        RedshiftPreferencesPanel.this.dateToDeployType = RedshiftPreferencesPanel.this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE");
                    } else if (((String)itemEvent.getItem()).equals(RedshiftPreferencesPanel.this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_ONCE"))) {
                        RedshiftPreferencesPanel.this.traceFlow(".. " + itemEvent.getStateChange() + ", getItem=" + itemEvent.getItem());
                        if (RedshiftPreferencesPanel.this.dateTimeSpinner != null) {
                            RedshiftPreferencesPanel.this.dateToDeploy = (Date)RedshiftPreferencesPanel.this.dateTimeSpinner.getValue();
                            RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                            RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
                        } else {
                            RedshiftPreferencesPanel.this.dateToDeploy = new Date();
                            RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                            RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
                            RedshiftPreferencesPanel.this.dateTimeSpinner.setValue(RedshiftPreferencesPanel.this.dateToDeploy);
                        }
                        RedshiftPreferencesPanel.this.dateToDeployType = RedshiftPreferencesPanel.this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_ONCE");
                    }
                }
            }
        });
        LayoutControl.GBC.addHSpring((JPanel)this.jobExecutePanel, (int)(++n));
        n = n++;
        LayoutControl.GBC.addVSpring((JPanel)this.jobExecutePanel, (int)n);
        return this.jobExecutePanel;
    }

    private JPanel getJobExecuteOncePanel(String string) {
        int n = 0;
        this.jobPanel = LayoutControl.GBC.createPanel();
        this.jobPanel.setName(string);
        JLabel jLabel = new JLabel(this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_STARTDATE"));
        this.jobPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)1, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.dateTimeSpinner.setModel(this.createDateTimeSpinnerModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.dateTimeSpinner, TIME_FORMAT);
        JFormattedTextField jFormattedTextField = dateEditor.getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setBackground(Color.white);
        this.dateTimeSpinner.setEditor(dateEditor);
        this.jobPanel.add((Component)this.dateTimeSpinner, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        Locale locale = Locale.getDefault();
        CalendarPopupButton calendarPopupButton = new CalendarPopupButton(locale);
        this.jobPanel.add((Component)calendarPopupButton, LayoutControl.GBC.gbc((int)3, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        JLabel jLabel2 = new JLabel(this.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_TIMEZONE"));
        this.jobPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)1, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.timeZoneComboBox.setModel(new DefaultComboBoxModel<Object>(this.getTimeZones().toArray()));
        this.timeZoneComboBox.setSelectedItem(US_CENTRAL_TZ);
        this.timeZoneComboBox.setEditable(false);
        this.timeZoneComboBox.setBackground(Color.white);
        this.jobPanel.add(this.timeZoneComboBox, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.timeZoneComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                RedshiftPreferencesPanel.this.timeZone = TimeZone.getTimeZone((String)jComboBox.getSelectedItem());
                RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                if (RedshiftPreferencesPanel.this.dateToDeploy == null) {
                    RedshiftPreferencesPanel.this.dateToDeploy = new Date();
                }
                RedshiftPreferencesPanel.this.timeZoneComboBox.setSelectedItem((String)jComboBox.getSelectedItem());
                RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
            }
        });
        this.dateTimeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RedshiftPreferencesPanel.this.dateToDeploy = (Date)((JSpinner)changeEvent.getSource()).getValue();
                RedshiftPreferencesPanel.this.timeZone = TimeZone.getTimeZone((String)RedshiftPreferencesPanel.this.timeZoneComboBox.getSelectedItem());
                RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
            }
        });
        calendarPopupButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Date[] dateArray;
                if (itemEvent.getSource() instanceof CalendarPopupButton && (dateArray = ((CalendarPopupButton)itemEvent.getSource()).getSelectedDates()) != null) {
                    RedshiftPreferencesPanel.this.dateTimeSpinner.setValue(dateArray[0]);
                    RedshiftPreferencesPanel.this.dateToDeploy = (Date)RedshiftPreferencesPanel.this.dateTimeSpinner.getValue();
                    RedshiftPreferencesPanel.this.timeZone = TimeZone.getTimeZone((String)RedshiftPreferencesPanel.this.timeZoneComboBox.getSelectedItem());
                    RedshiftPreferencesPanel.this.dateToDeployTimeZone = RedshiftPreferencesPanel.this.timeZone.getID();
                    RedshiftPreferencesPanel.this.formatedDateToDeploy = RedshiftPreferencesPanel.this.formatDateTimeZone(RedshiftPreferencesPanel.this.dateToDeploy, RedshiftPreferencesPanel.this.dateToDeployTimeZone);
                }
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)this.jobPanel, (int)(++n));
        return this.jobPanel;
    }

    private String formatDateTimeZone(Date date, String string) {
        return this.dateFormat.format(date).trim() + " " + string;
    }

    private SpinnerDateModel createDateTimeSpinnerModel() {
        Calendar calendar = Calendar.getInstance();
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        calendar2.add(1, -1);
        spinnerDateModel.setStart(calendar2.getTime());
        calendar2.add(1, 100);
        spinnerDateModel.setEnd(calendar2.getTime());
        return spinnerDateModel;
    }

    private void traceFlow(String string) {
    }

    private String nls(String string) {
        return CloudMigrationsResources.get(string);
    }

    private List<String> getTimeZones() {
        String[] stringArray = TimeZone.getAvailableIDs();
        List<String> list = Arrays.asList(stringArray);
        return list;
    }

    class FileBrowserActionListener
    implements ActionListener {
        FileBrowserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL;
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.clearChooseableURLFilters();
            uRLFileChooser.setSelectionScope(1);
            uRLFileChooser.setSelectionMode(0);
            int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), RedshiftPreferencesPanel.this.nls("FILE_BROWSER_HEADER"));
            if (n == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
                File file = new File(uRL.getPath());
                if (!file.exists() || !file.canWrite()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)RedshiftPreferencesPanel.this.nls("FILE_BROWSER_INVALID_DIRECTORY"), (String)RedshiftPreferencesPanel.this.nls("FILE_BROWSER_HEADER"), null);
                } else {
                    String string = file.getAbsolutePath();
                    CloudMigrationOptions.setPrefenceOutputDirectory(string);
                    RedshiftPreferencesPanel.this.m_migrationOutputDirectory.setText(string);
                }
            }
        }
    }

    class RBActionListener
    implements ActionListener {
        RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == RedshiftPreferencesPanel.this.m_igmc_true || jRadioButton == RedshiftPreferencesPanel.this.m_igmc_false || jRadioButton == RedshiftPreferencesPanel.this.m_escOpt_true || jRadioButton == RedshiftPreferencesPanel.this.m_escOpt_false) {
                // empty if block
            }
        }
    }

    class DefaultSettingActionListener
    implements ActionListener {
        DefaultSettingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RedshiftPreferencesPanel.this.setDefaultSettings();
        }
    }
}

