/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.preferences;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class CloudMigrationOptions
extends HashStructureAdapter {
    public static final String DATA_KEY = CloudMigrationOptions.class.getSimpleName();
    public static final String ARS_ADDQUOTES = "ARS.ADDQUOTES";
    public static final String ARS_DELIMITER = "ARS.DELIMITER";
    public static final String ARS_ESCAPE = "ARS.ESCAPE";
    public static final String ARS_FIXEDWIDTH = "ARS.FIXEDWIDTH";
    public static final String ARS_ENCRYPT = "ARS.ENCRYPT";
    public static final String ARS_OVERWRITE = "ARS.OVERWRITE";
    public static final String ARS_COMPRESS = "ARS.COMPRESS";
    public static final String ARS_MANIFEST = "ARS.MANIFEST";
    public static final String ARS_MAXFILE = "ARS.MAXFILE";
    public static final String ARS_MAXFILESIZE = "ARS.MAXFILESIZE";
    public static final String ARS_MAXFILESIZEUNIT = "ARS.MAXFILESIZEUNIT";
    public static final String ARS_NULL = "ARS.NULL";
    public static final String ARS_PARALLEL = "ARS.PARALLEL";
    public static final String CPD_BLKASNULL = "CPD.BLKASNULL";
    public static final String CPD_ESCAPE = "CPD.ESCAPE";
    public static final String CPD_IGNBLKLINES = "CPD.IGNBLKLINES";
    public static final String CPD_IGNMISCOLS = "CPD.IGNMISCOLS";
    public static final String CPD_REMQUOTES = "CPD.REMQUOTES";
    public static final String CPD_TRUNCLNGCOLS = "CPD.TRUNCLNGCOLS";
    public static final String CPD_RECDELIM = "CPD.RECDELIM";
    public static final String CPD_REJLIM = "CPD.REJLIM";
    public static final String CPD_SKIPHDRS = "CPD.SKIPHDRS";
    public static final String CPD_COMPRESS = "CPD.COMPRESS";
    public static final String CPD_CONVERRS = "CPD.CONVERRS";
    public static final String CPD_TRIMSPACES = "CPD.TRIMSPACES";
    public static final String CPD_ISFILETYPE = "CPD.ISFILETYPE";
    public static final String CPD_FILETYPE = "CPD.FILETYPE";
    public static final String CPD_COLDELIMITER = "CPD.COLDELIMITER";
    public static final String CPD_QUOTE = "CPD.QUOTE";
    public static final String REDSHIFT_MIGRATION_DIR = "REDSHIFT_MIGRATION_DIR";
    public static final String MAX_NUMBER_THREADS = "MAX_NUMBER_THREADS";
    public static final String USE_DBMS_SCHEDULER = "USE_DBMS_SCHEDULER";
    public static final String DATE_TO_DEPLOY_TYPE = "DATE_TO_DEPLOY_TYPE";
    public static final String DATE_TO_DEPLOY = "DATE_TO_DEPLOY";
    public static final String DATE_TO_DEPLOY_TIME_ZONE = "DATE_TO_DEPLOY_TIME_ZONE";
    public static final String FORMATTED_DATE_TO_DEPLOY = "FORMATTED_DATE_TO_DEPLOY";
    private static final String TIME_FORMAT = "dd-MMM-yyyy HH.mm.ss a";
    private static final String DEFAULT_TIME_ZONE = "US/Central";
    private static Map<String, Object> m_keydefaults = new HashMap<String, Object>();

    private CloudMigrationOptions(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static CloudMigrationOptions getInstance(PropertyStorage propertyStorage) {
        return new CloudMigrationOptions(CloudMigrationOptions.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public static CloudMigrationOptions getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return CloudMigrationOptions.getInstance((PropertyStorage)preferences);
    }

    public Object getValue(String string) {
        if (this._hash.getObject(string) == null) {
            Object object = null;
            switch (string) {
                case "ARS.DELIMITER": 
                case "ARS.FIXEDWIDTH": 
                case "ARS.COMPRESS": 
                case "ARS.MAXFILESIZEUNIT": 
                case "ARS.NULL": {
                    object = CloudMigrationOptions.getStringDefault(string);
                    break;
                }
                case "ARS.ADDQUOTES": 
                case "ARS.ESCAPE": 
                case "ARS.ENCRYPT": 
                case "ARS.OVERWRITE": 
                case "ARS.MANIFEST": 
                case "ARS.MAXFILE": 
                case "ARS.PARALLEL": {
                    object = CloudMigrationOptions.getBooleanDefault(string);
                    break;
                }
                case "ARS.MAXFILESIZE": {
                    object = CloudMigrationOptions.getIntegerDefault(string);
                    break;
                }
                case "CPD.BLKASNULL": 
                case "CPD.ESCAPE": 
                case "CPD.IGNBLKLINES": 
                case "CPD.IGNMISCOLS": 
                case "CPD.REMQUOTES": 
                case "CPD.TRUNCLNGCOLS": 
                case "CPD.ISFILETYPE": {
                    object = CloudMigrationOptions.getBooleanDefault(string);
                    break;
                }
                case "CPD.RECDELIM": 
                case "CPD.SKIPHDRS": 
                case "CPD.COMPRESS": 
                case "CPD.CONVERRS": 
                case "CPD.TRIMSPACES": 
                case "CPD.FILETYPE": 
                case "CPD.COLDELIMITER": 
                case "CPD.QUOTE": {
                    object = CloudMigrationOptions.getStringDefault(string);
                    break;
                }
                case "REDSHIFT_MIGRATION_DIR": {
                    object = CloudMigrationOptions.getStringDefault(string);
                    break;
                }
                case "CPD.REJLIM": {
                    object = CloudMigrationOptions.getIntegerDefault(string);
                    break;
                }
                case "MAX_NUMBER_THREADS": {
                    object = CloudMigrationOptions.getIntegerDefault(string);
                    break;
                }
                case "USE_DBMS_SCHEDULER": {
                    object = CloudMigrationOptions.getBooleanDefault(string);
                    break;
                }
                case "DATE_TO_DEPLOY_TYPE": {
                    object = CloudMigrationOptions.getStringDefault(string);
                    break;
                }
                case "DATE_TO_DEPLOY": {
                    object = CloudMigrationOptions.getLongDefault(string);
                    break;
                }
                case "DATE_TO_DEPLOY_TIME_ZONE": {
                    object = CloudMigrationOptions.getStringDefault(string);
                    break;
                }
                case "FORMATTED_DATE_TO_DEPLOY": {
                    object = CloudMigrationOptions.getStringDefault(string);
                }
            }
            return object;
        }
        return this._hash.getObject(string);
    }

    public void setValue(String string, Object object) {
        switch (string) {
            case "ARS.DELIMITER": 
            case "ARS.FIXEDWIDTH": 
            case "ARS.COMPRESS": 
            case "ARS.MAXFILESIZEUNIT": 
            case "ARS.NULL": {
                this._hash.putString(string, (String)object);
                break;
            }
            case "ARS.ADDQUOTES": 
            case "ARS.ESCAPE": 
            case "ARS.ENCRYPT": 
            case "ARS.OVERWRITE": 
            case "ARS.MANIFEST": 
            case "ARS.MAXFILE": 
            case "ARS.PARALLEL": {
                if (object instanceof String) {
                    this._hash.putBoolean(string, Boolean.valueOf((String)object).booleanValue());
                    break;
                }
                this._hash.putBoolean(string, Boolean.valueOf((Boolean)object).booleanValue());
                break;
            }
            case "ARS.MAXFILESIZE": {
                this._hash.putInt(string, ((Integer)object).intValue());
                break;
            }
            case "CPD.BLKASNULL": 
            case "CPD.ESCAPE": 
            case "CPD.IGNBLKLINES": 
            case "CPD.IGNMISCOLS": 
            case "CPD.REMQUOTES": 
            case "CPD.TRUNCLNGCOLS": 
            case "CPD.ISFILETYPE": {
                this._hash.putBoolean(string, ((Boolean)object).booleanValue());
                break;
            }
            case "CPD.RECDELIM": 
            case "CPD.SKIPHDRS": 
            case "CPD.COMPRESS": 
            case "CPD.CONVERRS": 
            case "CPD.TRIMSPACES": 
            case "CPD.FILETYPE": 
            case "CPD.COLDELIMITER": 
            case "CPD.QUOTE": {
                this._hash.putString(string, (String)object);
                break;
            }
            case "REDSHIFT_MIGRATION_DIR": {
                this._hash.putString(string, (String)object);
                break;
            }
            case "CPD.REJLIM": {
                this._hash.putInt(string, ((Integer)object).intValue());
                break;
            }
            case "MAX_NUMBER_THREADS": {
                this._hash.putInt(string, ((Integer)object).intValue());
                break;
            }
            case "USE_DBMS_SCHEDULER": {
                this._hash.putBoolean(string, ((Boolean)object).booleanValue());
                break;
            }
            case "DATE_TO_DEPLOY_TYPE": {
                this._hash.putString(string, (String)object);
                break;
            }
            case "DATE_TO_DEPLOY": {
                this._hash.putLong(string, ((Long)object).longValue());
                break;
            }
            case "DATE_TO_DEPLOY_TIME_ZONE": {
                this._hash.putString(string, (String)object);
                break;
            }
            case "FORMATTED_DATE_TO_DEPLOY": {
                this._hash.putString(string, (String)object);
            }
        }
    }

    private static String getStringDefault(String string) {
        Object object = m_keydefaults.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : "");
    }

    private static Boolean getBooleanDefault(String string) {
        Object object = m_keydefaults.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.valueOf(object.toString()) : null);
    }

    private static Integer getIntegerDefault(String string) {
        Object object = m_keydefaults.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(object.toString()) : 0);
    }

    private static Long getLongDefault(String string) {
        Object object = m_keydefaults.get(string);
        return object instanceof Long ? (Long)object : (object != null ? Long.valueOf(object.toString()) : 0L);
    }

    public static void setPrefenceOutputDirectory(String string) {
        CloudMigrationOptions.getInstance().setValue(REDSHIFT_MIGRATION_DIR, string);
    }

    public static String getPrefenceOutputDirectory() {
        return (String)CloudMigrationOptions.getInstance().getValue(REDSHIFT_MIGRATION_DIR);
    }

    public static Integer getUseMaxNumberThread() {
        Object object = CloudMigrationOptions.getInstance().getValue(MAX_NUMBER_THREADS);
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return (Integer)object;
    }

    public static Integer getRejectLimit() {
        Object object = CloudMigrationOptions.getInstance().getValue(CPD_REJLIM);
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return (Integer)object;
    }

    public static Boolean getUseDBMSScheduler() {
        Object object = CloudMigrationOptions.getInstance().getValue(USE_DBMS_SCHEDULER);
        if (object instanceof String) {
            Boolean bl = Boolean.valueOf((String)object);
            return bl;
        }
        return (Boolean)object;
    }

    public static String getDateToDeployType() {
        return (String)CloudMigrationOptions.getInstance().getValue(DATE_TO_DEPLOY_TYPE);
    }

    public static String getDateToDeployTimeZone() {
        return (String)CloudMigrationOptions.getInstance().getValue(DATE_TO_DEPLOY_TIME_ZONE);
    }

    public static Long getDateToDeploy() {
        Object object = CloudMigrationOptions.getInstance().getValue(DATE_TO_DEPLOY);
        if (object instanceof String) {
            long l = Long.parseLong((String)object);
            return new Long(l);
        }
        return (Long)object;
    }

    public static String getFormattedDateToDeploy() {
        return (String)CloudMigrationOptions.getInstance().getValue(FORMATTED_DATE_TO_DEPLOY);
    }

    private static String nls(String string) {
        return CloudMigrationsResources.get(string);
    }

    static {
        m_keydefaults.put(ARS_ADDQUOTES, Boolean.FALSE);
        m_keydefaults.put(ARS_DELIMITER, "|");
        m_keydefaults.put(ARS_ESCAPE, Boolean.FALSE);
        m_keydefaults.put(ARS_FIXEDWIDTH, "");
        m_keydefaults.put(ARS_ENCRYPT, Boolean.FALSE);
        m_keydefaults.put(ARS_OVERWRITE, Boolean.TRUE);
        m_keydefaults.put(ARS_COMPRESS, "GZIP");
        m_keydefaults.put(ARS_MANIFEST, Boolean.FALSE);
        m_keydefaults.put(ARS_MAXFILE, Boolean.TRUE);
        m_keydefaults.put(ARS_MAXFILESIZE, new Integer(1));
        m_keydefaults.put(ARS_MAXFILESIZEUNIT, "GB");
        m_keydefaults.put(ARS_NULL, "");
        m_keydefaults.put(ARS_PARALLEL, Boolean.FALSE);
        m_keydefaults.put(CPD_BLKASNULL, Boolean.FALSE);
        m_keydefaults.put(CPD_ESCAPE, Boolean.FALSE);
        m_keydefaults.put(CPD_IGNBLKLINES, Boolean.FALSE);
        m_keydefaults.put(CPD_IGNMISCOLS, Boolean.TRUE);
        m_keydefaults.put(CPD_REMQUOTES, Boolean.FALSE);
        m_keydefaults.put(CPD_TRUNCLNGCOLS, Boolean.FALSE);
        m_keydefaults.put(CPD_RECDELIM, "");
        m_keydefaults.put(CPD_REJLIM, new Integer(0));
        m_keydefaults.put(CPD_SKIPHDRS, "0");
        m_keydefaults.put(CPD_COMPRESS, "GZIP");
        m_keydefaults.put(CPD_CONVERRS, "");
        m_keydefaults.put(CPD_TRIMSPACES, "NOTRIM");
        m_keydefaults.put(CPD_ISFILETYPE, Boolean.FALSE);
        m_keydefaults.put(CPD_FILETYPE, "");
        m_keydefaults.put(CPD_COLDELIMITER, "|");
        m_keydefaults.put(CPD_QUOTE, "");
        m_keydefaults.put(REDSHIFT_MIGRATION_DIR, System.getProperty("user.home"));
        m_keydefaults.put(MAX_NUMBER_THREADS, new Integer(1));
        m_keydefaults.put(USE_DBMS_SCHEDULER, Boolean.FALSE);
        m_keydefaults.put(DATE_TO_DEPLOY_TYPE, CloudMigrationOptions.nls("REDSHIFT_MIGRATION_JOBEXECUTION_CHOICE_IMMEDIATE"));
        m_keydefaults.put(DATE_TO_DEPLOY, 0L);
        m_keydefaults.put(DATE_TO_DEPLOY_TIME_ZONE, DEFAULT_TIME_ZONE);
        m_keydefaults.put(FORMATTED_DATE_TO_DEPLOY, new SimpleDateFormat(TIME_FORMAT).format(new Date()) + " US/Central");
    }
}

