/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.generate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftPreferenceSettings;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.jdbc.OracleCallableStatement;

public class MigrationGenerate {
    private static final boolean DEBUG = false;
    private Logger migrationGenerateLogger = Logger.getLogger(MigrationGenerate.class.getName());
    private RedshiftPreferenceSettings userPreferenceSettings;
    private String migrationRepositoryPassword = null;
    private boolean dropMigrationRepository = false;
    private Connection m_targetConnection = null;
    private int m_convertVersion = 1;
    private String m_fileFormatDelimiter = null;
    private String m_awsAccessKey;
    private String m_awsSecretAccess;
    private String m_awsS3BucketHTTPSLocation;
    private String m_awsS3BucketURI;

    public MigrationGenerate(Connection connection) {
        this(connection, null);
    }

    public MigrationGenerate(Connection connection, RedshiftPreferenceSettings redshiftPreferenceSettings) {
        this.m_targetConnection = connection;
        this.checkNull(redshiftPreferenceSettings);
        this.userPreferenceSettings = redshiftPreferenceSettings;
    }

    public MigrationGenerate(Connection connection, int n) {
        this(connection, n, null, null, false);
    }

    public MigrationGenerate(Connection connection, int n, RedshiftPreferenceSettings redshiftPreferenceSettings, String string, boolean bl) {
        this.m_targetConnection = connection;
        this.m_convertVersion = n;
        this.checkNull(redshiftPreferenceSettings);
        this.userPreferenceSettings = redshiftPreferenceSettings;
        this.migrationRepositoryPassword = string;
        this.dropMigrationRepository = bl;
    }

    public MigrationGenerate(Connection connection, int n, String string, String string2, String string3, String string4, String string5) {
        this(connection, n, string, string2, string3, string4, string5, null, null, false);
    }

    public MigrationGenerate(Connection connection, int n, String string, String string2, String string3, String string4, String string5, RedshiftPreferenceSettings redshiftPreferenceSettings, String string6, boolean bl) {
        this.m_targetConnection = connection;
        this.m_convertVersion = n;
        this.m_awsAccessKey = string;
        this.m_awsSecretAccess = string2;
        this.m_awsS3BucketHTTPSLocation = string3;
        this.m_awsS3BucketURI = string4;
        this.setFileFormatDelimiter(string5);
        this.checkNull(redshiftPreferenceSettings);
        this.userPreferenceSettings = redshiftPreferenceSettings;
        this.migrationRepositoryPassword = string6;
        this.dropMigrationRepository = bl;
    }

    public void runGenerateDDL(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ExecutionException {
        this.traceFlow("start runGenerateDDL ...");
        this.runGenerateAll(backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end runGenerateDDL ...");
    }

    public void runGenerateData(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ExecutionException {
        this.traceFlow("start runGenerateData ...");
        this.runGenerateOCACopyData();
        backendDelegatorRaptorTask.checkCanProceed();
        this.runGenerateJobScheduler();
        backendDelegatorRaptorTask.checkCanProceed();
        this.runGenerateUnloadScript();
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end runGenerateData ...");
    }

    public void runGenerateAll(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ExecutionException {
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_GENERATOR.GenerateAll(?,?,?,?,?)}");
            oracleCallableStatement.setInt(1, 11111);
            oracleCallableStatement.setInt(2, 5);
            oracleCallableStatement.setString(3, "AWS_REDSHIFT");
            oracleCallableStatement.setInt(4, this.getConvertVersion());
            oracleCallableStatement.setString(5, this.getMigrationRepositoryPassword());
            oracleCallableStatement.executeUpdate();
        }
        backendDelegatorRaptorTask.checkCanProceed();
    }

    public void runGenerateOCACopyData() throws SQLException {
        this.traceFlow("start runGenerateOCACopyData ...");
        this.m_fileFormatDelimiter = this.getADWCCopyDataOptionsFromPreferences();
        this.traceFlow("setFileFormatDelimiter.adwcCopyDataOptions=" + this.m_fileFormatDelimiter);
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_GENERATOR.GenerateOCACopyDataUtilPkg(?,?,?,?,?,?)}");
            oracleCallableStatement.setInt(1, 11111);
            oracleCallableStatement.setInt(2, 5);
            oracleCallableStatement.setString(3, "AWS_REDSHIFT");
            oracleCallableStatement.setString(4, "REDSHIFT_ADWC_CREDS");
            oracleCallableStatement.setString(5, this.m_awsS3BucketHTTPSLocation);
            oracleCallableStatement.setString(6, this.getFileFormatDelimiter());
            oracleCallableStatement.executeUpdate();
        }
        this.traceFlow("end runGenerateOCACopyData ...");
    }

    public void runGenerateJobScheduler() throws SQLException {
        this.traceFlow("start runGenerateOCACopyData ...");
        this.m_fileFormatDelimiter = this.getADWCCopyDataOptionsFromPreferences();
        this.traceFlow("setFileFormatDelimiter.adwcCopyDataOptions=" + this.m_fileFormatDelimiter);
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_GENERATOR.GenerateSchedulerJobs(?)}");
            oracleCallableStatement.setString(1, this.userPreferenceSettings.getDBMSSchedulerType());
            oracleCallableStatement.executeUpdate();
        }
        this.traceFlow("end runGenerateOCACopyData ...");
    }

    public void runGenerateUnloadScript() throws SQLException {
        this.traceFlow("start runGenerateUnloadScript ...");
        String string = this.getRedshiftUnloadOptionsFromPreferencesNew();
        this.traceFlow("redshiftUnloadOption = " + string);
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_GENERATOR.GenerateUnloadScript(?,?,?,?,?,?,?)}");
            oracleCallableStatement.setInt(1, 11111);
            oracleCallableStatement.setInt(2, 5);
            oracleCallableStatement.setString(3, "AWS_REDSHIFT");
            oracleCallableStatement.setString(4, this.m_awsS3BucketURI);
            oracleCallableStatement.setString(5, this.m_awsAccessKey);
            oracleCallableStatement.setString(6, this.m_awsSecretAccess);
            oracleCallableStatement.setString(7, string);
            oracleCallableStatement.executeUpdate();
        }
        this.traceFlow("end runGenerateUnloadScript ...");
    }

    public void runGenerateExternalTable() throws SQLException {
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_GENERATOR.GenerateExternalTables(?,?,?,?,?,?,?)}");
            oracleCallableStatement.setInt(1, 11111);
            oracleCallableStatement.setInt(2, 5);
            oracleCallableStatement.setString(3, "AWS_REDSHIFT");
            oracleCallableStatement.setString(4, "&&EXTERNAL_DATA_FILE_DIR");
            oracleCallableStatement.setString(5, "&&EXTERNAL_LOG_FILE_DIR");
            oracleCallableStatement.setString(6, "&&EXTERNAL_DELIMITERS");
            oracleCallableStatement.setString(7, "&&EXTERNAL_FIELD_TERMINATOR");
            oracleCallableStatement.executeUpdate();
        }
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    public void setTargetConnection(Connection connection) {
        this.m_targetConnection = connection;
    }

    public int getConvertVersion() {
        return this.m_convertVersion;
    }

    public void setConvertVersion(int n) {
        this.m_convertVersion = n;
    }

    public String getAwsS3BucketHTTPSLocation() {
        return this.m_awsS3BucketHTTPSLocation;
    }

    public void setAS3BucketHTTPSLocation(String string) {
        this.m_awsS3BucketHTTPSLocation = string;
    }

    public String getFileFormatDelimiter() {
        return this.m_fileFormatDelimiter;
    }

    public void setFileFormatDelimiter(String string) {
        this.m_fileFormatDelimiter = string != null ? "json_object('delimiter' VALUE '" + string + "')" : "json_object('compression' value 'gzip', 'ignoremissingcolumns' value 'TRUE')";
    }

    public String getMigrationRepositoryPassword() {
        return this.migrationRepositoryPassword;
    }

    public void setMigrationRepositoryPassword(String string) {
        this.migrationRepositoryPassword = string;
    }

    public boolean isDropMigrationRepository() {
        return this.dropMigrationRepository;
    }

    public void setDropMigrationRepository(boolean bl) {
        this.dropMigrationRepository = bl;
    }

    private String getRedshiftUnloadOptionsFromPreferencesNew() {
        this.traceFlow("start getRedshiftUnloadOptionsFromPreferencesNew ...");
        Object object = "parallel on gzip maxfilesize as 1 GB".toUpperCase();
        if (this.userPreferenceSettings.getRedshiftAllowOverWrite().booleanValue()) {
            object = (String)object + " ALLOWOVERWRITE";
        }
        this.traceFlow("getRedshiftUnloadOptionsFromPreferencesNew.unloadOptions=" + (String)object);
        this.traceFlow("end getRedshiftUnloadOptionsFromPreferencesNew ...");
        return object;
    }

    private String getADWCCopyDataOptionsFromPreferences() {
        Object object = "json_object(";
        object = (String)object + " 'compression' value 'gzip'";
        object = (String)object + ", ";
        object = (String)object + " 'ignoremissingcolumns' value 'TRUE' ";
        if (this.userPreferenceSettings.getADWCRejlim() != null && this.userPreferenceSettings.getADWCRejlim().length() > 0 && !this.userPreferenceSettings.getADWCRejlim().equals("0")) {
            object = (String)object + ", ";
            object = (String)object + " 'rejectlimit' value '" + this.userPreferenceSettings.getADWCRejlim() + "' ";
        }
        object = (String)object + " )";
        this.traceFlow("adwcLoadOptions=" + (String)object);
        this.traceFlow("end getADWCCopyDataOptionsFromPreferences ...");
        return object;
    }

    private void checkNull(RedshiftPreferenceSettings redshiftPreferenceSettings) {
    }

    private void traceFlow(String string) {
    }
}

