/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.deploy.redshift;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.dataload.DwcsSQLQueryExecution;
import oracle.jdbc.OracleCallableStatement;

public class DeployExternalTables {
    private Connection m_targetConnection = null;
    private String[] m_sqlScriptsCommands;
    private String m_sqlScriptDirectory = null;
    private boolean m_startDeployment = false;

    public DeployExternalTables(Connection connection, String string, boolean bl) {
        this.m_targetConnection = connection;
        this.m_sqlScriptDirectory = string;
        this.m_startDeployment = bl;
    }

    public void deployExternalTablesToTarget() throws IOException, SQLException {
        this.m_sqlScriptsCommands = this.getExternalTablesSqlScripts();
        if (this.m_sqlScriptDirectory != null) {
            this.writeExternalTableDDLScript();
        }
    }

    private String[] getExternalTablesSqlScripts() throws SQLException {
        String[] stringArray = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_all_external_tables_scripts}");
            oracleCallableStatement.registerOutParameter(1, 2003, "sqldev_migrepos".toUpperCase() + ".DATA_SCRIPT");
            oracleCallableStatement.executeUpdate();
            stringArray = (String[])oracleCallableStatement.getARRAY(1).getArray();
        }
        return stringArray;
    }

    private void runSQLScriptOnTarget(String string) throws SQLException {
        DwcsSQLQueryExecution.executeSQLQuery(string, this.getTargetConnection());
    }

    public void writeExternalTableDDLScript() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "ddl" + File.separator + "external_tables.sql"));
        printWriter.write("-- Define all External Table variables here --" + MigrationUtilities.getLineSeparator());
        printWriter.write("DEFINE EXTERNAL_DATA_FILE_DIR = <data file directory>" + MigrationUtilities.getLineSeparator());
        printWriter.write("DEFINE EXTERNAL_LOG_FILE_DIR = <logfile directory>" + MigrationUtilities.getLineSeparator());
        printWriter.write("DEFINE EXTERNAL_DELIMITERS = <delimiter>" + MigrationUtilities.getLineSeparator());
        printWriter.write("DEFINE EXTERNAL_FIELD_TERMINATOR = <field terminator>" + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        printWriter.write("SET ECHO ON" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET VERIFY OFF" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET FEEDBACK ON" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET CLASSIC OFF" + MigrationUtilities.getLineSeparator());
        printWriter.write("set serveroutput on" + MigrationUtilities.getLineSeparator());
        printWriter.write("spool externalTable.log" + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        for (int i = 0; i < this.m_sqlScriptsCommands.length; ++i) {
            printWriter.write(this.m_sqlScriptsCommands[i] + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        }
        printWriter.write("spool off" + MigrationUtilities.getLineSeparator());
        printWriter.close();
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }
}

