/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.utils;

public final class MigrationConstants {
    public static final String projectName = "REDSHIFT_PROJECT";
    public static final String projectDescription = "Description for REDSHIFT_PROJECT";
    public static final int projectID = 11111;
    public static final int connectionID = 5;
    public static final String sourceDatabase = "AWS_REDSHIFT";
    public static int captureVersion = 1;
    public static int convertVersion = 1;
    public static String migrationRepoLogFileName = "MigrationRepository.log";
    public static final String migrationReposName = "sqldev_migrepos";
    public static final String adwcTargetReposName = "admin";
    public static final String m_repositoryPackageName = "oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_REPOSITORY.pls";
    public static final String m_repositoryQueryPackageName = "oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_REPOSITORY_QUERY.pls";
    public static final String m_sessionStatePackageName = "oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_SESSIONSTATE.pls";
    public static final String m_transformerPackage = "oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_TRANSFORMER.pls";
    public static final String m_redshiftCapturePackageName = "oracle/dbtools/migration/cloud/capture/redshift/plsql/REDSHIFT_CAPTURE.pls";
    public static final String m_convertPackageName = "oracle/dbtools/migration/cloud/convert/plsql/MIGRATION_CONVERT.pls";
    public static final String m_generatePackageName = "oracle/dbtools/migration/cloud/generate/plsql/MIGRATION_GENERATOR.pls";
    public static final String m_redshiftDeploymentName = "oracle/dbtools/migration/cloud/deploy/redshift/plsql/REDSHIFT_DEPLOY.pls";
    public static final String m_migrationUtilPackageName = "oracle/dbtools/migration/cloud/core/utils/plsql/MIGRATION_UTILS.pls";
    public static final String m_migrationSchedulerPackageName = "oracle/dbtools/migration/cloud/scheduler/plsql/MIGRATION_SCHEDULER.pls";
    public static final String m_migrationUtilitiesPackageName = "oracle/dbtools/migration/cloud/metadata/repository/plsql/REDSHIFT_MIGRATION_UTILITIES.pls";
    public static final String m_executeServeroutputOn = "SET SERVEROUTPUT ON";
    public static final String m_alterSessionToSqldevMigRepos = "ALTER SESSION SET CURRENT_SCHEMA=" + "sqldev_migrepos".toUpperCase();
    public static final String m_alterSessionToPDB_ADMIN = "ALTER SESSION SET CURRENT_SCHEMA=<username>";
    public static final String m_currentUser = "select user from dual ";
    public static final String m_executeCreateRepositoryPackage = "EXECUTE MIGRATION_REPOSITORY.createAllRepositoryTables()";
    public static final String m_executeDropRepositoryPackage = "EXECUTE MIGRATION_REPOSITORY.dropAllRepositoryTables()";
    public static final String m_executeTruncateRepositoryPackage = "EXECUTE MIGRATION_REPOSITORY.truncateAllRepositoryTables()";
    public static final String m_dropMigrationRepositoryPackage = "DROP package MIGRATION_REPOSITORY";
    public static final String redshiftJdbcConnection = "<REDSHIFT_JDBC_CONNECTION>";
    public static final String redshiftSchemaArray = "<SCHEMA_ARRAY>";
    public static final String redshiftUnloadOption = "parallel on gzip maxfilesize as 1 GB";
    public static final String credentialNameDWCS = "REDSHIFT_ADWC_CREDS";
    public static final String createDWCSCredentialQuery = "execute DBMS_CLOUD.create_credential(credential_name => '<DWCS_CRED>', username => '<aws_access_key>', password => '<aws_secret_key>')";
    public static final String dropDWCSCredentialQuery = "execute DBMS_CLOUD.drop_credential(credential_name => '<DWCS_CRED>')";
    public static final String fileFormatDelimiters = "json_object('compression' value 'gzip', 'ignoremissingcolumns' value 'TRUE')";
    public static final String migrationReposCheckQuery = "select username from all_users where username = '" + "sqldev_migrepos".toUpperCase() + "'";
    public static final String validateRedshiftSQLQuery = "select table_name from information_schema.tables where table_schema NOT IN ('pg_internal', 'information_schema', 'pg_catalog') and table_type = 'BASE TABLE' and table_schema in ('<schema_name>') order by table_name limit 1";
    public static final String validateUnloadCommand = "unload ('select count(*) from <schema_name>.<table_name>') to '<s3_bucket>' credentials 'aws_access_key_id=<aws_access_key>;aws_secret_access_key=<aws_secret_access>' parallel off ALLOWOVERWRITE";
    public static final String[] createUserSQLScript = new String[]{"CREATE USER <username> IDENTIFIED BY <password>", "grant resource, create session, create user, create table, create procedure, drop user, DWROLE to <username>", "grant create job to <username>", "grant inherit privileges on user admin to <username>", "ALTER USER <username> QUOTA UNLIMITED ON DATA"};
    public static final String dropUserSQLScript = "DROP USER sqldev_migrepos CASCADE";
    public static final String lockExpirePwdGeneratedSchemaSQLScript = "ALTER USER <generated_schema> account lock password expire";
    public static final String getGeneratedSchemaNamesSQLScript = "SELECT schema_name FROM sqldev_migrepos.MD_GENERATE WHERE OBJECT_TYPE= 'SCHEMA'";
    public static final String getGeneratedSchemaNamesSQLScript_selected = "SELECT schema_name FROM sqldev_migrepos.MD_GENERATE WHERE OBJECT_TYPE= 'SCHEMA' and schema_name in (<deployable_schemas>)";
    public static final String captureSchemaNameQuery = "select distinct table_schema as schema_name from information_schema.tables where table_schema NOT IN ('pg_internal', 'information_schema', 'pg_catalog')";
    public static final String ext_datafile_dir = "&&EXTERNAL_DATA_FILE_DIR";
    public static final String ext_logfile_dir = "&&EXTERNAL_LOG_FILE_DIR";
    public static final String ext_delimiter = "&&EXTERNAL_DELIMITERS";
    public static final String ext_field_terminator = "&&EXTERNAL_FIELD_TERMINATOR";
    public static final String ddl_directory = "ddl";
    public static final String data_directory = "data";
    public static final String readmeTxtFileName = "readme.txt";
    public static final String ddlFileName = "adwc_ddl.sql";
    public static final String redshiftUnloadFileName = "redshift_s3unload.sql";
    public static final String dwcsDataLoadFileName = "adwc_dataload.sql";
    public static final String dwcsDataLoadSchedulerFileName = "adwc_dataload_scheduler.sql";
    public static final String externalTableFileName = "external_tables.sql";
    public static final String migrationReportFileName = "redshift_migration_report";
    public static final String adwc_data_report = "SELECT id, sid, owner_name, table_name, rows_loaded, logfile_table, badfile_table, status FROM DBA_LOAD_OPERATIONS WHERE id = ( select operation_id from sqldev_migrepos.MD_REPORT where TARGET_SCHEMA_NAME= '<schemaname>' and TARGET_TABLE_NAME = '<tablename>') ";
    public static final String s3unload_scripts = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String s3unload_scripts_selected = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and sche.oracle_name in (<deployable_schemas>) and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String dataload_scripts = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'OCA_COPY_DATA' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String dataload_scripts_selected = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'OCA_COPY_DATA' and tabl.oracle_name = gen.object_name and gen.schema_name in (<deployable_schemas>) and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String dataload_scheduler_scripts = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'JOB_SCHEDULER' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String dataload_scheduler_scripts_selected = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'JOB_SCHEDULER' and tabl.oracle_name = gen.object_name and gen.schema_name in (<deployable_schemas>) and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc";
    public static final String rownum_script = "SELECT sche.oracle_name||'.'||tabl.oracle_name, TRIM(TO_CHAR(num_rows, '999,999,999,999,999,999')) FROM sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE tabl.type = 'CONVERTED' and sche.type = 'CONVERTED' order by num_rows asc";
    public static final String rownum_script_selected = "SELECT sche.oracle_name||'.'||tabl.oracle_name, TRIM(TO_CHAR(num_rows, '999,999,999,999,999,999')) FROM sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE tabl.type = 'CONVERTED' and sche.type = 'CONVERTED' and sche.oracle_name in (<deployable_schemas>) order by num_rows asc";
    public static final String total_tables_script = "SELECT count(*) FROM sqldev_migrepos.md_tables WHERE type = 'CONVERTED'";
    public static final String total_tables_script_selected = "SELECT count(*) FROM sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE tabl.type = 'CONVERTED' and sche.type = 'CONVERTED' and sche.oracle_name in (<deployable_schemas>) and tabl.schema_name = sche.schema_name";
    public static final String all_users_query = "SELECT username from sys.all_users";
    public static final String drop_run_redshift_dataload_script_proc = "drop PROCEDURE run_redshift_dataload_script;";
    public static final String drop_redshift_migration_utility_pkg = "drop PACKAGE redshift_migration_utilities;";
    public static final String compile_redshift_migration_utility_pkg = "ALTER PACKAGE REDSHIFT_MIGRATION_UTILITIES COMPILE;";
    public static final String generateReportFromMD_REPORT = "select operation_id, logfile_table, badfile_table, source_schema_name, source_table_name, source_table_rows, target_schema_name, target_table_name, target_table_rows_loaded,  error_messages, status, start_time, end_time from " + "sqldev_migrepos".toUpperCase() + ".MD_REPORT order by target_table_rows_loaded, target_schema_name, target_table_name";
}

