/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.capture.redshift.online;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftQueryCapture;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.utils.Connections;

public class RedshiftAccessKeySecretAccessS3BucketValidator {
    private static final Logger LOGGER = Logger.getLogger(RedshiftQueryCapture.class.getName());

    private RedshiftAccessKeySecretAccessS3BucketValidator() {
        throw new UnsupportedOperationException("Error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateRedshiftAccessKeySecretAccessS3Bucket(String string, String[] stringArray, String string2, String string3, String string4) throws SQLException {
        String string5;
        Object object;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(string);
            boolean bl = false;
            object = null;
            string5 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = RedshiftAccessKeySecretAccessS3BucketValidator.getRedshiftTable(connection, stringArray[i]);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                bl = true;
                object = stringArray2[0];
                if (((String)object).startsWith(" ") || ((String)object).endsWith(" ")) {
                    object = "\"" + (String)object + "\"";
                }
                string5 = stringArray[i];
                break;
            }
            if (!bl) {
                String string6 = Utilities.nls("VALIDATION_ERROR_REDSHIFT_ACCESSKEY_NO_TABLES");
                return string6;
            }
            String string7 = "unload ('select count(*) from <schema_name>.<table_name>') to '<s3_bucket>' credentials 'aws_access_key_id=<aws_access_key>;aws_secret_access_key=<aws_secret_access>' parallel off ALLOWOVERWRITE".replace("<schema_name>", string5).replace("<table_name>", (CharSequence)object).replace("<s3_bucket>", MigrationUtilities.generateS3BucketStringFromURL(string4)).replace("<aws_access_key>", string2).replace("<aws_secret_access>", string3);
            RedshiftAccessKeySecretAccessS3BucketValidator.executeSQL(string7, connection);
        }
        catch (Exception exception) {
            LOGGER.severe(Messages.getString((String)Utilities.nls("REDSHIFT_CONNECTION_FAILED")));
            object = exception.getMessage();
            if (!((String)object).startsWith("[JDBC Driver]")) {
                string5 = ((String)object).substring(0, ((String)object).indexOf(".") + 1);
                return string5;
            }
            string5 = null;
            return string5;
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        return null;
    }

    public static String[] getRedshiftTable(Connection connection, String string) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ResultSet resultSet = RedshiftAccessKeySecretAccessS3BucketValidator.executeSQLQuery("select table_name from information_schema.tables where table_schema NOT IN ('pg_internal', 'information_schema', 'pg_catalog') and table_type = 'BASE TABLE' and table_schema in ('<schema_name>') order by table_name limit 1".replace("<schema_name>", string), connection);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (Exception exception) {
            LOGGER.severe(Messages.getString((String)Utilities.nls("REDSHIFT_CONNECTION_FAILED")));
        }
        return arrayList.toArray(new String[0]);
    }

    public static ResultSet executeSQLQuery(String string, Connection connection) throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        catch (Exception exception) {
            if (statement != null) {
                statement.close();
            }
            throw new SQLException(exception.getLocalizedMessage());
        }
        return resultSet;
    }

    public static void executeSQL(String string, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        catch (Exception exception) {
            if (statement != null) {
                statement.close();
            }
            throw new SQLException(exception.getLocalizedMessage());
        }
    }
}

