/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.capture.redshift.online;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.dbtools.migration.cloud.ui.log.LogManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdeveloper.db.ConnectionException;

public class AWSDataUnloadAndADWCDataLoadTask
extends RaptorTask<Void> {
    private static Object _LOCK_ = new Object();
    private String m_sourceSQLScript;
    private String m_targetSQLScript;
    private String m_dataUnLoadMessage;
    private String m_dataLoadMessage;
    private static BackendDelegatorRaptorTask m_backendDelegatorRaptorTask;
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private String m_schemaTableName;
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getUniqueConnection(String string) throws ConnectionException {
        Object object = _LOCK_;
        synchronized (object) {
            return Connections.getInstance().getUniqueConnection(string);
        }
    }

    public AWSDataUnloadAndADWCDataLoadTask(String string) {
        super(string, true, IRaptorTaskRunMode.TASKVIEWER);
    }

    protected Void doWork() throws TaskException {
        try {
            this.traceFlow(" IN Thread UNLOAD and LOADING for TableName  ");
            this.getBackendDelegatorRaptorTask().checkCanProceed();
            this.checkCanProceed();
            this.setMessage(this.getDataUnLoadMessage());
            this.executeDataUnLoadScript(this.getSourceSQLScript(), this.getBackendDelegatorRaptorTask());
            this.traceFlow(" UNLOADED Table Script  " + this.getSourceSQLScript());
            this.checkCanProceed();
            this.getBackendDelegatorRaptorTask().checkCanProceed();
            this.setMessage(this.getDataLoadMessage());
            this.executeDataLoadScript(this.getTargetSQLScript(), this.getBackendDelegatorRaptorTask());
            this.traceFlow(" LOADED Table Script  " + this.getTargetSQLScript());
            this.checkCanProceed();
            this.getBackendDelegatorRaptorTask().checkCanProceed();
            this.traceFlow(" OUT Thread UNLOAD and LOADING for TableName  ");
        }
        catch (SQLException sQLException) {
            AWSDataUnloadAndADWCDataLoadTask.getLogManager().logStringWithComments("SQLException Exception happened.", sQLException);
            throw new TaskException(sQLException.getMessage(), sQLException.getCause());
        }
        catch (ConnectionException connectionException) {
            AWSDataUnloadAndADWCDataLoadTask.getLogManager().logStringWithComments("Connection Exception happened.", (Exception)((Object)connectionException));
            throw new TaskException(connectionException.getMessage(), connectionException.getCause());
        }
        catch (ExecutionException executionException) {
            AWSDataUnloadAndADWCDataLoadTask.getLogManager().logStringWithComments("Excecution Exception happened.", executionException);
            throw new TaskException(executionException.getMessage(), executionException.getCause());
        }
        catch (Exception exception) {
            AWSDataUnloadAndADWCDataLoadTask.getLogManager().logStringWithComments("Excecution Exception happened.", exception);
            throw new TaskException(exception.getMessage(), exception.getCause());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDataUnLoadScript(String string, BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, ExecutionException {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_sourceConnectionName);
            statement = connection.createStatement();
            backendDelegatorRaptorTask.checkCanProceed();
            statement.execute(string);
            backendDelegatorRaptorTask.checkCanProceed();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeDataLoadScript(String string, BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, ExecutionException {
        Connection connection = null;
        int n = 999999;
        try {
            backendDelegatorRaptorTask.checkCanProceed();
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_targetConnectionName);
            if (Connections.getInstance().lock(connection)) {
                DBUtil.getInstance((Connection)connection).execute(string);
            }
            backendDelegatorRaptorTask.checkCanProceed();
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        return n;
    }

    public void traceFlow(String string) {
    }

    public String getTargetConnectionName() {
        return this.m_targetConnectionName;
    }

    public void setTargetConnectionName(String string) {
        this.m_targetConnectionName = string;
    }

    public String getSourceConnectionName() {
        return this.m_sourceConnectionName;
    }

    public void setSourceConnectionName(String string) {
        this.m_sourceConnectionName = string;
    }

    public String getSourceSQLScript() {
        return this.m_sourceSQLScript;
    }

    public void setSourceSQLScript(String string) {
        this.m_sourceSQLScript = string;
    }

    public String getTargetSQLScript() {
        return this.m_targetSQLScript;
    }

    public void setTargetSQLScript(String string) {
        this.m_targetSQLScript = string;
    }

    public String getDataUnLoadMessage() {
        return this.m_dataUnLoadMessage;
    }

    public void setDataUnLoadMessage(String string) {
        this.m_dataUnLoadMessage = string;
    }

    public String getDataLoadMessage() {
        return this.m_dataLoadMessage;
    }

    public void setDataLoadMessage(String string) {
        this.m_dataLoadMessage = string;
    }

    public BackendDelegatorRaptorTask getBackendDelegatorRaptorTask() {
        return m_backendDelegatorRaptorTask;
    }

    public void setBackendDelegatorRaptorTask(BackendDelegatorRaptorTask backendDelegatorRaptorTask) {
        m_backendDelegatorRaptorTask = backendDelegatorRaptorTask;
    }

    public static LogManager getLogManager() {
        return BackendDelegatorRaptorTask.getLogManager();
    }

    public String getSchemaTableName() {
        return this.m_schemaTableName;
    }

    public void setSchemaTableName(String string) {
        this.m_schemaTableName = string;
    }
}

