/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.workflowImport;

import java.awt.Component;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.model.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.migration.Migration;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;
import oracle.xdb.XMLType;

public class WorkflowImport {
    private static final Logger theLogger = Logger.getLogger(Workflow.class.getName());

    public static Workflow WorkFlowImport(Context context, BigDecimal bigDecimal, String string, boolean bl, StringBuffer stringBuffer) throws Exception, JAXBException {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = new Timestamp[]{new Timestamp(0L)};
        Workflow workflow = null;
        BigDecimal bigDecimal2 = null;
        Connection connection = ConnectionFolder.getConnection(context, ConnectionProperties.UNIQUE);
        try {
            String string2 = stringBuffer.toString();
            if (!string2.startsWith("<?xml") || string2.indexOf("WorkflowProcess") <= 0) {
                throw new Exception("INVALID_WORKFLOW_XML");
            }
            String string3 = ConnectionFolder.getUserAccountName(context);
            string2 = string2.replaceAll("Schema=\"\"", "Schema=\"" + StringUtils.trimDoubleQuotes(string3) + "\"");
            Migration migration = Migration.getInstance();
            WorkflowProcess workflowProcess = migration.migrate(context, string2);
            if (workflowProcess != null) {
                XMLType xMLType;
                Object object;
                odmrWorkflow = new OdmrWorkflow(connection);
                bigDecimal2 = Workflow.create(connection, bigDecimal, string, null, timestampArray);
                workflow = new Workflow(string, bigDecimal2, bigDecimal);
                workflow.setWorkflowProcess(workflowProcess);
                oracle.ide.model.Node node = context.getNode();
                WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(node.getURL().getPath() + "/" + string, true);
                workflowNode.setWorkflowModel(new WorkflowModel());
                workflowNode.setRepositoryData(workflow);
                workflowNode.ensureOpen();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                ProjectFolder projectFolder = (ProjectFolder)node.getData();
                workflowNode.setParent(projectFolder.getParent());
                context.setNode((oracle.ide.model.Node)workflowNode);
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                Version version = connectionFolder.getDbVersion();
                context.setProperty("TARGET_DATABASE_VERSION", (Object)version);
                context.setProperty("SOURCE_DATABASE_VERSION", (Object)version);
                StringBuffer stringBuffer2 = new StringBuffer("");
                if (workflowProcess.getDBVersion() != null && workflowProcess.getDBVersion().equals(version.toString())) {
                    workflowModel.load(workflow.getWorkflowProcess(), context);
                } else {
                    workflowModel.load(workflow.getWorkflowProcess(), context, true, stringBuffer2);
                    if (stringBuffer2 != null && stringBuffer2.length() > 0) {
                        String string4 = MessageFormat.format(WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES"), stringBuffer2.toString());
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES_TITLE"), null);
                        Workflow.delete(connection, bigDecimal2);
                        Workflow workflow2 = null;
                        return workflow2;
                    }
                }
                workflowModel.initOldNodeIds();
                workflowModel.setInPaste(true);
                ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
                Collection<Object> collection = workflowModel.getObjectsCollection();
                boolean bl2 = false;
                for (Object object22 : collection) {
                    if (!(object22 instanceof AbstractNode)) continue;
                    object = (AbstractNode)object22;
                    ((AbstractObject)object).getContext().setNode(context.getNode());
                    xMLType = ((AbstractNode)object).findParentNodes();
                    if (xMLType.isEmpty()) {
                        arrayList.add((AbstractNode)object);
                    }
                    if (object instanceof BuildTextNodeRef) {
                        bl2 = true;
                    }
                    ((AbstractNode)object).setNodeReady();
                }
                workflowModel.beginRefactoring();
                for (Node node2 : arrayList) {
                    node2.refactor(null, !bl);
                }
                WorkflowUtils.refactorPostProcess(workflowModel, collection);
                for (Node node3 : arrayList) {
                    node3.validate(true);
                }
                if (bl2) {
                    MessageDialog.optionalInformation((String)(Workflow.class.getName() + "containsTextRefNodeWarning"), (Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_CONTAINS_TEXT_REF"), (String)WorkflowLrb.get("CREATE_WORKFLOW_WARNING_NAME"), null);
                }
                workflowModel.endRefactoring();
                workflowModel.setInPaste(false);
                context.setNode(node);
                StringWriter stringWriter = new StringWriter();
                Marshaller marshaller = Workflow.createMarshaller();
                marshaller.marshal((Object)workflow.getWorkflowProcess(), (Writer)stringWriter);
                object = stringWriter.getBuffer();
                xMLType = XMLType.createXML((Connection)connection, (String)((StringBuffer)object).toString());
                String string4 = "Y";
                odmrWorkflow.wfSave(bigDecimal2, xMLType, timestampArray, "W", string4);
            }
        }
        catch (Exception exception) {
            if (bigDecimal2 != null) {
                Workflow.delete(connection, bigDecimal2);
            }
            throw exception;
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
            }
            SQLHelper.close(connection);
        }
        return workflow;
    }
}

