/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.JavaFormat;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.teditor.graph.AbstractDialog;
import oracle.dmt.dataminer.workflow.scheduler.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.RepeatComboBoxModel;
import oracle.dmt.dataminer.workflow.scheduler.SaveAsSchedulePanel;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleDialog;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleRepeatPanel;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class ScheduleWorkflowDialog
extends AbstractDialog {
    private Logger theLogger = Logger.getLogger(this.getClass().getName());
    private JFrame parent;
    private boolean dialogOk;
    private Context context;
    private boolean isEdit;
    private DateTimeEditor startTimeEditor;
    private DateTimeEditor endTimeEditor;
    private JSpinner spinner;
    private JMultiLineLabel repeatTextArea;
    private JMultiLineLabel scheduleTextArea;
    private String curRepeatSel;
    private SchedulerModel model;
    private AdvancedSettingsPanel advancedSettings = null;
    private boolean isUIRendering = false;
    private static String SCHEDULER_END_REPEAT_OPTION_NEVER = DialogsLrb.get("SCHEDULER_END_REPEAT_OPTION_NEVER");
    private static String SCHEDULER_END_REPEAT_OPTION_AFTER = DialogsLrb.get("SCHEDULER_END_REPEAT_OPTION_AFTER");
    private static String SCHEDULER_END_REPEAT_OPTION_ON_DATE = DialogsLrb.get("SCHEDULER_END_REPEAT_OPTION_ON_DATE");
    private static String SCHEDULER_SELECT_A_SCHEDULE = DialogsLrb.get("SCHEDULER_SELECT_A_SCHEDULE");
    private static SchedulerModel.ScheduleInfo SCHEDULER_SELECT_A_SCHEDULE_OBJ = new SchedulerModel.ScheduleInfo();
    private static String DEFAULT_SCHEDULE_NAME = "SCHEDULE";
    private CalendarPopupButton EndRepeatCalendarButton;
    private CalendarPopupButton StartDateCalendarButton;
    private JButton jAddScheduleButton;
    private JButton jAdvanceButton;
    private JButton jCancelButton;
    private JPanel jCustomRepeatPanel;
    private JButton jEditScheduleButton;
    private JComboBox jEndRepeatComboBox;
    private JLabel jEndRepeatLabel;
    private JPanel jEndRepeatPanel;
    private JButton jHelpButton;
    private JButton jOKButton;
    private JButton jRemoveScheduleButton;
    private JComboBox jRepeatComboBox;
    private JLabel jRepeatLabel;
    private JButton jSaveAsScheduleButton;
    private JComboBox jScheduleComboBox;
    private JPanel jSchedulePanel;
    private JLabel jStartDateLabel;
    private JPanel jStartDatePanel;
    private JCheckBox jUseExistingScheduleCheckBox;

    public ScheduleWorkflowDialog(JFrame jFrame, Context context, SchedulerModel schedulerModel, boolean bl) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.context = context;
        this.isEdit = bl;
        this.model = schedulerModel;
        this.dialogOk = false;
        SCHEDULER_SELECT_A_SCHEDULE_OBJ.setName(SCHEDULER_SELECT_A_SCHEDULE);
        this.initComponents();
        this.initRes();
        this.initUI();
        this.setLocationRelativeTo(jFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponents() {
        this.jStartDateLabel = new JLabel();
        this.jStartDatePanel = new JPanel();
        Object object = this;
        synchronized (object) {
            this.StartDateCalendarButton = new CalendarPopupButton();
        }
        this.jSaveAsScheduleButton = new JButton();
        this.jRepeatLabel = new JLabel();
        this.jRepeatComboBox = new JComboBox();
        this.jCustomRepeatPanel = new JPanel();
        this.jEndRepeatLabel = new JLabel();
        this.jEndRepeatComboBox = new JComboBox();
        this.jEndRepeatPanel = new JPanel();
        object = this;
        synchronized (object) {
            this.EndRepeatCalendarButton = new CalendarPopupButton();
        }
        this.jUseExistingScheduleCheckBox = new JCheckBox();
        this.jScheduleComboBox = new JComboBox();
        this.jEditScheduleButton = new JButton();
        this.jAddScheduleButton = new JButton();
        this.jRemoveScheduleButton = new JButton();
        this.jSchedulePanel = new JPanel();
        this.jHelpButton = new JButton();
        this.jAdvanceButton = new JButton();
        this.jCancelButton = new JButton();
        this.jOKButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.jStartDateLabel.setLabelFor(this.jStartDatePanel);
        this.jStartDateLabel.setText("Start Date:");
        this.jStartDatePanel.setPreferredSize(new Dimension(60, 20));
        this.jStartDatePanel.setLayout(new BorderLayout());
        object = this;
        synchronized (object) {
            this.StartDateCalendarButton.setBorder(null);
            this.StartDateCalendarButton.setBorderPainted(false);
            this.StartDateCalendarButton.setContentAreaFilled(false);
        }
        this.jSaveAsScheduleButton.setText("+");
        this.jSaveAsScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jSaveAsScheduleButtonActionPerformed(actionEvent);
            }
        });
        this.jRepeatLabel.setLabelFor(this.jRepeatComboBox);
        this.jRepeatLabel.setText("Repeat:");
        this.jRepeatLabel.setMaximumSize(new Dimension(54, 14));
        this.jRepeatLabel.setMinimumSize(new Dimension(54, 14));
        this.jRepeatLabel.setPreferredSize(new Dimension(54, 14));
        this.jRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Every Day", "Every Week", "Custom"}));
        this.jRepeatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jRepeatComboBoxActionPerformed(actionEvent);
            }
        });
        this.jCustomRepeatPanel.setLayout(new BorderLayout());
        this.jEndRepeatLabel.setLabelFor(this.jEndRepeatComboBox);
        this.jEndRepeatLabel.setText("End Repeat:");
        this.jEndRepeatLabel.setMaximumSize(new Dimension(54, 14));
        this.jEndRepeatLabel.setMinimumSize(new Dimension(54, 14));
        this.jEndRepeatLabel.setPreferredSize(new Dimension(54, 14));
        this.jEndRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Never", "After", "On Date"}));
        this.jEndRepeatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jEndRepeatComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEndRepeatPanel.setPreferredSize(new Dimension(60, 20));
        this.jEndRepeatPanel.setLayout(new BorderLayout());
        object = this;
        synchronized (object) {
            this.EndRepeatCalendarButton.setBorder(null);
            this.EndRepeatCalendarButton.setBorderPainted(false);
            this.EndRepeatCalendarButton.setContentAreaFilled(false);
        }
        this.jUseExistingScheduleCheckBox.setText("Use Existing Schedule");
        this.jUseExistingScheduleCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.jUseExistingScheduleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jUseExistingScheduleCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jScheduleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jScheduleComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditScheduleButton.setText("+");
        this.jEditScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jEditScheduleButtonActionPerformed(actionEvent);
            }
        });
        this.jAddScheduleButton.setText("+");
        this.jAddScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jAddScheduleButtonActionPerformed(actionEvent);
            }
        });
        this.jRemoveScheduleButton.setText("+");
        this.jRemoveScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jRemoveScheduleButtonActionPerformed(actionEvent);
            }
        });
        this.jSchedulePanel.setLayout(new BorderLayout());
        this.jHelpButton.setText("Help");
        this.jHelpButton.setPreferredSize(new Dimension(65, 23));
        this.jAdvanceButton.setText("Advanced...");
        this.jAdvanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jAdvanceButtonActionPerformed(actionEvent);
            }
        });
        this.jCancelButton.setText("Cancel");
        this.jCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jCancelButtonActionPerformed(actionEvent);
            }
        });
        this.jOKButton.setText("Ok");
        this.jOKButton.setPreferredSize(new Dimension(65, 23));
        this.jOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleWorkflowDialog.this.jOKButtonActionPerformed(actionEvent);
            }
        });
        object = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)object);
        ((GroupLayout)object).setHorizontalGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jStartDateLabel, -1, 68, Short.MAX_VALUE).addComponent(this.jRepeatLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRepeatComboBox, 0, 150, Short.MAX_VALUE).addComponent(this.jStartDatePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.StartDateCalendarButton, -2, -1, -2).addGap(76, 76, 76).addComponent(this.jSaveAsScheduleButton, -2, 25, -2)).addComponent(this.jCustomRepeatPanel, -1, -1, Short.MAX_VALUE))).addGroup(((GroupLayout)object).createSequentialGroup().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUseExistingScheduleCheckBox).addGroup(((GroupLayout)object).createSequentialGroup().addComponent(this.jEndRepeatLabel, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEndRepeatComboBox, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEndRepeatPanel, -2, 152, -2).addGap(8, 8, 8).addComponent((Component)this.EndRepeatCalendarButton, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(((GroupLayout)object).createSequentialGroup().addComponent(this.jHelpButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jAdvanceButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jOKButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCancelButton))).addContainerGap()).addGroup(((GroupLayout)object).createSequentialGroup().addGap(31, 31, 31).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSchedulePanel, -1, -1, Short.MAX_VALUE).addGroup(((GroupLayout)object).createSequentialGroup().addComponent(this.jScheduleComboBox, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditScheduleButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAddScheduleButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveScheduleButton, -2, 25, -2))).addGap(28, 28, 28)));
        ((GroupLayout)object).setVerticalGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(((GroupLayout)object).createSequentialGroup().addContainerGap().addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jStartDateLabel, -2, 21, -2).addComponent(this.jStartDatePanel, -2, -1, -2).addComponent((Component)this.StartDateCalendarButton, -2, -1, -2).addComponent(this.jSaveAsScheduleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRepeatLabel, -2, -1, -2).addComponent(this.jRepeatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCustomRepeatPanel, -1, -1, Short.MAX_VALUE).addGap(8, 8, 8).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jEndRepeatPanel, -2, -1, -2).addComponent((Component)this.EndRepeatCalendarButton, -2, -1, -2).addComponent(this.jEndRepeatComboBox, -2, -1, -2).addComponent(this.jEndRepeatLabel, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jUseExistingScheduleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jScheduleComboBox, -2, -1, -2).addComponent(this.jEditScheduleButton).addComponent(this.jAddScheduleButton).addComponent(this.jRemoveScheduleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSchedulePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(((GroupLayout)object).createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jHelpButton, -2, -1, -2).addComponent(this.jAdvanceButton).addComponent(this.jOKButton, -2, -1, -2).addComponent(this.jCancelButton)).addContainerGap()));
        this.pack();
    }

    private void jSaveAsScheduleButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.model.genUniqueScheduleName(DEFAULT_SCHEDULE_NAME);
        SaveAsSchedulePanel saveAsSchedulePanel = new SaveAsSchedulePanel(this, this.context, string);
        if (saveAsSchedulePanel.showAsDialog(this)) {
            final class CreateScheduleObjectProc
            extends ProgressRunnable {
                private String name;
                private Exception exception;

                CreateScheduleObjectProc(String string) {
                    this.name = string;
                }

                protected Object doWork() throws Exception {
                    try {
                        ScheduleWorkflowDialog.this.model.setScheduleName(this.name);
                        ScheduleWorkflowDialog.this.model.setUseSchedule(true);
                        ScheduleWorkflowDialog.this.model.createScheduleObject();
                        ScheduleWorkflowDialog.this.model.loadSchedules();
                    }
                    catch (Exception exception) {
                        this.exception = exception;
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                protected void finish(Object object) {
                    if (this.exception != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)this.exception.getLocalizedMessage(), null);
                    }
                    DefaultComboBoxModel<SchedulerModel.ScheduleInfo> defaultComboBoxModel = new DefaultComboBoxModel<SchedulerModel.ScheduleInfo>();
                    for (SchedulerModel.ScheduleInfo scheduleInfo : ScheduleWorkflowDialog.this.model.getSchedules()) {
                        defaultComboBoxModel.addElement(scheduleInfo);
                    }
                    ScheduleWorkflowDialog.this.jScheduleComboBox.setModel(defaultComboBoxModel);
                    String string = ScheduleWorkflowDialog.this.model.getScheduleName();
                    boolean bl = false;
                    for (int i = 0; i < ScheduleWorkflowDialog.this.jScheduleComboBox.getItemCount(); ++i) {
                        if (string.compareTo(ScheduleWorkflowDialog.this.jScheduleComboBox.getItemAt(i).toString()) != 0) continue;
                        ScheduleWorkflowDialog.this.jScheduleComboBox.setSelectedIndex(i);
                        bl = true;
                        break;
                    }
                    if (bl) {
                        ScheduleWorkflowDialog.this.jUseExistingScheduleCheckBox.setSelected(true);
                    }
                    ScheduleWorkflowDialog.this.enableControls();
                }
            }
            CreateScheduleObjectProc createScheduleObjectProc = new CreateScheduleObjectProc(saveAsSchedulePanel.getName());
            createScheduleObjectProc.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
            createScheduleObjectProc.setMessage(DialogsLrb.get("SCHEDULER_CREATE_SCHEDULE"));
            createScheduleObjectProc.setCancelable(false);
            try {
                createScheduleObjectProc.start(true);
            }
            catch (ProgressException progressException) {
                this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            }
        }
    }

    private void jRepeatComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isUIRendering) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        SchedulerModel.Repeat repeat = null;
        if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE)) {
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY)) {
            repeat = new SchedulerModel.RepeatDailyBasic();
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK)) {
            repeat = new SchedulerModel.RepeatWeeklyBasic();
            this.model.setRepeat(repeat);
        } else if (jComboBox.getSelectedItem().equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM)) {
            ScheduleRepeatPanel scheduleRepeatPanel = new ScheduleRepeatPanel(this.context, this, this.model);
            scheduleRepeatPanel.showAsDialog(this);
        }
        this.updateRepeatOption();
    }

    private void jEndRepeatComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isUIRendering) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        if (string.equals(SCHEDULER_END_REPEAT_OPTION_NEVER)) {
            this.model.setEndRepeat(null);
        } else if (string.equals(SCHEDULER_END_REPEAT_OPTION_AFTER)) {
            this.model.setEndRepeat(this.spinner.getValue());
        } else if (string.equals(SCHEDULER_END_REPEAT_OPTION_ON_DATE)) {
            this.model.setEndRepeat(this.endTimeEditor.getCalendar());
        }
        this.updateEndRepeatDateOption(this.model.getEndRepeat());
    }

    private void jUseExistingScheduleCheckBoxActionPerformed(ActionEvent actionEvent) {
        SchedulerModel.ScheduleInfo scheduleInfo;
        boolean bl = this.jUseExistingScheduleCheckBox.isSelected();
        this.model.setUseSchedule(bl);
        if (bl && (scheduleInfo = (SchedulerModel.ScheduleInfo)this.jScheduleComboBox.getSelectedItem()) != SCHEDULER_SELECT_A_SCHEDULE_OBJ) {
            this.model.setScheduleName(scheduleInfo.getName());
        }
        this.enableControls();
    }

    private void jScheduleComboBoxActionPerformed(ActionEvent actionEvent) {
        SchedulerModel.ScheduleInfo scheduleInfo = (SchedulerModel.ScheduleInfo)this.jScheduleComboBox.getSelectedItem();
        if (scheduleInfo != SCHEDULER_SELECT_A_SCHEDULE_OBJ) {
            this.jScheduleComboBox.removeItem(SCHEDULER_SELECT_A_SCHEDULE_OBJ);
            StringBuffer stringBuffer = new StringBuffer();
            if (scheduleInfo.getRepeat() != null) {
                stringBuffer.append(scheduleInfo.getRepeat().displaySchedule() + "\n");
            }
            stringBuffer.append(MessageFormat.format(DialogsLrb.get("SCHEDULER_SCHEDULE_NEXT_RUN_DATE"), scheduleInfo.toNextRunDateString()));
            this.scheduleTextArea.setText(stringBuffer.toString());
            this.model.setScheduleName(scheduleInfo.getName());
        } else {
            this.scheduleTextArea.setText("");
        }
        this.pack();
        this.enableControls();
    }

    private void jEditScheduleButtonActionPerformed(ActionEvent actionEvent) {
        SchedulerModel.ScheduleInfo scheduleInfo = (SchedulerModel.ScheduleInfo)this.jScheduleComboBox.getSelectedItem();
        SchedulerModel schedulerModel = new SchedulerModel(this.context, this.model.getProjectId(), this.model.getWorkflowId(), null, null);
        GregorianCalendar gregorianCalendar = scheduleInfo.getCalStartDate();
        schedulerModel.setStartDate((GregorianCalendar)gregorianCalendar.clone());
        gregorianCalendar = scheduleInfo.getCalEndDate();
        if (gregorianCalendar != null) {
            schedulerModel.setEndDate((GregorianCalendar)gregorianCalendar.clone());
        }
        schedulerModel.setRepeat(SchedulerModel.getRepeat(scheduleInfo.getRepeat().toIntervalString()));
        schedulerModel.setScheduleName(scheduleInfo.getName());
        ScheduleDialog scheduleDialog = new ScheduleDialog(this, this.context, schedulerModel, true);
        if (scheduleDialog.showAsDialog(this)) {
            final class EditScheduleObjectProc
            extends ProgressRunnable {
                private SchedulerModel model;
                private Exception exception;

                EditScheduleObjectProc(SchedulerModel schedulerModel) {
                    this.model = schedulerModel;
                }

                protected Object doWork() throws Exception {
                    try {
                        this.model.editScheduleObject();
                        this.model.loadSchedules();
                    }
                    catch (Exception exception) {
                        this.exception = exception;
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                protected void finish(Object object) {
                    if (this.exception != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)this.exception.getLocalizedMessage(), null);
                    } else {
                        DefaultComboBoxModel<SchedulerModel.ScheduleInfo> defaultComboBoxModel = new DefaultComboBoxModel<SchedulerModel.ScheduleInfo>();
                        for (SchedulerModel.ScheduleInfo scheduleInfo : this.model.getSchedules()) {
                            defaultComboBoxModel.addElement(scheduleInfo);
                        }
                        ScheduleWorkflowDialog.this.jScheduleComboBox.setModel(defaultComboBoxModel);
                        String string = this.model.getScheduleName();
                        for (int i = 0; i < ScheduleWorkflowDialog.this.jScheduleComboBox.getItemCount(); ++i) {
                            if (string.compareTo(ScheduleWorkflowDialog.this.jScheduleComboBox.getItemAt(i).toString()) != 0) continue;
                            ScheduleWorkflowDialog.this.jScheduleComboBox.setSelectedIndex(i);
                            break;
                        }
                    }
                }
            }
            EditScheduleObjectProc editScheduleObjectProc = new EditScheduleObjectProc(schedulerModel);
            editScheduleObjectProc.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
            editScheduleObjectProc.setMessage(DialogsLrb.get("SCHEDULER_EDIT_SCHEDULE"));
            editScheduleObjectProc.setCancelable(false);
            try {
                editScheduleObjectProc.start(true);
            }
            catch (ProgressException progressException) {
                this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            }
        }
    }

    private void jAddScheduleButtonActionPerformed(ActionEvent actionEvent) {
        SchedulerModel schedulerModel = new SchedulerModel(this.context, this.model.getProjectId(), this.model.getWorkflowId(), null, null);
        String string = this.model.genUniqueScheduleName(DEFAULT_SCHEDULE_NAME);
        schedulerModel.setScheduleName(string);
        ScheduleDialog scheduleDialog = new ScheduleDialog(this, this.context, schedulerModel, false);
        if (scheduleDialog.showAsDialog(this)) {
            final class CreateScheduleObjectProc
            extends ProgressRunnable {
                private SchedulerModel model;
                private Exception exception;

                CreateScheduleObjectProc(SchedulerModel schedulerModel) {
                    this.model = schedulerModel;
                }

                protected Object doWork() throws Exception {
                    try {
                        this.model.createScheduleObject();
                        this.model.loadSchedules();
                    }
                    catch (Exception exception) {
                        this.exception = exception;
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                protected void finish(Object object) {
                    if (this.exception != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)this.exception.getLocalizedMessage(), null);
                    } else {
                        DefaultComboBoxModel<SchedulerModel.ScheduleInfo> defaultComboBoxModel = new DefaultComboBoxModel<SchedulerModel.ScheduleInfo>();
                        for (SchedulerModel.ScheduleInfo scheduleInfo : this.model.getSchedules()) {
                            defaultComboBoxModel.addElement(scheduleInfo);
                        }
                        ScheduleWorkflowDialog.this.jScheduleComboBox.setModel(defaultComboBoxModel);
                        String string = this.model.getScheduleName();
                        boolean bl = false;
                        for (int i = 0; i < ScheduleWorkflowDialog.this.jScheduleComboBox.getItemCount(); ++i) {
                            if (string.compareTo(ScheduleWorkflowDialog.this.jScheduleComboBox.getItemAt(i).toString()) != 0) continue;
                            ScheduleWorkflowDialog.this.jScheduleComboBox.setSelectedIndex(i);
                            bl = true;
                            break;
                        }
                    }
                }
            }
            CreateScheduleObjectProc createScheduleObjectProc = new CreateScheduleObjectProc(schedulerModel);
            createScheduleObjectProc.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
            createScheduleObjectProc.setMessage(DialogsLrb.get("SCHEDULER_CREATE_SCHEDULE"));
            createScheduleObjectProc.setCancelable(false);
            try {
                createScheduleObjectProc.start(true);
            }
            catch (ProgressException progressException) {
                this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            }
        }
    }

    private void jRemoveScheduleButtonActionPerformed(ActionEvent actionEvent) {
        if (MessageDialog.optionalConfirm((String)"warnDeleteScheduleObject", (Component)this, (Object)DialogsLrb.get("SCHEDULER_DELETE_SCHEDULE_WARNING_DESC"), (String)DialogsLrb.get("SCHEDULER_DELETE_SCHEDULE_WARNING_TITLE"), null)) {
            final class RemoveScheduleObjectProc
            extends ProgressRunnable {
                private SchedulerModel model;
                private Exception exception;

                RemoveScheduleObjectProc(SchedulerModel schedulerModel) {
                    this.model = schedulerModel;
                }

                protected Object doWork() throws Exception {
                    try {
                        this.model.removeScheduleObject();
                        this.model.setScheduleName(null);
                        this.model.loadSchedules();
                    }
                    catch (Exception exception) {
                        this.exception = exception;
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                protected void finish(Object object) {
                    if (this.exception != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this.exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)this.exception.getLocalizedMessage(), null);
                    } else {
                        DefaultComboBoxModel<SchedulerModel.ScheduleInfo> defaultComboBoxModel = new DefaultComboBoxModel<SchedulerModel.ScheduleInfo>();
                        defaultComboBoxModel.addElement(SCHEDULER_SELECT_A_SCHEDULE_OBJ);
                        for (SchedulerModel.ScheduleInfo scheduleInfo : this.model.getSchedules()) {
                            defaultComboBoxModel.addElement(scheduleInfo);
                        }
                        ScheduleWorkflowDialog.this.jScheduleComboBox.setModel(defaultComboBoxModel);
                        ScheduleWorkflowDialog.this.scheduleTextArea.setText("");
                        ScheduleWorkflowDialog.this.jScheduleComboBox.setSelectedItem(SCHEDULER_SELECT_A_SCHEDULE);
                        ScheduleWorkflowDialog.this.enableControls();
                    }
                }
            }
            RemoveScheduleObjectProc removeScheduleObjectProc = new RemoveScheduleObjectProc(this.model);
            removeScheduleObjectProc.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
            removeScheduleObjectProc.setMessage(DialogsLrb.get("SCHEDULER_REMOVE_SCHEDULE"));
            removeScheduleObjectProc.setCancelable(false);
            try {
                removeScheduleObjectProc.start(true);
            }
            catch (ProgressException progressException) {
                this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
            }
        }
    }

    private void jAdvanceButtonActionPerformed(ActionEvent actionEvent) {
        if (this.advancedSettings == null) {
            this.advancedSettings = new AdvancedSettingsPanel(this.context, this);
        } else {
            this.advancedSettings.refreshUI();
        }
        this.advancedSettings.showAsDialog(this);
    }

    private void jCancelButtonActionPerformed(ActionEvent actionEvent) {
        this.btnCancelActionPerformed();
    }

    private void jOKButtonActionPerformed(ActionEvent actionEvent) {
        this.btnOkActionPerformed();
    }

    private void initUI() {
        this.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
        this.jHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp(new HelpInfo("workflow_schedule_editor", 0));
            }
        });
        this.isUIRendering = true;
        Locale locale = this.model.getLocale();
        GregorianCalendar gregorianCalendar = this.model.getStartDate();
        this.startTimeEditor = new DateTimeEditor(gregorianCalendar.getTime(), (Calendar)gregorianCalendar, JavaFormat.getDateFormat((OraTemporalDatum.Precision)OraTemporalDatum.Precision.MINUTE, (Locale)locale));
        this.startTimeEditor.setEnabled(true);
        this.startTimeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Date) {
                    GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getStartDate();
                    gregorianCalendar.setTime((Date)object);
                }
            }
        });
        this.jStartDatePanel.add((Component)this.startTimeEditor);
        this.StartDateCalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel calendarPanel = ScheduleWorkflowDialog.this.StartDateCalendarButton.getCalendarPanel();
                calendarPanel.setMultiSelect(false);
                calendarPanel.setShowTime(false);
                calendarPanel.setShowTimeZone(false);
                GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getStartDate();
                calendarPanel.setSelectedDate(gregorianCalendar.getTime());
                calendarPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                            Date[] dateArray = ScheduleWorkflowDialog.this.StartDateCalendarButton.getSelectedDates();
                            for (int i = 0; i < dateArray.length; ++i) {
                                Date date = dateArray[i];
                                GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getStartDate();
                                gregorianCalendar.setTime(date);
                                ScheduleWorkflowDialog.this.startTimeEditor.setCalendar((Calendar)gregorianCalendar);
                            }
                        }
                    }
                });
                Container container = calendarPanel.getParent();
                do {
                    if (container == null || !(container instanceof JDialog)) continue;
                    ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
        this.spinner = new JSpinner(new SpinnerNumberModel(this.model.getMaxRuns(), 1, 1000, 1));
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                Integer n = (Integer)jSpinner.getValue();
                ScheduleWorkflowDialog.this.model.setMaxRuns(n);
            }
        });
        gregorianCalendar = this.model.getEndDate();
        this.endTimeEditor = new DateTimeEditor(gregorianCalendar.getTime(), (Calendar)gregorianCalendar, JavaFormat.getDateFormat((OraTemporalDatum.Precision)OraTemporalDatum.Precision.MINUTE, (Locale)locale));
        this.endTimeEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Date) {
                    GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getEndDate();
                    gregorianCalendar.setTime((Date)object);
                }
            }
        });
        this.EndRepeatCalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel calendarPanel = ScheduleWorkflowDialog.this.EndRepeatCalendarButton.getCalendarPanel();
                calendarPanel.setMultiSelect(false);
                calendarPanel.setShowTime(false);
                calendarPanel.setShowTimeZone(false);
                GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getEndDate();
                calendarPanel.setSelectedDate(gregorianCalendar.getTime());
                calendarPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                            Date[] dateArray = ScheduleWorkflowDialog.this.EndRepeatCalendarButton.getSelectedDates();
                            for (int i = 0; i < dateArray.length; ++i) {
                                Date date = dateArray[i];
                                GregorianCalendar gregorianCalendar = ScheduleWorkflowDialog.this.model.getEndDate();
                                gregorianCalendar.setTime(date);
                                ScheduleWorkflowDialog.this.endTimeEditor.setCalendar((Calendar)gregorianCalendar);
                            }
                        }
                    }
                });
                Container container = calendarPanel.getParent();
                do {
                    if (container == null || !(container instanceof JDialog)) continue;
                    ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
        this.jRepeatComboBox.setModel(new RepeatComboBoxModel<String>(new String[]{RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK, RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM}));
        this.jEndRepeatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_END_REPEAT_OPTION_NEVER, SCHEDULER_END_REPEAT_OPTION_AFTER, SCHEDULER_END_REPEAT_OPTION_ON_DATE}));
        this.repeatTextArea = new JMultiLineLabel("");
        this.jCustomRepeatPanel.setLayout(new BorderLayout());
        this.jCustomRepeatPanel.add((Component)this.repeatTextArea);
        this.scheduleTextArea = new JMultiLineLabel("");
        this.jSchedulePanel.setLayout(new BorderLayout());
        this.jSchedulePanel.add((Component)this.scheduleTextArea);
        DefaultComboBoxModel<SchedulerModel.ScheduleInfo> defaultComboBoxModel = new DefaultComboBoxModel<SchedulerModel.ScheduleInfo>();
        defaultComboBoxModel.addElement(SCHEDULER_SELECT_A_SCHEDULE_OBJ);
        for (SchedulerModel.ScheduleInfo scheduleInfo : this.model.getSchedules()) {
            defaultComboBoxModel.addElement(scheduleInfo);
        }
        this.jScheduleComboBox.setModel(defaultComboBoxModel);
        this.jUseExistingScheduleCheckBox.setSelected(this.model.isUseSchedule());
        String string = this.model.getScheduleName();
        if (string != null) {
            for (int i = 0; i < this.jScheduleComboBox.getItemCount(); ++i) {
                if (string.compareTo(this.jScheduleComboBox.getItemAt(i).toString()) != 0) continue;
                this.jScheduleComboBox.setSelectedIndex(i);
                this.jScheduleComboBox.removeItem(SCHEDULER_SELECT_A_SCHEDULE_OBJ);
                break;
            }
        } else {
            this.jScheduleComboBox.setSelectedItem(SCHEDULER_SELECT_A_SCHEDULE);
        }
        this.updateRepeatOption();
        this.enableControls();
        this.isUIRendering = false;
    }

    private void updateRepeatOption() {
        Object object;
        SchedulerModel.Repeat repeat = this.model.getRepeat();
        this.curRepeatSel = repeat == null ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_NONE : (repeat instanceof SchedulerModel.RepeatDailyBasic ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_DAY : (repeat instanceof SchedulerModel.RepeatWeeklyBasic ? RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_EVERY_WEEK : RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM));
        this.jRepeatComboBox.setSelectedItem(this.curRepeatSel);
        if (this.curRepeatSel.equals(RepeatComboBoxModel.SCHEDULER_REPEAT_OPTION_CUSTOM)) {
            object = (SchedulerModel.RepeatInterval)repeat;
            this.repeatTextArea.setText(((SchedulerModel.Repeat)object).displaySchedule());
            this.jCustomRepeatPanel.setVisible(true);
        } else {
            this.jCustomRepeatPanel.setVisible(false);
        }
        this.jEndRepeatLabel.setVisible(false);
        this.jEndRepeatComboBox.setVisible(false);
        this.jEndRepeatPanel.setVisible(false);
        this.EndRepeatCalendarButton.setVisible(false);
        if (repeat != null) {
            this.jEndRepeatLabel.setVisible(true);
            this.jEndRepeatComboBox.setVisible(true);
            object = this.model.getEndRepeat();
            if (object == null) {
                this.jEndRepeatComboBox.setSelectedItem(SCHEDULER_END_REPEAT_OPTION_NEVER);
            } else if (object instanceof Integer) {
                this.jEndRepeatComboBox.setSelectedItem(SCHEDULER_END_REPEAT_OPTION_AFTER);
            } else {
                this.jEndRepeatComboBox.setSelectedItem(SCHEDULER_END_REPEAT_OPTION_ON_DATE);
            }
            this.jEndRepeatPanel.setVisible(true);
            this.updateEndRepeatDateOption(object);
        }
        this.pack();
    }

    private void updateEndRepeatDateOption(Object object) {
        this.jEndRepeatPanel.removeAll();
        this.jEndRepeatPanel.setVisible(false);
        if (object == null) {
            this.EndRepeatCalendarButton.setVisible(false);
        } else if (object instanceof Integer) {
            this.jEndRepeatPanel.add(this.spinner);
            this.spinner.setValue(object);
            this.jEndRepeatPanel.setVisible(true);
            this.EndRepeatCalendarButton.setVisible(false);
        } else if (object instanceof Calendar) {
            GregorianCalendar gregorianCalendar = this.model.getEndDate();
            this.endTimeEditor.setCalendar((Calendar)gregorianCalendar);
            this.jEndRepeatPanel.add((Component)this.endTimeEditor);
            this.jEndRepeatPanel.setVisible(true);
            this.EndRepeatCalendarButton.setVisible(true);
        }
    }

    private void initRes() {
        this.jStartDateLabel.setText(DialogsLrb.get("SCHEDULER_START_DATE_LBL"));
        this.StartDateCalendarButton.setToolTipText(DialogsLrb.get("SCHEDULER_START_DATE_BTN_TOOLTIP"));
        this.jEndRepeatLabel.setText(DialogsLrb.get("SCHEDULER_END_REPEAT_LBL"));
        this.EndRepeatCalendarButton.setToolTipText(DialogsLrb.get("SCHEDULER_END_DATE_BTN_TOOLTIP"));
        ResourceUtils.resLabel((JLabel)this.jRepeatLabel, (Component)this.jRepeatComboBox, (String)DialogsLrb.get("SCHEDULER_REPEAT_LBL"));
        this.jRepeatComboBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SCHEDULER_REPEAT_ADA"));
        this.jRepeatComboBox.setToolTipText(DialogsLrb.get("SCHEDULER_REPEAT_ADA"));
        this.jEndRepeatComboBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SCHEDULER_END_REPEAT_ADA"));
        this.jEndRepeatComboBox.setToolTipText(DialogsLrb.get("SCHEDULER_END_REPEAT_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jUseExistingScheduleCheckBox, (String)DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_CHK"));
        this.jScheduleComboBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_ADA"));
        this.jScheduleComboBox.setToolTipText(DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_ADA"));
        this.jSaveAsScheduleButton.setText(null);
        this.jSaveAsScheduleButton.setIcon(OracleIcons.getIcon((String)"filesave.png"));
        this.jSaveAsScheduleButton.setToolTipText(DialogsLrb.get("SCHEDULER_SCHEDULE_SAVE_ADA"));
        this.jEditScheduleButton.setText(null);
        this.jAddScheduleButton.setText(null);
        this.jRemoveScheduleButton.setText(null);
        this.jEditScheduleButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.jAddScheduleButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jRemoveScheduleButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.jEditScheduleButton.setToolTipText(DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_EDIT_ADA"));
        this.jAddScheduleButton.setToolTipText(DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_ADD_ADA"));
        this.jRemoveScheduleButton.setToolTipText(DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_DEL_ADA"));
        this.jHelpButton.setText(CommonLrb.get("HELP"));
        this.jAdvanceButton.setText(DialogsLrb.get("SCHEDULER_EDIT_BTN_ADVANCED"));
        this.jOKButton.setText(CommonLrb.get("OK"));
        this.jCancelButton.setText(CommonLrb.get("CANCEL"));
    }

    private void enableControls() {
        this.jSaveAsScheduleButton.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jStartDateLabel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jStartDatePanel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jRepeatLabel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jRepeatComboBox.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jEndRepeatLabel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jEndRepeatComboBox.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.StartDateCalendarButton.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.EndRepeatCalendarButton.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jCustomRepeatPanel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.repeatTextArea.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jEndRepeatPanel.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.startTimeEditor.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.endTimeEditor.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.spinner.setEnabled(!this.jUseExistingScheduleCheckBox.isSelected());
        this.jScheduleComboBox.setEnabled(this.jUseExistingScheduleCheckBox.isSelected());
        this.jAddScheduleButton.setEnabled(this.jUseExistingScheduleCheckBox.isSelected());
        SchedulerModel.ScheduleInfo scheduleInfo = (SchedulerModel.ScheduleInfo)this.jScheduleComboBox.getSelectedItem();
        boolean bl = scheduleInfo.isReadOnly();
        this.jEditScheduleButton.setEnabled(this.jUseExistingScheduleCheckBox.isSelected() && !bl);
        this.jRemoveScheduleButton.setEnabled(this.jUseExistingScheduleCheckBox.isSelected() && !bl);
        this.jSchedulePanel.setEnabled(this.jUseExistingScheduleCheckBox.isSelected() && !bl);
        this.scheduleTextArea.setEnabled(this.jUseExistingScheduleCheckBox.isSelected() && !bl);
    }

    @Override
    protected void btnCancelActionPerformed() {
        this.dialogOk = false;
        super.btnCancelActionPerformed();
        this.setVisible(false);
    }

    @Override
    protected void btnOkActionPerformed() {
        SchedulerModel.ScheduleInfo scheduleInfo;
        this.dialogOk = true;
        boolean bl = this.jUseExistingScheduleCheckBox.isSelected();
        if (bl && (scheduleInfo = (SchedulerModel.ScheduleInfo)this.jScheduleComboBox.getSelectedItem()) == SCHEDULER_SELECT_A_SCHEDULE_OBJ) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_USE_EXISTING_SCHEDULE_INVALID_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            this.dialogOk = false;
            return;
        }
        super.btnOkActionPerformed();
        this.setVisible(false);
    }

    public SchedulerModel getModel() {
        return this.model;
    }

    public boolean doesScheduleNameExist(String string) {
        return this.model.doesScheduleNameExist(string);
    }

    public boolean isDialogOk() {
        return this.dialogOk;
    }
}

