/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RowDiagnosticsProvider;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class RegressionBuildNode
extends SupervisedBuildNode
implements RowDiagnosticsProvider {
    private static final Logger theLogger = Logger.getLogger(ClassificationBuildNode.class.getName());
    public static final String GLMSETTINGS = "RGLMSettings";
    public static final String TODO = "add settings here";
    private static Preferences _p = Preferences.getPreferences();
    private RegressionModelBuildPreferencesPanelSettings regrBuildPref = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public RegressionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        Object object;
        Double d;
        TestDataSource.BuildData buildData;
        super.initNewInstance(context);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL")) {
            buildData = new TestDataSource.BuildData();
            regressionBuildNodeType.getTestDataSource().setBuildData(buildData);
        } else if (regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT")) {
            buildData = new TestDataSource.SplitData();
            d = regressionModelBuildPreferencesPanelSettings.getTestSplitPercent();
            buildData.setTestPercent(d.doubleValue());
            object = regressionModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
            buildData.setDataFormat((String)object);
            regressionBuildNodeType.getTestDataSource().setSplitData((TestDataSource.SplitData)buildData);
        } else {
            buildData = new TestDataSource.TestData();
            regressionBuildNodeType.getTestDataSource().setTestData((TestDataSource.TestData)buildData);
        }
        buildData = new RegressionBuildNodeType.Models();
        d = new RegressionBuildNodeType.Results();
        regressionBuildNodeType.setModels((RegressionBuildNodeType.Models)buildData);
        d.setGenAccuracyMetrics(regressionModelBuildPreferencesPanelSettings.isAccuracyMetrics());
        d.setGenResiduals(regressionModelBuildPreferencesPanelSettings.isResiduals());
        regressionBuildNodeType.setResults((RegressionBuildNodeType.Results)d);
        object = new ArrayList();
        if (this.regrBuildPref.isSvm()) {
            object.add("ALGO_SUPPORT_VECTOR_MACHINES");
        }
        if (this.regrBuildPref.isGlm()) {
            object.add("ALGO_GENERALIZED_LINEAR_MODEL");
        }
        List<String> list = WorkflowUtils.getNewModelNames(context, "REGRESSION", (List<String>)object);
        int n = 0;
        ModelType modelType = null;
        if (this.regrBuildPref.isSvm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)object.get(n++));
            modelType.setUseForOutput(true);
            this.addSVMModel((RSupportVectorMachineModelType)modelType);
        }
        if (this.regrBuildPref.isGlm()) {
            modelType = this.createNewRegressionModel(list.get(n), "", (String)object.get(n));
            modelType.setUseForOutput(true);
            this.addGLMModel((RGeneralizedLinearModelType)modelType);
        }
        regressionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addGLMModel(RGeneralizedLinearModelType rGeneralizedLinearModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRGeneralizedLinearModel();
        list.add(rGeneralizedLinearModelType);
    }

    public void addSVMModel(RSupportVectorMachineModelType rSupportVectorMachineModelType) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        List list = models.getRSupportVectorMachineModel();
        list.add(rSupportVectorMachineModelType);
    }

    public ModelType createNewRegressionModel(String string, String string2, String string3) {
        RegressionModelType regressionModelType = (RegressionModelType)super.createNewModel(string, string2, "REGRESSION", string3);
        return regressionModelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_REG_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void refactor(Node node, boolean bl) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (!regressionBuildNodeType.getResults().getRegressionResult().isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
            results.setGenAccuracyMetrics(regressionBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenResiduals(regressionBuildNodeType.getResults().isGenResiduals());
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "regrTestResults", results);
        }
        super.refactor(node, bl);
    }

    @Override
    public Object getProperty(String string) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals("splitValueChanged")) {
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            double d = testDataSource.getSplitData().getTestPercent();
            return d;
        }
        if (string.equals("splitDataFormat")) {
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            String string2 = testDataSource.getSplitData().getDataFormat();
            return string2;
        }
        if (string.equals("testOptionsChanged")) {
            return regressionBuildNodeType.getTestDataSource();
        }
        if (string.equals("genAccuracyMetrics")) {
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            return results.isGenAccuracyMetrics();
        }
        if (string.equals("genResiduals")) {
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            return results.isGenResiduals();
        }
        if (string.equals("regrTestResults")) {
            return regressionBuildNodeType.getResults();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressionResultsCollection(this);
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            for (RegressionResultType regressionResultType : list) {
                if (null == map.get(regressionResultType.getModelId())) continue;
                hashMap.put(regressionResultType.getModelId(), regressionResultType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        if (models.getRGeneralizedLinearModel().isEmpty() && models.getRSupportVectorMachineModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            boolean bl4;
            Object object;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getRGeneralizedLinearModel())) {
                bl3 = false;
            }
            if (!this.validateModels(models.getRSupportVectorMachineModel())) {
                bl3 = false;
            }
            HashMap<String, RSupportVectorMachineModelType> hashMap = new HashMap<String, RSupportVectorMachineModelType>();
            for (Object object2 : models.getRSupportVectorMachineModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            for (Object object2 : models.getRGeneralizedLinearModel()) {
                hashMap.put(object2.getId(), (RSupportVectorMachineModelType)object2);
            }
            RegressionBuildNodeType.Results results = new RegressionBuildNodeType.Results();
            results.setGenAccuracyMetrics(regressionBuildNodeType.getResults().isGenAccuracyMetrics());
            results.setGenResiduals(regressionBuildNodeType.getResults().isGenResiduals());
            for (Object object3 : regressionBuildNodeType.getResults().getRegressionResult()) {
                if (!hashMap.containsKey(object3.getModelId())) continue;
                object = (RegressionResultType)MetaDataHelper.copyMetadataObject(object3);
                results.getRegressionResult().add(object);
            }
            boolean bl5 = bl4 = results.getRegressionResult().size() != regressionBuildNodeType.getResults().getRegressionResult().size();
            if (bl4) {
                Object object3;
                object3 = new ArrayList();
                object = (OdmrSDMUndoFilter)this.getUndoFilter();
                ComplexProperty complexProperty = new ComplexProperty("regrTestResults", results);
                complexProperty.setOldData(regressionBuildNodeType.getResults());
                object3.add(complexProperty);
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object3);
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        if (string.equals(GLMSETTINGS)) {
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            List list = models.getRGeneralizedLinearModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
                if (!rGeneralizedLinearModelType.getName().equals(string2)) continue;
                for (Property property : list2) {
                    if (!"TODO".equals(property.getDescription())) continue;
                    rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().setGLMSCONFLEVEL(0.0);
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)regressionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)regressionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Value is not a Map");
            }
            Map map = (Map)object;
            RegressionBuildNodeType regressionBuildNodeType2 = (RegressionBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)map.get(string3));
            }
        } else if (string.equals("testsRerun")) {
            List<RegressionResultType> list = MetaDataHelper.getRegressionResultsCollection(this);
            Map map = (Map)object;
            for (RegressionResultType regressionResultType : list) {
                ModelStatusType modelStatusType = (ModelStatusType)map.get(regressionResultType.getModelId());
                if (null == modelStatusType) continue;
                regressionResultType.setStatus(modelStatusType);
            }
        } else if (string.equals("splitValueChanged")) {
            if (object == null || !(object instanceof Double)) {
                return;
            }
            Double d = (Double)object;
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            if (testDataSource.getSplitData().getTestPercent() != d.doubleValue()) {
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
            }
        } else if (string.equals("splitDataFormat")) {
            String string4 = (String)object;
            TestDataSource testDataSource = regressionBuildNodeType.getTestDataSource();
            if (string4 == null || testDataSource.getSplitData().getDataFormat() == null || !testDataSource.getSplitData().getDataFormat().equals(string4)) {
                testDataSource.getSplitData().setDataFormat(string4);
            }
        } else if (string.equals("testOptionsChanged")) {
            if (object == null || !(object instanceof TestDataSource)) {
                return;
            }
            TestDataSource testDataSource = (TestDataSource)object;
            regressionBuildNodeType.setTestDataSource(testDataSource);
        } else if (string.equals("alltestsRemoved")) {
            RegressionBuildNodeType regressionBuildNodeType3 = (RegressionBuildNodeType)this.getData();
            if (regressionBuildNodeType3.getResults() != null && !regressionBuildNodeType3.getResults().getRegressionResult().isEmpty()) {
                regressionBuildNodeType3.getResults().getRegressionResult().clear();
            }
        } else if (string.equals("testsRemoved")) {
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType4 = (RegressionBuildNodeType)this.getData();
            List list5 = regressionBuildNodeType4.getResults().getRegressionResult();
            block6: for (MiningResultType miningResultType : list) {
                for (RegressionResultType regressionResultType : list5) {
                    if (!regressionResultType.getModelId().equals(miningResultType.getModelId())) continue;
                    list5.remove(regressionResultType);
                    continue block6;
                }
            }
        } else if (string.equals("alltestsRestored")) {
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType5 = (RegressionBuildNodeType)this.getData();
            regressionBuildNodeType5.getResults().getRegressionResult().clear();
            regressionBuildNodeType5.getResults().getRegressionResult().addAll(list);
        } else if (string.equals("testsRestored")) {
            Object object22;
            RegressionBuildNodeType regressionBuildNodeType6 = (RegressionBuildNodeType)this.getData();
            List list = regressionBuildNodeType6.getResults().getRegressionResult();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object22 : list) {
                hashMap.put(object22.getModelId(), object22);
            }
            List list6 = (List)object;
            object22 = list6.iterator();
            while (object22.hasNext()) {
                RegressionResultType regressionResultType = (RegressionResultType)object22.next();
                if (null != hashMap.get(regressionResultType.getModelId())) continue;
                list.add(regressionResultType);
            }
        } else if (string.equals("genAccuracyMetrics")) {
            Boolean bl = (Boolean)object;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenAccuracyMetrics())) {
                results.setGenAccuracyMetrics(bl);
            }
        } else if (string.equals("genResiduals")) {
            Boolean bl = (Boolean)object;
            RegressionBuildNodeType.Results results = regressionBuildNodeType.getResults();
            if (bl == null || !bl.equals(results.isGenResiduals())) {
                results.setGenResiduals(bl);
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            RegressionBuildNodeType regressionBuildNodeType7 = (RegressionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)regressionBuildNodeType7, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals("regrTestResults")) {
            regressionBuildNodeType.setResults((RegressionBuildNodeType.Results)object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.REGRESSION;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RSupportVectorMachineModelType rSupportVectorMachineModelType : list) {
            String string3 = rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION();
            if (string3 == null || string3.compareTo("SVMS_LINEAR") != 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rSupportVectorMachineModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        MiningFunctionType miningFunctionType = MiningFunctionType.REGRESSION;
        String string = regressionBuildNodeType.getId();
        String string2 = ConnectionFolder.getUserAccountName(this.getContext());
        string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
        List<RefModelType> list2 = MetaDataHelper.createRefModelTypeCollection(miningFunctionType, list, string, string2);
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string3 = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string3 == null || string3.length() <= 0) continue;
            for (RefModelType refModelType : list2) {
                if (refModelType.getName().compareTo(rGeneralizedLinearModelType.getName()) != 0 || refModelType.getSchema().compareTo(string2) != 0) continue;
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public Map<String, RowDiagnosticTableDetails> getRowDiagnosticTables() {
        HashMap<String, RowDiagnosticTableDetails> hashMap = new HashMap<String, RowDiagnosticTableDetails>();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
        for (RGeneralizedLinearModelType rGeneralizedLinearModelType : list) {
            String string = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            if (string == null) continue;
            RowDiagnosticTableDetails rowDiagnosticTableDetails = new RowDiagnosticTableDetails(this.getMetadataId(), string);
            hashMap.put(rGeneralizedLinearModelType.getId(), rowDiagnosticTableDetails);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "regression_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_REGRESSION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_REGRESSION_ICON"));
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        try {
            if (!super.isVersionSupported(context, stringBuffer)) {
                return false;
            }
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
            if (!DbVersionHelper.isDB121Up((Version)version)) {
                for (RGeneralizedLinearModelType rGeneralizedLinearModelType : regressionBuildNodeType.getModels().getRGeneralizedLinearModel()) {
                    if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() == null && rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() == null) continue;
                    stringBuffer.append(CodeGenLrb.get("VALIDATE_GLM_BUILD_SETTING_NOT_SUPPORTED"));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this.getData();
        RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getRGeneralizedLinearModel());
            arrayList.addAll(models.getRSupportVectorMachineModel());
        }
        return arrayList;
    }

    @Override
    protected String getModelTemplatePath() {
        return "workflow_regress_build_model.sql";
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof RSupportVectorMachineModelType) {
            RSupportVectorMachineModelType rSupportVectorMachineModelType = (RSupportVectorMachineModelType)modelType;
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSEPSILON() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_EPSILON||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSEPSILON() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSACTIVELEARNING() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_ACTIVE_LEARNING||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSACTIVELEARNING() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_COMPLEXITY_FACTOR||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCOMPLEXITYFACTOR() + ")'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_CONV_TOLERANCE||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSCONVTOLERANCE() + ")'); \n");
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_CACHE_SIZE||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELCACHESIZE() + ")'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_KERNEL_FUNCTION||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSKERNELFUNCTION() + "'')'); \n");
            }
            if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSTDDEV() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_STD_DEV||''', " + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSTDDEV() + ")'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_SUPPORT_VECTOR_MACHINES||''')'); \n");
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSREGULARIZER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_REGULARIZER||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSREGULARIZER() + "'')'); \n");
                }
                if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSBATCHROWS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_BATCH_ROWS||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSBATCHROWS() + "'')'); \n");
                }
                if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSOLVER() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_SOLVER||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSSOLVER() + "'')'); \n");
                }
                if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSNUMITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_NUM_ITERATIONS||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSNUMITERATIONS() + "'')'); \n");
                }
                if (rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSNUMPIVOTS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.SVMS_NUM_PIVOTS||''', ''" + rSupportVectorMachineModelType.getRSupportVectorMachineAlgo().getSVMSNUMPIVOTS() + "'')'); \n");
                }
            }
        } else if (modelType instanceof RGeneralizedLinearModelType) {
            RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)modelType;
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONF_LEVEL||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSCONFLEVEL() + ")'); \n");
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSVIFFORRIDGE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_VIF_FOR_RIDGE||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSVIFFORRIDGE() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_DIAGNOSTICS_TABLE_NAME||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() + "'')'); \n");
                stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', '" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME() + "', 'TABLE', NULL,'GLM Diagnostics Table'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEREGRESSION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_REGRESSION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEREGRESSION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEVALUE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_RIDGE_VALUE||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSRIDGEVALUE() + ")'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSMISSINGVALUETREATMENT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_MISSING_VALUE_TREATMENT||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSMISSINGVALUETREATMENT() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSROWWEIGHTCOLUMNNAME() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ROW_WEIGHT_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSROWWEIGHTCOLUMNNAME())) + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SEL_CRIT||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELCRIT() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_MAX_FEATURES||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSMAXFEATURES() + ")'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_SELECT_BLOCK||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSSELECTBLOCK() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_APPROXIMATE_COMPUTATION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getODMSAPPROXIMATECOMPUTATION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_PRUNE_MODEL||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSPRUNEMODEL() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_ACCEPTANCE||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRACCEPTANCE() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_SELECTION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRSELECTION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GENERATION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENERATION() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_GEN_METHOD||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRGENMETHOD() + "'')'); \n");
            }
            if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRIDENTIFICATION() != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_FTR_IDENTIFICATION||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSFTRIDENTIFICATION() + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_GENERALIZED_LINEAR_MODEL||''')'); \n");
            if (DbVersionHelper.isDB122Up((Version)version)) {
                if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSCONVTOLERANCE() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_CONV_TOLERANCE||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSCONVTOLERANCE() + ")'); \n");
                }
                if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSNUMITERATIONS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_NUM_ITERATIONS||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSNUMITERATIONS() + ")'); \n");
                }
                if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSBATCHROWS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_BATCH_ROWS||''', " + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSBATCHROWS() + ")'); \n");
                }
                if (rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSROWDIAGNOSTICS() != null) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.GLMS_ROW_DIAGNOSTICS||''', ''" + rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSROWDIAGNOSTICS() + "'')'); \n");
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> getAdditionalModelCodeTemplateReplacements(Context context, ModelType modelType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.generateTestModelCode(context, modelType);
        hashMap.put("<TEST_MODELS>", string);
        return hashMap;
    }

    @Override
    protected String generateTestModelCode(Context context, ModelType modelType) {
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        String string = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        TestDataSource testDataSource = this.getTestDataSource();
        String string2 = "";
        if (testDataSource.getNone() == null) {
            Object object;
            boolean bl = DbVersionHelper.isDB122Up((Version)version) && buildNodeType.getPartitionExpressions() != null && !buildNodeType.getPartitionExpressions().getPartitionExpression().isEmpty();
            string2 = bl ? CodeTemplate.getInstance().getTemplate("workflow_regress_test_part_model.sql") : CodeTemplate.getInstance().getTemplate("workflow_regress_test_model.sql");
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = this.isGeneratingResiduals();
            if (bl2) {
                object = "  -- Residual plot \n  v_residual_plot := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT \n            A.'||v_caseid||' CASEID, \n            B.\"'||v_target||'\" TARGET, \n            A.pred PREDICTION, \n            (B.\"'||v_target||'\" - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.'||v_caseid||' = B.'||v_caseid||' \n            ORDER BY A.pred ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n";
                object = bl ? (String)object + "  \n  -- Partition Residual plot \n  v_residual_plot_part := generateUniqueName; \n  v_sql :=  'CREATE TABLE '||v_residual_plot_part||' <TABLE_PARALLEL_HINT> AS \n    SELECT <PARALLEL_HINT> * \n      FROM (SELECT A.PARTITION_NAME PARTITION_NAME, \n            A.'||v_caseid||' CASEID, \n            B.\"'||v_target||'\" TARGET, \n            A.PRED PREDICTION, \n            (B.\"'||v_target||'\" - A.pred) RESIDUAL \n              FROM '||v_apply_data||' A, \n                   '||v_test_data||' B \n             WHERE A.'||v_caseid||' = B.'||v_caseid||' \n            ORDER BY A.PARTITION_NAME, A.PRED ASC) WHERE RESIDUAL IS NOT NULL'; \n  execSQL(v_sql); \n  v_index := generateUniqueName; \n  execSQL('CREATE INDEX '||v_index||' ON '||v_residual_plot_part||' (PARTITION_NAME) <TABLE_PARALLEL_HINT>'); \n  execSQL('INSERT INTO '||v_residual_plot_part||' (PARTITION_NAME, CASEID, TARGET, PREDICTION, RESIDUAL) \n          SELECT NULL, CASEID, TARGET, PREDICTION, RESIDUAL FROM '||v_residual_plot); \n  execSQL('DROP TABLE '||v_residual_plot||' PURGE'); \n  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot_part, 'TABLE', NULL, 'Residual Plot'); \n" : (String)object + "  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_residual_plot, 'TABLE', NULL, 'Residual Plot'); \n";
                stringBuilder.append((String)object);
            }
            object = this.getInMemorySettings(context);
            String string3 = (String)object.get("IN_MEMORY_ON");
            boolean bl3 = false;
            bl3 = string3 == null || string3.isEmpty() ? false : Boolean.parseBoolean(string3);
            String string4 = (String)object.get("COMPRESSION_METHOD");
            String string5 = (String)object.get("PRIORITY_LEVEL");
            if (bl3) {
                string2 = CodeTemplate.updateBodyTemplate(string2, "<COMPRESSION_METHOD>", string4);
                string2 = CodeTemplate.updateBodyTemplate(string2, "<PRIORITY_LEVEL>", string5);
            } else {
                string2 = CodeTemplate.updateBodyTemplate(string2, "<COMPRESSION_METHOD>", "");
                string2 = CodeTemplate.updateBodyTemplate(string2, "<PRIORITY_LEVEL>", "");
            }
            string2 = CodeTemplate.updateBodyTemplate(string2, "<RESIDUAL_PLOT>", stringBuilder.toString());
            string2 = CodeTemplate.updateBodyTemplate(string2, "<TABLE_PARALLEL_HINT>", string);
        }
        return string2;
    }

    private boolean isGeneratingResiduals() {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        Boolean bl = null;
        boolean bl2 = true;
        if (buildNodeType instanceof RegressionBuildNodeType) {
            bl = ((RegressionBuildNodeType)buildNodeType).getResults().isGenResiduals();
        } else if (buildNodeType instanceof ExtensibleBuildNodeType) {
            bl = ((ExtensibleBuildNodeType)buildNodeType).getResults().isGenResiduals();
        } else assert (false) : "Non Compatible Meta Data";
        bl2 = bl == null ? true : bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public String generateBuildTestDataCode(Context context) {
        BuildNodeType buildNodeType = (BuildNodeType)this.getData();
        String string = null;
        if (buildNodeType.getCaseAttributes() != null && !buildNodeType.getCaseAttributes().getAttribute().isEmpty()) {
            string = ((AttributeType)buildNodeType.getCaseAttributes().getAttribute().get(0)).getName();
        }
        String string2 = null;
        String string3 = null;
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, false);
        Object object = null;
        boolean bl = false;
        TestDataSource testDataSource = this.getTestDataSource();
        if (testDataSource.getSplitData() != null) {
            string2 = "VIEW";
            string3 = "VIEW";
            double d = 100.0 - testDataSource.getSplitData().getTestPercent();
            object = "  v_build_data := generateUniqueName; \n  v_sql :=  \n    'CREATE VIEW '||v_build_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT * FROM (SELECT /*+ no_merge */ t.* FROM '||v_input_data||' t) \n      WHERE ORA_HASH('||v_caseid||', 99, 0) <= " + d + " \n    )'; \n  execSQL(v_sql); \n  \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT * FROM (SELECT /*+ no_merge */ t.* FROM '||v_input_data||' t) \n      WHERE ORA_HASH('||v_caseid||', 99, 0) > " + d + " \n    )'; \n  execSQL(v_sql); \n";
            object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string4);
            bl = true;
        } else if (testDataSource.getTestData() != null) {
            String string6 = testDataSource.getTestData().getSourceId();
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
                object = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE VIEW '||v_test_data||' AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT t.*  \n      FROM '||getInputSource('" + string6 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
                object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string4);
            } else {
                void var20_29;
                Map<String, Object> map;
                Object object2;
                Object object3;
                Object object422;
                Object object5 = null;
                List<Object> list = new ArrayList();
                list = this.getModel().findLinksToNode((IlvSDMNode)this);
                for (Object object422 : list) {
                    object3 = (AbstractNode)((GeneralLink)object422).getFrom();
                    if (!((AbstractNode)object3).getMetadataId().equals(string6)) continue;
                    object2 = (AbstractDataNode)object3;
                    object5 = ((AbstractDataNode)object2).getInputSQL();
                    break;
                }
                Object object6 = null;
                object422 = null;
                object3 = new StringBuffer("");
                object2 = ConnectionFolder.getConnectionFolder(context);
                try {
                    object6 = ConnectionFolder.getUserAccountName(context);
                    object422 = DatabaseMetadataUtils.createUniqueTempTableName("ODMR$", (ConnectionManager)object2);
                    object5 = "SELECT * FROM (" + (String)object5 + ")";
                    DatabaseMetadataUtils.createViewAs((ConnectionManager)object2, (String)object5, (String)object6, (String)object422);
                    map = DatabaseMetadataUtils.getColumnInfo(context, (String)object422);
                    for (DatabaseMetadataUtils.ColumnInfo columnInfo : map.values()) {
                        if (columnInfo.getDataType().compareToIgnoreCase("CLOB") == 0 || columnInfo.getDataType().compareToIgnoreCase("NCLOB") == 0) {
                            if (((StringBuffer)object3).length() > 0) {
                                ((StringBuffer)object3).append(",\n        ");
                            }
                            ((StringBuffer)object3).append("LOB(" + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + ") STORE AS BASICFILE");
                            continue;
                        }
                        if (columnInfo.getDataType().contains("NESTED")) {
                            if (((StringBuffer)object3).length() > 0) {
                                ((StringBuffer)object3).append(",\n        ");
                            }
                            ((StringBuffer)object3).append("NESTED TABLE " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS '||generateUniqueName||'");
                            continue;
                        }
                        if (columnInfo.getDataType().compareToIgnoreCase("XMLTYPE") != 0) continue;
                        if (((StringBuffer)object3).length() > 0) {
                            ((StringBuffer)object3).append(",\n        ");
                        }
                        ((StringBuffer)object3).append("XMLTYPE COLUMN " + StringUtils.addDoubleQuotes(columnInfo.getColumnName()) + " STORE AS BASICFILE CLOB");
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    try {
                        DatabaseMetadataUtils.dropView((ConnectionManager)object2, (String)object6, (String)object422);
                    }
                    catch (SQLException sQLException) {
                        theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    }
                }
                map = this.getInMemorySettings(context);
                String string7 = (String)map.get("IN_MEMORY_ON");
                boolean bl2 = false;
                if (string7 == null || string7.isEmpty()) {
                    boolean bl3 = false;
                } else {
                    boolean bl4 = Boolean.parseBoolean(string7);
                }
                String string8 = (String)map.get("COMPRESSION_METHOD");
                String string9 = (String)map.get("PRIORITY_LEVEL");
                string2 = "TABLE";
                string3 = "TABLE";
                object = "  \n  v_build_data := v_input_data; \n  v_test_data := generateUniqueName; \n  v_sql := \n    'CREATE TABLE '||v_test_data||' \n        <STORAGE_CLAUSE> <TABLE_PARALLEL_HINT> COMPRESS \n    AS SELECT <PARALLEL_HINT> * FROM \n    ( \n      SELECT ROWNUM '||v_caseid||', t.*  \n      FROM '||getInputSource('" + string6 + "')||' t \n    )'; \n  execSQL(v_sql); \n";
                object = StringUtils.getReplacedString((String)object, "<STORAGE_CLAUSE>", ((StringBuffer)object3).toString());
                object = StringUtils.getReplacedString((String)object, "<TABLE_PARALLEL_HINT>", string5);
                object = StringUtils.getReplacedString((String)object, "<PARALLEL_HINT>", string4);
                if (var20_29 != false) {
                    object = (String)object + "\n";
                    object = (String)object + "  v_sql := \n";
                    object = (String)object + "    'ALTER TABLE '||v_test_data||' \n";
                    object = (String)object + "        <COMPRESSION_CLAUSE> <PRIORITY_CLAUSE>';\n";
                    object = (String)object + "\n";
                    object = (String)object + "  execSQL(v_sql); ";
                    object = (String)object + "\n";
                    object = StringUtils.getReplacedString((String)object, "<COMPRESSION_CLAUSE>", string8);
                    object = StringUtils.getReplacedString((String)object, "<PRIORITY_CLAUSE>", string9);
                }
            }
            bl = true;
        } else if (testDataSource.getBuildData() != null) {
            if (string != null) {
                string2 = "VIEW";
                string3 = "VIEW";
            } else {
                string2 = "TABLE";
                string3 = "TABLE";
            }
            object = "  \n  v_build_data := v_input_data; \n  v_test_data := v_build_data; \n";
            bl = true;
        } else {
            string2 = string != null ? "VIEW" : "TABLE";
            object = "  \n  v_build_data := v_input_data; \n";
            bl = false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)object);
        stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_build_data, '" + string2 + "', NULL, 'Build Data');\n");
        if (bl) {
            stringBuilder.append("  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', NULL, NULL, NULL, v_test_data, '" + string3 + "', NULL, 'Test Data');\n");
        }
        return stringBuilder.toString();
    }
}

