/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.join.JoinPreferencesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinKeyColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinSourceNodesType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.ide.Context;

public final class JoinNode
extends AbstractTransformNode
implements ApplyChainNode,
DataConsumer {
    public static final String JOIN_KEY_NODES = "joinKeyNodes";
    public static final String JOIN_KEY_COLUMNS = "joinKeyColumns";
    public static final String JOIN_OUTPUT_COLUMNS = "joinOutputColumns";
    public static final String JOIN_FILTER = "joinFilter";
    private HashMap<String, String> _nodesLookupMap = new HashMap();

    public JoinNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        Boolean bl;
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        if (joinNodeType != null && (bl = joinNodeType.isUseCartesian()) == null) {
            joinNodeType.setSourceNodes(null);
            joinNodeType.setUseCartesian(Boolean.valueOf(false));
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        JoinPreferencesPanel.JoinPreferenceSettings joinPreferenceSettings = JoinPreferencesPanel.JoinPreferenceSettings.getInstance();
        boolean bl = joinPreferenceSettings.getAutomaticSettingData();
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        JoinOutputColumnsType joinOutputColumnsType = new JoinOutputColumnsType();
        joinOutputColumnsType.setAutoSpec(bl ? AutoSpecType.YES : AutoSpecType.NO);
        joinNodeType.setOutputColumns(joinOutputColumnsType);
        JoinKeyColumnsType joinKeyColumnsType = new JoinKeyColumnsType();
        joinKeyColumnsType.setAutoSpec(AutoSpecType.NO);
        joinNodeType.setKeyColumns(joinKeyColumnsType);
        joinNodeType.setSourceNodes(null);
        joinNodeType.setUseCartesian(Boolean.valueOf(false));
        joinNodeType.setStatus(NodeStatusType.INVALID);
    }

    private void initDataNodeLookup() {
        this._nodesLookupMap.clear();
        List<AbstractNode> list = this.findJoinDataNode();
        for (AbstractNode abstractNode : list) {
            this._nodesLookupMap.put(abstractNode.getMetadataId(), abstractNode.getData().getName());
        }
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_JOIN_NODE_NAME");
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        bl = node instanceof AbstractDataNode || node instanceof AbstractTransformNode;
        return bl;
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return true;
    }

    @Override
    public void refactor(Node node, boolean bl) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        List<Object> list = new ArrayList();
        if (node != null) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            list = node.getModel().findLinksToNode((IlvSDMNode)this);
            AbstractNode abstractNode = (AbstractNode)node;
            NodeType nodeType = node.getData();
            nodeType = node.getData();
            JoinNodeType joinNodeType = (JoinNodeType)this.getData();
            JoinSourceNodesType joinSourceNodesType = joinNodeType.getSourceNodes();
            JoinKeyColumnsType joinKeyColumnsType = joinNodeType.getKeyColumns();
            JoinOutputColumnsType joinOutputColumnsType = joinNodeType.getOutputColumns();
            JoinSourceNodesType joinSourceNodesType2 = null;
            if (joinSourceNodesType != null) {
                joinSourceNodesType2 = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinSourceNodesType);
            }
            JoinKeyColumnsType joinKeyColumnsType2 = null;
            if (joinKeyColumnsType != null) {
                joinKeyColumnsType2 = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinKeyColumnsType);
            }
            if (joinSourceNodesType2 != null) {
                object6 = joinSourceNodesType2.getSourceNode();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (JoinSourceNodesType.SourceNode)object5.next();
                    object3 = object4.getNodeId();
                    if (!((String)object3).equals(abstractNode.getOldId())) continue;
                    object4.setNodeId(nodeType.getId());
                    object4.setNodeName(nodeType.getName());
                }
            }
            object6 = "";
            if (joinKeyColumnsType2 != null && (object5 = (JoinNodeType)this.getData()) != null && object5.getFilter() != null && object5.getFilter().trim().length() > 0) {
                object6 = object5.getFilter();
                object3 = joinKeyColumnsType2.getJoinColumn();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (JoinKeyColumnsType.JoinColumn)object2.next();
                    string = object.getLeftColumn();
                    RefDBColumnType refDBColumnType = object.getRightColumn();
                    if (string != null && ((String)(object4 = string.getNodeId())).equals(abstractNode.getOldId())) {
                        object6 = StringUtils.getReplacedString((String)object6, StringUtils.addDoubleQuotes(string.getNodeName()), StringUtils.addDoubleQuotes(nodeType.getName()));
                    }
                    if (refDBColumnType == null || !((String)(object4 = refDBColumnType.getNodeId())).equals(abstractNode.getOldId())) continue;
                    object6 = StringUtils.getReplacedString((String)object6, StringUtils.addDoubleQuotes(refDBColumnType.getNodeName()), StringUtils.addDoubleQuotes(nodeType.getName()));
                }
            }
            if (joinKeyColumnsType2 != null) {
                object5 = joinKeyColumnsType2.getJoinColumn();
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (JoinKeyColumnsType.JoinColumn)object4.next();
                    object2 = object3.getLeftColumn();
                    object = object3.getRightColumn();
                    string = object2.getNodeId();
                    if (string.equals(abstractNode.getOldId())) {
                        object2.setNodeId(nodeType.getId());
                        object2.setNodeName(nodeType.getName());
                    }
                    if (!(string = object.getNodeId()).equals(abstractNode.getOldId())) continue;
                    object.setNodeId(nodeType.getId());
                    object.setNodeName(nodeType.getName());
                }
            }
            object5 = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinOutputColumnsType);
            object4 = object5.getRefDBColumn();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (RefDBColumnType)object3.next();
                object = object2.getNodeId();
                if (!((String)object).equals(abstractNode.getOldId())) continue;
                object2.setNodeId(nodeType.getId());
                object2.setNodeName(nodeType.getName());
            }
            if (joinSourceNodesType2 != null) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), JOIN_KEY_NODES, joinSourceNodesType2);
            }
            if (joinKeyColumnsType2 != null) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), JOIN_KEY_COLUMNS, joinKeyColumnsType2);
            }
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), JOIN_OUTPUT_COLUMNS, object5);
            if (((String)object6).length() > 0) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), JOIN_FILTER, object6);
            }
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        String string;
        RefDBColumnType refDBColumnType;
        List list;
        Object object;
        Object object2;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        boolean bl = false;
        JoinKeyColumnsType joinKeyColumnsType = null;
        JoinKeyColumnsType joinKeyColumnsType2 = joinNodeType.getKeyColumns();
        if (joinKeyColumnsType2 != null) {
            joinKeyColumnsType = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinKeyColumnsType2);
            object2 = joinKeyColumnsType.getJoinColumn();
            object = object2.iterator();
            while (object.hasNext()) {
                RefDBColumnType refDBColumnType2;
                list = (JoinKeyColumnsType.JoinColumn)object.next();
                String string2 = list.getLeftColumn().getNodeId();
                if (!(!string2.equals(node.getMetadataId()) || (refDBColumnType2 = map.get((refDBColumnType = list.getLeftColumn()).getName())) == null || refDBColumnType.getName().equals(refDBColumnType2.getName()) && refDBColumnType.getDataType().equals(refDBColumnType2.getDataType()))) {
                    string = refDBColumnType.getName();
                    refDBColumnType.setName(refDBColumnType2.getName());
                    refDBColumnType.setDataType(refDBColumnType2.getDataType());
                    hashMap.put(string, (AttributeType)refDBColumnType);
                    bl = true;
                }
                if (!(string2 = list.getRightColumn().getNodeId()).equals(node.getMetadataId()) || (refDBColumnType2 = map.get((refDBColumnType = list.getRightColumn()).getName())) == null || refDBColumnType.getName().equals(refDBColumnType2.getName()) && refDBColumnType.getDataType().equals(refDBColumnType2.getDataType())) continue;
                string = refDBColumnType.getName();
                refDBColumnType.setName(refDBColumnType2.getName());
                refDBColumnType.setDataType(refDBColumnType2.getDataType());
                hashMap.put(string, (AttributeType)refDBColumnType);
                bl = true;
            }
        }
        object2 = joinNodeType.getOutputColumns();
        object = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(object2);
        list = object.getRefDBColumn();
        boolean bl2 = false;
        for (RefDBColumnType refDBColumnType2 : list) {
            AttributeType attributeType;
            string = refDBColumnType2.getNodeId();
            if (!string.equals(node.getMetadataId()) || (attributeType = map.get(refDBColumnType2.getName())) == null || refDBColumnType2.getName().equals(attributeType.getName()) && refDBColumnType2.getDataType().equals(attributeType.getDataType())) continue;
            String string3 = refDBColumnType2.getName();
            RefDBColumnType refDBColumnType3 = null;
            if (refDBColumnType2.getAlias() != null && !refDBColumnType2.getAlias().trim().isEmpty()) {
                refDBColumnType3 = new AttributeType();
                refDBColumnType3.setName(refDBColumnType2.getAlias());
                refDBColumnType3.setAlias(null);
                refDBColumnType3.setDataType(attributeType.getDataType());
                refDBColumnType3.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                refDBColumnType3.setStatus(AttributeStatus.VALID);
                string3 = refDBColumnType2.getAlias();
            } else {
                refDBColumnType3 = refDBColumnType2;
            }
            refDBColumnType2.setName(attributeType.getName());
            refDBColumnType2.setDataType(attributeType.getDataType());
            refDBColumnType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            hashMap.put(string3, (AttributeType)refDBColumnType3);
            bl2 = true;
        }
        if (!hashMap.isEmpty()) {
            refDBColumnType = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (bl) {
                refDBColumnType.prepareUndo(this, this.getContext(), JOIN_KEY_COLUMNS, joinKeyColumnsType);
            }
            if (bl2) {
                refDBColumnType.prepareUndo(this, this.getContext(), JOIN_OUTPUT_COLUMNS, object);
            }
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public void parentNodeNameChanged(Node node, String string) {
        ComplexProperty complexProperty;
        Object object2;
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        JoinSourceNodesType joinSourceNodesType = joinNodeType.getSourceNodes();
        JoinKeyColumnsType joinKeyColumnsType = joinNodeType.getKeyColumns();
        JoinSourceNodesType joinSourceNodesType2 = null;
        if (joinSourceNodesType != null) {
            joinSourceNodesType2 = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinSourceNodesType);
        }
        JoinKeyColumnsType joinKeyColumnsType2 = null;
        if (joinKeyColumnsType != null) {
            joinKeyColumnsType2 = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinKeyColumnsType);
        }
        JoinOutputColumnsType joinOutputColumnsType = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = node.getData().getId();
        String string3 = node.getData().getName();
        if (joinSourceNodesType2 != null) {
            for (Object object2 : joinSourceNodesType2.getSourceNode()) {
                if (!object2.getNodeId().equals(string2)) continue;
                object2.setNodeName(string3);
                bl = true;
            }
        }
        if (joinKeyColumnsType2 != null) {
            for (Object object2 : joinKeyColumnsType2.getJoinColumn()) {
                if (object2.getLeftColumn().getNodeId().equals(string2)) {
                    object2.getLeftColumn().setNodeName(string3);
                    bl2 = true;
                }
                if (!object2.getRightColumn().getNodeId().equals(string2)) continue;
                object2.getRightColumn().setNodeName(string3);
                bl2 = true;
            }
        }
        for (Object object2 : joinOutputColumnsType.getRefDBColumn()) {
            if (!object2.getNodeId().equals(string2)) continue;
            object2.setNodeName(string3);
            bl3 = true;
        }
        ArrayList arrayList = new ArrayList();
        object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl) {
            complexProperty = new ComplexProperty(JOIN_KEY_NODES, joinSourceNodesType2);
            complexProperty.setOldData(joinNodeType.getSourceNodes());
            arrayList.add(complexProperty);
        }
        if (bl2) {
            complexProperty = new ComplexProperty(JOIN_KEY_COLUMNS, joinKeyColumnsType2);
            complexProperty.setOldData(joinNodeType.getKeyColumns());
            arrayList.add(complexProperty);
        }
        if (bl3) {
            complexProperty = new ComplexProperty(JOIN_OUTPUT_COLUMNS, joinOutputColumnsType);
            complexProperty.setOldData(joinNodeType.getOutputColumns());
            arrayList.add(complexProperty);
        }
        if (bl || bl2 || bl3) {
            complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            complexProperty.setOldData(this.getSQLExpression());
            arrayList.add(complexProperty);
        }
        ((OdmrSDMUndoFilter)((Object)object2)).prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
        this._nodesLookupMap.clear();
    }

    @Override
    public boolean validate(boolean bl) {
        Iterator<Object> iterator;
        Object object3;
        Object object2;
        String string2;
        boolean bl2 = super.validate(bl);
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        boolean bl3 = joinNodeType.getOutputColumns().getAutoSpec().equals((Object)AutoSpecType.YES);
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        JoinSourceNodesType joinSourceNodesType = null;
        if (joinNodeType.getSourceNodes() != null) {
            joinSourceNodesType = (JoinSourceNodesType)MetaDataHelper.copyMetadataObject(joinNodeType.getSourceNodes());
        }
        JoinKeyColumnsType joinKeyColumnsType = null;
        if (joinNodeType.getKeyColumns() != null) {
            joinKeyColumnsType = (JoinKeyColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getKeyColumns());
        }
        JoinOutputColumnsType joinOutputColumnsType = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinNodeType.getOutputColumns());
        List<AbstractNode> list = this.findJoinDataNode();
        HashMap<String, AbstractNode> hashMap = new HashMap<String, AbstractNode>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<AttributeStatus, String> hashMap3 = new HashMap<AttributeStatus, String>();
        for (AbstractNode object42 : list) {
            hashMap.put(object42.getData().getName(), object42);
            if (!(object42 instanceof DataProvider)) continue;
            for (String string2 : ((DataProvider)((Object)object42)).getAttributes().getAttribute()) {
                object2 = object42.getData().getName() + "." + string2.getName() + "." + string2.getDataType();
                hashMap3.put((AttributeStatus)object2, string2);
            }
        }
        if (joinSourceNodesType != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinSourceNodesType.getSourceNode()) {
                hashMap2.put(sourceNode.getNodeName(), sourceNode);
                Object var19_36 = null;
                string2 = sourceNode.getNodeName();
                AbstractNode abstractNode = (AbstractNode)hashMap.get(string2);
                if (abstractNode == null) {
                    sourceNode.setStatus(AttributeStatus.INVALID);
                    sourceNode.setNodeId("");
                    if (!bl4) {
                        this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    bl2 = false;
                    bl6 = true;
                    continue;
                }
                if (sourceNode.getStatus() != AttributeStatus.INVALID) continue;
                sourceNode.setStatus(AttributeStatus.VALID);
                sourceNode.setNodeId(abstractNode.getMetadataId());
                bl6 = true;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                String string3 = (String)entry.getKey();
                boolean bl9 = false;
                for (Object object3 : joinSourceNodesType.getSourceNode()) {
                    if (!string3.equals(object3.getNodeName())) continue;
                    bl9 = true;
                    break;
                }
                if (bl9) continue;
                object2 = (AbstractNode)hashMap.get(string3);
                object3 = new JoinSourceNodesType.SourceNode();
                object3.setNodeId(((AbstractNode)object2).getMetadataId());
                object3.setNodeName(((AbstractNode)object2).getData().getName());
                object3.setStatus(AttributeStatus.VALID);
                joinSourceNodesType.getSourceNode().add(object3);
                bl6 = true;
            }
            for (JoinSourceNodesType.SourceNode sourceNode : joinSourceNodesType.getSourceNode()) {
                if (sourceNode.getStatus() != AttributeStatus.INVALID) continue;
                if (!bl4) {
                    this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                    bl4 = true;
                }
                bl2 = false;
            }
        }
        if (joinKeyColumnsType != null) {
            for (JoinKeyColumnsType.JoinColumn joinColumn : joinKeyColumnsType.getJoinColumn()) {
                String string4 = joinColumn.getLeftColumn().getNodeName();
                hashMap2.put(string4, joinColumn.getLeftColumn());
                String string5 = joinColumn.getRightColumn().getNodeName();
                hashMap2.put(string5, joinColumn.getRightColumn());
                string2 = null;
                String string6 = joinColumn.getLeftColumn().getNodeName() + "." + joinColumn.getLeftColumn().getName() + "." + joinColumn.getLeftColumn().getDataType();
                string2 = (AttributeType)hashMap3.get(string6);
                if (string2 == null) {
                    joinColumn.getLeftColumn().setStatus(AttributeStatus.INVALID);
                    joinColumn.getLeftColumn().setNodeId("");
                    if (!bl4) {
                        this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    bl2 = false;
                    bl7 = true;
                } else if (joinColumn.getLeftColumn().getStatus() == AttributeStatus.INVALID) {
                    object2 = (AbstractNode)hashMap.get(joinColumn.getLeftColumn().getNodeName());
                    joinColumn.getLeftColumn().setStatus(AttributeStatus.VALID);
                    joinColumn.getLeftColumn().setNodeId(((AbstractNode)object2).getMetadataId());
                    bl7 = true;
                }
                String string7 = joinColumn.getRightColumn().getNodeName() + "." + joinColumn.getRightColumn().getName() + "." + joinColumn.getRightColumn().getDataType();
                string2 = (AttributeType)hashMap3.get(string7);
                if (string2 == null) {
                    joinColumn.getRightColumn().setStatus(AttributeStatus.INVALID);
                    joinColumn.getRightColumn().setNodeId("");
                    if (!bl4) {
                        this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    bl2 = false;
                    bl7 = true;
                    continue;
                }
                if (joinColumn.getRightColumn().getStatus() != AttributeStatus.INVALID) continue;
                object2 = (AbstractNode)hashMap.get(joinColumn.getRightColumn().getNodeName());
                joinColumn.getRightColumn().setStatus(AttributeStatus.VALID);
                joinColumn.getRightColumn().setNodeId(((AbstractNode)object2).getMetadataId());
                bl7 = true;
            }
            for (JoinKeyColumnsType.JoinColumn joinColumn : joinKeyColumnsType.getJoinColumn()) {
                if (joinColumn.getLeftColumn().getStatus() == AttributeStatus.INVALID) {
                    if (!bl4) {
                        this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                        bl4 = true;
                    }
                    bl2 = false;
                }
                if (joinColumn.getRightColumn().getStatus() != AttributeStatus.INVALID) continue;
                if (!bl4) {
                    this.addMessage("JOIN_INVAL_KEY", MessageEnumType.WARNING, new String[0]);
                    bl4 = true;
                }
                bl2 = false;
            }
        }
        if (bl3) {
            joinOutputColumnsType.getRefDBColumn().clear();
            iterator = new ArrayList();
            for (AbstractNode abstractNode : list) {
                string2 = hashMap2.get(abstractNode.getData().getName());
                object2 = null;
                if (string2 instanceof RefDBColumnType) {
                    object2 = ((RefDBColumnType)string2).getStatus();
                }
                if (string2 instanceof JoinSourceNodesType.SourceNode) {
                    object2 = ((JoinSourceNodesType.SourceNode)string2).getStatus();
                }
                if (string2 == null || object2 != AttributeStatus.VALID || !(abstractNode instanceof DataProvider)) continue;
                for (AttributeType attributeType : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                    RefDBColumnType refDBColumnType = new RefDBColumnType();
                    refDBColumnType.setAlias(attributeType.getAlias());
                    refDBColumnType.setDataType(attributeType.getDataType());
                    refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                    refDBColumnType.setName(attributeType.getName());
                    refDBColumnType.setNodeId(abstractNode.getMetadataId());
                    refDBColumnType.setNodeName(abstractNode.getData().getName());
                    refDBColumnType.setStatus(attributeType.getStatus());
                    iterator.add(refDBColumnType);
                }
            }
            if (iterator.size() > 0) {
                JoinNode.addOutputAttrs(joinOutputColumnsType, iterator, new JoinOutputColumnNameGenerator(this.getContext(), joinOutputColumnsType));
            }
            bl = true;
            bl8 = true;
        } else {
            for (RefDBColumnType refDBColumnType : joinOutputColumnsType.getRefDBColumn()) {
                Object v = hashMap2.get(refDBColumnType.getNodeName());
                string2 = null;
                object2 = null;
                if (v instanceof RefDBColumnType) {
                    object2 = ((RefDBColumnType)v).getStatus();
                    string2 = ((RefDBColumnType)v).getNodeId();
                }
                if (v instanceof JoinSourceNodesType.SourceNode) {
                    object2 = ((JoinSourceNodesType.SourceNode)v).getStatus();
                    string2 = ((JoinSourceNodesType.SourceNode)v).getNodeId();
                }
                if (v != null) {
                    AttributeType attributeType;
                    if (object2 == AttributeStatus.INVALID && refDBColumnType.getStatus() == AttributeStatus.VALID) {
                        refDBColumnType.setStatus(AttributeStatus.INVALID);
                        refDBColumnType.setNodeId("");
                        if (!bl5) {
                            this.addMessage("JOIN_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                            bl5 = true;
                        }
                        bl2 = false;
                        bl = true;
                        bl8 = true;
                        continue;
                    }
                    if (object2 != AttributeStatus.VALID || refDBColumnType.getStatus() != AttributeStatus.INVALID || (attributeType = (AttributeType)hashMap3.get(object3 = refDBColumnType.getNodeName() + "." + refDBColumnType.getName() + "." + refDBColumnType.getDataType())) == null) continue;
                    refDBColumnType.setStatus(AttributeStatus.VALID);
                    refDBColumnType.setNodeId(string2);
                    bl = true;
                    bl8 = true;
                    continue;
                }
                refDBColumnType.setStatus(AttributeStatus.INVALID);
                refDBColumnType.setNodeId("");
                if (!bl5) {
                    this.addMessage("JOIN_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                    bl5 = true;
                }
                bl2 = false;
                bl = true;
                bl8 = true;
            }
        }
        iterator = new ArrayList();
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl6) {
            ComplexProperty complexProperty = new ComplexProperty(JOIN_KEY_NODES, joinSourceNodesType);
            complexProperty.setOldData(joinNodeType.getSourceNodes());
            iterator.add(complexProperty);
        }
        if (bl7) {
            ComplexProperty complexProperty = new ComplexProperty(JOIN_KEY_COLUMNS, joinKeyColumnsType);
            complexProperty.setOldData(joinNodeType.getKeyColumns());
            iterator.add(complexProperty);
        }
        if (bl8) {
            ComplexProperty complexProperty = new ComplexProperty(JOIN_OUTPUT_COLUMNS, joinOutputColumnsType);
            complexProperty.setOldData(joinNodeType.getOutputColumns());
            iterator.add(complexProperty);
        }
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        iterator.add(complexProperty);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)((Object)iterator));
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public List<AbstractNode> findAvailableJoinDataNode() {
        List<AbstractNode> list = this.findJoinDataNode();
        List<String> list2 = this.getResolveNodes();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String object : list2) {
            hashMap.put(object, Boolean.TRUE);
        }
        ArrayList arrayList = new ArrayList();
        for (AbstractNode abstractNode : list) {
            String string = abstractNode.getData().getName();
            if (hashMap.get(string) != null) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public List<String> getResolveNodes() {
        String string;
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (joinNodeType.getSourceNodes() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getSourceNodes().getSourceNode()) {
                string = sourceNode.getNodeName();
                if (sourceNode.getStatus() != AttributeStatus.VALID || hashMap.get(string) != null) continue;
                arrayList.add(string);
                hashMap.put(string, Boolean.TRUE);
            }
        }
        if (joinNodeType.getKeyColumns() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getKeyColumns().getJoinColumn()) {
                string = sourceNode.getLeftColumn().getNodeName();
                if (sourceNode.getLeftColumn().getStatus() == AttributeStatus.VALID && hashMap.get(string) == null) {
                    arrayList.add(string);
                    hashMap.put(string, Boolean.TRUE);
                }
                string = sourceNode.getRightColumn().getNodeName();
                if (sourceNode.getRightColumn().getStatus() != AttributeStatus.VALID || hashMap.get(string) != null) continue;
                arrayList.add(string);
                hashMap.put(string, Boolean.TRUE);
            }
        }
        return arrayList;
    }

    public static List<String> getUnResolveNodes(JoinKeyColumnsType joinKeyColumnsType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (joinKeyColumnsType != null) {
            for (JoinKeyColumnsType.JoinColumn joinColumn : joinKeyColumnsType.getJoinColumn()) {
                String string = joinColumn.getLeftColumn().getNodeName();
                if (joinColumn.getLeftColumn().getStatus() == AttributeStatus.INVALID && hashMap.get(string) == null) {
                    hashMap.put(string, string);
                }
                string = joinColumn.getRightColumn().getNodeName();
                if (joinColumn.getRightColumn().getStatus() != AttributeStatus.INVALID || hashMap.get(string) != null) continue;
                hashMap.put(string, string);
            }
        }
        return new ArrayList<String>(hashMap.values());
    }

    public static List<String> getUnResolveNodes(JoinSourceNodesType joinSourceNodesType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (joinSourceNodesType != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinSourceNodesType.getSourceNode()) {
                String string = sourceNode.getNodeName();
                if (sourceNode.getStatus() != AttributeStatus.INVALID || hashMap.get(string) != null) continue;
                hashMap.put(string, string);
            }
        }
        return new ArrayList<String>(hashMap.values());
    }

    public List<String> getUnResolveNodes() {
        String string;
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (joinNodeType.getSourceNodes() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getSourceNodes().getSourceNode()) {
                string = sourceNode.getNodeName();
                if (sourceNode.getStatus() != AttributeStatus.INVALID || hashMap.get(string) != null) continue;
                arrayList.add(string);
                hashMap.put(string, Boolean.TRUE);
            }
        }
        if (joinNodeType.getKeyColumns() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getKeyColumns().getJoinColumn()) {
                string = sourceNode.getLeftColumn().getNodeName();
                if (sourceNode.getLeftColumn().getStatus() == AttributeStatus.INVALID && hashMap.get(string) == null) {
                    arrayList.add(string);
                    hashMap.put(string, Boolean.TRUE);
                }
                string = sourceNode.getRightColumn().getNodeName();
                if (sourceNode.getRightColumn().getStatus() != AttributeStatus.INVALID || hashMap.get(string) != null) continue;
                arrayList.add(string);
                hashMap.put(string, Boolean.TRUE);
            }
        }
        return arrayList;
    }

    private boolean doesColumnExist(AbstractNode abstractNode, RefDBColumnType refDBColumnType) {
        if (abstractNode instanceof DataProvider) {
            for (AttributeType attributeType : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                String string;
                String string2 = attributeType.getName() + "." + attributeType.getDataType();
                if (!string2.equals(string = refDBColumnType.getName() + "." + refDBColumnType.getDataType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean resolveNodes(JoinNodeType joinNodeType, List<String> list, List<AbstractNode> list2) {
        boolean bl = false;
        if (list != null && list2 != null) {
            Object object;
            Object object22;
            Iterator<RefDBColumnType> iterator;
            int n;
            Iterator iterator2 = new HashMap();
            JoinSourceNodesType.SourceNode sourceNode = new HashMap();
            for (n = 0; n < list.size(); ++n) {
                iterator = list.get(n);
                object22 = list2.get(n);
                ((HashMap)((Object)iterator2)).put(iterator, object22);
                if (joinNodeType.getSourceNodes() != null) {
                    for (AbstractNode abstractNode : joinNodeType.getSourceNodes().getSourceNode()) {
                        if (abstractNode.getStatus() != AttributeStatus.INVALID || abstractNode.getNodeName().compareTo((String)((Object)iterator)) != 0) continue;
                        abstractNode.setNodeName(((AbstractNode)object22).getData().getName());
                        abstractNode.setNodeId(((AbstractNode)object22).getMetadataId());
                        abstractNode.setStatus(AttributeStatus.VALID);
                        sourceNode.put(((AbstractNode)object22).getData().getName(), abstractNode);
                    }
                }
                if (joinNodeType.getKeyColumns() == null) continue;
                for (AbstractNode abstractNode : joinNodeType.getKeyColumns().getJoinColumn()) {
                    if (abstractNode.getLeftColumn().getStatus() == AttributeStatus.INVALID && abstractNode.getLeftColumn().getNodeName().compareTo((String)((Object)iterator)) == 0) {
                        abstractNode.getLeftColumn().setNodeName(((AbstractNode)object22).getData().getName());
                        abstractNode.getLeftColumn().setNodeId(((AbstractNode)object22).getMetadataId());
                        if (this.doesColumnExist((AbstractNode)object22, abstractNode.getLeftColumn())) {
                            abstractNode.getLeftColumn().setStatus(AttributeStatus.VALID);
                        }
                        sourceNode.put(((AbstractNode)object22).getData().getName(), abstractNode.getLeftColumn());
                    }
                    if (abstractNode.getRightColumn().getStatus() != AttributeStatus.INVALID || abstractNode.getRightColumn().getNodeName().compareTo((String)((Object)iterator)) != 0) continue;
                    abstractNode.getRightColumn().setNodeName(((AbstractNode)object22).getData().getName());
                    abstractNode.getRightColumn().setNodeId(((AbstractNode)object22).getMetadataId());
                    if (this.doesColumnExist((AbstractNode)object22, abstractNode.getRightColumn())) {
                        abstractNode.getRightColumn().setStatus(AttributeStatus.VALID);
                    }
                    sourceNode.put(((AbstractNode)object22).getData().getName(), abstractNode.getRightColumn());
                }
            }
            n = joinNodeType.getOutputColumns().getAutoSpec().equals((Object)AutoSpecType.YES) ? 1 : 0;
            if (n != 0) {
                iterator = new ArrayList();
                object22 = this.findJoinDataNode();
                object = object22.iterator();
                while (object.hasNext()) {
                    AbstractNode abstractNode;
                    abstractNode = (AbstractNode)object.next();
                    Object v = sourceNode.get(abstractNode.getData().getName());
                    AttributeStatus attributeStatus = null;
                    if (v instanceof RefDBColumnType) {
                        attributeStatus = ((RefDBColumnType)v).getStatus();
                    }
                    if (v instanceof JoinSourceNodesType.SourceNode) {
                        attributeStatus = ((JoinSourceNodesType.SourceNode)v).getStatus();
                    }
                    if (v == null || attributeStatus != AttributeStatus.VALID || !(abstractNode instanceof DataProvider)) continue;
                    for (AttributeType attributeType : ((DataProvider)((Object)abstractNode)).getAttributes().getAttribute()) {
                        RefDBColumnType refDBColumnType = new RefDBColumnType();
                        refDBColumnType.setAlias(attributeType.getAlias());
                        refDBColumnType.setDataType(attributeType.getDataType());
                        refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                        refDBColumnType.setName(attributeType.getName());
                        refDBColumnType.setNodeId(abstractNode.getMetadataId());
                        refDBColumnType.setNodeName(abstractNode.getData().getName());
                        refDBColumnType.setStatus(attributeType.getStatus());
                        iterator.add(refDBColumnType);
                    }
                }
                if (iterator.size() > 0) {
                    JoinNode.addOutputAttrs(joinNodeType.getOutputColumns(), iterator, new JoinOutputColumnNameGenerator(this.getContext(), joinNodeType.getOutputColumns()));
                }
            } else {
                for (Object object22 : joinNodeType.getOutputColumns().getRefDBColumn()) {
                    object = (AbstractNode)((HashMap)((Object)iterator2)).get(object22.getNodeName());
                    if (object == null) continue;
                    object22.setNodeId(((AbstractNode)object).getMetadataId());
                    object22.setNodeName(((AbstractNode)object).getData().getName());
                    if (this.doesColumnExist((AbstractNode)object, (RefDBColumnType)object22)) {
                        object22.setStatus(AttributeStatus.VALID);
                        continue;
                    }
                    object22.setStatus(AttributeStatus.INVALID);
                }
            }
        }
        if (joinNodeType.getSourceNodes() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getSourceNodes().getSourceNode()) {
                if (sourceNode.getStatus() != AttributeStatus.INVALID) continue;
                bl = true;
                break;
            }
        }
        if (joinNodeType.getKeyColumns() != null) {
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getKeyColumns().getJoinColumn()) {
                if (sourceNode.getLeftColumn().getStatus() == AttributeStatus.INVALID) {
                    bl = true;
                    break;
                }
                if (sourceNode.getRightColumn().getStatus() != AttributeStatus.INVALID) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getOutputColumns().getRefDBColumn()) {
                    if (sourceNode.getStatus() != AttributeStatus.INVALID) continue;
                    bl = true;
                    break;
                }
            }
        }
        return !bl;
    }

    public void removeInvalidNodes(JoinNodeType joinNodeType) {
        ArrayList<JoinSourceNodesType.SourceNode> arrayList;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        int n = 0;
        if (joinNodeType.getSourceNodes() != null) {
            arrayList = new ArrayList<JoinSourceNodesType.SourceNode>();
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getSourceNodes().getSourceNode()) {
                if (sourceNode.getStatus() != AttributeStatus.INVALID) continue;
                hashMap.put(sourceNode.getNodeName(), Boolean.TRUE);
                arrayList.add(sourceNode);
            }
            if (arrayList.size() > 0) {
                joinNodeType.getSourceNodes().getSourceNode().removeAll(arrayList);
            }
            n = joinNodeType.getSourceNodes().getSourceNode().size();
        }
        if (joinNodeType.getKeyColumns() != null) {
            arrayList = new ArrayList();
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getKeyColumns().getJoinColumn()) {
                boolean bl = false;
                if (sourceNode.getLeftColumn().getStatus() == AttributeStatus.INVALID) {
                    hashMap.put(sourceNode.getLeftColumn().getNodeName(), Boolean.TRUE);
                    bl = true;
                }
                if (sourceNode.getRightColumn().getStatus() == AttributeStatus.INVALID) {
                    hashMap.put(sourceNode.getRightColumn().getNodeName(), Boolean.TRUE);
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(sourceNode);
            }
            if (arrayList.size() > 0) {
                joinNodeType.getKeyColumns().getJoinColumn().removeAll(arrayList);
            }
            n = joinNodeType.getKeyColumns().getJoinColumn().size();
        }
        if (n == 0) {
            joinNodeType.getOutputColumns().getRefDBColumn().clear();
        } else {
            arrayList = new ArrayList();
            for (JoinSourceNodesType.SourceNode sourceNode : joinNodeType.getOutputColumns().getRefDBColumn()) {
                if (sourceNode.getStatus() != AttributeStatus.INVALID && hashMap.get(sourceNode.getNodeName()) == null) continue;
                arrayList.add(sourceNode);
            }
            if (arrayList.size() > 0) {
                joinNodeType.getOutputColumns().getRefDBColumn().removeAll(arrayList);
            }
        }
    }

    public boolean validateNode() {
        boolean bl = true;
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        List<AbstractNode> list = this.findJoinDataNode();
        if (list.size() < 2) {
            this.addMessage("JOIN_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (joinNodeType.getOutputColumns().getRefDBColumn().size() == 0) {
            this.addMessage("JOIN_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (joinNodeType.getOutputColumns().getRefDBColumn().size() > 1000) {
            this.addMessage("JOIN_OUTPUT_EXCEED_LIMIT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (joinNodeType.getKeyColumns() != null && !JoinNode.areAllNodesUsedInKeys(this, joinNodeType.getKeyColumns())) {
            this.addMessage("JOIN_NODE_NOT_USED_IN_KEY", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        this.initDataNodeLookup();
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(true);
    }

    public boolean validateNodeRemoval(boolean bl) {
        return this.validate(bl);
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        for (RefDBColumnType refDBColumnType : joinNodeType.getOutputColumns().getRefDBColumn()) {
            AttributeType attributeType = new AttributeType();
            attributeType.setName(refDBColumnType.getAlias() != null && !refDBColumnType.getAlias().trim().isEmpty() ? refDBColumnType.getAlias() : refDBColumnType.getName());
            attributeType.setAlias(null);
            attributeType.setDataType(refDBColumnType.getDataType());
            attributeType.setDataTypeQualifier(refDBColumnType.getDataTypeQualifier());
            attributeType.setStatus(refDBColumnType.getStatus());
            attributes.getAttribute().add(attributeType);
        }
        return attributes;
    }

    public String generateSQLExpressionOld() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        StringBuffer stringBuffer3 = new StringBuffer(32000);
        StringBuffer stringBuffer4 = new StringBuffer(1000);
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        for (RefDBColumnType refDBColumnType : joinNodeType.getOutputColumns().getRefDBColumn()) {
            if (refDBColumnType.getStatus() != AttributeStatus.VALID) continue;
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("\"" + this.getDataNodeName(refDBColumnType.getNodeId()) + "\".\"" + refDBColumnType.getName() + "\"");
            if (refDBColumnType.getAlias() == null || refDBColumnType.getAlias().length() == 0) {
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer2.append(" \"" + refDBColumnType.getAlias() + "\"\n");
        }
        if (joinNodeType.getSourceNodes() != null) {
            for (RefDBColumnType refDBColumnType : joinNodeType.getSourceNodes().getSourceNode()) {
                if (refDBColumnType.getStatus() != AttributeStatus.VALID || stringBuffer4.indexOf(string = "{INPUT_SOURCE:" + refDBColumnType.getNodeId() + "} \"" + this.getDataNodeName(refDBColumnType.getNodeId()) + "\"") != -1) continue;
                if (stringBuffer4.length() > 0) {
                    stringBuffer4.append(", ");
                }
                stringBuffer4.append(string + "\n");
            }
        }
        if (joinNodeType.getKeyColumns() != null) {
            for (RefDBColumnType refDBColumnType : joinNodeType.getKeyColumns().getJoinColumn()) {
                if (refDBColumnType.getLeftColumn().getStatus() != AttributeStatus.VALID || refDBColumnType.getRightColumn().getStatus() != AttributeStatus.VALID) continue;
                string = "{INPUT_SOURCE:" + refDBColumnType.getLeftColumn().getNodeId() + "} \"" + this.getDataNodeName(refDBColumnType.getLeftColumn().getNodeId()) + "\"";
                if (stringBuffer4.indexOf(string) == -1) {
                    if (stringBuffer4.length() > 0) {
                        stringBuffer4.append(", ");
                    }
                    stringBuffer4.append(string + "\n");
                }
                if (stringBuffer4.indexOf(string = "{INPUT_SOURCE:" + refDBColumnType.getRightColumn().getNodeId() + "} \"" + this.getDataNodeName(refDBColumnType.getRightColumn().getNodeId()) + "\"") == -1) {
                    if (stringBuffer4.length() > 0) {
                        stringBuffer4.append(", ");
                    }
                    stringBuffer4.append(string + "\n");
                }
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append(" AND ");
                }
                if (refDBColumnType.getType().equals((Object)JoinType.INNER)) {
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getLeftColumn().getNodeId()) + "\".\"" + refDBColumnType.getLeftColumn().getName() + "\"");
                    stringBuffer3.append(" = ");
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getRightColumn().getNodeId()) + "\".\"" + refDBColumnType.getRightColumn().getName() + "\"\n");
                    continue;
                }
                if (refDBColumnType.getType().equals((Object)JoinType.LEFT_OUTER)) {
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getLeftColumn().getNodeId()) + "\".\"" + refDBColumnType.getLeftColumn().getName() + "\"");
                    stringBuffer3.append(" = ");
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getRightColumn().getNodeId()) + "\".\"" + refDBColumnType.getRightColumn().getName() + "\" (+)\n");
                    continue;
                }
                if (refDBColumnType.getType().equals((Object)JoinType.RIGHT_OUTER)) {
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getLeftColumn().getNodeId()) + "\".\"" + refDBColumnType.getLeftColumn().getName() + "\" (+)");
                    stringBuffer3.append(" = ");
                    stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getRightColumn().getNodeId()) + "\".\"" + refDBColumnType.getRightColumn().getName() + "\"\n");
                    continue;
                }
                if (!refDBColumnType.getType().equals((Object)JoinType.FULL_OUTER)) continue;
                stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getLeftColumn().getNodeId()) + "\".\"" + refDBColumnType.getLeftColumn().getName() + "\" (+)");
                stringBuffer3.append(" = ");
                stringBuffer3.append("\"" + this.getDataNodeName(refDBColumnType.getRightColumn().getNodeId()) + "\".\"" + refDBColumnType.getRightColumn().getName() + "\" (+)\n");
            }
        }
        if (joinNodeType.getFilter() != null && joinNodeType.getFilter().trim().length() > 0) {
            if (stringBuffer3.length() > 0) {
                stringBuffer3.append(" AND ");
            }
            stringBuffer3.append(joinNodeType.getFilter());
        }
        stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
        stringBuffer.append(stringBuffer2 + "\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append(stringBuffer4 + "\n");
        if (stringBuffer3.length() > 0) {
            stringBuffer.append("WHERE\n");
            stringBuffer.append(stringBuffer3);
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    public String getSQLExpressionForValidate(String string) throws SQLException {
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        if ((joinNodeType.getKeyColumns() == null || joinNodeType.getKeyColumns().getJoinColumn().size() == 0) && (joinNodeType.getSourceNodes() == null || joinNodeType.getSourceNodes().getSourceNode().size() == 0) || joinNodeType.getOutputColumns().getRefDBColumn().size() == 0) {
            return null;
        }
        String string2 = joinNodeType.getFilter();
        joinNodeType.setFilter(string);
        joinNodeType.setSQLExpression(this.generateSQLExpression());
        String string3 = this.getInputSQL();
        if (string2 != null && string2.length() > 0) {
            joinNodeType.setFilter(string2);
            joinNodeType.setSQLExpression(this.generateSQLExpression());
        }
        return string3;
    }

    private String generateJoinConditions(List<JoinKeyColumnsType.JoinColumn> list, HashMap<String, Boolean> hashMap, List<String> list2, List<JoinKeyColumnsType.JoinColumn> list3) {
        RefDBColumnType refDBColumnType;
        Object object;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<JoinKeyColumnsType.JoinColumn> arrayList2 = new ArrayList<JoinKeyColumnsType.JoinColumn>();
        for (int i = 0; i < list.size(); ++i) {
            JoinKeyColumnsType.JoinColumn joinColumn = list.get(i);
            if (arrayList.contains(joinColumn) || arrayList2.contains(joinColumn)) continue;
            arrayList.add(joinColumn);
            for (int string2 = i + 1; string2 < list.size(); ++string2) {
                object = list.get(string2);
                if ((!joinColumn.getType().equals((Object)JoinType.INNER) || !object.getType().equals((Object)JoinType.INNER)) && (!joinColumn.getType().equals((Object)JoinType.FULL_OUTER) || !object.getType().equals((Object)JoinType.FULL_OUTER)) || !joinColumn.getLeftColumn().getNodeId().equals(object.getRightColumn().getNodeId())) continue;
                refDBColumnType = new JoinKeyColumnsType.JoinColumn();
                refDBColumnType.setLeftColumn(object.getRightColumn());
                refDBColumnType.setRightColumn(object.getLeftColumn());
                refDBColumnType.setType(object.getType());
                arrayList.add(refDBColumnType);
                arrayList2.add((JoinKeyColumnsType.JoinColumn)object);
            }
        }
        for (JoinKeyColumnsType.JoinColumn joinColumn : arrayList) {
            if (joinColumn.getLeftColumn().getStatus() != AttributeStatus.VALID || joinColumn.getRightColumn().getStatus() != AttributeStatus.VALID) continue;
            String string2 = null;
            object = null;
            refDBColumnType = joinColumn.getLeftColumn();
            RefDBColumnType refDBColumnType2 = joinColumn.getRightColumn();
            String string3 = null;
            String string4 = null;
            boolean bl = false;
            string2 = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType.getName());
            object = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType2.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType2.getName());
            if (hashMap.isEmpty()) {
                string = refDBColumnType.getNodeId();
                string3 = refDBColumnType2.getNodeId();
                hashMap.put(string, Boolean.TRUE);
                hashMap.put(string3, Boolean.TRUE);
            } else if (!hashMap.containsKey(refDBColumnType.getNodeId()) && hashMap.containsKey(refDBColumnType2.getNodeId())) {
                bl = true;
                string3 = refDBColumnType.getNodeId();
                hashMap.put(string3, Boolean.FALSE);
                string2 = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType2.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType2.getName());
                object = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType.getName());
            } else if (!hashMap.containsKey(refDBColumnType2.getNodeId()) && hashMap.containsKey(refDBColumnType.getNodeId())) {
                string3 = refDBColumnType2.getNodeId();
                hashMap.put(string3, Boolean.TRUE);
            } else if (hashMap.containsKey(refDBColumnType.getNodeId()) && hashMap.containsKey(refDBColumnType2.getNodeId())) {
                string3 = refDBColumnType2.getNodeId();
                string4 = refDBColumnType.getNodeId();
                if (Boolean.FALSE.equals(hashMap.get(refDBColumnType.getNodeId()))) {
                    bl = true;
                    string3 = refDBColumnType.getNodeId();
                    string4 = refDBColumnType2.getNodeId();
                    string2 = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType2.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType2.getName());
                    object = StringUtils.addDoubleQuotes(this.getDataNodeName(refDBColumnType.getNodeId())) + "." + StringUtils.addDoubleQuotes(refDBColumnType.getName());
                }
            } else if (!hashMap.containsKey(refDBColumnType.getNodeId()) && !hashMap.containsKey(refDBColumnType2.getNodeId())) {
                list3.add(joinColumn);
            }
            if (string3 == null) continue;
            String string5 = null;
            if (joinColumn.getType().equals((Object)JoinType.INNER)) {
                string5 = "INNER JOIN ";
            } else if (joinColumn.getType().equals((Object)JoinType.LEFT_OUTER)) {
                string5 = bl ? "RIGHT OUTER JOIN " : "LEFT OUTER JOIN ";
            } else if (joinColumn.getType().equals((Object)JoinType.RIGHT_OUTER)) {
                string5 = bl ? "LEFT OUTER JOIN " : "RIGHT OUTER JOIN ";
            } else if (joinColumn.getType().equals((Object)JoinType.FULL_OUTER)) {
                string5 = "FULL OUTER JOIN ";
            }
            String string6 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", string3) + " " + StringUtils.addDoubleQuotes(this.getDataNodeName(string3));
            String string7 = string5 + string6;
            String string8 = null;
            for (int i = 0; i < list2.size(); ++i) {
                String string9 = list2.get(i);
                if (!string9.startsWith(string7)) continue;
                string8 = "\nAND " + string2 + " = " + (String)object;
                list2.set(i, string9 + (String)string8);
                break;
            }
            if (string8 != null) continue;
            string8 = "\nON " + string2 + " = " + (String)object;
            list2.add(string7 + string8);
        }
        return string;
    }

    public String generateSQLExpression(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        StringBuffer stringBuffer3 = new StringBuffer(32000);
        StringBuffer stringBuffer4 = new StringBuffer(1000);
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        for (Object object2 : joinNodeType.getOutputColumns().getRefDBColumn()) {
            if (object2.getStatus() != AttributeStatus.VALID) continue;
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(StringUtils.addDoubleQuotes(this.getDataNodeName(object2.getNodeId())) + "." + StringUtils.addDoubleQuotes(object2.getName()));
            if (object2.getAlias() == null || object2.getAlias().length() == 0) {
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer2.append(" " + StringUtils.addDoubleQuotes(object2.getAlias()) + "\n");
        }
        if (joinNodeType.getSourceNodes() != null) {
            for (Object object2 : joinNodeType.getSourceNodes().getSourceNode()) {
                if (object2.getStatus() != AttributeStatus.VALID || stringBuffer4.indexOf((String)(object = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", object2.getNodeId()) + " " + StringUtils.addDoubleQuotes(this.getDataNodeName(object2.getNodeId())))) != -1) continue;
                if (stringBuffer4.length() > 0) {
                    stringBuffer4.append(", ");
                }
                stringBuffer4.append((String)object + "\n");
            }
        }
        if (joinNodeType.getKeyColumns() != null) {
            Object object2;
            HashMap hashMap = new HashMap();
            object2 = new ArrayList();
            object = new ArrayList<JoinKeyColumnsType.JoinColumn>();
            String string2 = this.generateJoinConditions(joinNodeType.getKeyColumns().getJoinColumn(), hashMap, (List<String>)object2, (List<JoinKeyColumnsType.JoinColumn>)object);
            if (string2 != null) {
                String string3;
                Object object3;
                String string4 = "{INPUT_SOURCE:<NodeId>}".replace("<NodeId>", string2) + " " + StringUtils.addDoubleQuotes(this.getDataNodeName(string2));
                stringBuffer4.append(string4 + "\n");
                if (!object.isEmpty()) {
                    object3 = new ArrayList();
                    object3.addAll(object);
                    object.clear();
                    string3 = this.generateJoinConditions((List<JoinKeyColumnsType.JoinColumn>)object3, hashMap, (List<String>)object2, (List<JoinKeyColumnsType.JoinColumn>)object);
                }
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    string3 = (String)object3.next();
                    stringBuffer4.append(string3 + "\n");
                }
            }
        }
        if (stringBuffer4.length() > 0) {
            if (string != null && string.trim().length() > 0) {
                if (stringBuffer3.length() > 0) {
                    stringBuffer3.append("\nAND ");
                }
                stringBuffer3.append(string);
            }
            stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
            stringBuffer.append(stringBuffer2 + "\n");
            stringBuffer.append("FROM\n");
            stringBuffer.append(stringBuffer4 + "\n");
            if (stringBuffer3.length() > 0) {
                stringBuffer.append("WHERE\n");
                stringBuffer.append(stringBuffer3);
            }
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    @Override
    public String generateSQLExpression() {
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        return this.generateSQLExpression(joinNodeType.getFilter());
    }

    @Override
    public void setProperty(String string, Object object) {
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        if (string.equals(JOIN_KEY_COLUMNS)) {
            JoinKeyColumnsType joinKeyColumnsType = (JoinKeyColumnsType)object;
            joinNodeType.setKeyColumns(joinKeyColumnsType);
            if (joinKeyColumnsType != null) {
                joinNodeType.setUseCartesian(Boolean.valueOf(false));
            }
            this._nodesLookupMap.clear();
        } else if (string.equals(JOIN_KEY_NODES)) {
            JoinSourceNodesType joinSourceNodesType = (JoinSourceNodesType)object;
            joinNodeType.setSourceNodes(joinSourceNodesType);
            if (joinSourceNodesType != null) {
                joinNodeType.setUseCartesian(Boolean.valueOf(true));
            }
            this._nodesLookupMap.clear();
        } else if (string.equals(JOIN_OUTPUT_COLUMNS)) {
            JoinOutputColumnsType joinOutputColumnsType = (JoinOutputColumnsType)object;
            joinNodeType.setOutputColumns(joinOutputColumnsType);
            this._nodesLookupMap.clear();
        } else if (string.equals(JOIN_FILTER)) {
            String string2 = (String)object;
            joinNodeType.setFilter(string2);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                joinNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                joinNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(JOIN_KEY_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(JOIN_KEY_NODES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(JOIN_OUTPUT_COLUMNS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(JOIN_FILTER)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        Object object = null;
        if (string.equals(JOIN_KEY_COLUMNS)) {
            object = joinNodeType.getKeyColumns();
        } else if (string.equals(JOIN_KEY_NODES)) {
            object = joinNodeType.getSourceNodes();
        } else if (string.equals(JOIN_OUTPUT_COLUMNS)) {
            object = joinNodeType.getOutputColumns();
        } else if (string.equals(JOIN_FILTER)) {
            object = joinNodeType.getFilter();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = joinNodeType.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    public String getDataNodeName(String string) {
        if (this._nodesLookupMap.size() == 0) {
            this.initDataNodeLookup();
        }
        return this._nodesLookupMap.get(string);
    }

    public List<AbstractNode> findJoinDataNode() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public static List<AbstractNode> findDataNodesUsedInJoins(JoinNode joinNode, JoinSourceNodesType joinSourceNodesType) {
        HashMap<String, AbstractNode> hashMap = new HashMap<String, AbstractNode>();
        HashMap<String, AbstractNode> hashMap2 = new HashMap<String, AbstractNode>();
        for (AbstractNode abstractNode : joinNode.findJoinDataNode()) {
            hashMap2.put(abstractNode.getMetadataId(), abstractNode);
        }
        for (AbstractNode abstractNode : joinSourceNodesType.getSourceNode()) {
            AbstractNode abstractNode2;
            String string = abstractNode.getNodeId();
            if (string == null || (abstractNode2 = (AbstractNode)hashMap2.get(string)) == null) continue;
            hashMap.put(string, abstractNode2);
        }
        return new ArrayList<AbstractNode>(hashMap.values());
    }

    public static List<AbstractNode> findDataNodesUsedInJoins(JoinNode joinNode, JoinKeyColumnsType joinKeyColumnsType) {
        HashMap<String, AbstractNode> hashMap = new HashMap<String, AbstractNode>();
        HashMap<String, AbstractNode> hashMap2 = new HashMap<String, AbstractNode>();
        for (AbstractNode abstractNode : joinNode.findJoinDataNode()) {
            hashMap2.put(abstractNode.getMetadataId(), abstractNode);
        }
        for (AbstractNode abstractNode : joinKeyColumnsType.getJoinColumn()) {
            AbstractNode abstractNode2;
            String string = abstractNode.getLeftColumn().getNodeId();
            if (string != null && (abstractNode2 = (AbstractNode)hashMap2.get(string)) != null) {
                hashMap.put(string, abstractNode2);
            }
            if ((string = abstractNode.getRightColumn().getNodeId()) == null || (abstractNode2 = (AbstractNode)hashMap2.get(string)) == null) continue;
            hashMap.put(string, abstractNode2);
        }
        return new ArrayList<AbstractNode>(hashMap.values());
    }

    public static boolean areAllNodesUsedInKeys(JoinNode joinNode, JoinKeyColumnsType joinKeyColumnsType) {
        HashMap<String, AbstractNode> hashMap = new HashMap<String, AbstractNode>();
        for (AbstractNode abstractNode : joinNode.findJoinDataNode()) {
            hashMap.put(abstractNode.getMetadataId(), abstractNode);
        }
        for (AbstractNode abstractNode : joinKeyColumnsType.getJoinColumn()) {
            String string = abstractNode.getLeftColumn().getNodeId();
            if (string != null && hashMap.get(string) != null) {
                hashMap.remove(string);
            }
            if ((string = abstractNode.getRightColumn().getNodeId()) == null || hashMap.get(string) == null) continue;
            hashMap.remove(string);
        }
        return hashMap.size() <= 0;
    }

    public static void addKey(JoinSourceNodesType joinSourceNodesType, List<AbstractNode> list) {
        for (AbstractNode abstractNode : list) {
            JoinSourceNodesType.SourceNode sourceNode = new JoinSourceNodesType.SourceNode();
            sourceNode.setNodeId(abstractNode.getMetadataId());
            sourceNode.setNodeName(abstractNode.getData().getName());
            sourceNode.setStatus(AttributeStatus.VALID);
            joinSourceNodesType.getSourceNode().add(sourceNode);
        }
    }

    public static void addKey(JoinKeyColumnsType joinKeyColumnsType, Node node, AttributeType attributeType, Node node2, AttributeType attributeType2, JoinType joinType) {
        RefDBColumnType refDBColumnType = new RefDBColumnType();
        refDBColumnType.setDataType(attributeType.getDataType());
        refDBColumnType.setKey("Yes");
        refDBColumnType.setName(attributeType.getName());
        refDBColumnType.setNodeId(node.getMetadataId());
        refDBColumnType.setNodeName(node.getData().getName());
        refDBColumnType.setStatus(attributeType.getStatus());
        RefDBColumnType refDBColumnType2 = new RefDBColumnType();
        refDBColumnType2.setDataType(attributeType2.getDataType());
        refDBColumnType2.setKey("Yes");
        refDBColumnType2.setName(attributeType2.getName());
        refDBColumnType2.setNodeId(node2.getMetadataId());
        refDBColumnType2.setNodeName(node2.getData().getName());
        refDBColumnType2.setStatus(attributeType2.getStatus());
        JoinKeyColumnsType.JoinColumn joinColumn = new JoinKeyColumnsType.JoinColumn();
        joinColumn.setLeftColumn(refDBColumnType);
        joinColumn.setRightColumn(refDBColumnType2);
        joinColumn.setType(joinType);
        joinKeyColumnsType.getJoinColumn().add(joinColumn);
    }

    public static void removeKey(JoinKeyColumnsType joinKeyColumnsType, List<JoinKeyColumnsType.JoinColumn> list) {
        joinKeyColumnsType.getJoinColumn().removeAll(list);
    }

    public static void addOutputAttrs(JoinOutputColumnsType joinOutputColumnsType, List<RefDBColumnType> list, JoinOutputColumnNameGenerator joinOutputColumnNameGenerator) {
        List list2 = joinOutputColumnsType.getRefDBColumn();
        for (RefDBColumnType refDBColumnType : list) {
            String string = refDBColumnType.getAlias() != null && refDBColumnType.getAlias().trim().length() > 0 ? refDBColumnType.getAlias() : refDBColumnType.getName();
            boolean bl = false;
            for (Object object : list2) {
                if (refDBColumnType.getNodeId().compareTo(object.getNodeId()) != 0 || string.compareTo(object.getName()) != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            RefDBColumnType refDBColumnType2 = (RefDBColumnType)MetaDataHelper.copyMetadataObject(refDBColumnType);
            if (joinOutputColumnNameGenerator.doesNameExist(string)) {
                Object object;
                object = joinOutputColumnNameGenerator.GenerateColumnName(string, true);
                refDBColumnType2.setAlias((String)object);
            } else {
                joinOutputColumnNameGenerator.addUniqueName(string);
            }
            joinOutputColumnsType.getRefDBColumn().add(refDBColumnType2);
        }
    }

    public static void removeOutputAttrs(JoinOutputColumnsType joinOutputColumnsType, List<RefDBColumnType> list, JoinOutputColumnNameGenerator joinOutputColumnNameGenerator) {
        if (joinOutputColumnNameGenerator != null) {
            for (RefDBColumnType refDBColumnType : list) {
                joinOutputColumnNameGenerator.removeUniqueName(refDBColumnType);
            }
        }
        joinOutputColumnsType.getRefDBColumn().removeAll(list);
    }

    public static int addOutputAttrs(JoinOutputColumnsType joinOutputColumnsType, JoinNode joinNode, JoinSourceNodesType joinSourceNodesType) {
        Object object;
        JoinSourceNodesType.SourceNode sourceNode2;
        ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
        HashMap<Object, JoinSourceNodesType.SourceNode> hashMap = new HashMap<Object, JoinSourceNodesType.SourceNode>();
        if (joinSourceNodesType != null) {
            for (JoinSourceNodesType.SourceNode sourceNode2 : joinSourceNodesType.getSourceNode()) {
                object = sourceNode2.getNodeName();
                hashMap.put(object, sourceNode2);
            }
        }
        List<AbstractNode> list = joinNode.findParentNodes();
        sourceNode2 = list.iterator();
        while (sourceNode2.hasNext()) {
            object = (AbstractNode)sourceNode2.next();
            Object v = hashMap.get(((AbstractNode)object).getData().getName());
            AttributeStatus attributeStatus = null;
            if (v instanceof RefDBColumnType) {
                attributeStatus = ((RefDBColumnType)v).getStatus();
            }
            if (v instanceof JoinSourceNodesType.SourceNode) {
                attributeStatus = ((JoinSourceNodesType.SourceNode)v).getStatus();
            }
            if (v == null || attributeStatus != AttributeStatus.VALID || !(object instanceof DataProvider)) continue;
            for (AttributeType attributeType : ((DataProvider)object).getAttributes().getAttribute()) {
                RefDBColumnType refDBColumnType = new RefDBColumnType();
                refDBColumnType.setAlias(attributeType.getAlias());
                refDBColumnType.setDataType(attributeType.getDataType());
                refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                refDBColumnType.setName(attributeType.getName());
                refDBColumnType.setNodeId(((AbstractNode)object).getMetadataId());
                refDBColumnType.setNodeName(((AbstractNode)object).getData().getName());
                refDBColumnType.setStatus(attributeType.getStatus());
                arrayList.add(refDBColumnType);
            }
        }
        if (arrayList.size() > 0) {
            JoinNode.addOutputAttrs(joinOutputColumnsType, arrayList, new JoinOutputColumnNameGenerator(joinNode.getContext(), joinOutputColumnsType));
        }
        return arrayList.size();
    }

    public static int addOutputAttrs(JoinOutputColumnsType joinOutputColumnsType, JoinNode joinNode, JoinKeyColumnsType joinKeyColumnsType) {
        Object object;
        JoinKeyColumnsType.JoinColumn joinColumn2;
        ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
        HashMap<Object, RefDBColumnType> hashMap = new HashMap<Object, RefDBColumnType>();
        if (joinKeyColumnsType != null) {
            for (JoinKeyColumnsType.JoinColumn joinColumn2 : joinKeyColumnsType.getJoinColumn()) {
                object = joinColumn2.getLeftColumn().getNodeName();
                hashMap.put(object, joinColumn2.getLeftColumn());
                object = joinColumn2.getRightColumn().getNodeName();
                hashMap.put(object, joinColumn2.getRightColumn());
            }
        }
        List<AbstractNode> list = joinNode.findParentNodes();
        joinColumn2 = list.iterator();
        while (joinColumn2.hasNext()) {
            object = (AbstractNode)joinColumn2.next();
            Object v = hashMap.get(((AbstractNode)object).getData().getName());
            AttributeStatus attributeStatus = null;
            if (v instanceof RefDBColumnType) {
                attributeStatus = ((RefDBColumnType)v).getStatus();
            }
            if (v instanceof JoinSourceNodesType.SourceNode) {
                attributeStatus = ((JoinSourceNodesType.SourceNode)v).getStatus();
            }
            if (v == null || attributeStatus != AttributeStatus.VALID || !(object instanceof DataProvider)) continue;
            for (AttributeType attributeType : ((DataProvider)object).getAttributes().getAttribute()) {
                RefDBColumnType refDBColumnType = new RefDBColumnType();
                refDBColumnType.setAlias(attributeType.getAlias());
                refDBColumnType.setDataType(attributeType.getDataType());
                refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                refDBColumnType.setName(attributeType.getName());
                refDBColumnType.setNodeId(((AbstractNode)object).getMetadataId());
                refDBColumnType.setNodeName(((AbstractNode)object).getData().getName());
                refDBColumnType.setStatus(attributeType.getStatus());
                arrayList.add(refDBColumnType);
            }
        }
        if (arrayList.size() > 0) {
            JoinNode.addOutputAttrs(joinOutputColumnsType, arrayList, new JoinOutputColumnNameGenerator(joinNode.getContext(), joinOutputColumnsType));
        }
        return arrayList.size();
    }

    public static void addOutputAttrs(JoinOutputColumnsType joinOutputColumnsType, Node node, JoinOutputColumnNameGenerator joinOutputColumnNameGenerator) {
        if (node instanceof DataProvider) {
            DataProvider dataProvider = (DataProvider)((Object)node);
            List list = dataProvider.getAttributes().getAttribute();
            List list2 = joinOutputColumnsType.getRefDBColumn();
            for (AttributeType attributeType : list) {
                String string = attributeType.getAlias() != null && attributeType.getAlias().trim().length() > 0 ? attributeType.getAlias() : attributeType.getName();
                boolean bl = false;
                for (Object object : list2) {
                    if (node.getMetadataId().compareTo(object.getNodeId()) != 0 || string.compareTo(object.getName()) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                RefDBColumnType refDBColumnType = new RefDBColumnType();
                refDBColumnType.setNodeId(node.getMetadataId());
                refDBColumnType.setNodeName(node.getData().getName());
                refDBColumnType.setName(string);
                if (joinOutputColumnNameGenerator.doesNameExist(string)) {
                    Object object;
                    object = joinOutputColumnNameGenerator.GenerateColumnName(string, true);
                    refDBColumnType.setAlias((String)object);
                } else {
                    joinOutputColumnNameGenerator.addUniqueName(string);
                }
                refDBColumnType.setDataType(attributeType.getDataType());
                refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                refDBColumnType.setStatus(attributeType.getStatus());
                joinOutputColumnsType.getRefDBColumn().add(refDBColumnType);
            }
        }
    }

    public static void removeOutputAttrsFromNodes(JoinOutputColumnsType joinOutputColumnsType, List<String> list, JoinOutputColumnNameGenerator joinOutputColumnNameGenerator) {
        if (list == null) {
            joinOutputColumnsType.getRefDBColumn().clear();
            if (joinOutputColumnNameGenerator != null) {
                joinOutputColumnNameGenerator.removeAllUniqueNames();
            }
        } else {
            ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
            for (String string : list) {
                for (RefDBColumnType refDBColumnType : joinOutputColumnsType.getRefDBColumn()) {
                    if (refDBColumnType.getNodeId().compareTo(string) != 0) continue;
                    arrayList.add(refDBColumnType);
                }
            }
            JoinNode.removeOutputAttrs(joinOutputColumnsType, arrayList, joinOutputColumnNameGenerator);
        }
    }

    @Override
    public String getHelpTopic() {
        return "join_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_JOIN_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_JOIN_ICON"));
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public DataGuideType getJSONAttrDataGuide(AttributeType attributeType, Integer n) {
        AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        boolean bl = false;
        for (RefDBColumnType refDBColumnType : joinNodeType.getOutputColumns().getRefDBColumn()) {
            if (refDBColumnType.getAlias() != null && !refDBColumnType.getAlias().trim().isEmpty()) {
                if (attributeType.getName().compareToIgnoreCase(refDBColumnType.getAlias()) != 0) continue;
                attributeType2.setName(refDBColumnType.getName());
                bl = true;
                break;
            }
            if (attributeType.getName().compareToIgnoreCase(refDBColumnType.getName()) != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return super.getJSONAttrDataGuide(attributeType2, n);
        }
        return null;
    }

    @Override
    public DataGuideInfoType getJSONAttrDataGuideInfoType(AttributeType attributeType) {
        AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
        JoinNodeType joinNodeType = (JoinNodeType)this.getData();
        boolean bl = false;
        for (RefDBColumnType refDBColumnType : joinNodeType.getOutputColumns().getRefDBColumn()) {
            if (refDBColumnType.getAlias() != null && !refDBColumnType.getAlias().trim().isEmpty()) {
                if (attributeType.getName().compareToIgnoreCase(refDBColumnType.getAlias()) != 0) continue;
                attributeType2.setName(refDBColumnType.getName());
                bl = true;
                break;
            }
            if (attributeType.getName().compareToIgnoreCase(refDBColumnType.getName()) != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return super.getJSONAttrDataGuideInfoType(attributeType2);
        }
        return null;
    }

    public static class JoinOutputColumnNameGenerator {
        private static final int MAXIMUM = 30;
        private static final int MAXIMUM_EX = 128;
        private boolean isExpandedObjNameEnabled;
        private Map<String, Boolean> columnNames = new HashMap<String, Boolean>();

        public JoinOutputColumnNameGenerator(Context context, JoinOutputColumnsType joinOutputColumnsType) {
            this.isExpandedObjNameEnabled = SQLHelper.isExpandedObjNameEnabled(context);
            for (RefDBColumnType refDBColumnType : joinOutputColumnsType.getRefDBColumn()) {
                String string = refDBColumnType.getAlias() == null ? refDBColumnType.getName() : refDBColumnType.getAlias();
                this.columnNames.put(string, Boolean.TRUE);
            }
        }

        public boolean doesNameExist(String string) {
            Boolean bl = this.columnNames.get(string);
            return bl != null;
        }

        public void addUniqueName(String string) {
            this.columnNames.put(string, Boolean.TRUE);
        }

        public void removeUniqueName(String string) {
            this.columnNames.remove(string);
        }

        public void removeUniqueName(RefDBColumnType refDBColumnType) {
            String string = refDBColumnType.getAlias() == null ? refDBColumnType.getName() : refDBColumnType.getAlias();
            this.removeUniqueName(string);
        }

        public void removeAllUniqueNames() {
            this.columnNames.clear();
        }

        private String getUniqueName(String string) {
            Object object = string;
            int n = 0;
            while (this.columnNames.containsKey(object)) {
                int n2;
                if ((n2 = ((String)(object = string + ++n)).length()) <= (this.isExpandedObjNameEnabled ? 128 : 30)) continue;
                int n3 = n2 - (this.isExpandedObjNameEnabled ? 128 : 30);
                object = string.substring(0, string.length() - n3) + n;
            }
            return object;
        }

        public String GenerateColumnName(String string, boolean bl) {
            String string2 = this.getUniqueName(string);
            if (bl) {
                this.columnNames.put(string2, Boolean.TRUE);
            }
            return string2;
        }
    }
}

