/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.model.SupervisedBuildNode;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public abstract class ExtensibleBuildNode
extends AbstractBuildNode {
    public static final String MINING_FUNCTION = "miningFunction";
    private static final int INPUT_SOURCES_LIMIT = 2;
    private static final String UNSUPERVISED_SECTION = "UNSUPERVISED";
    private static final String SUPERVISED_SECTION = "SUPERVISED";
    private static final String CLASSIFICATION_SECTION = "CLASSIFICATION";
    private static final String REGRESSION_SECTION = "REGRESSION";
    private boolean supervisedLearning;
    private Preferences preferences = Preferences.getPreferences();

    public ExtensibleBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return false;
        }
        if (this.isSupervisedBuildNode()) {
            TestDataSource.TestData testData;
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
            BuildDataSource buildDataSource = extensibleBuildNodeType.getBuildDataSource();
            TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
            if (testDataSource != null && (testData = testDataSource.getTestData()) != null && buildDataSource != null) {
                bl = false;
            }
        } else {
            List<AbstractNode> list = this.findAllParentNodes();
            if (!list.isEmpty()) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        if (!this.isSupervisedBuildNode()) {
            return;
        }
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        if (testData == null && list.size() == 2) {
            TestDataSource testDataSource2 = new TestDataSource();
            testData = new TestDataSource.TestData();
            testData.setSourceId(node.getMetadataId());
            testDataSource2.setTestData(testData);
            testDataSource2.setSplitData(null);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testOptionsChanged", testDataSource2);
            for (GeneralLink generalLink : list) {
                if (((AbstractNode)generalLink.getFrom()).getMetadataId().equals(testData.getSourceId())) {
                    odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("TEST_DATA_LINK_LABEL"));
                    continue;
                }
                odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("BUILD_DATA_LINK_LABEL"));
            }
            if (NodeStatusType.COMPLETE.equals((Object)extensibleBuildNodeType.getStatus()) || NodeStatusType.WARNING.equals((Object)extensibleBuildNodeType.getStatus())) {
                this.setNodeReady();
            }
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        if (!this.isSupervisedBuildNode()) {
            return;
        }
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        if (testData != null && testData.getSourceId().equals(node.getMetadataId())) {
            this.handleRemoveTestDataSource(testDataSource);
        } else if (testData != null) {
            this.handleRemoveTestDataSource(testDataSource);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        List list;
        Attributes attributes;
        boolean bl2 = super.validate(bl);
        if (!this.isSupervisedBuildNode()) {
            List<GeneralLink> list2 = this.getModel().findLinksToNode((IlvSDMNode)this);
            if (list2.size() == 2) {
                this.addMessage("BUILD_TEST_NOT_REQUIRED", MessageEnumType.ADVISORY, new String[0]);
                bl2 = false;
            }
            return bl2;
        }
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        if (abstractDataNode != null) {
            attributes = ((DataProvider)abstractDataNode).getAttributes();
            list = attributes.getAttribute();
            if (!this.validateBuildAttributes(list)) {
                bl2 = false;
            }
            if (!this.validateTarget(list)) {
                bl2 = false;
            }
        } else {
            this.validateTarget(null);
            bl2 = false;
            return bl2;
        }
        attributes = (ExtensibleBuildNodeType)this.getData();
        list = attributes.getTestDataSource();
        if (list != null && list.getTestData() != null) {
            AbstractDataNode abstractDataNode2 = this.findTestDataNode(this.getModel());
            if (abstractDataNode2 != null) {
                Attributes attributes2 = ((DataProvider)abstractDataNode2).getAttributes();
                List list3 = attributes2.getAttribute();
                if (!this.validateTestAttributes(list3)) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        if (bl) {
            this.validateChildren();
        }
        this.setState(bl2);
        return bl2;
    }

    @Override
    public Object getProperty(String string) {
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
        switch (string) {
            case "miningFunction": {
                MiningFunctionType miningFunctionType = extensibleBuildNodeType.getMiningFunction();
                return miningFunctionType;
            }
            case "targetAttribute": {
                AttributeType attributeType = extensibleBuildNodeType.getTargetAttribute();
                return attributeType;
            }
            case "targetAttributeInvalid": {
                AttributeType attributeType = extensibleBuildNodeType.getTargetAttribute();
                return attributeType == null ? null : attributeType.getStatus();
            }
            case "testData": {
                return extensibleBuildNodeType.getTestDataSource();
            }
            case "splitValueChanged": {
                TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
                return testDataSource.getSplitData().getTestPercent();
            }
            case "splitDataFormat": {
                TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
                return testDataSource.getSplitData().getDataFormat();
            }
            case "testOptionsChanged": {
                return extensibleBuildNodeType.getTestDataSource();
            }
            case "genAccuracyMetrics": {
                return results.isGenAccuracyMetrics();
            }
            case "classTestResults": 
            case "regrTestResults": {
                return results;
            }
            case "genConfusionMatrix": {
                return results.isGenConfusionMatrix();
            }
            case "genROC": {
                return results.isGenROC();
            }
            case "genLiftProfit": {
                return results.isGenLift();
            }
            case "testSettingsChanged": {
                return extensibleBuildNodeType.getTestSettings();
            }
            case "genResiduals": {
                results = extensibleBuildNodeType.getResults();
                return results.isGenResiduals();
            }
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        List list = null;
        switch (complexProperty.getPropertyName()) {
            case "miningFunction": {
                return complexProperty.getOldData();
            }
            case "targetAttributeInvalid": {
                return complexProperty.getOldData();
            }
            case "resultStatus": {
                return complexProperty.getOldData();
            }
            case "modelsRerun": {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
                Map map = (Map)complexProperty.getData();
                HashMap hashMap = new HashMap(map.size());
                map.forEach((string, modelStatusType) -> {
                    ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)extensibleBuildNodeType, string);
                    hashMap.put(string, modelType.getStatus());
                });
                return hashMap;
            }
            case "modelUseForOutput": {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
                List list2 = (List)complexProperty.getData();
                List list3 = list2.stream().map(pair -> {
                    String string = (String)pair.getFirst();
                    ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)extensibleBuildNodeType, string);
                    return new Pair((Object)string, (Object)modelType.isUseForOutput());
                }).collect(Collectors.toList());
                return list3;
            }
            case "testsRerun": {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
                if (this.isClassification()) {
                    list = extensibleBuildNodeType.getResults().getClassificationResult();
                } else if (this.isRegression()) {
                    list = extensibleBuildNodeType.getResults().getRegressionResult();
                }
                Map map = (Map)complexProperty.getData();
                HashMap hashMap = new HashMap(map.size());
                list.stream().filter(miningResultType -> map.containsKey(miningResultType.getModelId())).forEach(miningResultType -> hashMap.put(miningResultType.getModelId(), miningResultType.getStatus()));
                return hashMap;
            }
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string2, Object object) {
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        List list = new ArrayList(0);
        switch (string2) {
            case "miningFunction": {
                MiningFunctionType miningFunctionType = (MiningFunctionType)object;
                if (AbstractBuildNode.isSupervisedFunction(miningFunctionType)) {
                    ExtensibleBuildNode.initializeSupervisedMetadata(extensibleBuildNodeType);
                } else {
                    ExtensibleBuildNode.deleteSupervisedMetadata(extensibleBuildNodeType);
                }
                extensibleBuildNodeType.setMiningFunction(miningFunctionType);
                break;
            }
            case "targetAttribute": {
                extensibleBuildNodeType.setTargetAttribute((AttributeType)object);
                break;
            }
            case "targetAttributeInvalid": {
                AttributeType attributeType = extensibleBuildNodeType.getTargetAttribute();
                if (attributeType == null) break;
                attributeType.setStatus((AttributeStatus)object);
                break;
            }
            case "testData": {
                extensibleBuildNodeType.setTestDataSource((TestDataSource)object);
                break;
            }
            case "resultStatus": {
                this.setResultStatus(object);
                break;
            }
            case "modelAdded": {
                if (!(object instanceof List)) {
                    return;
                }
                List list2 = (List)object;
                for (ModelType modelType : list2) {
                    List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)extensibleBuildNodeType, modelType);
                    if (list3.contains(modelType)) continue;
                    MetaDataHelper.addModel((BuildNodeType)extensibleBuildNodeType, modelType);
                }
                this.setNavigatorRefreshPending();
                break;
            }
            case "modelRemoved": {
                if (!(object instanceof List)) {
                    return;
                }
                List list4 = (List)object;
                for (ModelType modelType : list4) {
                    List<ModelType> list5 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)extensibleBuildNodeType, modelType);
                    if (!list5.contains(modelType)) continue;
                    MetaDataHelper.removeModel((BuildNodeType)extensibleBuildNodeType, modelType);
                }
                this.setNavigatorRefreshPending();
                break;
            }
            case "modelsRerun": {
                if (!(object instanceof Map)) {
                    throw new IllegalArgumentException("Value is not a Map");
                }
                Map map = (Map)object;
                map.forEach((string, modelStatusType) -> {
                    ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)extensibleBuildNodeType, string);
                    modelType.setStatus((ModelStatusType)map.get(string));
                });
                break;
            }
            case "testsRerun": {
                if (this.isClassification()) {
                    list = extensibleBuildNodeType.getResults().getClassificationResult();
                } else if (this.isRegression()) {
                    list = extensibleBuildNodeType.getResults().getRegressionResult();
                }
                Map map = (Map)object;
                for (MiningResultType miningResultType : list) {
                    ModelStatusType modelStatusType2 = (ModelStatusType)map.get(miningResultType.getModelId());
                    if (modelStatusType2 == null) continue;
                    miningResultType.setStatus(modelStatusType2);
                }
                break;
            }
            case "splitValueChanged": {
                if (object == null || !(object instanceof Double)) {
                    return;
                }
                Double d = (Double)object;
                TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
                if (testDataSource.getSplitData().getTestPercent() == d.doubleValue()) break;
                testDataSource.getSplitData().setTestPercent(d.doubleValue());
                break;
            }
            case "splitDataFormat": {
                String string3 = (String)object;
                TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
                if (string3 != null && testDataSource.getSplitData().getDataFormat() != null && testDataSource.getSplitData().getDataFormat().equals(string3)) break;
                testDataSource.getSplitData().setDataFormat(string3);
                break;
            }
            case "testOptionsChanged": {
                TestDataSource testDataSource = (TestDataSource)object;
                extensibleBuildNodeType.setTestDataSource(testDataSource);
                break;
            }
            case "alltestsRemoved": {
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (results == null) break;
                if (this.isClassification()) {
                    results.getClassificationResult().clear();
                    break;
                }
                if (!this.isRegression()) break;
                results.getRegressionResult().clear();
                break;
            }
            case "testsRemoved": {
                List list6 = (List)object;
                if (this.isClassification()) {
                    list = extensibleBuildNodeType.getResults().getClassificationResult();
                } else if (this.isRegression()) {
                    list = extensibleBuildNodeType.getResults().getRegressionResult();
                }
                this.removeResultsFromList(list, list6);
                break;
            }
            case "alltestsRestored": {
                if (this.isClassification()) {
                    List list7 = (List)object;
                    extensibleBuildNodeType.getResults().getClassificationResult().clear();
                    extensibleBuildNodeType.getResults().getClassificationResult().addAll(list7);
                    break;
                }
                if (!this.isRegression()) break;
                List list8 = (List)object;
                extensibleBuildNodeType.getResults().getRegressionResult().clear();
                extensibleBuildNodeType.getResults().getRegressionResult().addAll(list8);
                break;
            }
            case "testsRestored": {
                if (this.isClassification()) {
                    List list9 = (List)object;
                    List list10 = extensibleBuildNodeType.getResults().getClassificationResult();
                    Map<String, ClassificationResultType> map = list10.stream().collect(Collectors.toMap(classificationResultType -> classificationResultType.getModelId(), classificationResultType -> classificationResultType));
                    list10.addAll(list9.stream().filter(classificationResultType -> !map.containsKey(classificationResultType.getModelId())).collect(Collectors.toList()));
                    break;
                }
                if (!this.isRegression()) break;
                List list11 = (List)object;
                List list12 = extensibleBuildNodeType.getResults().getRegressionResult();
                Map<String, RegressionResultType> map = list12.stream().collect(Collectors.toMap(regressionResultType -> regressionResultType.getModelId(), regressionResultType -> regressionResultType));
                list12.addAll(list11.stream().filter(regressionResultType -> !map.containsKey(regressionResultType.getModelId())).collect(Collectors.toList()));
                break;
            }
            case "genAccuracyMetrics": {
                Boolean bl = (Boolean)object;
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (bl != null && bl.equals(results.isGenAccuracyMetrics())) break;
                results.setGenAccuracyMetrics(bl);
                break;
            }
            case "modelUseForOutput": {
                if (object == null || !(object instanceof List)) {
                    return;
                }
                List list13 = (List)object;
                list13.forEach(pair -> {
                    ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)extensibleBuildNodeType, (String)pair.getFirst());
                    modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
                });
                break;
            }
            case "classTestResults": 
            case "regrTestResults": {
                extensibleBuildNodeType.setResults((ExtensibleBuildNodeType.Results)object);
                break;
            }
            case "genConfusionMatrix": {
                Boolean bl = (Boolean)object;
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (bl != null && bl.equals(results.isGenConfusionMatrix())) break;
                results.setGenConfusionMatrix(bl);
                break;
            }
            case "genROC": {
                Boolean bl = (Boolean)object;
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (bl != null && bl.equals(results.isGenROC())) break;
                results.setGenROC(bl);
                break;
            }
            case "genLiftProfit": {
                Boolean bl = (Boolean)object;
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (bl != null && bl.equals(results.isGenLift())) break;
                results.setGenLift(bl);
                break;
            }
            case "testSettingsChanged": {
                if (object == null || !(object instanceof ClassificationTestSettingsType)) {
                    return;
                }
                ClassificationTestSettingsType classificationTestSettingsType = (ClassificationTestSettingsType)object;
                extensibleBuildNodeType.setTestSettings(classificationTestSettingsType);
                break;
            }
            case "genResiduals": {
                Boolean bl = (Boolean)object;
                ExtensibleBuildNodeType.Results results = extensibleBuildNodeType.getResults();
                if (bl != null && bl.equals(results.isGenResiduals())) break;
                results.setGenResiduals(bl);
                break;
            }
            default: {
                super.setProperty(string2, object);
            }
        }
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return ((ExtensibleBuildNodeType)this.getData()).getMiningFunction();
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return ((ExtensibleBuildNodeType)this.getData()).getMiningFunction();
    }

    @Override
    public void refactor(Node node, boolean bl) {
        if (this.isSupervisedBuildNode()) {
            ExtensibleBuildNodeType.Results results = new ExtensibleBuildNodeType.Results();
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            if (this.isClassification()) {
                if (!extensibleBuildNodeType.getResults().getClassificationResult().isEmpty()) {
                    results.setGenAccuracyMetrics(extensibleBuildNodeType.getResults().isGenAccuracyMetrics());
                    results.setGenConfusionMatrix(extensibleBuildNodeType.getResults().isGenConfusionMatrix());
                    results.setGenLift(extensibleBuildNodeType.getResults().isGenLift());
                    results.setGenROC(extensibleBuildNodeType.getResults().isGenROC());
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "classTestResults", results);
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), new ComplexProperty("allweightsRemoved", "allweightsRestored", MetaDataHelper.getWeightTablesCollection((BuildNodeType)extensibleBuildNodeType)));
                }
            } else if (this.isRegression() && !extensibleBuildNodeType.getResults().getRegressionResult().isEmpty()) {
                results.setGenAccuracyMetrics(extensibleBuildNodeType.getResults().isGenAccuracyMetrics());
                results.setGenResiduals(extensibleBuildNodeType.getResults().isGenResiduals());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "regrTestResults", results);
            }
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        super.refactorAttributes(node, map);
        if (!this.isSupervisedBuildNode()) {
            return;
        }
        if (!map.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(extensibleBuildNodeType.getTargetAttribute());
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 != null) {
                attributeType.setName(attributeType2.getName());
                attributeType.setDataType(attributeType2.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "targetAttribute", attributeType);
            }
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        boolean bl = super.isVersionSupported(context, stringBuffer);
        if (bl && this.isSupervisedBuildNode()) {
            Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
            String string = extensibleBuildNodeType.getTargetAttribute().getName();
            String string2 = extensibleBuildNodeType.getTargetAttribute().getDataType();
            stringBuffer.setLength(0);
            if (!DbMetadataUtils.isTargetCategoricalDataTypeSupported((Version)version, (String)string2)) {
                Object[] objectArray = new Object[]{string, string2};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_TARGET_DATA_TYPE_NOT_SUPPORTED"), objectArray));
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        if (!this.isSupervisedBuildNode()) {
            return;
        }
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(this.getData());
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (MiningResultType miningResultType : list) {
            if (!ModelStatusType.COMPLETE.equals((Object)miningResultType.getStatus())) continue;
            ComplexProperty complexProperty = new ComplexProperty("resultStatus", new SubNodeProperty(miningResultType.getModelId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(miningResultType.getModelId(), miningResultType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.isSupervisedBuildNode()) {
            SupervisedBuildNode supervisedBuildNode = null;
            if (this.isClassification()) {
                supervisedBuildNode = new ClassificationBuildNode("", this.getData(), this.getContext());
                string2 = CodeTemplate.removeSectionFromTemplate(string2, REGRESSION_SECTION);
            } else if (this.isRegression()) {
                supervisedBuildNode = new RegressionBuildNode("", this.getData(), this.getContext());
                string2 = CodeTemplate.removeSectionFromTemplate(string2, CLASSIFICATION_SECTION);
                treeMap.put("<COMMENT_MODEL>", "");
                treeMap.put("<WEIGHTS_SETTING>", "");
            } else assert (false) : "The supervised node is not supported yet.";
            string2 = CodeTemplate.removeSectionFromTemplate(string2, UNSUPERVISED_SECTION);
            String string3 = ((SupervisedBuildNode)supervisedBuildNode).generateBuildTestDataCode(context);
            String string4 = this.getTargetAttribute().getName();
            treeMap.put("<TARGET_ASSIGNATION>", String.format("  v_target := '%s';", string4));
            treeMap.put("<TARGET_DEFINITION>", "'\"'||v_target||'\"'");
            treeMap.put("<BUILD_TEST_DATA>", string3);
            treeMap.put("<TARGET>", string4);
        } else {
            treeMap.put("<TARGET_ASSIGNATION>", "");
            treeMap.put("<TARGET_DEFINITION>", "NULL");
            treeMap.put("<BUILD_TEST_DATA>", "");
            treeMap.put("<COMMENT_MODEL>", "");
            treeMap.put("<WEIGHTS_SETTING>", "");
            treeMap.put("<TEST_MODELS>", "");
            string2 = CodeTemplate.removeSectionFromTemplate(string2, SUPERVISED_SECTION);
            string2 = CodeTemplate.removeSectionFromTemplate(string2, CLASSIFICATION_SECTION);
            string2 = CodeTemplate.removeSectionFromTemplate(string2, REGRESSION_SECTION);
        }
        treeMap.put("{$UNSUPERVISED}", "");
        treeMap.put("{$SUPERVISED}", "");
        treeMap.put("{$CLASSIFICATION}", "");
        treeMap.put("{$REGRESSION}", "");
        string2 = this.makeReplacementsInTemplate(string2, treeMap);
        return string2;
    }

    @Override
    public AttributeType getTargetAttribute() {
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        return extensibleBuildNodeType.getTargetAttribute();
    }

    private void removeResultsFromList(List<? extends MiningResultType> list, List<MiningResultType> list2) {
        list.removeIf(miningResultType -> list2.stream().anyMatch(miningResultType2 -> miningResultType2.getModelId().equals(miningResultType.getModelId())));
    }

    private static void initializeSupervisedMetadata(ExtensibleBuildNodeType extensibleBuildNodeType) {
        TestDataSource testDataSource = new TestDataSource();
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(40.0);
        testDataSource.setSplitData(splitData);
        extensibleBuildNodeType.setTestDataSource(testDataSource);
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        extensibleBuildNodeType.setTestSettings(classificationTestSettingsType);
        ExtensibleBuildNodeType.Results results = new ExtensibleBuildNodeType.Results();
        extensibleBuildNodeType.setResults(results);
    }

    private void initializeSupervisedMetadata() {
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        TestDataSource testDataSource = new TestDataSource();
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(40.0);
        testDataSource.setSplitData(splitData);
        extensibleBuildNodeType.setTestDataSource(testDataSource);
        ClassificationTestSettingsType classificationTestSettingsType = new ClassificationTestSettingsType();
        extensibleBuildNodeType.setTestSettings(classificationTestSettingsType);
        ExtensibleBuildNodeType.Results results = new ExtensibleBuildNodeType.Results();
        extensibleBuildNodeType.setResults(results);
    }

    private static void deleteSupervisedMetadata(ExtensibleBuildNodeType extensibleBuildNodeType) {
        TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
        if (testDataSource != null) {
            testDataSource.setTestData(null);
            testDataSource.setBuildData(null);
            testDataSource.setSplitData(null);
            extensibleBuildNodeType.setTestDataSource(null);
        }
        extensibleBuildNodeType.setTestSettings(null);
        extensibleBuildNodeType.setResults(null);
    }

    private void deleteSupervisedMetadata() {
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
        if (testDataSource != null) {
            testDataSource.setTestData(null);
            testDataSource.setBuildData(null);
            testDataSource.setSplitData(null);
            extensibleBuildNodeType.setTestDataSource(null);
        }
        extensibleBuildNodeType.setTestSettings(null);
        extensibleBuildNodeType.setResults(null);
    }

    private static void loadClassificationPreferences(ExtensibleBuildNodeType extensibleBuildNodeType) {
        String string;
        TestDataSource testDataSource;
        Preferences preferences = Preferences.getPreferences();
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (StringUtils.isNotEmpty((String)classificationModelBuildPreferencesPanelSettings.getTestDataOption())) {
            testDataSource = extensibleBuildNodeType.getTestDataSource();
            switch (classificationModelBuildPreferencesPanelSettings.getTestDataOption()) {
                case "TEST_DATA_OPTION_ALL": {
                    testDataSource.setBuildData(new TestDataSource.BuildData());
                    break;
                }
                case "TEST_DATA_OPTION_SPLIT": {
                    TestDataSource.SplitData splitData = testDataSource.getSplitData();
                    Double d = classificationModelBuildPreferencesPanelSettings.getTestSplitPercent();
                    splitData.setTestPercent(d.doubleValue());
                    String string2 = classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
                    splitData.setDataFormat(string2);
                    break;
                }
                default: {
                    testDataSource.setTestData(new TestDataSource.TestData());
                }
            }
        }
        testDataSource = extensibleBuildNodeType.getTestSettings();
        if (classificationModelBuildPreferencesPanelSettings.isTOPN()) {
            string = new ClassificationTestSettingsType.TopNTargets();
            string.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            testDataSource.setTopNTargets((ClassificationTestSettingsType.TopNTargets)string);
        } else {
            string = new ClassificationTestSettingsType.BottomNTargets();
            string.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            testDataSource.setBottomNTargets((ClassificationTestSettingsType.BottomNTargets)string);
        }
        string = extensibleBuildNodeType.getResults();
        string.setGenAccuracyMetrics(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        string.setGenConfusionMatrix(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isConfusionMatrix()));
        string.setGenROC(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isROC()));
        string.setGenLift(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isLift()));
    }

    private void loadClassificationPreferences() {
        String string;
        TestDataSource testDataSource;
        ClassificationModelBuildPreferencesPanelSettings classificationModelBuildPreferencesPanelSettings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)this.preferences);
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        if (StringUtils.isNotEmpty((String)classificationModelBuildPreferencesPanelSettings.getTestDataOption())) {
            testDataSource = extensibleBuildNodeType.getTestDataSource();
            switch (classificationModelBuildPreferencesPanelSettings.getTestDataOption()) {
                case "TEST_DATA_OPTION_ALL": {
                    testDataSource.setBuildData(new TestDataSource.BuildData());
                    break;
                }
                case "TEST_DATA_OPTION_SPLIT": {
                    TestDataSource.SplitData splitData = testDataSource.getSplitData();
                    Double d = classificationModelBuildPreferencesPanelSettings.getTestSplitPercent();
                    splitData.setTestPercent(d.doubleValue());
                    String string2 = classificationModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
                    splitData.setDataFormat(string2);
                    break;
                }
                default: {
                    testDataSource.setTestData(new TestDataSource.TestData());
                }
            }
        }
        testDataSource = extensibleBuildNodeType.getTestSettings();
        if (classificationModelBuildPreferencesPanelSettings.isTOPN()) {
            string = new ClassificationTestSettingsType.TopNTargets();
            string.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            testDataSource.setTopNTargets((ClassificationTestSettingsType.TopNTargets)string);
        } else {
            string = new ClassificationTestSettingsType.BottomNTargets();
            string.setValue(BigInteger.valueOf(classificationModelBuildPreferencesPanelSettings.getNTarget()));
            testDataSource.setBottomNTargets((ClassificationTestSettingsType.BottomNTargets)string);
        }
        string = extensibleBuildNodeType.getResults();
        string.setGenAccuracyMetrics(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        string.setGenConfusionMatrix(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isConfusionMatrix()));
        string.setGenROC(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isROC()));
        string.setGenLift(Boolean.valueOf(classificationModelBuildPreferencesPanelSettings.isLift()));
    }

    private void loadRegressionPreferences() {
        TestDataSource testDataSource;
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)this.preferences);
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)this.getData();
        if (StringUtils.isNotEmpty((String)regressionModelBuildPreferencesPanelSettings.getTestDataOption())) {
            testDataSource = extensibleBuildNodeType.getTestDataSource();
            switch (regressionModelBuildPreferencesPanelSettings.getTestDataOption()) {
                case "TEST_DATA_OPTION_ALL": {
                    testDataSource.setBuildData(new TestDataSource.BuildData());
                    break;
                }
                case "TEST_DATA_OPTION_SPLIT": {
                    TestDataSource.SplitData splitData = testDataSource.getSplitData();
                    Double d = regressionModelBuildPreferencesPanelSettings.getTestSplitPercent();
                    splitData.setTestPercent(d.doubleValue());
                    String string = regressionModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
                    splitData.setDataFormat(string);
                    break;
                }
                default: {
                    testDataSource.setTestData(new TestDataSource.TestData());
                }
            }
        }
        testDataSource = extensibleBuildNodeType.getResults();
        testDataSource.setGenAccuracyMetrics(Boolean.valueOf(regressionModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        testDataSource.setGenResiduals(Boolean.valueOf(regressionModelBuildPreferencesPanelSettings.isResiduals()));
    }

    private static void loadRegressionPreferences(ExtensibleBuildNodeType extensibleBuildNodeType) {
        TestDataSource testDataSource;
        Preferences preferences = Preferences.getPreferences();
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
        if (StringUtils.isNotEmpty((String)regressionModelBuildPreferencesPanelSettings.getTestDataOption())) {
            testDataSource = extensibleBuildNodeType.getTestDataSource();
            switch (regressionModelBuildPreferencesPanelSettings.getTestDataOption()) {
                case "TEST_DATA_OPTION_ALL": {
                    testDataSource.setBuildData(new TestDataSource.BuildData());
                    break;
                }
                case "TEST_DATA_OPTION_SPLIT": {
                    TestDataSource.SplitData splitData = testDataSource.getSplitData();
                    Double d = regressionModelBuildPreferencesPanelSettings.getTestSplitPercent();
                    splitData.setTestPercent(d.doubleValue());
                    String string = regressionModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View";
                    splitData.setDataFormat(string);
                    break;
                }
                default: {
                    testDataSource.setTestData(new TestDataSource.TestData());
                }
            }
        }
        testDataSource = extensibleBuildNodeType.getResults();
        testDataSource.setGenAccuracyMetrics(Boolean.valueOf(regressionModelBuildPreferencesPanelSettings.isAccuracyMetrics()));
        testDataSource.setGenResiduals(Boolean.valueOf(regressionModelBuildPreferencesPanelSettings.isResiduals()));
    }

    public boolean isClassification() {
        return MiningFunctionType.CLASSIFICATION.equals((Object)this.getMiningFunctionType());
    }

    public boolean isRegression() {
        return MiningFunctionType.REGRESSION.equals((Object)this.getMiningFunctionType());
    }

    public boolean isClustering() {
        return MiningFunctionType.CLUSTERING.equals((Object)this.getMiningFunctionType());
    }

    public boolean isFeatureExtraction() {
        return MiningFunctionType.FEATURE_EXTRACTION.equals((Object)this.getMiningFunctionType());
    }

    public void setMiningFunctionType(MiningFunctionType miningFunctionType) {
        if (miningFunctionType == null) {
            this.deleteSupervisedMetadata();
        } else {
            switch (miningFunctionType) {
                case CLASSIFICATION: {
                    this.initializeSupervisedMetadata();
                    this.loadClassificationPreferences();
                    this.supervisedLearning = true;
                    break;
                }
                case REGRESSION: {
                    this.initializeSupervisedMetadata();
                    this.loadRegressionPreferences();
                    this.supervisedLearning = true;
                    break;
                }
                case CLUSTERING: 
                case FEATURE_EXTRACTION: {
                    this.deleteSupervisedMetadata();
                    this.supervisedLearning = false;
                    break;
                }
                default: {
                    assert (false) : "Mining Function Not Supported";
                    this.supervisedLearning = false;
                }
            }
        }
        ((ExtensibleBuildNodeType)this.getData()).setMiningFunction(miningFunctionType);
    }

    public static void setMiningFunctionType(ExtensibleBuildNodeType extensibleBuildNodeType, MiningFunctionType miningFunctionType) {
        if (miningFunctionType == null) {
            TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
            if (testDataSource != null) {
                testDataSource.setTestData(null);
                testDataSource.setBuildData(null);
                testDataSource.setSplitData(null);
                extensibleBuildNodeType.setTestDataSource(null);
            }
            extensibleBuildNodeType.setTestSettings(null);
            extensibleBuildNodeType.setResults(null);
        } else {
            switch (miningFunctionType) {
                case CLASSIFICATION: 
                case REGRESSION: {
                    ExtensibleBuildNode.initializeSupervisedMetadata(extensibleBuildNodeType);
                    if (MiningFunctionType.CLASSIFICATION.equals((Object)miningFunctionType)) {
                        ExtensibleBuildNode.loadClassificationPreferences(extensibleBuildNodeType);
                        break;
                    }
                    if (!MiningFunctionType.REGRESSION.equals((Object)miningFunctionType)) break;
                    ExtensibleBuildNode.loadRegressionPreferences(extensibleBuildNodeType);
                    break;
                }
                case CLUSTERING: 
                case FEATURE_EXTRACTION: {
                    TestDataSource testDataSource = extensibleBuildNodeType.getTestDataSource();
                    if (testDataSource != null) {
                        testDataSource.setTestData(null);
                        testDataSource.setBuildData(null);
                        testDataSource.setSplitData(null);
                        extensibleBuildNodeType.setTestDataSource(null);
                    }
                    extensibleBuildNodeType.setTestSettings(null);
                    extensibleBuildNodeType.setResults(null);
                    break;
                }
                default: {
                    assert (false) : "Mining Function Not Supported";
                    break;
                }
            }
        }
        extensibleBuildNodeType.setMiningFunction(miningFunctionType);
    }
}

