/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public class ExplicitFeatureExtractionBuildNode
extends UnsupervisedBuildNode {
    private static final String SETTINGS = "settings";

    public ExplicitFeatureExtractionBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    public ModelType createNewModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "FEATURE_EXTRACTION", string3);
        return modelType;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
        ExplicitFeatureExtractionBuildNodeType.Models models = new ExplicitFeatureExtractionBuildNodeType.Models();
        explicitFeatureExtractionBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_EXPLICIT_SEMANTIC_ANALYS");
        List<String> list = WorkflowUtils.getNewModelNames(context, "FEATURE_EXTRACTION", arrayList);
        ModelType modelType = this.createNewModel(list.get(0), "", (String)arrayList.get(0));
        modelType.setUseForOutput(true);
        ExplicitFeatureExtractionBuildNodeType.Models models2 = explicitFeatureExtractionBuildNodeType.getModels();
        List list2 = models2.getExplicitSemanticAnalysisModel();
        list2.add((ExplicitSemanticAnalysisModelType)modelType);
        explicitFeatureExtractionBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public void setProperty(String string, Object object) {
        ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
        if (string.equals(SETTINGS)) {
            ExplicitFeatureExtractionBuildNodeType.Models models = explicitFeatureExtractionBuildNodeType.getModels();
            List list = models.getExplicitSemanticAnalysisModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (ExplicitSemanticAnalysisModelType explicitSemanticAnalysisModelType : list) {
                if (!explicitSemanticAnalysisModelType.getId().equals(string2)) continue;
                for (Property property : list2) {
                    ExplicitSemanticAnalysisAlgoType explicitSemanticAnalysisAlgoType = explicitSemanticAnalysisModelType.getExplicitSemanticAnalysisAlgo();
                    if (explicitSemanticAnalysisAlgoType == null) continue;
                    if (property.getDescription().equals("ESAS_TOPN_FEATURES")) {
                        explicitSemanticAnalysisAlgoType.setESASTOPNFEATURES((BigInteger)property.getValue());
                    }
                    if (property.getDescription().equals("ESAS_MIN_ITEMS")) {
                        explicitSemanticAnalysisAlgoType.setESASMINITEMS((BigInteger)property.getValue());
                    }
                    if (!property.getDescription().equals("ESAS_VALUE_THRESHOLD")) continue;
                    explicitSemanticAnalysisAlgoType.setESASTOPNFEATURES((BigInteger)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)explicitFeatureExtractionBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)explicitFeatureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)explicitFeatureExtractionBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)explicitFeatureExtractionBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType2 = (ExplicitFeatureExtractionBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)explicitFeatureExtractionBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType3 = (ExplicitFeatureExtractionBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)explicitFeatureExtractionBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals("modelsRerun")) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)explicitFeatureExtractionBuildNodeType, string);
                hashMap.put(string, modelType.getStatus());
            }
            return hashMap;
        }
        if (complexProperty.getPropertyName().equals("modelUseForOutput")) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)explicitFeatureExtractionBuildNodeType, string);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_EFE_BUILD_NODE_NAME");
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.FEATURE_EXTRACTION;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
        ExplicitFeatureExtractionBuildNodeType.Models models = explicitFeatureExtractionBuildNodeType.getModels();
        if (models.getExplicitSemanticAnalysisModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType2;
            CaseAttributes caseAttributes;
            if (bl2) {
                this.setNodeReady();
            }
            if (!this.validateModels(models.getExplicitSemanticAnalysisModel())) {
                bl3 = false;
            }
            if ((caseAttributes = (explicitFeatureExtractionBuildNodeType2 = (ExplicitFeatureExtractionBuildNodeType)this.getData()).getCaseAttributes()).getAttribute().isEmpty()) {
                bl3 = false;
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_EXPLICIT_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    public String getHelpTopic() {
        return "esa_node";
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_EXPLICIT_FEATURE_EXTRACTION_ICON"));
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof ExplicitSemanticAnalysisModelType) {
            ExplicitSemanticAnalysisModelType explicitSemanticAnalysisModelType = (ExplicitSemanticAnalysisModelType)modelType;
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ESAS_TOPN_FEATURES||''', ''" + explicitSemanticAnalysisModelType.getExplicitSemanticAnalysisAlgo().getESASTOPNFEATURES() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ESAS_MIN_ITEMS||''', ''" + explicitSemanticAnalysisModelType.getExplicitSemanticAnalysisAlgo().getESASMINITEMS() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ESAS_VALUE_THRESHOLD||''', ''" + explicitSemanticAnalysisModelType.getExplicitSemanticAnalysisAlgo().getESASVALUETHRESHOLD() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_EXPLICIT_SEMANTIC_ANALYS||''')'); \n");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<? extends ModelType> getModels() {
        ArrayList arrayList = new ArrayList();
        ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this.getData();
        ExplicitFeatureExtractionBuildNodeType.Models models = explicitFeatureExtractionBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getExplicitSemanticAnalysisModel());
        }
        return arrayList;
    }
}

