/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.ar.filter.ModelARAddFilterSettingsBean;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UnsupervisedBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.AssociationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.ASSOAGGREGATES;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.AprioriModelType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RuleItemsType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public final class AssociationBuildNode
extends UnsupervisedBuildNode {
    public static final String SETTINGS = "settings";
    public static final String ITEM_ID = "ITEM_ID";
    public static final String ITEM_VALUE = "ITEM_VALUE";
    private static final String CASE_ID_ATTRIBUTES = "CASE_ID_ATTRIBUTES";
    private static final String ITEM_ID_INVALID = "ITEM_ID_INVALID";
    private static final String ITEM_VALUE_INVALID = "ITEM_VALUE_INVALID";
    private static Preferences _p = Preferences.getPreferences();
    private AssociationModelBuildPreferencesPanelSettings AssocBuildPref = AssociationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)_p);

    public AssociationBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AssociationBuildNodeType.Models models = new AssociationBuildNodeType.Models();
        associationBuildNodeType.setModels(models);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALGO_APRIORI_ASSOCIATION_RULES");
        List<String> list = WorkflowUtils.getNewModelNames(context, "ASSOCIATION", arrayList);
        int n = 0;
        ModelType modelType = null;
        modelType = this.createNewAprioriModel(list.get(n), "", (String)arrayList.get(n));
        modelType.setUseForOutput(true);
        this.addModel((AprioriModelType)modelType);
        associationBuildNodeType.setMaxDistinctItemValue(BigInteger.valueOf(this.AssocBuildPref.getMaxDistinctItemValue()));
        associationBuildNodeType.setASSOPREPROCESSEDTABLENAME("NONE");
        associationBuildNodeType.setASSOGENERATEPREPROCESSEDTABLE(Boolean.valueOf(false));
        associationBuildNodeType.setASSOAGGREGATES(ServerConstants.AssocSettings.DEFAULTS.ASSO_AGGREGATES);
        associationBuildNodeType.setStatus(NodeStatusType.INVALID);
    }

    public void addModel(AprioriModelType aprioriModelType) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
        List list = models.getAprioriModel();
        list.add(aprioriModelType);
    }

    public ModelType createNewAprioriModel(String string, String string2, String string3) {
        ModelType modelType = super.createNewModel(string, string2, "ASSOCIATION", string3);
        modelType.getInputMiningData().setDataUsage(InputMiningDataType.MANUAL);
        modelType.getInputMiningData().setMiningUsage(InputMiningDataType.MANUAL);
        return modelType;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_ASSOC_BUILD_NODE_NAME");
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    protected boolean validateCaseAttributes(List<AttributeType> list) {
        AttributeType attributeType;
        boolean bl = true;
        boolean bl2 = true;
        CaseAttributes caseAttributes = ((BuildNodeType)this.getData()).getCaseAttributes();
        List list2 = caseAttributes.getAttribute();
        if (list2.size() == 0) {
            this.addMessage("BUILD_NO_TRANSACTION_ID", MessageEnumType.WARNING, new String[0]);
            return false;
        }
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list2.size());
        ArrayList<AttributeType> arrayList2 = new ArrayList<AttributeType>(list2.size());
        for (AttributeType object : list2) {
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            arrayList.add(attributeType);
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(object);
            arrayList2.add(attributeType2);
            if (!attributeType2.getStatus().equals((Object)AttributeStatus.INVALID)) continue;
            bl = false;
        }
        for (AttributeType attributeType3 : arrayList) {
            attributeType = null;
            if (list != null) {
                attributeType = this.findCompatibleAttribute(attributeType3, list);
            }
            if (null == attributeType) {
                attributeType3.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_CASEIDS", MessageEnumType.INCOMPLETE, new String[0]);
                bl2 = false;
                continue;
            }
            attributeType3.setStatus(AttributeStatus.VALID);
        }
        if (bl2 != bl) {
            ComplexProperty complexProperty = new ComplexProperty(CASE_ID_ATTRIBUTES, arrayList);
            complexProperty.setOldData(arrayList2);
            complexProperty.setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
        return bl2;
    }

    protected boolean validateItemId(List<AttributeType> list) {
        Object object;
        AttributeStatus attributeStatus;
        boolean bl = true;
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AttributeType attributeType = associationBuildNodeType.getItemID();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            object = null;
            if (list != null) {
                object = this.findCompatibleAttribute(attributeType, list);
            }
            if (null == object) {
                attributeType.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_ITEM_ID", MessageEnumType.WARNING, new String[0]);
                bl = false;
            } else {
                attributeType.setStatus(AttributeStatus.VALID);
            }
        } else {
            this.addMessage("BUILD_NO_ITEM_ID", MessageEnumType.INCOMPLETE, new String[0]);
            bl = false;
        }
        if (attributeType != null && !attributeType.getStatus().equals((Object)attributeStatus)) {
            object = new ComplexProperty(ITEM_ID_INVALID, attributeType.getStatus());
            ((ComplexProperty)object).setOldData(attributeStatus);
            ((ComplexProperty)object).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    protected boolean validateItemValue(List<AttributeType> list) {
        Object object;
        AttributeStatus attributeStatus;
        boolean bl = true;
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AttributeType attributeType = associationBuildNodeType.getItemValue();
        AttributeStatus attributeStatus2 = attributeStatus = attributeType == null ? null : attributeType.getStatus();
        if (attributeType != null) {
            object = null;
            if (list != null) {
                object = this.findCompatibleAttribute(attributeType, list);
            }
            if (null == object) {
                attributeType.setStatus(AttributeStatus.INVALID);
                this.addMessage("BUILD_INVALID_ITEM_VALUE", MessageEnumType.WARNING, new String[0]);
                bl = false;
            } else {
                attributeType.setStatus(AttributeStatus.VALID);
            }
        }
        if (attributeType != null && !attributeType.getStatus().equals((Object)attributeStatus)) {
            object = new ComplexProperty(ITEM_VALUE_INVALID, attributeType.getStatus());
            ((ComplexProperty)object).setOldData(attributeStatus);
            ((ComplexProperty)object).setForceUpdate(true);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), (ComplexProperty)object);
        }
        return bl;
    }

    @Override
    protected boolean validateImpl(boolean bl, boolean bl2) {
        boolean bl3 = super.validate(bl);
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (associationBuildNodeType.getModels().getAprioriModel().isEmpty()) {
            this.addMessage("BUILD_MISSING_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
            bl3 = false;
        } else {
            Attributes attributes;
            if (bl2) {
                this.setNodeReady();
            }
            List list = null;
            if (abstractDataNode != null) {
                attributes = ((DataProvider)abstractDataNode).getAttributes();
                list = attributes.getAttribute();
            }
            if (!this.validateItemId(list)) {
                bl3 = false;
            }
            if (!this.validateItemValue(list)) {
                bl3 = false;
            }
            if (list != null) {
                attributes = associationBuildNodeType.getModels();
                for (ModelType modelType : attributes.getAprioriModel()) {
                    MiningAttributes miningAttributes = modelType.getInputMiningData().getMiningAttributes();
                    if (miningAttributes == null) continue;
                    MiningAttributes miningAttributes2 = associationBuildNodeType.getMiningAttributes();
                    miningAttributes.getMiningAttribute().clear();
                    miningAttributes.getMiningAttribute().addAll(miningAttributes2.getMiningAttribute());
                }
            }
        }
        this.setState(bl3);
        if (bl) {
            this.validateChildren();
        }
        return bl3;
    }

    @Override
    public boolean validate(boolean bl) {
        return this.validateImpl(bl, true);
    }

    @Override
    public void setProperty(String string, Object object) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (string.equals(ITEM_ID)) {
            associationBuildNodeType.setItemID((AttributeType)object);
        } else if (string.equals(ITEM_VALUE)) {
            associationBuildNodeType.setItemValue((AttributeType)object);
        } else if (string.equals("ASSO_GENERATE_PREPROCESSED_TABLE")) {
            associationBuildNodeType.setASSOGENERATEPREPROCESSEDTABLE((Boolean)object);
        } else if (string.equals("ASSO_PREPROCESSED_TABLE_NAME")) {
            associationBuildNodeType.setASSOPREPROCESSEDTABLENAME((String)object);
        }
        if (string.equals(SETTINGS)) {
            AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
            List list = models.getAprioriModel();
            if (object == null || !(object instanceof List)) {
                return;
            }
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return;
            }
            String string2 = ((Property)list2.get(0)).getId();
            for (AprioriModelType aprioriModelType : list) {
                if (!aprioriModelType.getId().equals(string2)) continue;
                for (Property property : list2) {
                    AprioriAlgoType aprioriAlgoType = aprioriModelType.getAprioriAlgo();
                    if (aprioriAlgoType == null) continue;
                    if (property.getDescription().equals("ASSO_MAX_RULE_LENGTH")) {
                        aprioriAlgoType.setASSOMAXRULELENGTH(((Integer)property.getValue()).intValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_MIN_CONFIDENCE")) {
                        aprioriAlgoType.setASSOMINCONFIDENCE(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_MIN_SUPPORT")) {
                        aprioriAlgoType.setASSOMINSUPPORT(((Double)property.getValue()).doubleValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_MIN_SUPPORT_COUNT")) {
                        aprioriAlgoType.setASSOMINSUPPORTINT((BigInteger)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_MIN_REVERSE_CONF")) {
                        aprioriAlgoType.setASSOMINREVCONFIDENCE((Double)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_ANT_IN_RULES")) {
                        aprioriAlgoType.setASSOANTINRULES((RuleItemsType)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_ANT_EX_RULES")) {
                        aprioriAlgoType.setASSOANTEXRULES((RuleItemsType)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_CONS_IN_RULES")) {
                        aprioriAlgoType.setASSOCONSINRULES((RuleItemsType)property.getValue());
                        continue;
                    }
                    if (property.getDescription().equals("ASSO_CONS_EX_RULES")) {
                        aprioriAlgoType.setASSOCONSEXRULES((RuleItemsType)property.getValue());
                        continue;
                    }
                    if (!property.getDescription().equals("ASSO_FILTERS_ACTIVE")) continue;
                    aprioriAlgoType.setASSOFILTERSACTIVE((Boolean)property.getValue());
                }
                break;
            }
        } else if (string.equals("modelAdded")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list3 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)associationBuildNodeType, modelType);
                if (list3.contains(modelType)) continue;
                MetaDataHelper.addModel((BuildNodeType)associationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelRemoved")) {
            if (!(object instanceof List)) {
                return;
            }
            List list = (List)object;
            for (ModelType modelType : list) {
                List<ModelType> list4 = MetaDataHelper.getModelsCollectionForType((BuildNodeType)associationBuildNodeType, modelType);
                if (!list4.contains(modelType)) continue;
                MetaDataHelper.removeModel((BuildNodeType)associationBuildNodeType, modelType);
            }
            this.setNavigatorRefreshPending();
        } else if (string.equals("modelsRerun")) {
            if (!(object instanceof Map)) {
                return;
            }
            Map map = (Map)object;
            AssociationBuildNodeType associationBuildNodeType2 = (AssociationBuildNodeType)this.getData();
            for (Map.Entry entry : map.entrySet()) {
                String string3 = (String)entry.getKey();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType2, string3);
                modelType.setStatus((ModelStatusType)entry.getValue());
            }
        } else if (string.equals("modelUseForOutput")) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            AssociationBuildNodeType associationBuildNodeType3 = (AssociationBuildNodeType)this.getData();
            for (Pair pair : list) {
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType3, (String)pair.getFirst());
                modelType.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
            }
        } else if (string.equals(CASE_ID_ATTRIBUTES)) {
            List list = (List)object;
            CaseAttributes caseAttributes = associationBuildNodeType.getCaseAttributes();
            List list5 = caseAttributes.getAttribute();
            list5.clear();
            list5.addAll(list);
        } else if (string.equals(ITEM_ID_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemID();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else if (string.equals(ITEM_VALUE_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemValue();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else if (string.equals("ASSO_FILTERS_ACTIVE") || string.equals("ASSO_ANT_IN_RULES") || string.equals("ASSO_ANT_EX_RULES") || string.equals("ASSO_CONS_IN_RULES") || string.equals("ASSO_CONS_EX_RULES")) {
            AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
            List list = models.getAprioriModel();
            if (object == null) {
                return;
            }
            for (AprioriModelType aprioriModelType : list) {
                AprioriAlgoType aprioriAlgoType = aprioriModelType.getAprioriAlgo();
                if (aprioriAlgoType == null) continue;
                if (string.equals("ASSO_FILTERS_ACTIVE")) {
                    aprioriAlgoType.setASSOFILTERSACTIVE((Boolean)object);
                    continue;
                }
                if (string.equals("ASSO_ANT_IN_RULES")) {
                    aprioriAlgoType.setASSOANTINRULES((RuleItemsType)object);
                    continue;
                }
                if (string.equals("ASSO_ANT_EX_RULES")) {
                    aprioriAlgoType.setASSOANTEXRULES((RuleItemsType)object);
                    continue;
                }
                if (string.equals("ASSO_CONS_IN_RULES")) {
                    aprioriAlgoType.setASSOCONSINRULES((RuleItemsType)object);
                    continue;
                }
                if (!string.equals("ASSO_CONS_EX_RULES")) continue;
                aprioriAlgoType.setASSOCONSEXRULES((RuleItemsType)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        String string = complexProperty.getPropertyName();
        if (CASE_ID_ATTRIBUTES.equals(string) || ITEM_ID_INVALID.equals(string) || ITEM_VALUE_INVALID.equals(string) || "ASSO_GENERATE_PREPROCESSED_TABLE".equals(string) || "ASSO_PREPROCESSED_TABLE_NAME".equals(string) || "ASSO_FILTERS_ACTIVE".equals(string) || "ASSO_ANT_IN_RULES".equals(string) || "ASSO_ANT_EX_RULES".equals(string) || "ASSO_CONS_IN_RULES".equals(string) || "ASSO_CONS_EX_RULES".equals(string)) {
            return complexProperty.getOldData();
        }
        if (SETTINGS.equals(string)) {
            List list = (List)complexProperty.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Property property : list) {
                String string2 = property.getId();
                String string3 = property.getDescription();
                Object object = this.getOldPropertyValue(string2, string3);
                Property property2 = new Property(string2, null, object, string3, null);
                arrayList.add(property2);
            }
            return arrayList;
        }
        if ("modelsRerun".equals(string)) {
            Map map = (Map)complexProperty.getData();
            HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>(map.size());
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string4);
                hashMap.put(string4, modelType.getStatus());
            }
            return hashMap;
        }
        if ("modelUseForOutput".equals(string)) {
            List list = (List)complexProperty.getData();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Pair pair : list) {
                String string5 = (String)pair.getFirst();
                AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
                ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string5);
                boolean bl = modelType.isUseForOutput();
                Pair pair2 = new Pair((Object)string5, (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return super.getProperty(complexProperty);
    }

    private Object getOldPropertyValue(String string, String string2) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        ModelType modelType = MetaDataHelper.findModelById((BuildNodeType)associationBuildNodeType, string);
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof AprioriModelType) {
            if (string2.equals("ASSO_PREPROCESSED_TABLE_NAME")) {
                return associationBuildNodeType.getASSOPREPROCESSEDTABLENAME();
            }
            if (string2.equals("ASSO_GENERATE_PREPROCESSED_TABLE")) {
                return associationBuildNodeType.isASSOGENERATEPREPROCESSEDTABLE();
            }
            AprioriAlgoType aprioriAlgoType = ((AprioriModelType)modelType).getAprioriAlgo();
            if (string2.equals("ASSO_MAX_RULE_LENGTH")) {
                return aprioriAlgoType.getASSOMAXRULELENGTH();
            }
            if (string2.equals("ASSO_MIN_CONFIDENCE")) {
                return aprioriAlgoType.getASSOMINCONFIDENCE();
            }
            if (string2.equals("ASSO_MIN_SUPPORT")) {
                return aprioriAlgoType.getASSOMINSUPPORT();
            }
            if (string2.equals("ASSO_MIN_SUPPORT_COUNT")) {
                return aprioriAlgoType.getASSOMINSUPPORTINT();
            }
            if (string2.equals("ASSO_MIN_REVERSE_CONF")) {
                return aprioriAlgoType.getASSOMINREVCONFIDENCE();
            }
            if (string2.equals("ASSO_ANT_IN_RULES")) {
                return aprioriAlgoType.getASSOANTINRULES();
            }
            if (string2.equals("ASSO_ANT_EX_RULES")) {
                return aprioriAlgoType.getASSOANTEXRULES();
            }
            if (string2.equals("ASSO_CONS_IN_RULES")) {
                return aprioriAlgoType.getASSOCONSINRULES();
            }
            if (string2.equals("ASSO_CONS_EX_RULES")) {
                return aprioriAlgoType.getASSOCONSEXRULES();
            }
            if (string2.equals("ASSO_FILTERS_ACTIVE")) {
                return aprioriAlgoType.isASSOFILTERSACTIVE();
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String string) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        if (string.equals(ITEM_ID)) {
            return associationBuildNodeType.getItemID();
        }
        if (string.equals(ITEM_VALUE)) {
            return associationBuildNodeType.getItemValue();
        }
        if (string.equals(ITEM_ID_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemID();
            return attributeType == null ? null : attributeType.getStatus();
        }
        if (string.equals(ITEM_VALUE_INVALID)) {
            AttributeType attributeType = associationBuildNodeType.getItemValue();
            return attributeType == null ? null : attributeType.getStatus();
        }
        return super.getProperty(string);
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        return MiningFunctionType.ASSOCIATION;
    }

    @Override
    public MiningFunctionType getMiningFunctionType() {
        return MiningFunctionType.ASSOCIATION;
    }

    @Override
    public String getHelpTopic() {
        return "association_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_ASSOCIATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_ASSOCIATION_ICON"));
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        if (!map.isEmpty()) {
            AttributeType attributeType;
            CaseAttributes caseAttributes;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(associationBuildNodeType.getItemID());
            AttributeType attributeType3 = map.get(attributeType2.getName());
            if (attributeType3 != null) {
                attributeType2.setName(attributeType3.getName());
                attributeType2.setDataType(attributeType3.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ITEM_ID, attributeType2);
            }
            if (associationBuildNodeType.getItemValue() != null && (caseAttributes = map.get((attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(associationBuildNodeType.getItemValue())).getName())) != null) {
                attributeType.setName(caseAttributes.getName());
                attributeType.setDataType(caseAttributes.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), ITEM_VALUE, attributeType);
            }
            boolean bl = false;
            caseAttributes = MetaDataHelper.copyCaseAttributes(associationBuildNodeType.getCaseAttributes());
            List list = caseAttributes.getAttribute();
            for (AttributeType attributeType4 : list) {
                AttributeType attributeType5 = map.get(attributeType4.getName());
                if (attributeType5 == null) continue;
                bl = true;
                attributeType4.setName(attributeType5.getName());
                attributeType4.setDataType(attributeType5.getDataType());
            }
            if (bl) {
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "caseAttributes", caseAttributes);
            }
        }
    }

    @Override
    protected String getDataUsageAttributesCode(List<MiningAttributeType> list, Version version) {
        ASSOAGGREGATES aSSOAGGREGATES;
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        StringBuilder stringBuilder = new StringBuilder();
        AttributeType attributeType = associationBuildNodeType.getItemID();
        if (DbVersionHelper.isDB11203Up((Version)version)) {
            stringBuilder.append("        ");
            stringBuilder.append(StringUtils.addDoubleQuotes(attributeType.getName()));
        } else {
            stringBuilder.append("        TO_CHAR(");
            stringBuilder.append(StringUtils.addDoubleQuotes(attributeType.getName()));
            stringBuilder.append(") ");
            stringBuilder.append(StringUtils.addDoubleQuotes(attributeType.getName()));
        }
        AttributeType attributeType2 = associationBuildNodeType.getItemValue();
        if (attributeType2 != null) {
            stringBuilder.append(",\n");
            stringBuilder.append("        ");
            stringBuilder.append(StringUtils.addDoubleQuotes(attributeType2.getName()));
        }
        if (associationBuildNodeType.getPartitionExpressions() != null) {
            aSSOAGGREGATES = associationBuildNodeType.getPartitionExpressions().getPartitionExpression().iterator();
            while (aSSOAGGREGATES.hasNext()) {
                PartitionExpressionType partitionExpressionType = (PartitionExpressionType)aSSOAGGREGATES.next();
                stringBuilder.append(",\n");
                stringBuilder.append("        ");
                stringBuilder.append(StringUtils.addDoubleQuotes(partitionExpressionType.getPartitionAttribute().getName()));
            }
        }
        if (DbVersionHelper.isDB122Up((Version)version) && (aSSOAGGREGATES = associationBuildNodeType.getASSOAGGREGATES()) != null && aSSOAGGREGATES.getAttribute() != null && !aSSOAGGREGATES.getAttribute().isEmpty()) {
            for (int i = 0; i < aSSOAGGREGATES.getAttribute().size(); ++i) {
                stringBuilder.append(",\n");
                stringBuilder.append("        ");
                stringBuilder.append(StringUtils.addDoubleQuotes(((AttributeType)aSSOAGGREGATES.getAttribute().get(i)).getName()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String generateAttributeTransformationsCode(ModelType modelType, AttributeType attributeType, Version version) {
        return "";
    }

    @Override
    protected String generateSpecificModelSettingsCode(ModelType modelType, Version version) {
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        StringBuilder stringBuilder = new StringBuilder();
        if (modelType instanceof AprioriModelType) {
            Object object;
            AttributeType attributeType;
            AprioriModelType aprioriModelType = (AprioriModelType)modelType;
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MAX_RULE_LENGTH||''', ''" + aprioriModelType.getAprioriAlgo().getASSOMAXRULELENGTH() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_CONFIDENCE||''', ''" + aprioriModelType.getAprioriAlgo().getASSOMINCONFIDENCE() + "'')'); \n");
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_SUPPORT||''', ''" + aprioriModelType.getAprioriAlgo().getASSOMINSUPPORT() + "'')'); \n");
            if (DbVersionHelper.isDB122Up((Version)version)) {
                RuleItemsType.RuleItems ruleItems;
                List list;
                Object object2;
                Object object3;
                Object object4;
                RuleItemsType.RuleItems ruleItems2;
                Object object5;
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_SUPPORT_INT||''', ''" + aprioriModelType.getAprioriAlgo().getASSOMINSUPPORTINT() + "'')'); \n");
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_MIN_REV_CONFIDENCE||''', ''" + aprioriModelType.getAprioriAlgo().getASSOMINREVCONFIDENCE() + "'')'); \n");
                attributeType = associationBuildNodeType.getASSOAGGREGATES();
                if (attributeType != null && attributeType.getAttribute() != null && !attributeType.getAttribute().isEmpty()) {
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ASSO_AGGREGATES||''',''");
                    for (int i = 0; i < attributeType.getAttribute().size(); ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        object5 = ((AttributeType)attributeType.getAttribute().get(i)).getName();
                        if (((AttributeType)attributeType.getAttribute().get(i)).getAlias() != null) {
                            object5 = ((AttributeType)attributeType.getAttribute().get(i)).getAlias();
                        }
                        if (((String)object5).contains("'") || ((String)object5).contains(" ")) {
                            stringBuilder.append("\"");
                            if (((String)object5).contains("'")) {
                                object5 = StringUtils.escapeSingleQuotesForSQL((String)object5);
                            }
                            stringBuilder.append((String)object5);
                            stringBuilder.append("\"");
                            continue;
                        }
                        stringBuilder.append((String)object5);
                    }
                    stringBuilder.append("'')'); \n");
                }
                object = null;
                object5 = aprioriModelType.getAprioriAlgo().getASSOANTINRULES();
                if (object5 != null && (ruleItems2 = object5.getRuleItems()) != null && (object = ruleItems2.getItem()) != null && object.size() > 0) {
                    object4 = new StringBuilder();
                    for (int i = 0; i < object.size(); ++i) {
                        if (i > 0) {
                            ((StringBuilder)object4).append("'''',''''");
                        }
                        if (StringUtils.isSingleQuotedString((String)(object3 = (String)object.get(i)))) {
                            object3 = ((String)object3).substring(1, ((String)object3).length() - 1);
                        }
                        ((StringBuilder)object4).append((String)object3);
                    }
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ");
                    stringBuilder.append("('''||DBMS_DATA_MINING.ASSO_ANT_IN_RULES ||''', ''''''");
                    stringBuilder.append(((StringBuilder)object4).toString() + "'''''')'); \n");
                }
                if ((ruleItems2 = aprioriModelType.getAprioriAlgo().getASSOANTEXRULES()) != null && (object3 = ruleItems2.getRuleItems()) != null && (object4 = object3.getItem()) != null && object4.size() > 0) {
                    object2 = new StringBuffer();
                    for (int i = 0; i < object4.size(); ++i) {
                        String string;
                        if (i > 0) {
                            ((StringBuffer)object2).append("'''',''''");
                        }
                        if (StringUtils.isSingleQuotedString(string = (String)object4.get(i))) {
                            string = string.substring(1, string.length() - 1);
                        }
                        ((StringBuffer)object2).append(string);
                    }
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ");
                    stringBuilder.append("('''||DBMS_DATA_MINING.ASSO_ANT_EX_RULES ||''', ''''''");
                    stringBuilder.append(((StringBuffer)object2).toString() + "'''''')'); \n");
                }
                if ((object3 = aprioriModelType.getAprioriAlgo().getASSOCONSINRULES()) != null && (object4 = object3.getRuleItems()) != null && (list = object4.getItem()) != null && list.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            stringBuffer.append("'''',''''");
                        }
                        if (StringUtils.isSingleQuotedString((String)(object2 = (String)list.get(i)))) {
                            object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                        }
                        stringBuffer.append((String)object2);
                    }
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ");
                    stringBuilder.append("('''||DBMS_DATA_MINING.ASSO_CONS_IN_RULES ||''', ''''''");
                    stringBuilder.append(stringBuffer.toString() + "'''''')'); \n");
                }
                if ((object4 = aprioriModelType.getAprioriAlgo().getASSOCONSEXRULES()) != null && (ruleItems = object4.getRuleItems()) != null && (object2 = ruleItems.getItem()) != null && object2.size() > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < object2.size(); ++i) {
                        String string;
                        if (i > 0) {
                            stringBuffer.append("'''',''''");
                        }
                        if (StringUtils.isSingleQuotedString(string = (String)object2.get(i))) {
                            string = string.substring(1, string.length() - 1);
                        }
                        stringBuffer.append(string);
                    }
                    stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ");
                    stringBuilder.append("('''||DBMS_DATA_MINING.ASSO_CONS_EX_RULES ||''', ''''''");
                    stringBuilder.append(stringBuffer.toString() + "'''''')'); \n");
                }
            }
            attributeType = associationBuildNodeType.getItemID();
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ITEM_ID_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(attributeType.getName())) + "'')'); \n");
            object = associationBuildNodeType.getItemValue();
            if (object != null) {
                stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ODMS_ITEM_VALUE_COLUMN_NAME||''', ''" + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(object.getName())) + "'')'); \n");
            }
            stringBuilder.append("  execSQL('INSERT INTO '||v_build_setting||' VALUES ('''||DBMS_DATA_MINING.ALGO_NAME||''', '''||DBMS_DATA_MINING.ALGO_APRIORI_ASSOCIATION_RULES||''')'); \n");
        }
        return stringBuilder.toString();
    }

    @Override
    protected boolean isDataAutoPreparationOn(List<MiningAttributeType> list) {
        return false;
    }

    public List<ModelType> getModels() {
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this.getData();
        AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
        if (models != null) {
            arrayList.addAll(models.getAprioriModel());
        }
        return arrayList;
    }

    public String getStackedSQL(WorkflowModel workflowModel, boolean bl, ModelARAddFilterSettingsBean modelARAddFilterSettingsBean, AbstractDataNode abstractDataNode) {
        String string = bl ? ";" : "";
        String string2 = this.getStackedSQL(workflowModel, modelARAddFilterSettingsBean, abstractDataNode);
        if (string2 != null) {
            return string2 + string;
        }
        return null;
    }

    public String getStackedSQL(WorkflowModel workflowModel, ModelARAddFilterSettingsBean modelARAddFilterSettingsBean, AbstractDataNode abstractDataNode) {
        StringBuilder stringBuilder = new StringBuilder(32000);
        if (workflowModel == null) {
            return null;
        }
        if (abstractDataNode.parentContainsIncompleteModel(workflowModel)) {
            return null;
        }
        if (modelARAddFilterSettingsBean.getFetchSize() > 0) {
            stringBuilder.append("Select * from (");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (modelARAddFilterSettingsBean.isFetchFromActual()) {
            stringBuilder2.append(abstractDataNode.getSQLNodeComment(abstractDataNode, true));
            stringBuilder2.append(abstractDataNode.getSQLExpression());
            stringBuilder2.append(abstractDataNode.getSQLNodeComment(abstractDataNode, false));
            abstractDataNode.getInternalStackedSQL(abstractDataNode, stringBuilder2);
            stringBuilder2.append(",");
        }
        stringBuilder.append("WITH ");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(" \"SampleTable\" as (");
        stringBuilder.append("select * from ");
        if (modelARAddFilterSettingsBean.isFetchFromActual()) {
            stringBuilder.append(abstractDataNode.getNodeNameForSQLExpression(true));
        } else {
            stringBuilder.append("\"");
            stringBuilder.append(modelARAddFilterSettingsBean.getPreprocessedTableName());
            stringBuilder.append("\"");
        }
        if (modelARAddFilterSettingsBean.getSampleSize() > 0) {
            stringBuilder.append(" where rownum <=");
            stringBuilder.append(modelARAddFilterSettingsBean.getSampleSize());
        }
        stringBuilder.append(")");
        stringBuilder.append(",\"CalcTable\" as ( ");
        stringBuilder.append("select ");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append(", count(*) as colCount ");
        stringBuilder.append("from ");
        if (modelARAddFilterSettingsBean.isFetchFromActual()) {
            stringBuilder.append(abstractDataNode.getNodeNameForSQLExpression(true));
        } else {
            stringBuilder.append("\"");
            stringBuilder.append(modelARAddFilterSettingsBean.getPreprocessedTableName());
            stringBuilder.append("\"");
        }
        stringBuilder.append(" group by ");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append("),");
        stringBuilder.append("\"TotalTable\" as (");
        stringBuilder.append("select count (*) as colTotal ");
        stringBuilder.append("from ");
        if (modelARAddFilterSettingsBean.isFetchFromActual()) {
            stringBuilder.append(abstractDataNode.getNodeNameForSQLExpression(true));
        } else {
            stringBuilder.append("\"");
            stringBuilder.append(modelARAddFilterSettingsBean.getPreprocessedTableName());
            stringBuilder.append("\"");
        }
        stringBuilder.append(") ");
        stringBuilder.append("select distinct n1.");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append(", n2.colCount,");
        stringBuilder.append("round( (n2.colCount/n3.colTotal) * 100, 3) as support");
        stringBuilder.append(" from \"SampleTable\"  n1,\"CalcTable\" n2, \"TotalTable\" n3 ");
        stringBuilder.append("where n1.");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append(" = n2.");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append(" and UPPER(n1.");
        stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
        stringBuilder.append(") like '%");
        stringBuilder.append(modelARAddFilterSettingsBean.getSearchText().toUpperCase());
        stringBuilder.append("%'");
        stringBuilder.append(" order by ");
        switch (modelARAddFilterSettingsBean.getSortByColumn()) {
            case 0: {
                stringBuilder.append("n1.");
                stringBuilder.append(modelARAddFilterSettingsBean.getColumnToSearch());
                break;
            }
            case 1: {
                stringBuilder.append(" n2.colCount");
                break;
            }
            case 2: {
                stringBuilder.append(" (round( (n2.colCount/n3.colTotal) * 100, 3) )");
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        stringBuilder.append(" ");
        stringBuilder.append(modelARAddFilterSettingsBean.getOrder().getSqlKeyword());
        if (modelARAddFilterSettingsBean.getFetchSize() > 0) {
            stringBuilder.append(") where rownum <= " + modelARAddFilterSettingsBean.getFetchSize());
        }
        return StringUtils.removeBlankLines(stringBuilder.toString());
    }
}

