/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.profile;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.status.Issue;

public class OuputProfileColumnsPanel
extends PIComponentPanel {
    private static final int MAX_LENGTH = 32;
    private static final int MAX_LENGTH_EX = 130;
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    private List<AttributeType> _profiledAttributes = new ArrayList<AttributeType>();
    private List<AttributeType> _allAttributes = new ArrayList<AttributeType>();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private List<String> _allowedAttributes = new ArrayList<String>();
    private AbstractDataNode _targetNode;
    private JLabel jLabelName;
    private JTextField jTextFieldName;
    private DataMinerTablePanel tablePanel;

    public OuputProfileColumnsPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.tablePanel = new DataMinerTablePanel();
        this.jLabelName.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 448, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelName, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldName, -2, 192, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName, -2, 14, -2).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tablePanel, -1, 254, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jTextFieldName, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_OUTPUT_TABLE_NAME"));
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        DataProfileOutputType dataProfileOutputType;
        Object object3;
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        DataNodeType dataNodeType = (DataNodeType)this._targetNode.getData();
        if (!(dataNodeType instanceof DataProfileNodeType)) {
            return;
        }
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataNodeType;
        String string = dataProfileNodeType.getStatisticTable().getName();
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this.getContext((PropertyModel)this._model));
        this.jTextFieldName.setDocument(new TextFieldLimit(bl ? 130 : 32));
        TableNameInputVerifier tableNameInputVerifier = new TableNameInputVerifier(this.jTextFieldName, this.getContext((PropertyModel)this._model));
        this.jTextFieldName.setInputVerifier(tableNameInputVerifier);
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        CustomTableNameValidator customTableNameValidator = new CustomTableNameValidator(tableNameInputVerifier, this.getContext((PropertyModel)this._model));
        this.jTextFieldName.addFocusListener(customTableNameValidator);
        this.jTextFieldName.addKeyListener(customTableNameValidator);
        List<AttributeType> list = this.getOutputAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            object3 = list.iterator();
            while (object3.hasNext()) {
                dataProfileOutputType = (AttributeType)object3.next();
                this._allAttributesMap.put(dataProfileOutputType.getName(), (AttributeType)dataProfileOutputType);
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileOutputType.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileOutputType.getName());
            }
        }
        if ((object2 = (dataProfileOutputType = (object3 = (DataProfileNodeType)dataNodeType).getDataProfileOutput()).getAttributes()) != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        AttributesTableModel attributesTableModel = new AttributesTableModel(this._profiledAttributes);
        this.setupItemsTable(attributesTableModel);
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        ((AttributesTableModel)((Object)this.tablePanel.getTable().getModel())).setWritable(bl);
        this.jTextFieldName.setEnabled(bl);
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        if (!(propertyModel instanceof WorkflowDataProfileNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof DataProfileNodeType)) {
            return;
        }
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
        this._allAttributes.clear();
        this._allAttributesMap.clear();
        this._allowedAttributes.clear();
        List<AttributeType> list = this.getOutputAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            for (AttributeType dataProfileOutputType2 : list) {
                this._allAttributesMap.put(dataProfileOutputType2.getName(), dataProfileOutputType2);
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileOutputType2.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileOutputType2.getName());
            }
        }
        this._profiledAttributes.clear();
        DataProfileNodeType dataProfileNodeType2 = (DataProfileNodeType)nodeType;
        DataProfileOutputType dataProfileOutputType = dataProfileNodeType2.getDataProfileOutput();
        object2 = dataProfileOutputType.getAttributes();
        if (object2 != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = new AttributesTableModel(this._profiledAttributes);
        this.setupItemsTable((AttributesTableModel)((Object)object));
        String string = dataProfileNodeType.getStatisticTable().getName();
        if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        this.jTextFieldName.setText(string);
        this.validateTableName(string);
        this.setWritableControls();
    }

    private void setupItemsTable(AttributesTableModel attributesTableModel) {
        this.tablePanel.setup((TableModel)((Object)attributesTableModel), PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE"), 0, true);
        this.tablePanel.getTable().setAutoResizeMode(4);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return IconCellRenderer.getIconForAttrStatus(OuputProfileColumnsPanel.this._profiledAttributes, object);
            }
        });
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private void validateTableName(String string) {
        String string2 = null;
        string = StringUtils.trimDoubleQuotes(string);
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this.getContext((PropertyModel)this._model));
        if (bl) {
            if (string.length() > 128) {
                string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_NAME_TOO_LONG_EX_ERROR");
            }
        } else if (string.length() > 30) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_NAME_TOO_LONG_ERROR");
        } else if (!StringUtils.isDoubleQuotedString(string) && !StringUtils.containsNoDot(string)) {
            string2 = TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_TABLE_NAME_ERROR");
        }
        if (string2 != null) {
            List<Issue> list = this.openIssue(string2);
            this.addWarningBorderAndTooltip(this.jTextFieldName, list);
        } else {
            this.restoreBorder(this.jTextFieldName);
        }
    }

    protected List<AttributeType> getOutputAttributes() {
        List list = null;
        Attributes attributes = null;
        DataProfileNode dataProfileNode = (DataProfileNode)this.getNode((PropertyModel)this._model);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        if (dataProfileNodeType != null && null != dataProfileNodeType.getDataProfileOutput()) {
            attributes = dataProfileNodeType.getDataProfileOutput().getAttributes();
        }
        if (attributes != null) {
            list = attributes.getAttribute();
        }
        return list;
    }

    private AbstractDataNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof AbstractDataNode)) {
            return null;
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)node;
        return abstractDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTableName(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        DataProfileNode dataProfileNode = (DataProfileNode)this.getTargetNode((PropertyModel)this._model, DataProfileNodeType.class);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
        String string2 = dataProfileNodeType.getStatisticTable().getName();
        if (string2 != null && string2.trim().length() > 0 && string2.equals(StringUtils.trimDoubleQuotes(string))) {
            return;
        }
        string = StringUtils.trimDoubleQuotes(string);
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ComplexProperty complexProperty = new ComplexProperty("tableName", string);
        CommandProcessor.getInstance().beginTrans(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME_TXN"));
        try {
            this._model.setValueAt(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_TABLE_NAME"), dataProfileNode, complexProperty, DataProfileNodePropertyModel.TABLE_NAME.index);
            workflowNodeInspectorElement.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    class TableNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public TableNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                DataProfileNode dataProfileNode = (DataProfileNode)OuputProfileColumnsPanel.this.getTargetNode((PropertyModel)OuputProfileColumnsPanel.this._model, DataProfileNodeType.class);
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)dataProfileNode.getData();
                this._currentValue = dataProfileNodeType.getStatisticTable().getName();
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_MISSING"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                    bl = false;
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0 && !TableNameValidator.isTableNameUnique(this._context, string)) {
                        String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string);
                        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                            bl = false;
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableNameInputVerifier.this._textField.setText(TableNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    OuputProfileColumnsPanel.this.setTableName(string);
                }
            }
            return bl;
        }
    }

    class CustomTableNameValidator
    extends KeyAdapter
    implements FocusListener {
        Context _context;
        boolean busy = false;
        TableNameInputVerifier _verifier;
        String oldName = "";

        public CustomTableNameValidator(TableNameInputVerifier tableNameInputVerifier, Context context) {
            this._context = context;
            this._verifier = tableNameInputVerifier;
        }

        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(OuputProfileColumnsPanel.this.jTextFieldName);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.oldName = OuputProfileColumnsPanel.this.jTextFieldName.getText();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (StringUtils.checkDataLossWithMsg(this._context, OuputProfileColumnsPanel.this.jTextFieldName.getText(), GraphLrb.get("VALIDATION_ISSUES_TITLE"), true)) {
                OuputProfileColumnsPanel.this.jTextFieldName.setText(this.oldName);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }

    private static class AttributesTableModel
    extends ODMrTableModel<AttributeType> {
        private static final int NAME = 0;
        private static final int DATA_TYPE = 1;
        private static String[] _columnNames = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")};
        private boolean _writable = true;

        private AttributesTableModel(List<AttributeType> list) {
            super(_columnNames, list);
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = (AttributeType)this.srcData.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = attributeType.getName();
                    break;
                }
                case 1: {
                    string = attributeType.getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return string != null ? string : "";
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

