/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.CaseEditRecord;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;

public class EditCaseAttributesDialog
implements DialogDisplayable {
    private CaseEditRecord caseEdits;
    private Context context;
    private AbstractDataNode data;

    public EditCaseAttributesDialog(Context context, AbstractDataNode abstractDataNode, CaseEditRecord caseEditRecord) {
        this.context = context;
        this.data = abstractDataNode;
        this.caseEdits = caseEditRecord;
    }

    private List<AttributeType> getAvailableAttributes(AbstractDataNode abstractDataNode) {
        if (abstractDataNode == null) {
            return new ArrayList<AttributeType>();
        }
        AbstractDataNode abstractDataNode2 = abstractDataNode;
        List list = abstractDataNode2.getAttributes().getAttribute();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            arrayList.add(attributeType2);
        }
        return arrayList;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){
            private SelectCaseAttributesPanel content;

            @Override
            public void onOK() throws DialogExecutionException {
                this.content.doWork();
            }

            @Override
            public String getTitle() {
                return DataDialogsLrb.get("DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "association_node_edit_cols";
            }

            @Override
            public JComponent getContent() {
                this.content = new SelectCaseAttributesPanel(EditCaseAttributesDialog.this.context, EditCaseAttributesDialog.this.data, EditCaseAttributesDialog.this.getAvailableAttributes(EditCaseAttributesDialog.this.data));
                return this.content;
            }
        };
    }

    private class SelectCaseAttributesPanel
    extends DataSourceAttributesPanel {
        private SelectCaseAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
            super(context, abstractNode, list);
        }

        @Override
        protected List<AttributeType> getSelectedAttributes() {
            return EditCaseAttributesDialog.this.caseEdits.getCaseAttributes().getAttribute();
        }

        @Override
        public boolean doWork() {
            boolean bl = true;
            List list = EditCaseAttributesDialog.this.caseEdits.getCaseAttributes().getAttribute();
            list.clear();
            list.addAll(this.selectedAttrsCache);
            return bl;
        }
    }
}

