/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelNoStats;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.MissingValuesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.NormalizationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.OutlierPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericTable;

public class UseExistingColumnPanel
extends JPanel {
    private Context context;
    private TransformationSourceAttribute selSourceColumn;
    private MapTransformedSource selectedTransformedColumn;
    private TransformationStatisticsState state;
    private int datatype = 0;
    private Vector<String> transformedColumns;
    private Map<String, MapTransformedSource> helperMap;
    private boolean wizard;
    private AddEditTransformsPanelNoStats parent;
    private static final String _CURRENT_PANEL = "_CURRENT_PANEL";
    private JComboBox jCmbXformedColumn;
    private JLabel jLblXformedColumn;
    private JPanel jPanelHost;
    private BinningPanel binningPanel;
    private MissingValuesPanel missValuesPanel;
    private OutlierPanel outlierPanel;
    private NormalizationPanel normalizationPanel;

    public UseExistingColumnPanel(Context context, List<TransformationSourceAttribute> list, List<MapTransformedSource> list2, TransformationStatisticsState transformationStatisticsState) {
        this.context = context;
        this.state = transformationStatisticsState;
        this.wizard = true;
        this.context = context;
        HashMap<String, TransformationSourceAttribute> hashMap = new HashMap<String, TransformationSourceAttribute>();
        for (TransformationSourceAttribute transformationSourceAttribute : list) {
            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute);
        }
        this.helperMap = new HashMap<String, MapTransformedSource>(list2.size());
        this.transformedColumns = new Vector(list2.size());
        for (MapTransformedSource mapTransformedSource : list2) {
            if (null != hashMap.get(mapTransformedSource.getKey().getName())) continue;
            this.transformedColumns.add(mapTransformedSource.getKey().getName());
            this.helperMap.put(mapTransformedSource.getKey().getName(), mapTransformedSource);
        }
        this.selectedTransformedColumn = list2.get(0);
        if ("NUMBER".equals(this.selectedTransformedColumn.getKey().getDataType()) || "FLOAT".equals(this.selectedTransformedColumn.getKey().getDataType()) || "BINARY_DOUBLE".equals(this.selectedTransformedColumn.getKey().getDataType()) || "BINARY_FLOAT".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = 1;
        } else if ("VARCHAR2".equals(this.selectedTransformedColumn.getKey().getDataType()) || "CHAR".equals(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = 2;
        } else if ("DATE".equals(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestamp(this.selectedTransformedColumn.getKey().getDataType()) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = 3;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(this.selectedTransformedColumn.getKey().getDataType())) {
            this.datatype = 6;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public UseExistingColumnPanel(Context context, TransformationSourceAttribute transformationSourceAttribute, TransformationStatisticsState transformationStatisticsState, List<MapTransformedSource> list, AddEditTransformsPanelNoStats addEditTransformsPanelNoStats) {
        String string;
        MapTransformedSource mapTransformedSource;
        Object object;
        this.state = transformationStatisticsState;
        this.selSourceColumn = transformationSourceAttribute;
        this.parent = addEditTransformsPanelNoStats;
        this.wizard = false;
        this.helperMap = new HashMap<String, MapTransformedSource>(list.size());
        this.transformedColumns = new Vector(list.size());
        TransformationOutputAttribute transformationOutputAttribute = list.iterator();
        while (transformationOutputAttribute.hasNext()) {
            object = transformationOutputAttribute.next();
            if (transformationSourceAttribute.getName().equals(object.getKey().getName())) continue;
            this.transformedColumns.add(object.getKey().getName());
            this.helperMap.put(object.getKey().getName(), (MapTransformedSource)object);
        }
        this.selectedTransformedColumn = null;
        if (transformationSourceAttribute != null && transformationSourceAttribute instanceof TransformationOutputAttribute) {
            transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
            object = list.iterator();
            while (object.hasNext()) {
                mapTransformedSource = (MapTransformedSource)object.next();
                if (!mapTransformedSource.getKey().getName().equals(transformationOutputAttribute.getName())) continue;
                this.selectedTransformedColumn = mapTransformedSource;
                break;
            }
        }
        if (this.selectedTransformedColumn == null) {
            this.selectedTransformedColumn = list.get(0);
        }
        if ("NUMBER".equals(string = (mapTransformedSource = transformationStatisticsState.findTransformationSourceColumn((String)(object = (String)(transformationOutputAttribute = this.selectedTransformedColumn.getStringCollectionNames()).getValue().get(0)))).getDataType()) || "FLOAT".equals(string) || "BINARY_DOUBLE".equals(string) || "BINARY_FLOAT".equals(string)) {
            this.datatype = 1;
        } else if ("VARCHAR2".equals(string) || "CHAR".equals(string) || "NVARCHAR2".equals(string) || "NCHAR".equals(string)) {
            this.datatype = 2;
        } else if ("DATE".equals(string) || DatabaseMetadataUtils.isTimestamp(string) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string)) {
            this.datatype = 3;
        } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(string)) {
            this.datatype = 6;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblXformedColumn = new JLabel();
        this.jCmbXformedColumn = new DataMinerCombBox();
        this.jPanelHost = new JPanel();
        this.jLblXformedColumn.setText("Transformed Column:");
        this.jCmbXformedColumn.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelHost.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelHost, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblXformedColumn, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmbXformedColumn, -2, 186, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblXformedColumn).addComponent(this.jCmbXformedColumn, -2, 22, -2)).addGap(18, 18, 18).addComponent(this.jPanelHost, -2, 214, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblXformedColumn, (Component)this.jCmbXformedColumn, (String)XformDialogsLrb.get("EXISTING_COLUMN_TRANSFORMED_COLUMN"));
    }

    public void initUI() {
        this.jCmbXformedColumn.setModel(new DefaultComboBoxModel<String>(this.transformedColumns));
        if (this.transformedColumns.size() > 0) {
            this.jCmbXformedColumn.setSelectedIndex(0);
        }
        this.jCmbXformedColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)UseExistingColumnPanel.this.jCmbXformedColumn.getSelectedItem();
                UseExistingColumnPanel.this.selectedTransformedColumn = UseExistingColumnPanel.this.helperMap.get(string);
                UseExistingColumnPanel.this.showPanel();
                if (UseExistingColumnPanel.this.parent != null) {
                    UseExistingColumnPanel.this.parent.updateOutputName(UseExistingColumnPanel.this.selectedTransformedColumn);
                }
            }
        });
        this.showPanel();
    }

    private void showPanel() {
        TransformationType transformationType = this.selectedTransformedColumn.getKey().getTransformationElementType();
        if (TransformationTypes.isBinning(transformationType)) {
            this.binningPanel = !this.wizard ? new BinningPanel(this.context, this.selSourceColumn.getName(), this.selSourceColumn.getDataType(), this.state, TransformationTypes.binningToString(transformationType), TransformationTypes.getBinCount(transformationType), this.datatype, TransformationTypes.getBinGeneration(transformationType), TransformationTypes.getBinLabels(transformationType), TransformationTypes.getCustomBinningSpec(transformationType), TransformationTypes.getTransformNulls(transformationType)) : new BinningPanel(this.context, this.state, TransformationTypes.binningToString(transformationType), TransformationTypes.getBinCount(transformationType), this.datatype, TransformationTypes.getBinGeneration(transformationType), TransformationTypes.getBinLabels(transformationType), TransformationTypes.getTransformNulls(transformationType));
            this.jPanelHost.add(_CURRENT_PANEL, this.binningPanel);
            UseExistingColumnPanel.disableUI(this.binningPanel, false);
        } else if (TransformationTypes.isMissingValuesCategorical(transformationType) || TransformationTypes.isMissingValuesNumeric(transformationType) || TransformationTypes.isMissingValuesDate(transformationType)) {
            this.missValuesPanel = !this.wizard ? new MissingValuesPanel(this.state.getContext(), (TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getMissingValuesDefaultReplacementValue(this.selSourceColumn), null, null) : new MissingValuesPanel(this.state.getContext(), this.selectedTransformedColumn.getKey());
            this.jPanelHost.add(_CURRENT_PANEL, this.missValuesPanel);
            UseExistingColumnPanel.disableUI(this.missValuesPanel, false);
        } else if (TransformationTypes.isOutlier(transformationType)) {
            this.outlierPanel = !this.wizard ? new OutlierPanel((TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getStd(this.selSourceColumn), this.state.getAvg(this.selSourceColumn), null) : new OutlierPanel(this.selectedTransformedColumn.getKey());
            this.jPanelHost.add(_CURRENT_PANEL, this.outlierPanel);
            UseExistingColumnPanel.disableUI(this.outlierPanel, false);
        } else if (TransformationTypes.isNormalization(transformationType)) {
            this.normalizationPanel = !this.wizard ? new NormalizationPanel((TransformationSourceAttribute)this.selectedTransformedColumn.getKey(), this.state.getMin(this.selSourceColumn.getName()), this.state.getMax(this.selSourceColumn.getName()), null) : new NormalizationPanel(this.selectedTransformedColumn.getKey());
            this.jPanelHost.add(_CURRENT_PANEL, this.normalizationPanel);
            UseExistingColumnPanel.disableUI(this.normalizationPanel, false);
        }
        CardLayout cardLayout = (CardLayout)this.jPanelHost.getLayout();
        cardLayout.show(this.jPanelHost, _CURRENT_PANEL);
    }

    public MapTransformedSource getSelectedTransformedColumn() {
        return this.selectedTransformedColumn;
    }

    private static void disableUI(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                if (componentArray[i] instanceof GenericTable) {
                    GenericTable genericTable = (GenericTable)componentArray[i];
                    genericTable.setCellSelectionEnabled(false);
                    genericTable.setColumnHeaderSelectionEnabled(false);
                    genericTable.setSorted(false);
                }
                UseExistingColumnPanel.disableUI((Container)componentArray[i], bl);
            }
            componentArray[i].setEnabled(bl);
        }
    }

    public TransformationType getResultTransformatonType(String string) {
        TransformationOutputAttribute transformationOutputAttribute = this.state.findTransformedColumn(string);
        TransformationType transformationType = transformationOutputAttribute.getTransformationElementType();
        TransformationType.Binning binning = transformationType.getBinning();
        TransformationType.MissingValuesDate missingValuesDate = transformationType.getMissingValuesDate();
        TransformationType.MissingValuesCategorical missingValuesCategorical = transformationType.getMissingValuesCategorical();
        TransformationType.MissingValuesNumeric missingValuesNumeric = transformationType.getMissingValuesNumeric();
        TransformationType.Normalization normalization = transformationType.getNormalization();
        TransformationType.Outlier outlier = transformationType.getOutlier();
        TransformationType transformationType2 = null;
        if (null != binning) {
            TransformationType.Binning.CustomCategorical customCategorical = null;
            TransformNulls transformNulls = null;
            String string2 = null;
            Integer n = null;
            boolean bl = true;
            boolean bl2 = true;
            if (null != binning.getEqualWidth()) {
                n = binning.getEqualWidth().getBinCount().intValue();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_NUMBER();
                transformNulls = binning.getEqualWidth().getTransformNulls();
                bl2 = null != binning.getEqualWidth().getBinLabels();
                bl = null != binning.getEqualWidth().getBinGeneration().getAuto();
            } else if (null != binning.getCustomCategorical()) {
                n = binning.getCustomCategorical().getCategoricalBin().size();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC();
                customCategorical = binning.getCustomCategorical();
                transformNulls = binning.getCustomCategorical().getTransformNulls();
            } else if (null != binning.getCustomDate()) {
                n = binning.getCustomDate().getDateBin().size();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP();
                customCategorical = binning.getCustomDate();
                transformNulls = binning.getCustomDate().getTransformNulls();
            } else if (null != binning.getCustomNumeric()) {
                n = binning.getCustomNumeric().getNumericBin().size();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC();
                customCategorical = binning.getCustomNumeric();
                transformNulls = binning.getCustomNumeric().getTransformNulls();
            } else if (null != binning.getCustomTimestamp()) {
                n = binning.getCustomTimestamp().getTimestampTimezoneBin().size();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE();
                customCategorical = binning.getCustomTimestamp();
                transformNulls = binning.getCustomTimestamp().getTransformNulls();
            } else if (null != binning.getDateEqualWidth()) {
                n = binning.getDateEqualWidth().getBinCount().intValue();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_DATE();
                transformNulls = binning.getDateEqualWidth().getTransformNulls();
                bl2 = null != binning.getDateEqualWidth().getBinLabels();
                bl = null != binning.getDateEqualWidth().getBinGeneration().getAuto();
            } else if (null != binning.getQuantile()) {
                n = binning.getQuantile().getBinCount().intValue();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_QUANTILE();
                transformNulls = binning.getQuantile().getTransformNulls();
                bl2 = null != binning.getQuantile().getBinLabels();
                bl = null != binning.getQuantile().getBinGeneration().getAuto();
            } else if (null != binning.getTimestampEqualWidth()) {
                n = binning.getTimestampEqualWidth().getBinCount().intValue();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_EQW_TIMESTAMP_WITH_TIMEZONE();
                transformNulls = binning.getTimestampEqualWidth().getTransformNulls();
                bl2 = null != binning.getTimestampEqualWidth().getBinLabels();
                bl = null != binning.getTimestampEqualWidth().getBinGeneration().getAuto();
            } else if (null != binning.getTopN()) {
                n = binning.getTopN().getBinCount().intValue();
                string2 = TransformationTypes.getTRANSFORMATION_TYPE_BINNING_TOPN();
                transformNulls = binning.getTopN().getTransformNulls();
            }
            if (n == null || n == 0) {
                throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_BIN_COUNT_INVALID"));
            }
            transformationType2 = string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_CATEGORIC()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_NUMERIC()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP()) || string2.equals(TransformationTypes.getTRANSFORMATION_TYPE_BINNING_CUSTOM_TIMESTAMP_WITH_TIME_ZONE()) ? TransformationTypes.initCustomBinning(string2, customCategorical, transformNulls) : TransformationTypes.initBinning(string2, n, bl, bl2, transformNulls);
        } else if (null != missingValuesDate || null != missingValuesCategorical || null != missingValuesNumeric) {
            Object object = null;
            XMLGregorianCalendar xMLGregorianCalendar = null;
            String string3 = null;
            if (null != missingValuesDate) {
                if (null != missingValuesDate.getDateStatistic()) {
                    object = missingValuesDate.getDateStatistic().getReplaceNullsWith();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
                } else {
                    xMLGregorianCalendar = missingValuesDate.getValue().getReplaceNullsWith();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
                }
            } else if (null != missingValuesCategorical) {
                if (null != missingValuesCategorical.getCategoricalStatistic()) {
                    object = missingValuesCategorical.getCategoricalStatistic().getReplaceNullsWith();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
                } else {
                    xMLGregorianCalendar = missingValuesCategorical.getValue();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
                }
            } else if (null != missingValuesNumeric) {
                if (null != missingValuesNumeric.getNumericStatistic()) {
                    object = missingValuesNumeric.getNumericStatistic().getReplaceNullsWith();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_STATS();
                } else {
                    xMLGregorianCalendar = missingValuesNumeric.getValue();
                    string3 = TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE();
                    try {
                        object = Double.valueOf(((Object)xMLGregorianCalendar).toString());
                    }
                    catch (Exception exception) {
                        throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"));
                    }
                }
            }
            if (string3.equals(TransformationTypes.getTRANSFORMATION_TYPE_MISS_VALUES_VALUE())) {
                if (xMLGregorianCalendar == null || ((Object)xMLGregorianCalendar).toString().isEmpty()) {
                    throw new DataMinerException(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MISS_VALUE_INVALID"));
                }
                object = xMLGregorianCalendar;
            }
            transformationType2 = TransformationTypes.initMissValues(this.datatype, string3, object);
        } else if (null != normalization) {
            TransformationType.Normalization normalization2 = new TransformationType.Normalization();
            if (null != normalization.getManual()) {
                Double d = normalization.getManual().getShift();
                Double d2 = normalization.getManual().getScale();
                TransformationType.Normalization.Manual manual = new TransformationType.Normalization.Manual();
                manual.setShift(d);
                manual.setScale(d2);
                normalization2.setManual(manual);
            } else if (null != normalization.getLinearScale()) {
                normalization2.setLinearScale(new TransformationType.Normalization.LinearScale());
            } else if (null != normalization.getZScore()) {
                normalization2.setZScore(new TransformationType.Normalization.ZScore());
            } else if (null != normalization.getMinMax()) {
                normalization2.setMinMax(new TransformationType.Normalization.MinMax());
            }
            transformationType2 = new TransformationType();
            transformationType2.setNormalization(normalization2);
        } else if (null != outlier) {
            TransformationType.Outlier outlier2 = new TransformationType.Outlier();
            if (null != outlier.getStandardDeviation()) {
                TransformationType.Outlier.StandardDeviation standardDeviation = new TransformationType.Outlier.StandardDeviation();
                standardDeviation.setMultiplesSigma(Double.valueOf(outlier.getStandardDeviation().getMultiplesSigma()));
                outlier2.setReplaceWith(outlier.getReplaceWith());
                outlier2.setStandardDeviation(standardDeviation);
            } else if (null != outlier.getPercent()) {
                TransformationType.Outlier.Percent percent = new TransformationType.Outlier.Percent();
                percent.setLowerPercent(Double.valueOf(outlier.getPercent().getLowerPercent()));
                percent.setUpperPercent(Double.valueOf(outlier.getPercent().getUpperPercent()));
                outlier2.setReplaceWith(outlier.getReplaceWith());
                outlier2.setPercent(percent);
            } else if (null != outlier.getValue()) {
                TransformationType.Outlier.Value value = new TransformationType.Outlier.Value();
                value.setLowerValue(Double.valueOf(outlier.getValue().getLowerValue()));
                value.setUpperValue(Double.valueOf(outlier.getValue().getUpperValue()));
                outlier2.setReplaceWith(outlier.getReplaceWith());
                outlier2.setValue(value);
            }
            transformationType2 = new TransformationType();
            transformationType2.setOutlier(outlier2);
        }
        return transformationType2;
    }
}

