/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationLoadGraphPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesBasePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesGrid;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationSettingsTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class TransformationNodeAttributesPanel
extends TransformationNodeAttributesBasePanel {
    private static Preferences _p = Preferences.getPreferences();
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)_p);
    private boolean loadingDetailedGraph = false;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JPanel jBottomPanel;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedBottomPane;
    private JPanel jTopPanel;
    private ControlBar jcontrolBar;
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private JCheckBox jChkBoxShowStats;
    private JCheckBox jChkBoxShowNulls;
    private JButton jBtnRefresh;
    private JPanel _jGraphPanel = new JPanel();
    private JPanel _jStatsPanel = new JPanel();
    private LoadGraphPanel _currentGraphPanel;
    private boolean showHistogram = true;

    public void setLoadingDetailedGraph(boolean bl) {
        this.loadingDetailedGraph = bl;
    }

    public boolean isLoadingDetailedGraph() {
        return this.loadingDetailedGraph;
    }

    public TransformationNodeAttributesPanel(TransformSettingsEditorDialog transformSettingsEditorDialog, Context context, AbstractNode abstractNode) {
        super(transformSettingsEditorDialog, context, abstractNode);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jTabbedBottomPane = new JTabbedPane();
        this.jcontrolBar = new ControlBar();
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 623, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 603, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 149, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 127, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPane1.setTopComponent(this.jTopPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedBottomPane, -1, 623, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedBottomPane, GroupLayout.Alignment.TRAILING, -1, 196, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addComponent((Component)this.jcontrolBar, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent((Component)this.jcontrolBar, -2, 25, -2).addGap(4, 4, 4).addComponent(this.jSplitPane1)));
    }

    @Override
    public void initRes() {
        this.jSplitPane1.setDividerLocation(280);
        HelpUtils.setHelpID((JComponent)this, (String)"edit_transform_settings");
    }

    @Override
    public void initUI() {
        this.jcontrolBar.setAlignment(2);
        this.jBtnRefresh = new JButton();
        this.jBtnRefresh.setToolTipText(XformDialogsLrb.get("MAIN_TRANSFORMATION_DIALOG_REFRESH_STATS"));
        this.jBtnRefresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this.jcontrolBar.add((Component)this.jBtnRefresh);
        this.jChkBoxShowStats = new JCheckBox();
        this.jChkBoxShowStats.setText(XformDialogsLrb.get("MAIN_TRANSFORMATION_DIALOG_SHOW_STATS"));
        this.jcontrolBar.add((Component)this.jChkBoxShowStats);
        this.jChkBoxShowNulls = new JCheckBox();
        this.jChkBoxShowNulls.setText(DataProfileStatisticsLrb.get("TABLE_SUMMARY_EDITOR_SHOW_NULLS_LABEL"));
        this.jcontrolBar.add((Component)this.jChkBoxShowNulls);
        this.jChkBoxShowNulls.setSelected(this.transformSettings.isShowNulls());
        this.jChkBoxShowNulls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TransformationNodeAttributesPanel.this.jChkBoxShowNulls.isSelected();
                TransformationNodeAttributesPanel.this.transformSettings.setShowNulls(bl);
                TransformationLoadGraphPanel.addLoadingPanel(TransformationNodeAttributesPanel.this._jGraphPanel);
                TransformationNodeAttributesPanel.this.grid.showStats(TransformationNodeAttributesPanel.this._jAttributesTable, TransformationNodeAttributesPanel.this.jChkBoxShowStats.isSelected());
            }
        });
        Object a = this.getData();
        NodeType nodeType = ((AbstractNode)a).getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        this.grid = new TransformationNodeAttributesGrid((AbstractNode)a, this.parentDlg, transformationNodeType);
        this.grid.initUI(this.getContext(), this.jAttributesComponent, this._jAttributesTable);
        if (this.grid.getState().getStatsSelection() != null) {
            this.showHistogram = this.grid.getState().getStatsSelection().isHistogram();
        }
        GraphicalPreferencesSettings graphicalPreferencesSettings = this.grid.getGraphPanelSettings();
        boolean bl = graphicalPreferencesSettings.isShowStatistics();
        this.jChkBoxShowStats.setSelected(bl);
        this.jChkBoxShowStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformationLoadGraphPanel.addLoadingPanel(TransformationNodeAttributesPanel.this._jGraphPanel);
                TransformationNodeAttributesPanel.this.grid.showStats(TransformationNodeAttributesPanel.this._jAttributesTable, TransformationNodeAttributesPanel.this.jChkBoxShowStats.isSelected());
            }
        });
        if (this.showHistogram) {
            this.jTabbedBottomPane.addTab(XformDialogsLrb.get("ADD_TRANSFORMATION_TAB_HISTOGRAM"), this._jGraphPanel);
            TransformationLoadGraphPanel.addLoadingPanel(this._jGraphPanel);
        }
        this.jTabbedBottomPane.addTab(XformDialogsLrb.get("ADD_TRANSFORMATION_TAB_STATISTICS"), this._jStatsPanel);
        ListSelectionModel listSelectionModel = this._jAttributesTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TransformationNodeAttributesPanel.this.grid.isLoading()) {
                    return;
                }
                if (TransformationNodeAttributesPanel.this.isLoadingDetailedGraph()) {
                    return;
                }
                int[] nArray = TransformationNodeAttributesPanel.this._jAttributesTable.getSelectedRowsInModel();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                if (nArray.length > 1) {
                    TransformationLoadGraphPanel.addNoShowPanel(TransformationNodeAttributesPanel.this.showHistogram ? TransformationNodeAttributesPanel.this._jGraphPanel : TransformationNodeAttributesPanel.this._jStatsPanel);
                    return;
                }
                TransformationSettingsTableModel transformationSettingsTableModel = (TransformationSettingsTableModel)((Object)TransformationNodeAttributesPanel.this._jAttributesTable.getModel());
                if (nArray[0] >= transformationSettingsTableModel.getDataVector().size()) {
                    return;
                }
                TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)transformationSettingsTableModel.getDataVector().get(nArray[0]);
                String string = null;
                String string2 = null;
                if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
                    MapTransformedSource mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(TransformationNodeAttributesPanel.this.getCachedTransformationNodeType().getTransformedAttributes(), (AttributeType)transformationSourceAttribute);
                    string2 = transformationSourceAttribute.getName();
                    List list = mapTransformedSource.getStringCollectionNames().getValue();
                    string = !list.isEmpty() ? (String)mapTransformedSource.getStringCollectionNames().getValue().get(0) : null;
                } else {
                    string = transformationSourceAttribute.getName();
                }
                TransformationNodeAttributesPanel.this.setLoadingDetailedGraph(true);
                TransformationNodeAttributesPanel.this._currentGraphPanel = new LoadGraphPanel(TransformationNodeAttributesPanel.this.grid.getState(), TransformationNodeAttributesPanel.this, TransformationNodeAttributesPanel.this._jGraphPanel, TransformationNodeAttributesPanel.this._jStatsPanel, string, string2);
                TransformationNodeAttributesPanel.this._currentGraphPanel.execute();
            }
        });
        this.updateResfresButtonState();
        this.jBtnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TransformationNodeAttributesPanel.this.grid.refreshStats(TransformationNodeAttributesPanel.this._jAttributesTable, TransformationNodeAttributesPanel.this.jChkBoxShowStats.isSelected());
                    TransformationNodeAttributesPanel.this.updateResfresButtonState();
                }
                catch (Exception exception) {
                    String string = exception.getLocalizedMessage();
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("REFRESH_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                }
            }
        });
    }

    void updateResfresButtonState() {
        boolean bl = this.grid.isRefresheEnabled();
        this.jBtnRefresh.setEnabled(bl);
    }

    void updateGraph(GraphDataModel graphDataModel) {
        this._currentGraphPanel.updateGraphModel(graphDataModel);
    }

    void updateGraph(Map<String, GraphDataModel> map) {
        this._currentGraphPanel.updateGraphModel(map);
    }

    void updateGraphNoData() {
        TransformationLoadGraphPanel.addNoDataPanel(this._jGraphPanel);
    }

    @Override
    public boolean doWork() {
        GraphicalPreferencesSettings graphicalPreferencesSettings = this.grid.getGraphPanelSettings();
        graphicalPreferencesSettings.setShowStatistics(this.jChkBoxShowStats.isSelected());
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.isQuantileBinningValid(arrayList);
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                if (!stringBuilder.toString().isEmpty()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            String string = StringUtils.getReplacedString(XformDialogsLrb.get("QUANTILE_BINNING_ERROR_NOT_ENOUGH_DITINCTS"), "<list of columns>", stringBuilder.toString());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
        }
        return bl;
    }

    @Override
    public List<Property> getResults() {
        TransformationNodeType transformationNodeType = this.getCachedTransformationNodeType();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(transformationNodeType), null, null));
        arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
        return arrayList;
    }

    @Override
    public void cleanUp() {
        this.grid.cleanUp();
    }

    private class LoadGraphPanel
    extends TransformationLoadGraphPanel {
        public LoadGraphPanel(TransformationStatisticsState transformationStatisticsState, JPanel jPanel, JPanel jPanel2, JPanel jPanel3, String string, String string2) {
            super(transformationStatisticsState, jPanel, jPanel2, jPanel3, string, string2);
        }

        @Override
        public void setLoadingFinished(boolean bl) {
            TransformationNodeAttributesPanel.this.setLoadingDetailedGraph(false);
        }
    }
}

