/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.dprofiler.DataProfileStatisticsData;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelWithStats;
import oracle.dmt.dataminer.workflow.dialog.transformations.RefreshGraphJPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dss.graph.Graph;

public class TransformationLoadGraphPanel
extends SwingWorker {
    private static final Logger theLogger = Logger.getLogger(TransformationLoadGraphPanel.class.getName());
    private GraphPanel[] _graphPanel;
    private JPanel _jGraphPanel;
    private JPanel _jStatsPanel;
    private TransformationStatisticPanel _statsPanel;
    private Exception _ex;
    private boolean _success = false;
    private GraphDataModel[] localGraphModel;
    private String sourceAttribute;
    private String xformedAttribute;
    private int panelCount = 1;
    private TransformationStatisticsState _state;
    private JPanel _parentPanel;
    private RefreshGraphJPanel _panelWithRefreshButton = null;
    private boolean noSource = false;
    private String customOutputName;
    private TransformationOutputAttribute xformed;
    private TransformationSourceAttribute srcColumn;
    private static JPanel _noShowPanel = null;

    public TransformationLoadGraphPanel(TransformationStatisticsState transformationStatisticsState, JPanel jPanel, JPanel jPanel2, JPanel jPanel3, String string, String string2) {
        this._parentPanel = jPanel;
        this._state = transformationStatisticsState;
        this.sourceAttribute = string;
        this.xformedAttribute = string2;
        this._jGraphPanel = jPanel2;
        this._jStatsPanel = jPanel3;
        this.srcColumn = transformationStatisticsState.findTransformationSourceColumn(string);
        if (string2 != null) {
            this.panelCount = 2;
        }
        this.xformed = transformationStatisticsState.findTransformedColumn(string2);
        if (string2 != null && TransformationTypes.isCustomXform(this.xformed.getTransformationElementType())) {
            this.noSource = true;
        }
    }

    public void setLoadingFinished(boolean bl) {
    }

    boolean isUpdateStatistics() {
        if (this._parentPanel instanceof TransformationNodeAttributesPanel) {
            return true;
        }
        if (this._parentPanel instanceof AddEditTransformsPanelWithStats) {
            return ((AddEditTransformsPanelWithStats)this._parentPanel).isUpdateWhenFinished();
        }
        return false;
    }

    boolean isAddEditDialog() {
        return this._parentPanel instanceof AddEditTransformsPanelWithStats;
    }

    void updateGraphModel(GraphDataModel graphDataModel) {
        if (this.localGraphModel.length == 2) {
            this.localGraphModel[1] = graphDataModel;
        } else {
            this.panelCount = 2;
            GraphDataModel graphDataModel2 = this.localGraphModel[0];
            this.localGraphModel = new GraphDataModel[this.panelCount];
            this.localGraphModel[0] = graphDataModel2;
            this.localGraphModel[1] = graphDataModel;
        }
        this.done();
    }

    void updateGraphModel(Map<String, GraphDataModel> map) {
        GraphDataModel graphDataModel = map.get(TransformationStatisticsState.getQuotedName(this.xformedAttribute));
        if (this.localGraphModel.length == 2) {
            this.localGraphModel[1] = graphDataModel;
        } else {
            this.panelCount = 2;
            GraphDataModel graphDataModel2 = this.localGraphModel[0];
            this.localGraphModel = new GraphDataModel[this.panelCount];
            this.localGraphModel[0] = graphDataModel2;
            this.localGraphModel[1] = graphDataModel;
        }
        this.done();
    }

    void peerRefresButtonState(JPanel jPanel) {
        if (jPanel instanceof TransformationStatisticPanel) {
            if (this._panelWithRefreshButton != null) {
                this._panelWithRefreshButton.updateRefresButtonStateFromPeer();
            }
        } else if (this._statsPanel != null) {
            this._statsPanel.updateRefresButtonStateFromPeer();
        }
    }

    void updateGraph(DataProfileStatisticsData dataProfileStatisticsData, GraphDataModel graphDataModel) {
        assert (this.localGraphModel.length == 2);
        this.localGraphModel[1] = graphDataModel;
        this._statsPanel.updateTableModel(dataProfileStatisticsData);
        this.done();
    }

    private void arrangeGraphs(JPanel jPanel) {
        if (this.noSource) {
            jPanel.setLayout(new GridLayout(0, 1));
            if (this.panelCount == 1) {
                jPanel.add(TransformationLoadGraphPanel.createNoDataPanel());
            } else {
                jPanel.add(this._graphPanel[this.panelCount - 1]);
            }
        } else {
            jPanel.setLayout(new GridLayout(0, this.panelCount));
            for (int i = 0; i < this.panelCount; ++i) {
                if (this._graphPanel[i] != null) {
                    jPanel.add(this._graphPanel[i]);
                    continue;
                }
                jPanel.add(TransformationLoadGraphPanel.createNoDataPanel());
            }
        }
        jPanel.updateUI();
    }

    public static void addLoadingPanel(JPanel jPanel) {
        jPanel.removeAll();
        String string = XformDialogsLrb.get("ADD_TRANSFORMATION_LOADING");
        JPanel jPanel2 = TransformationLoadGraphPanel.createDescriptionPanel(jPanel, string, 5);
        jPanel.add(jPanel2);
        jPanel.updateUI();
    }

    public static void addNoDataPanel(JPanel jPanel) {
        jPanel.removeAll();
        JPanel jPanel2 = TransformationLoadGraphPanel.createNoDataPanel();
        jPanel.add(jPanel2);
        jPanel.updateUI();
    }

    public static void addNoShowPanel(JPanel jPanel) {
        jPanel.removeAll();
        if (_noShowPanel == null) {
            String string = XformDialogsLrb.get("ADD_TRANSFORMATION_MULTIPLE_ITEMS_SELECTED");
            Graphics graphics = jPanel.getGraphics();
            JLabel jLabel = new JLabel();
            Font font = jLabel.getFont();
            Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
            FontMetrics fontMetrics = graphics.getFontMetrics(font2);
            int n = fontMetrics.stringWidth(string);
            _noShowPanel = TransformationLoadGraphPanel.createDescriptionPanel(jPanel, string, n);
        }
        jPanel.add(_noShowPanel);
        jPanel.updateUI();
    }

    private static JPanel createDescriptionPanel(JPanel jPanel, String string, int n) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        Dimension dimension = jPanel.getSize();
        jPanel2.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel2.add(jLabel);
        return jPanel2;
    }

    private static JPanel createNoDataPanel() {
        String string = XformDialogsLrb.get("ADD_TRANSFORMATION_NO_DATA");
        JPanel jPanel = new JPanel(new GridLayout(0, 3));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        jPanel.add(new JLabel(""));
        jPanel.add(jLabel);
        jPanel.add(new JLabel(""));
        return jPanel;
    }

    public void setNoSource(boolean bl) {
        this.noSource = bl;
    }

    public void setCustomOutputName(String string) {
        this.customOutputName = string;
    }

    protected Object doInBackground() throws Exception {
        try {
            this.localGraphModel = new GraphDataModel[this.panelCount];
            this.localGraphModel[0] = this._state.createDetailedGraphModel(this.sourceAttribute);
            if (this.xformedAttribute != null) {
                this.localGraphModel[1] = this._state.createDetailedGraphModel(this.xformedAttribute);
            }
            this._success = true;
        }
        catch (Exception exception) {
            this._ex = exception;
            this._success = false;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this;
    }

    @Override
    protected void done() {
        super.done();
        if (this._success && this._ex == null) {
            this._graphPanel = new GraphPanel[this.panelCount];
            for (int i = 0; i < this.panelCount; ++i) {
                if (this.localGraphModel[i] != null) {
                    this._graphPanel[i] = new GraphPanel(this.localGraphModel[i]);
                    this.localGraphModel[i].setDepthRadius(Integer.valueOf(this._state.getDepthRadius()));
                    this._graphPanel[i].initGraph();
                    this.localGraphModel[i].setStyleSelection(this._state.getStyleSelection());
                    this._graphPanel[i].updateGraphStyle();
                } else {
                    this._graphPanel[i] = null;
                }
                this.setupColumnXAxis(i);
            }
            this._jGraphPanel.removeAll();
            if (this.panelCount > 1) {
                this._panelWithRefreshButton = new RefreshGraphJPanel(this, this._state, this.xformedAttribute);
                this.arrangeGraphs(this._panelWithRefreshButton.getJHostPanel());
                this._jGraphPanel.setLayout(new GridLayout(0, 1));
                this._jGraphPanel.add(this._panelWithRefreshButton);
            } else {
                this.arrangeGraphs(this._jGraphPanel);
            }
            this._jGraphPanel.updateUI();
            if (this._statsPanel != null) {
                return;
            }
            this._statsPanel = new TransformationStatisticPanel(this, this._state, this.sourceAttribute, this.xformedAttribute, this.noSource, this.customOutputName);
            this._jStatsPanel.removeAll();
            this._jStatsPanel.setLayout(new GridLayout(0, 1));
            this._jStatsPanel.add(this._statsPanel);
            this._jStatsPanel.updateUI();
        }
        this.setLoadingFinished(false);
    }

    private void setupColumnXAxis(int n) {
        if (this.srcColumn == null) {
            return;
        }
        String string = this.srcColumn.getDataType();
        if ((DatabaseMetadataUtils.isTimestampDerived(string) || string.equals("DATE")) && null != this.localGraphModel[n] && this.localGraphModel[n].getColumnLabels().length > 3) {
            Graph graph = this._graphPanel[n].getGraph();
            graph.doAutoLayout(2);
            graph.getO1TickLabel().setTextRotation(90);
        }
    }
}

