/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import oracle.dmt.dataminer.workflow.dialog.transformations.FilterProcessor;
import oracle.dmt.dataminer.workflow.inspect.transformations.TransformationPIPropertyLrb;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class SearchHelper {
    private SearchField _searchField;
    private FilterProcessor filterProcessor;
    private int _currentSearchCategory = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_COLUMN_NAME"));

    public SearchHelper(FilterProcessor filterProcessor) {
        this.filterProcessor = filterProcessor;
    }

    private void setupFilterCtl(SearchField searchField) {
        this._currentSearchCategory = 0;
        searchField.addCategory(this._defaultSearchCategory);
        searchField.addCategory(new SearchCategory(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_TRANSFORMATION")));
        searchField.addCategory(new SearchCategory(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_SOURCE_COLUMN")));
        searchField.setSelectedCategory(this._defaultSearchCategory);
    }

    private synchronized void translateSearchCategoryToConstant(SearchCategory searchCategory) {
        if (searchCategory.getLabel().equals(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_COLUMN_NAME"))) {
            this._currentSearchCategory = 0;
        } else if (searchCategory.getLabel().equals(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_TRANSFORMATION"))) {
            this._currentSearchCategory = 1;
        } else if (searchCategory.getLabel().equals(TransformationPIPropertyLrb.get("SEARCH_CRITERIA_SOURCE_COLUMN"))) {
            this._currentSearchCategory = 2;
        } else assert (false) : "Invalid Search Category Code";
    }

    private SearchField searchField() {
        final SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                SearchHelper.this.translateSearchCategoryToConstant(searchField.getSelectedCategory());
                SearchHelper.this.filterProcessor.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                SearchHelper.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                SearchHelper.this.filterProcessor.processFilter(string);
            }
        });
        return searchField;
    }

    private static Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    public Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.setupFilterCtl(this._searchField);
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = SearchHelper.derive(dimension, 250);
        Dimension dimension3 = SearchHelper.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    public int getCurrentSearchCategory() {
        return this._currentSearchCategory;
    }

    public String getSearchText() {
        return this._searchField.getText();
    }
}

