/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.util.ResourceUtils;

public class NormalizationPanel
extends JPanel {
    private String selectedType;
    private TransformationType.Normalization normalization;
    private Double min;
    private Double max;
    private JComboBox jComboBoxType;
    private JLabel jLabelMax;
    private JLabel jLabelMin;
    private JLabel jLabelType;
    private JTextField jTextMax;
    private JTextField jTextMin;

    public NormalizationPanel() {
        this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public NormalizationPanel(TransformationOutputAttribute transformationOutputAttribute) {
        this.normalization = transformationOutputAttribute.getTransformationElementType().getNormalization();
        if (null != this.normalization) {
            this.selectedType = null != this.normalization.getMinMax() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX() : (null != this.normalization.getZScore() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE() : (null != this.normalization.getLinearScale() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE() : TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MANUAL()));
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public NormalizationPanel(TransformationSourceAttribute transformationSourceAttribute, Double d, Double d2, String string) {
        this.min = d;
        this.max = d2;
        this.selectedType = string;
        if (transformationSourceAttribute instanceof TransformationOutputAttribute) {
            TransformationOutputAttribute transformationOutputAttribute = (TransformationOutputAttribute)transformationSourceAttribute;
            this.normalization = transformationOutputAttribute.getTransformationElementType().getNormalization();
            if (null != this.normalization) {
                this.selectedType = null != this.normalization.getMinMax() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX() : (null != this.normalization.getZScore() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE() : (null != this.normalization.getLinearScale() ? TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE() : TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MANUAL()));
            }
        }
        if (this.selectedType == null) {
            this.selectedType = TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelType = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jTextMin = new NumberTextField();
        this.jLabelMin = new JLabel();
        this.jLabelMax = new JLabel();
        this.jTextMax = new NumberTextField();
        this.jLabelType.setText("Normalization Type:");
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Min Max", "Z-Score", "Linear Scale", " "}));
        this.jLabelMin.setText("New Minimum:");
        this.jLabelMax.setText("New Maximum:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelType).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelMax, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelMin, -1, -1, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxType, -2, 183, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextMax, GroupLayout.Alignment.LEADING).addComponent(this.jTextMin, GroupLayout.Alignment.LEADING, -1, 62, Short.MAX_VALUE))).addContainerGap(32, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLabelMax, this.jLabelMin);
        groupLayout.linkSize(0, this.jTextMax, this.jTextMin);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addGap(38, 38, 38).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMin).addComponent(this.jTextMin, -2, -1, -2)))).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMax).addComponent(this.jTextMax, -2, -1, -2)).addContainerGap(109, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelType, (Component)this.jComboBoxType, (String)XformDialogsLrb.get("NORMALIZATION_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jLabelMin, (Component)this.jTextMin, (String)XformDialogsLrb.get("NORMALIZATION_SHIFT"));
        ResourceUtils.resLabel((JLabel)this.jLabelMax, (Component)this.jTextMax, (String)XformDialogsLrb.get("NORMALIZATION_SCALE"));
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX"), XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE"), XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE"), XformDialogsLrb.get("TRANSFORMATION_TYPE_NORMALIZATION_MANUAL")}));
    }

    public void initUI() {
        this.jComboBoxType.setSelectedItem(this.selectedType);
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NormalizationPanel.this.selectedType = (String)NormalizationPanel.this.jComboBoxType.getSelectedItem();
                NormalizationPanel.this.showPanel();
            }
        });
        if (this.normalization != null) {
            TransformationType.Normalization.Manual manual = this.normalization.getManual();
            if (manual != null) {
                double d = manual.getScale();
                this.setValue(this.jTextMax, d);
                double d2 = manual.getShift();
                this.setValue(this.jTextMin, d2);
            }
        } else {
            this.setValue(this.jTextMax, 1.0);
            this.setValue(this.jTextMin, 0.0);
        }
        this.showPanel();
    }

    public String getSelectedNormalizationType() {
        return this.selectedType;
    }

    private void setValue(JTextField jTextField, double d) {
        ((NumberTextField)jTextField).setDataType(Double.class);
        ((NumberTextField)jTextField).setSigned(false);
        jTextField.setLocale(Locale.getDefault());
        ((NumberTextField)jTextField).setNumber((Number)d);
    }

    private void showPanel() {
        boolean bl = this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MANUAL());
        this.jLabelMin.setVisible(bl);
        this.jLabelMax.setVisible(bl);
        this.jTextMin.setVisible(bl);
        this.jTextMax.setVisible(bl);
        if (bl) {
            Double d = null;
            Double d2 = null;
            if (null != this.normalization && null != this.normalization.getManual()) {
                d = this.normalization.getManual().getShift();
                d2 = this.normalization.getManual().getScale();
            } else {
                d = this.min;
                d2 = this.max;
            }
            ((NumberTextField)this.jTextMin).setNumber((Number)d);
            ((NumberTextField)this.jTextMax).setNumber((Number)d2);
        }
    }

    public Double getShiftValue() {
        if (null == this.jTextMin.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextMin).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    public Double getScaleValue() {
        if (null == this.jTextMax.getText()) {
            return null;
        }
        Number number = ((NumberTextField)this.jTextMax).getNumber();
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    public TransformationType.Normalization getResults() throws Exception {
        TransformationType.Normalization normalization = null;
        if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MANUAL())) {
            Double d = this.getShiftValue();
            Double d2 = this.getScaleValue();
            if (d == null || d2 == null) {
                String string = XformDialogsLrb.get("NORMALIZATION_VALUE_MISSING_ERROR");
                throw new Exception(string);
            }
            TransformationType.Normalization.Manual manual = new TransformationType.Normalization.Manual();
            manual.setShift(d);
            manual.setScale(d2);
            normalization = new TransformationType.Normalization();
            normalization.setManual(manual);
        } else if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_Z_SCORE())) {
            normalization = new TransformationType.Normalization();
            normalization.setZScore(new TransformationType.Normalization.ZScore());
        } else if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_LINEAR_SCALE())) {
            normalization = new TransformationType.Normalization();
            normalization.setLinearScale(new TransformationType.Normalization.LinearScale());
        } else if (this.selectedType.equals(TransformationTypes.getTRANSFORMATION_TYPE_NORMALIZATION_MIN_MAX())) {
            normalization = new TransformationType.Normalization();
            normalization.setMinMax(new TransformationType.Normalization.MinMax());
        }
        return normalization;
    }
}

