/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONFilterCellEditor;
import oracle.dmt.dataminer.controls.JSONFilterObject;
import oracle.dmt.dataminer.controls.JSONQueryStructureTreeTable;
import oracle.dmt.dataminer.controls.JSONSearchListener;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.FilterSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAddAggregationSelectionChange;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONDataPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.NameChangeListener;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONFilterType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Version;

public class JSONPanel
extends AbstractPanel<JSONQueryNode>
implements NameChangeListener {
    private JSONStructurePanel2 _JSONStructurePanel2;
    private JSONDataPanel _JSONDataPanel;
    private JSONQueryEditorPanel _parent;
    private UserObject _curJSONCol = null;
    private boolean _withFiltersOnly = false;
    private boolean _selectedAttrsOnly = false;
    boolean _filterSupport = false;
    private Map<String, JSONAttributeType> _JSONAttributesMap = new HashMap<String, JSONAttributeType>();
    private Map<String, JSONFilterType.FilterElement> _JSONFiltersMap = new HashMap<String, JSONFilterType.FilterElement>();
    private static UserObject SELECT_A_COLUMN;
    private static String JSON_STARTING_ARRAY;
    private JButton jButtonFilterSettings;
    private DataMinerCombBox jColumnComboBox;
    private JLabel jColumnLabel;
    private JPanel jInfoPanel;
    private JLabel jLabelFilterSettings;
    private JLabel jStatusIconLabel;
    private JTabbedPane jTabbedPane;
    private JLabel infoMsg = new JLabel();
    private static String SOURCE_TAB;
    private static String DATA_TAB;

    public JSONPanel(Context context, JSONQueryEditorPanel jSONQueryEditorPanel) {
        super(context, (JSONQueryNode)jSONQueryEditorPanel.getData());
        JSONAttributeType jSONAttributeType2;
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        AttributeType attributeType = new AttributeType();
        attributeType.setName(DialogsLrb.get("JSON_QUERY_SOURCE_SELECT_COLUMN"));
        attributeType.setStatus(AttributeStatus.INVALID);
        SELECT_A_COLUMN = new UserObject(attributeType);
        JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
        if (jSONAttributesType != null) {
            for (JSONAttributeType jSONAttributeType2 : jSONAttributesType.getJSONAttribute()) {
                this._JSONAttributesMap.put(jSONAttributeType2.getPath(), jSONAttributeType2);
            }
        }
        Version version = ConfigUtils.getDatabaseVersion(context);
        this._filterSupport = DbVersionHelper.isDB122Up((Version)version);
        jSONAttributeType2 = this._parent.getJSONFilters();
        if (jSONAttributeType2 != null) {
            for (JSONFilterType.FilterElement filterElement : jSONAttributeType2.getFilterElement()) {
                this._JSONFiltersMap.put(filterElement.getJSONAttribute().getPath(), filterElement);
            }
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jColumnLabel.setText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA_COL"));
        this.jColumnLabel.setLabelFor(this.jColumnComboBox);
        this.jStatusIconLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.jStatusIconLabel.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_COLUMN_INVALID_TIP"));
        this.jStatusIconLabel.setText("");
        this.infoMsg.setText(DialogsLrb.get("JSON_QUERY_MISSING_DATA_GUIDE_MESSAGE"));
        this.infoMsg.setIcon(OracleIcons.getIcon((String)"warning.png"));
    }

    @Override
    public void initUI() {
        List list;
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        if (this._filterSupport) {
            this.jButtonFilterSettings.setText("");
            this.jButtonFilterSettings.setIcon(OracleIcons.getIcon((String)"edit.png"));
            this.jButtonFilterSettings.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_FILTER_SETTINGS"));
            this.setFilterSettingsLabel();
        } else {
            this.jButtonFilterSettings.setVisible(false);
            this.jLabelFilterSettings.setVisible(false);
        }
        this.infoMsg.setVerticalTextPosition(1);
        this.infoMsg.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jInfoPanel.setVisible(false);
        this.jInfoPanel.setMaximumSize(new Dimension(100, 50));
        this.jInfoPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.jInfoPanel.setLayout(new BorderLayout());
        this.jInfoPanel.add(this.infoMsg);
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)jSONQueryNode.findParentNode());
        this._JSONStructurePanel2 = new JSONStructurePanel2(this._context, jSONQueryNode, null, null, null, null, dataGuideProvider);
        this.jTabbedPane.add(SOURCE_TAB, this._JSONStructurePanel2);
        this._JSONDataPanel = new JSONDataPanel(this._context, this._parent);
        this.jTabbedPane.add(DATA_TAB, this._JSONDataPanel);
        AttributeType attributeType = this._parent.getJSONSourceColumn();
        DataProvider dataProvider = (DataProvider)((Object)jSONQueryNode.findParentNode());
        Vector<Object> vector = new Vector<Object>();
        if (dataProvider != null) {
            list = dataProvider.getAttributes().getAttribute();
            for (AttributeType attributeType2 : list) {
                if (!DatabaseMetadataUtils.isJSONTypeSupported(DatabaseMetadataUtils.getJSONDataType(attributeType2.getDataType(), attributeType2.getDataTypeQualifier()))) continue;
                UserObject userObject = new UserObject(attributeType2);
                vector.addElement(userObject);
                if (attributeType == null || attributeType.getName() == null || attributeType.getName().compareToIgnoreCase(attributeType2.getName()) != 0) continue;
                this._curJSONCol = userObject;
                this.jStatusIconLabel.setVisible(false);
            }
        }
        if (this._curJSONCol == null) {
            if (attributeType != null && attributeType.getName() != null) {
                list = new AttributeType();
                list.setName(attributeType.getName());
                list.setDataType(attributeType.getDataType());
                list.setStatus(AttributeStatus.INVALID);
                UserObject userObject = new UserObject((AttributeType)list);
                vector.addElement(userObject);
                this._curJSONCol = userObject;
            } else {
                this._curJSONCol = SELECT_A_COLUMN;
                vector.add(0, SELECT_A_COLUMN);
            }
            this.jStatusIconLabel.setVisible(true);
        }
        this.jColumnComboBox.setModel(new DefaultComboBoxModel(vector));
        this.jColumnComboBox.setSelectedItem(this._curJSONCol);
        if (this._curJSONCol != SELECT_A_COLUMN) {
            this.reload();
        }
    }

    private void setFilterSettingsLabel() {
        JSONFilterType jSONFilterType = this._parent.getJSONFilters();
        String string = ServerConstants.JSONFilterMatchSetting.toHuman((String)jSONFilterType.getMatch());
        String string2 = ServerConstants.JSONFilterApplySetting.toHuman((String)jSONFilterType.getUseBy());
        String string3 = DialogsLrb.get("JSON_QUERY_SOURCE_FILTER_SETTINGS_LBL");
        String string4 = MessageFormat.format(string3, string, string2);
        this.jLabelFilterSettings.setText(string4);
    }

    private void initComponents() {
        this.jColumnLabel = new JLabel();
        this.jColumnComboBox = new DataMinerCombBox();
        this.jStatusIconLabel = new JLabel();
        this.jLabelFilterSettings = new JLabel();
        this.jButtonFilterSettings = new JButton();
        this.jTabbedPane = new JTabbedPane();
        this.jInfoPanel = new JPanel();
        this.jColumnLabel.setText("Column:");
        this.jColumnLabel.setName("jColumnLabel");
        this.jColumnComboBox.setName("jColumnComboBox");
        this.jColumnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONPanel.this.jColumnComboBoxActionPerformed(actionEvent);
            }
        });
        this.jStatusIconLabel.setText("warnIcon");
        this.jStatusIconLabel.setVerticalAlignment(3);
        this.jStatusIconLabel.setName("jStatusIconLabel");
        this.jStatusIconLabel.setVerticalTextPosition(3);
        this.jLabelFilterSettings.setHorizontalAlignment(11);
        this.jLabelFilterSettings.setText("jLabel1");
        this.jLabelFilterSettings.setName("jLabelFilterSettings");
        this.jButtonFilterSettings.setText("jButton1");
        this.jButtonFilterSettings.setMaximumSize(new Dimension(21, 21));
        this.jButtonFilterSettings.setMinimumSize(new Dimension(21, 21));
        this.jButtonFilterSettings.setName("jButtonFilterSettings");
        this.jButtonFilterSettings.setPreferredSize(new Dimension(21, 21));
        this.jButtonFilterSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONPanel.this.jButtonFilterSettingsActionPerformed(actionEvent);
            }
        });
        this.jTabbedPane.setName("jTabbedPane");
        this.jInfoPanel.setName("jInfoPanel");
        this.jInfoPanel.setPreferredSize(new Dimension(0, 30));
        this.jInfoPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 785, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jColumnLabel, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jColumnComboBox, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jStatusIconLabel).addGap(18, 18, 18).addComponent(this.jLabelFilterSettings, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterSettings, -2, -1, -2)).addComponent(this.jInfoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jColumnLabel).addComponent(this.jColumnComboBox, -2, -1, -2).addComponent(this.jStatusIconLabel)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFilterSettings, -2, -1, -2).addComponent(this.jLabelFilterSettings))).addGap(18, 18, 18).addComponent(this.jTabbedPane, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInfoPanel, -2, -1, -2).addContainerGap()));
    }

    private void jColumnComboBoxActionPerformed(ActionEvent actionEvent) {
        UserObject userObject = (UserObject)this.jColumnComboBox.getSelectedItem();
        if (userObject != SELECT_A_COLUMN) {
            this.jColumnComboBox.removeItem(SELECT_A_COLUMN);
            if (this._curJSONCol != userObject) {
                JSONFilterType jSONFilterType;
                this._parent.setJSONSourceColumn(userObject.getAttr());
                this._curJSONCol = userObject;
                JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
                this._JSONAttributesMap.clear();
                this._JSONFiltersMap.clear();
                if (jSONAttributesType != null) {
                    jSONFilterType = jSONAttributesType.getJSONAttribute().iterator();
                    while (jSONFilterType.hasNext()) {
                        JSONAttributeType jSONAttributeType = (JSONAttributeType)jSONFilterType.next();
                        this._JSONAttributesMap.put(jSONAttributeType.getPath(), jSONAttributeType);
                    }
                }
                if ((jSONFilterType = this._parent.getJSONFilters()) != null) {
                    for (JSONFilterType.FilterElement filterElement : jSONFilterType.getFilterElement()) {
                        this._JSONFiltersMap.put(filterElement.getJSONAttribute().getPath(), filterElement);
                    }
                }
                if (this._JSONStructurePanel2 != null) {
                    if (this._curJSONCol != SELECT_A_COLUMN) {
                        this.reload();
                    }
                    this._parent.setJSONDirty(true);
                }
            }
        }
    }

    private void jButtonFilterSettingsActionPerformed(ActionEvent actionEvent) {
        FilterSettingsPanel filterSettingsPanel = new FilterSettingsPanel(this._parent);
        DialogHelper dialogHelper = new DialogHelper(filterSettingsPanel);
        dialogHelper.showAsDialog(this);
        this.setFilterSettingsLabel();
    }

    protected String getHelpTopic() {
        return "json_attributes";
    }

    private DataGuideType generateDataGuideFromMeta(AttributeType attributeType) {
        DataGuideType dataGuideType = null;
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        JSONAttributesType jSONAttributesType = jSONQueryNodeType.getJSONAttributes();
        if (jSONAttributesType.getSource() != null && jSONAttributesType.getSource().compareTo(attributeType.getName()) == 0) {
            dataGuideType = new DataGuideType();
            for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                DataGuideType.Item item = new DataGuideType.Item();
                item.setPath(jSONAttributeType.getPath());
                item.setType(jSONAttributeType.getDataType());
                dataGuideType.getItem().add(item);
            }
        }
        return dataGuideType;
    }

    private List<JSONAttributeType> collectJSONAttributes() {
        ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        if (null != jSONQueryNodeType.getJSONAttributes()) {
            return jSONQueryNodeType.getJSONAttributes().getJSONAttribute();
        }
        return arrayList;
    }

    @Override
    public void relColNameChanged(String string, String string2) {
    }

    @Override
    public void jsonColNameChanged(String string, String string2, String string3) {
        JSONFilterType jSONFilterType;
        JSONAttributesType jSONAttributesType = this._parent.getJSONAttributes();
        if (jSONAttributesType != null) {
            jSONFilterType = jSONAttributesType.getJSONAttribute().iterator();
            while (jSONFilterType.hasNext()) {
                JSONAttributeType jSONAttributeType = (JSONAttributeType)jSONFilterType.next();
                if (jSONAttributeType.getPath().compareTo(string) != 0 || jSONAttributeType.getDBName().compareTo(string2) != 0) continue;
                jSONAttributeType.setDBName(string3);
            }
        }
        if ((jSONFilterType = this._parent.getJSONFilters()) != null) {
            for (JSONFilterType.FilterElement filterElement : jSONFilterType.getFilterElement()) {
                JSONAttributeType jSONAttributeType = filterElement.getJSONAttribute();
                if (jSONAttributeType.getPath().compareTo(string) != 0 || jSONAttributeType.getDBName().compareTo(string2) != 0) continue;
                jSONAttributeType.setDBName(string3);
            }
        }
    }

    @Override
    public void aggColNameChanged(String string, String string2, List<String> list, String string3, String string4) {
    }

    private void reload() {
        this._JSONStructurePanel2.getJsonTree().getTree().setRootVisible(true);
        DataGuideType dataGuideType = null;
        try {
            dataGuideType = this._parent.getDataGuide();
            this._JSONStructurePanel2.clearTree();
            this._JSONDataPanel.clear();
            if (dataGuideType == null) {
                if (this._parent.getJSONSourceColumn() != null) {
                    dataGuideType = this.generateDataGuideFromMeta(this._parent.getJSONSourceColumn());
                }
                this.jStatusIconLabel.setVisible(true);
                this.jInfoPanel.setVisible(true);
                if (dataGuideType != null) {
                    ((JSONStructureDefaultTreeTableModel)((Object)this._JSONStructurePanel2.getJsonTree().getTree().getModel())).setLoadingStatus();
                    this._JSONStructurePanel2.reload2(this._curJSONCol.getAttr(), null, dataGuideType, this.collectJSONAttributes(), null, false, false);
                }
            } else {
                this.jInfoPanel.setVisible(false);
                this.jStatusIconLabel.setVisible(false);
                if (dataGuideType != null) {
                    ((JSONStructureDefaultTreeTableModel)((Object)this._JSONStructurePanel2.getJsonTree().getTree().getModel())).setLoadingStatus();
                    if (this._withFiltersOnly || this._selectedAttrsOnly) {
                        this._JSONStructurePanel2.reload2(this._curJSONCol.getAttr(), this._parent.getJSONAttributes().getJSONAttribute(), dataGuideType, null, this._parent.getJSONFilters().getFilterElement(), this._withFiltersOnly, this._selectedAttrsOnly);
                    } else {
                        this._JSONStructurePanel2.reload2(this._curJSONCol.getAttr(), this._parent.getJSONAttributes().getJSONAttribute(), dataGuideType, this.collectJSONAttributes(), this._parent.getJSONFilters().getFilterElement(), false, false);
                    }
                    this._JSONDataPanel.reload();
                }
            }
            this._JSONStructurePanel2.updatePanelTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        JSON_STARTING_ARRAY = "$.\"[*]\"";
        SOURCE_TAB = DialogsLrb.get("JSON_QUERY_SOURCE_STRUCTURE_TAB");
        DATA_TAB = DialogsLrb.get("JSON_QUERY_SOURCE_DATA_TAB");
    }

    private class UserObject {
        private AttributeType attr;

        public UserObject(AttributeType attributeType) {
            this.attr = attributeType;
        }

        public String toString() {
            return this.attr.getName();
        }

        public AttributeType getAttr() {
            return this.attr;
        }
    }

    private class JSONStructurePanel2
    extends JSONStructurePanel
    implements JSONAddAggregationSelectionChange {
        private JLabel jViewLabel;
        private JComboBox<String> jViewComboBox;
        private JButton jSelectButton;
        private JButton jDeselectButton;
        private JLabel jFilterLabel;
        private JButton jEditButton;
        private JButton jCopyButton;
        private JButton jPasteButton;
        private JButton jClearButton;
        private JSeparator jSeparator;
        private JSONFilterObject copyFilter;

        public JSONStructurePanel2(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, List<JSONAttributeType> list, List<JSONAttributeType> list2, List<JSONFilterType.FilterElement> list3, DataGuideProvider dataGuideProvider) {
            super(context, abstractDataNode, attributeType, list, list2, list3, dataGuideProvider, true);
            this.copyFilter = null;
        }

        @Override
        protected void setPreferredColumnWidth() {
            this.jsonTree.setAutoResizeMode(3);
            this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_ATTRIBUTE_COLUMN).setPreferredWidth(200);
            this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_DATA_COLUMN).setMinWidth(80);
            this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_DATA_COLUMN).setMaxWidth(80);
            this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_UNNESTED_COLUMN).setMinWidth(60);
            this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_UNNESTED_COLUMN).setMaxWidth(60);
            if (JSONPanel.this._filterSupport) {
                this.jsonTree.getColumnModel().getColumn(JSONElement.JSON_FILTER_COLUMN).setPreferredWidth(200);
            }
        }

        @Override
        protected void setPanelTitle() {
            this.titleLabel.setText(ControlsLrb.get("JSON_GUIDE_STRUCTURE_PANEL_TITLE"));
        }

        private void discardJSONFilterPasteWarning() {
            MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
            Boolean bl = messageDialogPersistence.getConfirmed("warnDiscardJSONFilterPaste");
            if (Boolean.FALSE.equals(bl)) {
                messageDialogPersistence.setConfirmed("warnDiscardJSONFilterPaste", Boolean.valueOf(true));
            }
            MessageDialog.optionalInformation((String)"warnDiscardJSONFilterPaste", (Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER_PASTE_WARNING"), (String)DialogsLrb.get("WARNING_TITLE"), null);
        }

        @Override
        protected void setupControlBar() {
            this.jViewLabel = new JLabel();
            this.jViewComboBox = new JComboBox();
            this.jSelectButton = new JButton();
            this.jDeselectButton = new JButton();
            this.jSeparator = new JSeparator(1);
            String string = DialogsLrb.get("JSON_QUERY_SOURCE_JSON_VIEW_ALL");
            final String string2 = DialogsLrb.get("JSON_QUERY_SOURCE_JSON_VIEW_SELECTED");
            final String string3 = DialogsLrb.get("JSON_QUERY_SOURCE_JSON_VIEW_FILTERS");
            final String string4 = DialogsLrb.get("JSON_QUERY_SOURCE_JSON_VIEW_SELECTED_AND_FILTERS");
            this.jSelectButton.setEnabled(false);
            this.jDeselectButton.setEnabled(false);
            this.jViewLabel.setText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_VIEW"));
            this.jViewLabel.setLabelFor(this.jViewComboBox);
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            if (JSONPanel.this._filterSupport) {
                vector.add(string3);
                vector.add(string4);
            }
            this.jViewComboBox.setModel(new DefaultComboBoxModel(vector));
            this.jViewComboBox.setSelectedItem(string);
            this.jViewComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)JSONStructurePanel2.this.jViewComboBox.getSelectedItem();
                    JSONPanel.this._withFiltersOnly = string.equals(string3) || string.equals(string4);
                    JSONPanel.this._selectedAttrsOnly = string.equals(string2) || string.equals(string4);
                    JSONPanel.this.reload();
                }
            });
            this.jSelectButton.setIcon(OracleIcons.getIcon((String)"messageAsync.png"));
            this.jSelectButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_INCLUDE_ATTRS_TOOLTIP"));
            this.jSelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSONStructurePanel2.this.jsonTree.selectNodes(true);
                }
            });
            this.jDeselectButton.setIcon(DataMinerIcons.get(Icons.ATTR_IGNORE));
            this.jDeselectButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_EXCLUDE_ATTRS_TOOLTIP"));
            this.jDeselectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSONStructurePanel2.this.jsonTree.selectNodes(false);
                }
            });
            this.controlBar.add((Component)this.jViewLabel);
            this.controlBar.add(this.jViewComboBox);
            this.controlBar.add((Component)this.jSelectButton);
            this.controlBar.add((Component)this.jDeselectButton);
            this.controlBar.add((Component)this.jSeparator);
            if (JSONPanel.this._filterSupport) {
                this.jFilterLabel = new JLabel();
                this.jEditButton = new JButton();
                this.jCopyButton = new JButton();
                this.jPasteButton = new JButton();
                this.jClearButton = new JButton();
                this.jEditButton.setEnabled(false);
                this.jCopyButton.setEnabled(false);
                this.jPasteButton.setEnabled(false);
                this.jClearButton.setEnabled(false);
                this.controlBar.add((Component)this.jFilterLabel);
                this.controlBar.add((Component)this.jEditButton);
                this.controlBar.add((Component)this.jCopyButton);
                this.controlBar.add((Component)this.jPasteButton);
                this.controlBar.add((Component)this.jClearButton);
                this.jFilterLabel.setText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER"));
                this.jEditButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
                this.jEditButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER_EDIT_TOOLTIP"));
                this.jEditButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = JSONStructurePanel2.this.jsonTree.getSelectedRows();
                        if (nArray == null || nArray.length == 0) {
                            return;
                        }
                        JSONStructurePanel2.this.jsonTree.editCellAt(nArray[0], JSONElement.JSON_FILTER_COLUMN);
                        JSONFilterCellEditor jSONFilterCellEditor = (JSONFilterCellEditor)JSONStructurePanel2.this.jsonTree.getCellEditor(nArray[0], JSONElement.JSON_FILTER_COLUMN);
                        jSONFilterCellEditor.activate();
                    }
                });
                this.jCopyButton.setIcon(OracleIcons.getIcon((String)"copy.png"));
                this.jCopyButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER_COPY_TOOLTIP"));
                this.jCopyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = JSONStructurePanel2.this.jsonTree.getSelectedRows();
                        if (nArray == null || nArray.length == 0) {
                            return;
                        }
                        boolean bl = false;
                        TreePath treePath = JSONStructurePanel2.this.jsonTree.getTree().getPathForRow(nArray[0]);
                        if (treePath == null) {
                            return;
                        }
                        JSONElement jSONElement = (JSONElement)((Object)treePath.getLastPathComponent());
                        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)JSONStructurePanel2.this.getJsonTree().getTreeModel();
                        String string = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID());
                        if (string == null) {
                            return;
                        }
                        JSONFilterType.FilterElement filterElement = JSONPanel.this._JSONFiltersMap.get(string);
                        if (filterElement != null) {
                            JSONFilterObject jSONFilterObject = (JSONFilterObject)jSONElement.getValue(JSONElement.JSON_FILTER_COLUMN);
                            JSONStructurePanel2.this.copyFilter = new JSONFilterObject(jSONFilterObject.getDataType(), jSONFilterObject.getOperator(), jSONFilterObject.getConditions());
                            bl = true;
                        }
                        JSONStructurePanel2.this.jPasteButton.setEnabled(JSONStructurePanel2.this.copyFilter != null);
                    }
                });
                this.jPasteButton.setIcon(OracleIcons.getIcon((String)"paste.png"));
                this.jPasteButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER_PASTE_TOOLTIP"));
                this.jPasteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = JSONStructurePanel2.this.jsonTree.getSelectedRows();
                        if (nArray == null || nArray.length == 0) {
                            return;
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                        for (int i = 0; i < nArray.length; ++i) {
                            Object object;
                            TreePath treePath = JSONStructurePanel2.this.jsonTree.getTree().getPathForRow(nArray[i]);
                            if (treePath == null) continue;
                            JSONElement jSONElement = (JSONElement)((Object)treePath.getLastPathComponent());
                            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)JSONStructurePanel2.this.getJsonTree().getTreeModel();
                            String string = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID());
                            if (string == null) continue;
                            JSONFilterType.FilterElement filterElement = JSONPanel.this._JSONFiltersMap.get(string);
                            if (filterElement != null) {
                                if (JSONStructurePanel2.this.copyFilter.getDataType().equals(filterElement.getJSONAttribute().getDataType())) {
                                    object = new JSONFilterObject(JSONStructurePanel2.this.copyFilter.getDataType(), JSONStructurePanel2.this.copyFilter.getOperator(), JSONStructurePanel2.this.copyFilter.getConditions());
                                    jSONElement.setValue(object, JSONElement.JSON_FILTER_COLUMN);
                                    filterElement.setOperator(JSONStructurePanel2.this.copyFilter.getOperator());
                                    filterElement.setConditions(JSONStructurePanel2.this.copyFilter.getConditions());
                                    arrayList.add(treePath);
                                    JSONStructurePanel2.this.jsonTree.addRowSelectionInterval(i, i);
                                    bl = true;
                                    continue;
                                }
                                bl2 = true;
                                continue;
                            }
                            object = (String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN);
                            if (JSONStructurePanel2.this.copyFilter.getDataType().equals(object)) {
                                JSONFilterObject jSONFilterObject = new JSONFilterObject(JSONStructurePanel2.this.copyFilter.getDataType(), JSONStructurePanel2.this.copyFilter.getOperator(), JSONStructurePanel2.this.copyFilter.getConditions());
                                jSONElement.setValue(jSONFilterObject, JSONElement.JSON_FILTER_COLUMN);
                                filterElement = new JSONFilterType.FilterElement();
                                JSONAttributeType jSONAttributeType = new JSONAttributeType();
                                jSONAttributeType.setPath(string);
                                jSONAttributeType.setDataType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN));
                                if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                                    jSONAttributeType.setUnnest(Boolean.TRUE);
                                }
                                jSONAttributeType.setDBDataType((String)jSONElement.getValue(JSONElement.JSON_DB_DATA_COLUMN));
                                jSONAttributeType.setDBName((String)jSONElement.getValue(JSONElement.JSON_DB_ATTRIBUTE_COLUMN));
                                jSONAttributeType.setStatus(AttributeStatus.VALID);
                                filterElement.setJSONAttribute(jSONAttributeType);
                                filterElement.setOperator(JSONStructurePanel2.this.copyFilter.getOperator());
                                filterElement.setConditions(JSONStructurePanel2.this.copyFilter.getConditions());
                                JSONPanel.this._JSONFiltersMap.put(string, filterElement);
                                arrayList.add(treePath);
                                JSONStructurePanel2.this.jsonTree.addRowSelectionInterval(i, i);
                                bl = true;
                                continue;
                            }
                            bl2 = true;
                        }
                        if (bl) {
                            JSONPanel.this._parent.getJSONFilters().getFilterElement().clear();
                            JSONPanel.this._parent.getJSONFilters().getFilterElement().addAll(JSONPanel.this._JSONFiltersMap.values());
                            JSONPanel.this._parent.setJSONFilterDirty(true);
                        }
                        if (!arrayList.isEmpty()) {
                            JSONStructurePanel2.this.jsonTree.getTree().clearSelection();
                            JSONStructurePanel2.this.jsonTree.getTree().setSelectionPaths(arrayList.toArray(new TreePath[0]));
                        }
                        if (bl2) {
                            JSONStructurePanel2.this.discardJSONFilterPasteWarning();
                        }
                        JSONStructurePanel2.this.jsonTree.updateUI();
                    }
                });
                this.jClearButton.setIcon(OracleIcons.getIcon((String)"clear.png"));
                this.jClearButton.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_FILTER_CLEAR_TOOLTIP"));
                this.jClearButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JSONStructurePanel2.this.removeFilter();
                    }
                });
            }
            this.listener = new JSONSearchListener(this);
            this.searchField.addSearchListener((SearchListener)this.listener);
            this.controlBar.add((Component)this.searchField);
            this.searchField.setEnabled(true);
        }

        private void removeFilter() {
            int[] nArray = this.jsonTree.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                JSONFilterType.FilterElement filterElement;
                TreePath treePath = this.jsonTree.getTree().getPathForRow(nArray[i]);
                if (treePath == null) continue;
                JSONElement jSONElement = (JSONElement)((Object)treePath.getLastPathComponent());
                JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.getJsonTree().getTreeModel();
                String string = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID());
                if (string == null || (filterElement = JSONPanel.this._JSONFiltersMap.get(string)) == null) continue;
                JSONPanel.this._JSONFiltersMap.remove(string);
                jSONElement.setValue(null, JSONElement.JSON_FILTER_COLUMN);
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONFilters().getFilterElement().clear();
                JSONPanel.this._parent.getJSONFilters().getFilterElement().addAll(JSONPanel.this._JSONFiltersMap.values());
                JSONPanel.this._parent.setJSONFilterDirty(true);
            }
            this.jsonTree.updateUI();
            this.jClearButton.setEnabled(false);
        }

        @Override
        protected void createJSONTree() {
            this.jsonTree = new JSONQueryStructureTreeTable(this.getContext(), JSONPanel.this._filterSupport);
            this.jsonTree.setMultiSelectionMode();
            ((JSONQueryStructureTreeTable)this.jsonTree).addSelectionChangeListener(this);
        }

        @Override
        public void selectionChanged() {
            int[] nArray = this.jsonTree.getSelectedRows();
            if (nArray == null || 0 == nArray.length) {
                if (JSONPanel.this._filterSupport) {
                    this.jEditButton.setEnabled(false);
                    this.jClearButton.setEnabled(false);
                    this.jCopyButton.setEnabled(false);
                    this.jPasteButton.setEnabled(false);
                }
                return;
            }
            this.jSelectButton.setEnabled(nArray.length > 0);
            this.jDeselectButton.setEnabled(nArray.length > 0);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                TreePath treePath = this.jsonTree.getTree().getPathForRow(nArray[i]);
                if (treePath == null) continue;
                JSONElement jSONElement = (JSONElement)((Object)treePath.getLastPathComponent());
                JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.getJsonTree().getTreeModel();
                String string2 = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONElement.getElementID());
                if (string2 == null || !DatabaseMetadataUtils.isJSONPredicateSupported(string = jSONElement.getDataType())) continue;
                bl2 = true;
                if (jSONElement.getFilterConditions() == null || jSONElement.getFilterConditions().isEmpty()) continue;
                bl = true;
            }
            if (JSONPanel.this._filterSupport) {
                this.jClearButton.setEnabled(bl);
                this.jCopyButton.setEnabled(nArray.length == 1 && bl);
                this.jEditButton.setEnabled(nArray.length == 1 && bl2);
            }
        }

        @Override
        protected void updatePanelTitle() {
            ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>(JSONPanel.this._JSONAttributesMap.values());
            String string = "";
            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
            int n = jSONStructureDefaultTreeTableModel.getNodeCount();
            if (1 < n) {
                int n2 = 0;
                if (arrayList != null) {
                    n2 += arrayList.size();
                }
                Object[] objectArray = new Object[]{n2, n - 1};
                string = MessageFormat.format(titleTemplate, objectArray);
            }
            this.titleLabel.setText(string);
        }

        @Override
        public void jsonAttrSelectionChanged(Map<String, Boolean> map) {
            if (map.isEmpty()) {
                return;
            }
            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.getJsonTree().getTreeModel();
            Iterator<String> iterator = map.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                int n;
                String string = iterator.next();
                if (string.compareTo(JSON_STARTING_ARRAY) == 0 || (n = string.lastIndexOf(46)) <= 0) continue;
                JSONAttributeType jSONAttributeType = JSONPanel.this._JSONAttributesMap.get(string);
                if (Boolean.TRUE.equals(map.get(string))) {
                    if (jSONAttributeType != null) continue;
                    jSONAttributeType = new JSONAttributeType();
                    jSONAttributeType.setPath(string);
                    String string2 = StringUtils.trimDoubleQuotes(string.substring(n + 1, string.length()));
                    string2 = string2.toUpperCase();
                    string2 = string2.replaceAll("\\s+", "");
                    JSONElement jSONElement = jSONStructureDefaultTreeTableModel.getNodeByPath(string);
                    jSONAttributeType.setDataType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN));
                    if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                        jSONAttributeType.setUnnest(Boolean.TRUE);
                    }
                    jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN)));
                    jSONAttributeType.setDBName(JSONPanel.this._parent.getNameGenerator().GenerateName(string2, jSONAttributeType.getPath()));
                    jSONAttributeType.setStatus(AttributeStatus.VALID);
                    JSONPanel.this._JSONAttributesMap.put(string, jSONAttributeType);
                    bl = true;
                    continue;
                }
                if (jSONAttributeType == null) continue;
                JSONPanel.this._JSONAttributesMap.remove(string);
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().clear();
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().addAll(JSONPanel.this._JSONAttributesMap.values());
                JSONPanel.this._parent.setJSONDirty(true);
            }
            super.jsonAttrSelectionChanged(map);
        }

        @Override
        public void jsonAttrUnnestedChanged(Map<String, Boolean> map) {
            if (map.isEmpty()) {
                return;
            }
            Iterator<String> iterator = map.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                JSONAttributeType jSONAttributeType;
                int n;
                String string = iterator.next();
                if (string.compareTo(JSON_STARTING_ARRAY) == 0 || (n = string.lastIndexOf(46)) <= 0 || (jSONAttributeType = JSONPanel.this._JSONAttributesMap.get(string)) == null) continue;
                if (Boolean.TRUE.equals(map.get(string))) {
                    jSONAttributeType.setUnnest(Boolean.TRUE);
                    jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType(jSONAttributeType.getDataType()));
                    bl = true;
                    continue;
                }
                jSONAttributeType.setUnnest(Boolean.FALSE);
                jSONAttributeType.setDBDataType("VARCHAR2");
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().clear();
                JSONPanel.this._parent.getJSONAttributes().getJSONAttribute().addAll(JSONPanel.this._JSONAttributesMap.values());
                JSONPanel.this._parent.setJSONDirty(true);
            }
        }

        @Override
        public void jsonAttrFilterChanged(Map<String, JSONFilterObject> map) {
            if (map.isEmpty()) {
                return;
            }
            JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.getJsonTree().getTreeModel();
            Iterator<String> iterator = map.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = iterator.next();
                int n = string.lastIndexOf(46);
                JSONFilterType.FilterElement filterElement = JSONPanel.this._JSONFiltersMap.get(string);
                if (map.get(string) != null && map.get(string).getConditions() != null && !map.get(string).getConditions().isEmpty()) {
                    if (filterElement == null) {
                        filterElement = new JSONFilterType.FilterElement();
                        JSONAttributeType jSONAttributeType = new JSONAttributeType();
                        jSONAttributeType.setPath(string);
                        String string2 = StringUtils.trimDoubleQuotes(string.substring(n + 1, string.length()));
                        string2 = string2.toUpperCase();
                        string2 = string2.replaceAll("\\s+", "");
                        JSONElement jSONElement = jSONStructureDefaultTreeTableModel.getNodeByPath(string);
                        jSONAttributeType.setDataType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN));
                        if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                            jSONAttributeType.setUnnest(Boolean.TRUE);
                        }
                        jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONElement.getValue(JSONElement.JSON_DATA_COLUMN)));
                        jSONAttributeType.setDBName(JSONPanel.this._parent.getNameGenerator().GenerateName(string2, jSONAttributeType.getPath()));
                        jSONAttributeType.setStatus(AttributeStatus.VALID);
                        filterElement.setJSONAttribute(jSONAttributeType);
                        JSONPanel.this._JSONFiltersMap.put(string, filterElement);
                    }
                    filterElement.setOperator(map.get(string).getOperator());
                    filterElement.setConditions(map.get(string).getConditions());
                    bl = true;
                    continue;
                }
                if (filterElement == null) continue;
                JSONPanel.this._JSONFiltersMap.remove(string);
                bl = true;
            }
            if (bl) {
                JSONPanel.this._parent.getJSONFilters().getFilterElement().clear();
                JSONPanel.this._parent.getJSONFilters().getFilterElement().addAll(JSONPanel.this._JSONFiltersMap.values());
                JSONPanel.this._parent.setJSONFilterDirty(true);
            }
        }
    }
}

