/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.xmlschema.JSONFilterType;

public class FilterSettingsPanel
extends JPanel
implements DialogDisplayable {
    private JSONQueryEditorPanel _parent;
    private JSONFilterType _filterSetting;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JLabel jLabelFilterApply;
    private JLabel jLabelFilterMatches;
    private JRadioButton jRadioButtonApplyAggreg;
    private JRadioButton jRadioButtonApplyAll;
    private JRadioButton jRadioButtonApplyUnnest;
    private JRadioButton jRadioButtonMatchAll;
    private JRadioButton jRadioButtonMatchAny;

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return DialogsLrb.get("JSON_FILTER_SETTINGS_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "json_filter_settings_id";
            }

            @Override
            public int getButtonMask() {
                return 7;
            }

            @Override
            public JComponent getContent() {
                return FilterSettingsPanel.this;
            }

            @Override
            public void onOK() throws DialogExecutionException {
                FilterSettingsPanel.this._filterSetting.setMatch(FilterSettingsPanel.this.jRadioButtonMatchAll.isSelected() ? "All" : "Any");
                FilterSettingsPanel.this._filterSetting.setUseBy(FilterSettingsPanel.this.jRadioButtonApplyUnnest.isSelected() ? "Unnest" : (FilterSettingsPanel.this.jRadioButtonApplyAggreg.isSelected() ? "Aggregation" : "All"));
                FilterSettingsPanel.this._parent.setJSONFilters(FilterSettingsPanel.this._filterSetting);
            }
        };
    }

    public FilterSettingsPanel(JSONQueryEditorPanel jSONQueryEditorPanel) {
        this._parent = jSONQueryEditorPanel;
        this._filterSetting = this._parent.getJSONFilters();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        this.jLabelFilterMatches.setText(DialogsLrb.get("JSON_QUERY_SOURCE_FILTER_SETTINGS"));
        this.jRadioButtonMatchAll.setText(ServerConstantsLrb.get("JSON_FILTER_MATCH_TYPE_ALL"));
        this.jRadioButtonMatchAny.setText(ServerConstantsLrb.get("JSON_FILTER_MATCH_TYPE_ANY"));
        this.jLabelFilterApply.setText(DialogsLrb.get("JSON_FILTER_SETTINGS_APPLY"));
        this.jRadioButtonApplyUnnest.setText(ServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_UNNEST"));
        this.jRadioButtonApplyAggreg.setText(ServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_AGGREG"));
        this.jRadioButtonApplyAll.setText(ServerConstantsLrb.get("JSON_FILTER_APPLY_TYPE_ALL"));
    }

    private void initUI() {
        this.jRadioButtonMatchAll.setSelected(ServerConstants.JSONFilterMatchSetting.isMatchAll((String)this._filterSetting.getMatch()));
        this.jRadioButtonMatchAny.setSelected(ServerConstants.JSONFilterMatchSetting.isMatchAny((String)this._filterSetting.getMatch()));
        this.jRadioButtonApplyUnnest.setSelected(ServerConstants.JSONFilterApplySetting.isApplyUnnest((String)this._filterSetting.getUseBy()));
        this.jRadioButtonApplyAggreg.setSelected(ServerConstants.JSONFilterApplySetting.isApplyAggreg((String)this._filterSetting.getUseBy()));
        this.jRadioButtonApplyAll.setSelected(ServerConstants.JSONFilterApplySetting.isApplyAll((String)this._filterSetting.getUseBy()));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabelFilterMatches = new JLabel();
        this.jRadioButtonMatchAll = new JRadioButton();
        this.jRadioButtonMatchAny = new JRadioButton();
        this.jLabelFilterApply = new JLabel();
        this.jRadioButtonApplyUnnest = new JRadioButton();
        this.jRadioButtonApplyAggreg = new JRadioButton();
        this.jRadioButtonApplyAll = new JRadioButton();
        this.jLabelFilterMatches.setText("Filter Matches:");
        this.buttonGroup1.add(this.jRadioButtonMatchAll);
        this.jRadioButtonMatchAll.setText("All");
        this.buttonGroup1.add(this.jRadioButtonMatchAny);
        this.jRadioButtonMatchAny.setText("Any");
        this.jLabelFilterApply.setText("Filter Applies To:");
        this.buttonGroup2.add(this.jRadioButtonApplyUnnest);
        this.jRadioButtonApplyUnnest.setText("JSON Unnest");
        this.buttonGroup2.add(this.jRadioButtonApplyAggreg);
        this.jRadioButtonApplyAggreg.setText("Aggregations");
        this.buttonGroup2.add(this.jRadioButtonApplyAll);
        this.jRadioButtonApplyAll.setText("JSON Unnest and Aggregations");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelFilterMatches).addComponent(this.jLabelFilterApply).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonApplyUnnest).addComponent(this.jRadioButtonMatchAny).addComponent(this.jRadioButtonMatchAll).addComponent(this.jRadioButtonApplyAggreg).addComponent(this.jRadioButtonApplyAll)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFilterMatches).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonMatchAny).addGap(18, 18, 18).addComponent(this.jLabelFilterApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonApplyUnnest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonApplyAggreg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonApplyAll).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

