/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.AttributeTypeCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.NameChangeListener;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.SuppAttrsPanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;

public class AdditionalOutputPanel
extends AbstractPanel<JSONQueryNode>
implements NameChangeListener {
    private JSONQueryEditorPanel _parent;
    private RelationalAttributesType _relationalAttributes;
    private AttrTableModel<AttributeExType> _models;
    private JButton _addBtn;
    private JButton _removeBtn;
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JCheckBox jAutoSettingsCheckBox;
    private DataMinerTablePanel tablePanel;

    public AdditionalOutputPanel(Context context, JSONQueryEditorPanel jSONQueryEditorPanel) {
        super(context, null);
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        this._relationalAttributes = jSONQueryEditorPanel.getRelationalAttributes();
        this._relationalAttributes = this._relationalAttributes == null ? new RelationalAttributesType() : this._relationalAttributes;
        jSONQueryEditorPanel.setRelationalAttributes(this._relationalAttributes);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.jAutoSettingsCheckBox.setVisible(false);
        this._models = new AttrTableModel(this._relationalAttributes == null ? null : this._relationalAttributes.getAttribute());
        this._removeBtn.setEnabled(false);
        this.tablePanel.addControlBarComponents(this._addBtn, this._removeBtn);
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("JSON_QUERY_ADDITIONAL_TABLE_TITLE"), 0, true);
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalOutputPanel.this.processAdd();
            }
        });
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("JSON_QUERY_ADDITIONAL_REMOVE_ATTRIBUTE"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                AdditionalOutputPanel.this.processRemove();
            }
        });
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AdditionalOutputPanel.this.handleModelSelectionChanged();
            }
        });
        AttributeTypeCellRenderer attributeTypeCellRenderer = new AttributeTypeCellRenderer();
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(attributeTypeCellRenderer);
        this.enableControls();
    }

    private void enableControls() {
        int n = this.tablePanel.getTable().getSelectedRowCount();
        this._removeBtn.setEnabled(n > 0);
    }

    private void processAdd() {
        SuppAttrsPanel suppAttrsPanel = new SuppAttrsPanel(this.getContext(), this, this._parent.getAvailRelationalAttributes(), this._relationalAttributes);
        if (suppAttrsPanel.showAsDialog(this) && suppAttrsPanel.isDirty()) {
            List<AttributeExType> list = suppAttrsPanel.getSelectedAttrsCache();
            for (AttributeExType attributeExType : list) {
                String string = this._parent.getNameGenerator().GenerateName(attributeExType.getName(), attributeExType.getName());
                if (attributeExType.getName().compareTo(string) == 0) continue;
                attributeExType.setAlias(string);
            }
            this._relationalAttributes.getAttribute().clear();
            this._relationalAttributes.getAttribute().addAll(list);
            this._models.setSrcData(this._relationalAttributes.getAttribute());
            if (suppAttrsPanel.isDirty()) {
                this._parent.setRelationalDirty(true);
            }
        }
    }

    private void processRemove() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<AttributeExType> arrayList = new ArrayList<AttributeExType>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            AttributeExType attributeExType = (AttributeExType)this._relationalAttributes.getAttribute().get(n);
            arrayList.add(attributeExType);
        }
        for (AttributeExType attributeExType : arrayList) {
            this._relationalAttributes.getAttribute().remove(attributeExType);
        }
        this._models.setSrcData(this._relationalAttributes.getAttribute());
        this._parent.setRelationalDirty(true);
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    @Override
    public void relColNameChanged(String string, String string2) {
        RelationalAttributesType relationalAttributesType = this._parent.getRelationalAttributes();
        if (relationalAttributesType != null) {
            for (AttributeExType attributeExType : relationalAttributesType.getAttribute()) {
                String string3 = attributeExType.getAlias() != null ? attributeExType.getAlias() : attributeExType.getName();
                if (string3.compareTo(string) != 0) continue;
                attributeExType.setAlias(string2);
            }
        }
    }

    @Override
    public void jsonColNameChanged(String string, String string2, String string3) {
    }

    @Override
    public void aggColNameChanged(String string, String string2, List<String> list, String string3, String string4) {
    }

    private void initComponents() {
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this._removeBtn = new JButton();
        this._addBtn = new JButton();
        this.jAutoSettingsCheckBox = new JCheckBox();
        this.tablePanel = new DataMinerTablePanel();
        this.componentWithTitlebar.setAutoscrolls(true);
        this.componentWithTitlebar.setName("componentWithTitlebar");
        this._removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_ADDITIONAL_DELETE_OUTPUT_COLUMNS"));
        this._removeBtn.setName("_removeBtn");
        this._addBtn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_ADDITIONAL_EDIT_OUTPUT_COLUMNS"));
        this._addBtn.setName("_addBtn");
        this.setPreferredSize(new Dimension(950, 400));
        this.jAutoSettingsCheckBox.setText("Automatic Settings");
        this.jAutoSettingsCheckBox.setName("jAutoSettingsCheckBox");
        this.jAutoSettingsCheckBox.setOpaque(false);
        this.jAutoSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalOutputPanel.this.jAutoSettingsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 717, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAutoSettingsCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jAutoSettingsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 357, Short.MAX_VALUE).addContainerGap()));
    }

    private void jAutoSettingsCheckBoxActionPerformed(ActionEvent actionEvent) {
    }
}

