/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.featureCompare;

import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareAddOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareEditorState;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareInputPanel;
import oracle.dmt.dataminer.workflow.model.FeatureCompareNode;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureCompareNodeType;
import oracle.ide.Context;

public class FeatureCompareEditorPanel
extends JPanel
implements DialogDisplayable {
    private FeatureCompareInputPanel inputPanel;
    private FeatureCompareAddOutputPanel outputPanel;
    private FeatureCompareEditorState state;
    private FeatureCompareNode node;
    private Context context;
    private PropertyModel model;
    private JTabbedPane editorTabbedPane;

    public FeatureCompareEditorPanel(Context context, FeatureCompareNode featureCompareNode, PropertyModel propertyModel) {
        this.node = featureCompareNode;
        this.context = context;
        this.model = propertyModel;
        this.state = new FeatureCompareEditorState();
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.inputPanel = new FeatureCompareInputPanel(this.context, this.node, this.state, this.model);
        this.editorTabbedPane.add(DialogsLrb.get("FEATURE_COMPARE_INPUT_TAB"), this.inputPanel);
        this.outputPanel = new FeatureCompareAddOutputPanel(this.context, this.node, this.state, this.model);
        this.editorTabbedPane.add(DialogsLrb.get("FEATURE_COMPARE_ADD_INPUT_TAB"), this.outputPanel);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)FeatureCompareEditorPanel.this.node.getData();
                if (FeatureCompareEditorPanel.this.inputPanel.isDirty() || FeatureCompareEditorPanel.this.outputPanel.isDirty()) {
                    if (FeatureCompareEditorPanel.this.inputPanel.isModelDirty()) {
                        featureCompareNodeType.setModelSignature(FeatureCompareEditorPanel.this.inputPanel.getSelectedModel());
                    }
                    featureCompareNodeType.getOutputColumn().setName(FeatureCompareEditorPanel.this.inputPanel.getColumnName());
                    featureCompareNodeType.getOutputColumn().setAutoSpec(FeatureCompareEditorPanel.this.inputPanel.isAutoColumn() ? AutoSpecType.YES : AutoSpecType.NO);
                    featureCompareNodeType.setDataInput1(FeatureCompareEditorPanel.this.inputPanel.getDataInput1());
                    featureCompareNodeType.setDataInput2(FeatureCompareEditorPanel.this.inputPanel.getDataInput2());
                    featureCompareNodeType.setSupplementalAttributes(FeatureCompareEditorPanel.this.state.getSupplementalAttributes());
                    FeatureCompareEditorPanel.this.node.validate(true);
                }
            }

            @Override
            public String getTitle() {
                return DialogsLrb.get("DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "featurecompare_node";
            }

            @Override
            public JComponent getContent() {
                return FeatureCompareEditorPanel.this;
            }
        };
    }

    private void initComponents() {
        this.editorTabbedPane = new JTabbedPane();
        this.setPreferredSize(new Dimension(800, 500));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.editorTabbedPane, -1, 380, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.editorTabbedPane, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }
}

