/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;

public class PredictionTargetsTableModel
extends ODMrTableModel<MiningAttributeType> {
    private static final String[] COLUMNS = new String[]{PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_NAME"), PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_DATA_TYPE"), DynamicNodesLrb.get("BUILD_DATA_USAGE_MINING_TYPE")};
    public static final int NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int MINING_TYPE = 2;
    private boolean writable = true;

    public PredictionTargetsTableModel(TargetAttributes targetAttributes) {
        super(COLUMNS);
        for (MiningAttributeType miningAttributeType : targetAttributes.getMiningAttribute()) {
            this.srcData.add(miningAttributeType);
        }
    }

    public void setWritable(boolean bl) {
        this.writable = bl;
    }

    public int getRow(String string) {
        for (int i = 0; i < this.srcData.size(); ++i) {
            if (!((MiningAttributeType)this.srcData.get(i)).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Object getValueAt(int n, int n2) {
        if (this.srcData.isEmpty()) {
            return "";
        }
        if (n >= this.srcData.size()) {
            return "";
        }
        MiningAttributeType miningAttributeType = (MiningAttributeType)this.srcData.get(n);
        String string = null;
        if (n2 == 0) {
            string = miningAttributeType.getName();
        } else if (n2 == 1) {
            String string2 = miningAttributeType.getDataType();
            String string3 = miningAttributeType.getDataTypeQualifier();
            string = DatabaseMetadataUtils.isACharacterOracleDataType(string2) ? DatabaseMetadataUtils.getJSONDataType(string2, string3) : string2;
        } else if (n2 == 2) {
            String string4 = string = miningAttributeType.getMiningType();
            string = ServerConstants.MiningType.toHuman((String)string4);
        } else assert (false) : "Out of bounds column when accessing items";
        return string != null ? string : "";
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 2) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)this.srcData.get(n);
            return !DatabaseMetadataUtils.isACharacterOracleDataType(miningAttributeType.getDataType()) ? this.writable : false;
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            MiningAttributeType miningAttributeType = (MiningAttributeType)this.srcData.get(n);
            String string = (String)object;
            object = ServerConstants.MiningType.toSchema((String)string);
            miningAttributeType.setMiningType((String)object);
        }
    }

    public String getMaxString(int n) {
        String string = "";
        for (int i = 0; i < this.srcData.size(); ++i) {
            Object object = this.getValueAt(i, n);
            if (object == null || object.toString().length() <= string.length()) continue;
            string = object.toString();
        }
        return string;
    }
}

