/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import java.math.BigInteger;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputColumnNameGenerator;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionDetailsType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionProbabilityType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionSetType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionType;

public class ColumnGeneratorHelper {
    public static DynamicApplyOutputColumnType generateDynamicApplyOutputColumn(Object object, DynamicApplyOutputColumnNameGenerator dynamicApplyOutputColumnNameGenerator, String string) {
        String string2 = object != null ? object.toString() : null;
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = null;
        if (string.equals(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION"))) {
            dynamicApplyOutputColumnType = ColumnGeneratorHelper.generateDefaultPredictionOutput(string2, dynamicApplyOutputColumnNameGenerator, false);
        } else if (string.equals(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_PROBABILITY"))) {
            dynamicApplyOutputColumnType = ColumnGeneratorHelper.generateDefaultPredictionProbabilityOutput(string2, dynamicApplyOutputColumnNameGenerator, false);
        } else if (string.equals(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_DETAILS"))) {
            dynamicApplyOutputColumnType = ColumnGeneratorHelper.generateDefaultPredictionDetailsOutput(string2, dynamicApplyOutputColumnNameGenerator, false);
        } else if (string.equals(ServerConstants.ApplyPredictionFunctions.toHuman((String)"PREDICTION_SET"))) {
            dynamicApplyOutputColumnType = ColumnGeneratorHelper.generateDefaultPredictionSetOutput(string2, dynamicApplyOutputColumnNameGenerator, false);
        }
        return dynamicApplyOutputColumnType;
    }

    public static DynamicApplyOutputColumnType generateDefaultPredictionDetailsOutput(String string, DynamicApplyOutputColumnNameGenerator dynamicApplyOutputColumnNameGenerator, boolean bl) {
        PredictionDetailsType predictionDetailsType = new PredictionDetailsType();
        PredictionDetailsType.Column column = new PredictionDetailsType.Column();
        column.setName(dynamicApplyOutputColumnNameGenerator.generatePredictionDetailsColumnName(string, bl));
        column.setSort("ABS");
        column.setTargetValue(null);
        column.setTopNValue(new BigInteger("5"));
        predictionDetailsType.setColumn(column);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = new DynamicApplyOutputColumnType();
        dynamicApplyOutputColumnType.setPredictionDetails(predictionDetailsType);
        dynamicApplyOutputColumnType.setTargetAttributeName(string);
        return dynamicApplyOutputColumnType;
    }

    public static DynamicApplyOutputColumnType generateDefaultPredictionProbabilityOutput(String string, DynamicApplyOutputColumnNameGenerator dynamicApplyOutputColumnNameGenerator, boolean bl) {
        PredictionProbabilityType predictionProbabilityType = new PredictionProbabilityType();
        PredictionProbabilityType.Column column = new PredictionProbabilityType.Column();
        column.setName(dynamicApplyOutputColumnNameGenerator.generatePredictionProbabilityColumnName(string, bl));
        predictionProbabilityType.setColumn(column);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = new DynamicApplyOutputColumnType();
        dynamicApplyOutputColumnType.setPredictionProbability(predictionProbabilityType);
        dynamicApplyOutputColumnType.setTargetAttributeName(string);
        return dynamicApplyOutputColumnType;
    }

    public static DynamicApplyOutputColumnType generateDefaultPredictionSetOutput(String string, DynamicApplyOutputColumnNameGenerator dynamicApplyOutputColumnNameGenerator, boolean bl) {
        PredictionSetType predictionSetType = new PredictionSetType();
        PredictionSetType.Column column = new PredictionSetType.Column();
        column.setName(dynamicApplyOutputColumnNameGenerator.generatePredictionSetColumnName(string, bl));
        column.setTopNValue(PredictionFunctionsHelper.TOPN_VALUE);
        predictionSetType.setColumn(column);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = new DynamicApplyOutputColumnType();
        dynamicApplyOutputColumnType.setPredictionSet(predictionSetType);
        dynamicApplyOutputColumnType.setTargetAttributeName(string);
        return dynamicApplyOutputColumnType;
    }

    public static DynamicApplyOutputColumnType generateDefaultPredictionOutput(String string, DynamicApplyOutputColumnNameGenerator dynamicApplyOutputColumnNameGenerator, boolean bl) {
        PredictionType predictionType = new PredictionType();
        PredictionType.CostOption costOption = new PredictionType.CostOption();
        costOption.setNone(new PredictionType.CostOption.None());
        predictionType.setCostOption(costOption);
        PredictionType.Column column = new PredictionType.Column();
        column.setName(dynamicApplyOutputColumnNameGenerator.generatePredictionColumnName(string, bl));
        predictionType.setColumn(column);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = new DynamicApplyOutputColumnType();
        dynamicApplyOutputColumnType.setPrediction(predictionType);
        dynamicApplyOutputColumnType.setTargetAttributeName(string);
        return dynamicApplyOutputColumnType;
    }
}

