/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.AttributeNameCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class DataProfileAttributesPanel
extends AbstractPanel<AbstractDataNode>
implements DataConsumerPanel {
    protected List<AttributeType> availAttrsCache;
    protected List<AttributeType> selectedAttrsCache;
    private List<String> _allowedAttributes = new ArrayList<String>();
    private HashMap<String, AttributeType> _allAttributesMap = new HashMap();
    private static final String DEFAULT_GROUP_VALUE = DataDialogsLrb.get("PROFILE_GROUP_BY_DEFAULT_VALUE");
    private static final String GROUP_VALUE_NONE = DataDialogsLrb.get("PROFILE_GROUP_BY_NONE");
    private DataMinerTablePanel availAttrsPanel;
    private JCheckBox jChkBoxAuto;
    private JComboBox jCmblGroupBy;
    private JLabel jLblGroupBy;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selAttrsPanel;

    public DataProfileAttributesPanel(Context context, AbstractDataNode abstractDataNode, List<AttributeType> list) {
        super(context, abstractDataNode);
        this.availAttrsCache = list;
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        for (AttributeType attributeType : this.availAttrsCache) {
            this._allAttributesMap.put(attributeType.getName(), attributeType);
            try {
                if (DatabaseMetadataUtils.isACustomDataType(this._context, attributeType.getDataType())) {
                    continue;
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                return;
            }
            String string = DatabaseMetadataUtils.getDefaultMiningType(attributeType.getDataType());
            if (!string.equals("Numerical") && !string.equals("Categorical")) continue;
            this._allowedAttributes.add(attributeType.getName());
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLblGroupBy = new JLabel();
        this.jCmblGroupBy = new DataMinerCombBox();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jChkBoxAuto = new JCheckBox();
        this.availAttrsPanel = new DataMinerTablePanel();
        this.selAttrsPanel = new DataMinerTablePanel();
        this.jLblGroupBy.setText("Group By:");
        this.jCmblGroupBy.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLblGroupBy, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCmblGroupBy, 0, 260, Short.MAX_VALUE).addGap(249, 249, 249)).addComponent(this.jChkBoxAuto, -2, 269, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.availAttrsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addComponent(this.selAttrsPanel, -1, -1, Short.MAX_VALUE))).addGap(10, 10, 10)));
        groupLayout.linkSize(0, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblGroupBy).addComponent(this.jCmblGroupBy, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkBoxAuto).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selAttrsPanel, -1, 352, Short.MAX_VALUE).addComponent(this.availAttrsPanel, GroupLayout.Alignment.TRAILING, -1, 352, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(47, 47, 47).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSelectBtn).addGap(64, 64, 64).addComponent(this.jRemoveAllBtn))))).addContainerGap()));
        groupLayout.linkSize(1, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblGroupBy, (Component)this.jCmblGroupBy, (String)DataDialogsLrb.get("PROFILE_GROUP_BY_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    protected List<AttributeType> getSelectedAttributes() {
        Object a = this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)((AbstractNode)a).getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        List<Object> list = new ArrayList<AttributeType>();
        if (null != dataProfileInputType.getAttributes()) {
            list = dataProfileInputType.getAttributes().getAttribute();
        }
        return list;
    }

    @Override
    public void initUI() {
        Object object;
        List<AttributeType> list = this.getSelectedAttributes();
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        for (AttributeType object22 : list) {
            object = (AttributeType)MetaDataHelper.copyMetadataObject(object22);
            this.selectedAttrsCache.add((AttributeType)object);
        }
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        Object object3 = new AttrTableModel<AttributeType>(this.availAttrsCache);
        this.availAttrsPanel.setup((TableModel)object3, DataDialogsLrb.get("AVAILABLE_LABEL"), 0);
        TableColumn tableColumn = this.availAttrsPanel.getTable().getColumnModel().getColumn(0);
        object = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer((TableCellRenderer)object);
        AttrTableModel<AttributeType> attrTableModel = new AttrTableModel<AttributeType>(this.selectedAttrsCache);
        this.selAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("SELECTED_LABEL"), 0);
        TableColumn tableColumn2 = this.selAttrsPanel.getTable().getColumnModel().getColumn(0);
        object = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn2.setCellRenderer((TableCellRenderer)object);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.selAttrsPanel.getTable(), DataProfileAttributesPanel.this.availAttrsPanel.getTable(), false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.selAttrsPanel.getTable(), DataProfileAttributesPanel.this.availAttrsPanel.getTable(), true);
            }
        });
        this.jLblGroupBy.setLabelFor(this.jCmblGroupBy);
        Collections.sort(this._allowedAttributes);
        Vector<String> vector = new Vector<String>(this._allowedAttributes);
        vector.add(0, DEFAULT_GROUP_VALUE);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        String string = DEFAULT_GROUP_VALUE;
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractDataNode.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != attributeType) {
            string = attributeType.getName();
            if (-1 == this._allowedAttributes.indexOf(string)) {
                defaultComboBoxModel.addElement(string);
            }
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLblGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            defaultComboBoxModel.removeElementAt(0);
            defaultComboBoxModel.insertElementAt(GROUP_VALUE_NONE, 0);
        } else {
            this.jLblGroupBy.setIcon(null);
        }
        this.jCmblGroupBy.setModel(defaultComboBoxModel);
        this.jCmblGroupBy.setSelectedItem(string);
        this.jCmblGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                if (string.equals(GROUP_VALUE_NONE)) {
                    DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                    DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(DEFAULT_GROUP_VALUE, 0);
                    DataProfileAttributesPanel.this.jCmblGroupBy.setSelectedItem(DEFAULT_GROUP_VALUE);
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    return;
                }
                AttributeType attributeType = DataProfileAttributesPanel.this._allAttributesMap.get(string);
                if (attributeType == null) {
                    DataProfileAttributesPanel.this.jLblGroupBy.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    return;
                }
                DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(GROUP_VALUE_NONE, 0);
                boolean bl = attributeType.getStatus().equals((Object)AttributeStatus.VALID);
                DataProfileAttributesPanel.this.jLblGroupBy.setIcon(bl ? null : OracleIcons.getIcon((String)"warning.png"));
            }
        });
        this.jCmblGroupBy.setRenderer(new ToolTipComboBoxRenderer());
        boolean bl = 0 == dataProfileNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl);
        this.enableShuttleButtons(bl);
        this.availAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                boolean bl = !listSelectionModel.isSelectionEmpty() && !DataProfileAttributesPanel.this.jChkBoxAuto.isSelected();
                DataProfileAttributesPanel.this.jSelectBtn.setEnabled(bl);
                boolean bl2 = DataProfileAttributesPanel.this.availAttrsPanel.getTable().getRowCount() > 0;
                DataProfileAttributesPanel.this.jSelectAllBtn.setEnabled(bl2 && !DataProfileAttributesPanel.this.jChkBoxAuto.isSelected());
            }
        });
        this.selAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                boolean bl = !listSelectionModel.isSelectionEmpty() && !DataProfileAttributesPanel.this.jChkBoxAuto.isSelected();
                DataProfileAttributesPanel.this.jRemoveBtn.setEnabled(bl);
                boolean bl2 = DataProfileAttributesPanel.this.selAttrsPanel.getTable().getRowCount() > 0;
                DataProfileAttributesPanel.this.jRemoveAllBtn.setEnabled(bl2 && !DataProfileAttributesPanel.this.jChkBoxAuto.isSelected());
            }
        });
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataProfileAttributesPanel.this.jChkBoxAuto.isSelected();
                DataProfileAttributesPanel.this.enableShuttleButtons(bl);
                if (bl) {
                    DataProfileAttributesPanel.this.moveItems(DataProfileAttributesPanel.this.availAttrsPanel.getTable(), DataProfileAttributesPanel.this.selAttrsPanel.getTable(), true);
                    String string = (String)DataProfileAttributesPanel.this.jCmblGroupBy.getSelectedItem();
                    if (string.equals(DEFAULT_GROUP_VALUE)) {
                        DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                    } else {
                        AttributeType attributeType = DataProfileAttributesPanel.this._allAttributesMap.get(string);
                        if (attributeType == null) {
                            DataProfileAttributesPanel.this.jCmblGroupBy.removeItemAt(0);
                            DataProfileAttributesPanel.this.jCmblGroupBy.insertItemAt(DEFAULT_GROUP_VALUE, 0);
                            DataProfileAttributesPanel.this.jCmblGroupBy.setSelectedItem(DEFAULT_GROUP_VALUE);
                            DataProfileAttributesPanel.this.jLblGroupBy.setIcon(null);
                        }
                    }
                }
            }
        });
    }

    private void enableShuttleButtons(boolean bl) {
        int[] nArray = this.selAttrsPanel.getTable().getSelectedRows();
        boolean bl2 = this.selAttrsPanel.getTable().getRowCount() > 0;
        int[] nArray2 = this.availAttrsPanel.getTable().getSelectedRows();
        boolean bl3 = this.availAttrsPanel.getTable().getRowCount() > 0;
        boolean bl4 = nArray != null && nArray.length > 0;
        boolean bl5 = nArray2 != null && nArray2.length > 0;
        this.jSelectBtn.setEnabled(bl4 && !bl);
        this.jRemoveAllBtn.setEnabled(bl2 && !bl);
        this.jRemoveBtn.setEnabled(bl5 && !bl);
        this.jSelectAllBtn.setEnabled(bl3 && !bl);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = (AttributeType)list.get(nArray[n2]);
                arrayList.add((AttributeType)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add((AttributeType)list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((AttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            object2[n] = (AttributeType)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this.jRemoveAllBtn.setEnabled(this.selAttrsPanel.getTable().getRowCount() != 0);
        this.jSelectAllBtn.setEnabled(this.availAttrsPanel.getTable().getRowCount() != 0);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName()) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<Property> getResults() {
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType.setAttributes(attributes);
        String string = this.jCmblGroupBy.getSelectedItem().toString();
        AttributeType attributeType = this._allAttributesMap.get(string);
        dataProfileInputType.setGroupByAttribute(attributeType);
        List list = attributes.getAttribute();
        list.addAll(this.selectedAttrsCache);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(DataProfileNode.DATAPROFILE_INPUT, null, dataProfileInputType, null, null));
        String string2 = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
        AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string2);
        arrayList.add(new Property(String.valueOf("autoSpec"), null, autoSpecType, null, null));
        arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
        return arrayList;
    }
}

