/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelNMFBuildSettingsPanel
extends AbstractPropertiesPanel {
    private boolean is122andUp;
    private boolean isModelPartitioned = false;
    private JCheckBox jCheckBoxNumOfFeatures;
    private JLabel jLabelConvTolerance;
    private JLabel jLabelNumIterations;
    private JLabel jLabelRandomSeed;
    private JScrollPane jScrollPane1;
    private JTextField jTextConvTolerance;
    private JTextField jTextFieldNumOfFeatures;
    private JTextField jTextNumIterations;
    private JTextField jTextRandomSeed;
    private JLabel lblNonNegativeScoring;
    private JComboBox nonNegativeScoringComboBox;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelNMFBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        Version version = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        this.is122andUp = DbVersionHelper.isDB122Up((Version)version);
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.intRes();
        this.initUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jCheckBoxNumOfFeatures = new JCheckBox();
        this.jTextFieldNumOfFeatures = new NumberTextField();
        this.jLabelConvTolerance = new JLabel();
        this.jTextConvTolerance = new NumberTextField();
        this.jLabelNumIterations = new JLabel();
        this.jTextNumIterations = new NumberTextField();
        this.jLabelRandomSeed = new JLabel();
        this.jTextRandomSeed = new NumberTextField();
        this.lblNonNegativeScoring = new JLabel();
        this.nonNegativeScoringComboBox = new JComboBox();
        this.jScrollPane1.setBorder(null);
        this.jCheckBoxNumOfFeatures.setText("Specify the number of features");
        this.jCheckBoxNumOfFeatures.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxNumOfFeatures.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNumOfFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelNMFBuildSettingsPanel.this.jCheckBoxNumOfFeaturesActionPerformed(actionEvent);
            }
        });
        this.jTextFieldNumOfFeatures.setText("1");
        this.jLabelConvTolerance.setText("Convergence tolerance:");
        this.jLabelNumIterations.setText("Number of iterations:");
        this.jLabelRandomSeed.setText("Random seed:");
        this.lblNonNegativeScoring.setText("Non negative Scoring:");
        this.nonNegativeScoringComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 394, Short.MAX_VALUE).addContainerGap(26, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jTextFieldNumOfFeatures, -2, 86, -2)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jCheckBoxNumOfFeatures)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelNumIterations, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextNumIterations, -2, 110, -2)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelConvTolerance, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextConvTolerance, -2, 110, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelRandomSeed, -2, 107, -2).addComponent(this.lblNonNegativeScoring)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextRandomSeed, -1, 110, Short.MAX_VALUE).addComponent(this.nonNegativeScoringComboBox, 0, -1, Short.MAX_VALUE)))))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jLabelConvTolerance, this.jLabelNumIterations, this.jLabelRandomSeed);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNumOfFeatures).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNumOfFeatures, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelConvTolerance).addComponent(this.jTextConvTolerance, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumIterations).addComponent(this.jTextNumIterations, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRandomSeed).addComponent(this.jTextRandomSeed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNonNegativeScoring).addComponent(this.nonNegativeScoringComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jCheckBoxNumOfFeaturesActionPerformed(ActionEvent actionEvent) {
    }

    private void intRes() {
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxNumOfFeatures, (String)AlgSettingsLrb.get("FEAT_NUM_FEATURES"));
        ResourceUtils.resLabel((JLabel)this.jLabelConvTolerance, (Component)this.jTextConvTolerance, (String)AlgSettingsLrb.get("NMFS_CONV_TOLERANCE"));
        ResourceUtils.resLabel((JLabel)this.jLabelNumIterations, (Component)this.jTextNumIterations, (String)AlgSettingsLrb.get("NMFS_NUM_ITERATIONS"));
        ResourceUtils.resLabel((JLabel)this.jLabelRandomSeed, (Component)this.jTextRandomSeed, (String)AlgSettingsLrb.get("NMFS_RANDOM_SEED"));
        if (this.is122andUp) {
            ResourceUtils.resLabel((JLabel)this.lblNonNegativeScoring, (Component)this.nonNegativeScoringComboBox, (String)AlgSettingsLrb.get("NMFS_NON_NEGATIVE_SCORING"));
        }
    }

    private void initUI() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPane1);
        this.setDataType(this.jTextFieldNumOfFeatures, Integer.class);
        this.setDataType(this.jTextConvTolerance, Double.class);
        ((NumberTextField)this.jTextConvTolerance).setDecimal(true, 4);
        this.setDataType(this.jTextNumIterations, Integer.class);
        this.setDataType(this.jTextRandomSeed, Integer.class);
        this.setSigned(this.jTextFieldNumOfFeatures, false);
        this.setSigned(this.jTextConvTolerance, false);
        this.setSigned(this.jTextNumIterations, false);
        this.setSigned(this.jTextRandomSeed, true);
        this.setLocale(this.jTextFieldNumOfFeatures, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextConvTolerance, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextNumIterations, commonSettingDataObject.getLocale());
        this.setLocale(this.jTextRandomSeed, commonSettingDataObject.getLocale());
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("FEAT_NUM_FEATURES");
        if (bigDecimal == null || 0 == bigDecimal.compareTo(BigDecimal.ZERO)) {
            this.jCheckBoxNumOfFeatures.setSelected(false);
            this.jTextFieldNumOfFeatures.setEnabled(false);
            commonSettingDataObject.setBackupNullValue("FEAT_NUM_FEATURES");
        } else {
            commonSettingDataObject.setBackupValue("FEAT_NUM_FEATURES", bigDecimal);
            this.jCheckBoxNumOfFeatures.setSelected(true);
            this.setNumber(this.jTextFieldNumOfFeatures, bigDecimal);
            this.jTextFieldNumOfFeatures.setToolTipText(AlgSettingsLrb.get("FEAT_NUM_FEATURES_TOOLTIP"));
        }
        this.jCheckBoxNumOfFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    ModelNMFBuildSettingsPanel.this.jTextFieldNumOfFeatures.setEnabled(jCheckBox.isSelected());
                }
            }
        });
        BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("NMFS_CONV_TOLERANCE");
        if (bigDecimal2 == null || 0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_CONV_TOLERANCE");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_CONV_TOLERANCE", bigDecimal2);
            this.setNumber(this.jTextConvTolerance, bigDecimal2);
            this.jTextConvTolerance.setToolTipText(AlgSettingsLrb.get("NMFS_CONV_TOLERANCE_TOOLTIP"));
        }
        BigDecimal bigDecimal3 = commonSettingDataObject.getModelSettingNumValue("NMFS_NUM_ITERATIONS");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_NUM_ITERATIONS");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_NUM_ITERATIONS", bigDecimal3);
            this.setNumber(this.jTextNumIterations, bigDecimal3);
            this.jTextNumIterations.setToolTipText(AlgSettingsLrb.get("NMFS_NUM_ITERATIONS_TOOLTIP"));
        }
        BigDecimal bigDecimal4 = commonSettingDataObject.getModelSettingNumValue("NMFS_RANDOM_SEED");
        if (bigDecimal3 == null || 0 == bigDecimal3.compareTo(BigDecimal.ZERO)) {
            commonSettingDataObject.setBackupNullValue("NMFS_RANDOM_SEED");
        } else {
            commonSettingDataObject.setBackupValue("NMFS_RANDOM_SEED", bigDecimal4);
            this.setNumber(this.jTextRandomSeed, bigDecimal4);
        }
        if (this.is122andUp) {
            this.nonNegativeScoringComboBox.removeAllItems();
            this.nonNegativeScoringComboBox.addItem(AlgSettingsLrb.get("NMFS_NONNEG_SCORING_ENABLE"));
            this.nonNegativeScoringComboBox.addItem(AlgSettingsLrb.get("NMFS_NONNEG_SCORING_DISABLE"));
            String string = commonSettingDataObject.getModelSettingStringValue("NMFS_NONNEGATIVE_SCORING");
            if (string == null || "".equals(string) || string.equals("NMFS_NONNEG_SCORING_ENABLE")) {
                this.nonNegativeScoringComboBox.setSelectedIndex(0);
            } else {
                this.nonNegativeScoringComboBox.setSelectedIndex(1);
            }
        } else {
            this.nonNegativeScoringComboBox.setVisible(false);
            this.lblNonNegativeScoring.setVisible(false);
        }
    }

    @Override
    public void processInput() {
        Number number;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        if (this.jCheckBoxNumOfFeatures.isSelected()) {
            number = this.getNumber(this.jTextFieldNumOfFeatures);
            if (null == number || number.intValue() <= 0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("FEAT_NUM_FEATURES_INVALID"));
                return;
            }
            this.setObjectValue("FEAT_NUM_FEATURES", number);
        } else {
            this.setNullObjectValue("FEAT_NUM_FEATURES");
        }
        number = this.getNumber(this.jTextConvTolerance);
        if (null == number || number.doubleValue() <= 0.0 || number.doubleValue() > 0.5) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("NMFS_CONV_TOLERANCE_INVALID"));
            return;
        }
        this.setObjectValue("NMFS_CONV_TOLERANCE", number);
        Number number2 = this.getNumber(this.jTextNumIterations);
        if (null == number2 || number2.intValue() <= 0 || number.intValue() > 500) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("NMFS_NUM_ITERATIONS_INVALID"));
            return;
        }
        this.setObjectValue("NMFS_NUM_ITERATIONS", number2);
        Number number3 = this.getNumber(this.jTextRandomSeed);
        this.setObjectValue("NMFS_RANDOM_SEED", number3);
        if (this.is122andUp) {
            String string = this.nonNegativeScoringComboBox.getSelectedItem().toString();
            string = string.equals(AlgSettingsLrb.get("NMFS_NONNEG_SCORING_ENABLE")) ? "NMFS_NONNEG_SCORING_ENABLE" : "NMFS_NONNEG_SCORING_DISABLE";
            this.setObjectValue("NMFS_NONNEGATIVE_SCORING", string);
        }
    }
}

