/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class TextSettingsThemePanel<T extends AbstractBuildNode>
extends AbstractPanel<AbstractBuildNode> {
    private BuildNodeType _buildNodeType = null;
    private BuildNodeType.TextSettings.Theme _theme;
    private BuildNodeType.Stoplists _stoplists;
    private boolean _isLoading = false;
    private boolean _dirty = false;
    private static Icon _editIcon;
    private JButton jEditStoplistButton;
    private JButton jNewStoplistButton;
    private JComboBox<String> jThemeLanguageComboBox;
    private JLabel jThemeLanguageLabel;
    private JLabel jThemeMaxAllDocsLabel;
    private JSpinner jThemeMaxAllDocsSpinner;
    private JComboBox<String> jThemeStoplistComboBox;
    private JLabel jThemeStoplistLabel;
    private JLabel jThemeTokensLabel;

    public TextSettingsThemePanel(Context context, T t, BuildNodeType buildNodeType, BuildNodeType.TextSettings.Theme theme, BuildNodeType.Stoplists stoplists) {
        super(context, t);
        assert (context != null) : "Context must not be null.";
        assert (t != null) : "node node must not be null.";
        this.init(buildNodeType, theme, stoplists);
    }

    private void init(BuildNodeType buildNodeType, BuildNodeType.TextSettings.Theme theme, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._theme = theme;
        this._stoplists = stoplists;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void reload(BuildNodeType buildNodeType, BuildNodeType.TextSettings.Theme theme, BuildNodeType.Stoplists stoplists) {
        this._buildNodeType = buildNodeType;
        this._theme = theme;
        this._stoplists = stoplists;
        this.refreshUI();
    }

    @Override
    public void initUI() {
        this._isLoading = true;
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        Vector<String> vector = new Vector<String>();
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE bASIC_LEXER_LANG_SINGLE_BYTE : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE.values()) {
            vector.add(bASIC_LEXER_LANG_SINGLE_BYTE.value());
        }
        this.jThemeLanguageComboBox.setModel(new DefaultComboBoxModel(vector));
        LexerType lexerType = this._theme.getToken().getLexer();
        String string = "ENGLISH";
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE bASIC_LEXER_LANG_SINGLE_BYTE : lexerType.getSettings().getAttribute()) {
            if (!"theme_language".equals(bASIC_LEXER_LANG_SINGLE_BYTE.getName())) continue;
            string = bASIC_LEXER_LANG_SINGLE_BYTE.getValueString();
            break;
        }
        this.jThemeLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)string));
        this.jThemeLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TextSettingsThemePanel.this._isLoading) {
                    TextSettingsThemePanel.this._dirty = true;
                }
            }
        });
        this.jThemeMaxAllDocsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextSettingsThemePanel.this._dirty = true;
            }
        });
        this.jThemeLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)TextSettingsThemePanel.this.jThemeLanguageComboBox.getSelectedItem();
                String string2 = ServerConstants.StoplistLanguage.toHuman((String)"ENGLISH");
                String string3 = ServerConstants.StoplistLanguage.toHuman((String)"FRENCH");
                if (!string.equals(string2) && !string.equals(string3)) {
                    MessageDialog.optionalInformation((String)(Workflow.class.getName() + "ThemeWarning"), (Component)Ide.getMainWindow(), (Object)MessageFormat.format(WorkflowEditorLrb.get("ORACLE_TEXT_KB"), string), (String)WorkflowEditorLrb.get("ORACLE_TEXT_KB_TITLE"), null);
                }
            }
        });
        this.refreshUI();
        this._isLoading = false;
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jThemeLanguageLabel, this.jThemeLanguageComboBox, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
        ResourceUtils.resLabel((JLabel)this.jThemeStoplistLabel, this.jThemeStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resSpinner((JLabel)this.jThemeMaxAllDocsLabel, (JSpinner)this.jThemeMaxAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        ResourceUtils.resLabel((JLabel)this.jThemeTokensLabel, null, (String)DialogsLrb.get("BUILD_TEXT_THEMES"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    private void refreshUI() {
        this.initStoplists(this._theme.getToken().getStoplistId());
        int n = this._theme.getToken().getMaxNumberAllDocs().intValue();
        this.jThemeMaxAllDocsSpinner.setModel(new SpinnerNumberModel(n, 1, 100000, 1000));
        this.enableControls();
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void initStoplists(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : this._stoplists.getStoplist()) {
            arrayList.add(stoplistType.getName());
            if (string == null || !string.equals(stoplistType.getId())) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman((String)"None"));
        this.jThemeStoplistComboBox.removeAllItems();
        this.jThemeStoplistComboBox.setModel(new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()])));
        if (string2 != null) {
            this.jThemeStoplistComboBox.setSelectedItem(string2);
        }
    }

    public void copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Integer n;
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        String string = (String)this.jThemeLanguageComboBox.getSelectedItem();
        language = new TransformationTokenType.Token.Languages.Language();
        language.setName(ServerConstants.StoplistLanguage.toSchema((String)string));
        language.setType("SingleByte");
        languages.getLanguage().add(language);
        transformationTokenType.getToken().setLanguages(languages);
        LexerType lexerType = new LexerType();
        lexerType.setType("Basic");
        transformationTokenType.getToken().setLexer(lexerType);
        LexerType.Settings settings = new LexerType.Settings();
        LexerType.Settings.Attribute attribute = new LexerType.Settings.Attribute();
        attribute.setName("index_themes");
        attribute.setType("String");
        attribute.setValueString("YES");
        settings.getAttribute().add(attribute);
        attribute = new LexerType.Settings.Attribute();
        attribute.setName("theme_language");
        attribute.setType("String");
        attribute.setValueString(ServerConstants.StoplistLanguage.toSchema((String)string));
        settings.getAttribute().add(attribute);
        lexerType.setSettings(settings);
        transformationTokenType.getToken().setStoplistId(null);
        String string2 = (String)this.jThemeStoplistComboBox.getSelectedItem();
        if (string2 != null) {
            if (ServerConstants.StoplistLanguage.isDefault((String)ServerConstants.StoplistLanguage.toSchema((String)string2))) {
                string = (String)this.jThemeLanguageComboBox.getSelectedItem();
                string = ServerConstants.StoplistLanguage.toSchema((String)string);
                n = AbstractBuildNode.findDefaultStoplist(stoplists, string);
                String string3 = n.getId();
                transformationTokenType.getToken().setStoplistId(string3);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string2));
            }
        }
        n = (Integer)this.jThemeMaxAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
    }

    private void enableControls() {
        if (this.jThemeStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jThemeStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jThemeLanguageLabel = new JLabel();
        this.jThemeLanguageComboBox = new JComboBox();
        this.jThemeStoplistLabel = new JLabel();
        this.jThemeStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jThemeTokensLabel = new JLabel();
        this.jThemeMaxAllDocsLabel = new JLabel();
        this.jThemeMaxAllDocsSpinner = new JSpinner();
        this.jThemeLanguageLabel.setText("Languages:");
        this.jThemeLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jThemeLanguageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsThemePanel.this.jThemeLanguageComboBoxActionPerformed(actionEvent);
            }
        });
        this.jThemeStoplistLabel.setText("Stoplists:");
        this.jThemeStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jThemeStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsThemePanel.this.jThemeStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsThemePanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextSettingsThemePanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jThemeTokensLabel.setText("Tokens:");
        this.jThemeMaxAllDocsLabel.setText("Max number across all documents");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jThemeTokensLabel, -1, -1, Short.MAX_VALUE).addGap(238, 238, 238)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jThemeMaxAllDocsLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jThemeMaxAllDocsSpinner, -2, 70, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jThemeLanguageLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeLanguageComboBox, -2, 160, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jThemeStoplistLabel, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThemeStoplistComboBox, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2)))).addContainerGap(12, Short.MAX_VALUE)))));
        groupLayout.linkSize(0, this.jThemeLanguageComboBox, this.jThemeStoplistComboBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeLanguageLabel).addComponent(this.jThemeLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeStoplistLabel).addComponent(this.jThemeStoplistComboBox, -2, -1, -2).addComponent(this.jEditStoplistButton).addComponent(this.jNewStoplistButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jThemeTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThemeMaxAllDocsLabel).addComponent(this.jThemeMaxAllDocsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.jThemeStoplistComboBox.getSelectedItem();
        StoplistType stoplistType = null;
        boolean bl = false;
        for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
            if (!stoplistType2.getName().equals(string)) continue;
            stoplistType = stoplistType2;
            break;
        }
        bl = true;
        StoplistDetailsPanel stoplistDetailsPanel = new StoplistDetailsPanel(this._context, (AbstractBuildNode)this.getData(), this._buildNodeType, this, stoplistType);
        if (stoplistDetailsPanel.showAsDialog(this) && stoplistDetailsPanel.isDirty()) {
            StoplistType stoplistType2;
            stoplistType2 = stoplistDetailsPanel.getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType2.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType2);
                break;
            }
            this.initStoplists(stoplistType2.getId());
            this._dirty = true;
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, (AbstractBuildNode)this.getData(), DialogsLrb.get("BUILD_TEXT_DEFAULT_STOPLIST_NAME"))) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = "" + AbstractBuildNode.getStoplistNextId(this._stoplists);
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this.initStoplists(stoplistType.getId());
            this._dirty = true;
        }
    }

    private void jThemeStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
        if (!this._isLoading) {
            this._dirty = true;
        }
    }

    private void jThemeLanguageComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

