/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;

public class SelectNodeResultPanel
extends DialogDisplayer<AbstractBuildNode> {
    private GenericTable _nodeTable = new DataMinerTable();
    private NodeTableModel _nodeTblModel;
    private BuildTextNodeType _textNode;
    private BuildNodeType _metadataCopy;
    private boolean _dirty;
    private static final String SELECT_MAPPING_NODE = DialogsLrb.get("SELECT_NODE_MAPPING_NODE");
    private ComponentWithTitlebar<JComponent> componentWithTitlebar;
    private JCheckBox jOverwriteCustomStoplistCheckBox;
    private JCheckBox jOverwriteDefaultStoplistCheckBox;

    public SelectNodeResultPanel(Context context, BuildTextNodeType buildTextNodeType, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        super(context, abstractBuildNode);
        this._textNode = buildTextNodeType;
        this._metadataCopy = buildNodeType;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("SELECT_NODE_OVERWRITE_DEFAULT_STOPLIST"), this.jOverwriteDefaultStoplistCheckBox);
        hashMap.put(DialogsLrb.get("SELECT_NODE_OVERWRITE_CUSTOM_STOPLIST"), this.jOverwriteCustomStoplistCheckBox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        JScrollPane jScrollPane = new JScrollPane((Component)this._nodeTable);
        this.componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.componentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("SELECT_NODE_RESULT_TABLE")));
        ControlBar controlBar = new ControlBar();
        this.componentWithTitlebar.setControlBar(controlBar);
        this._nodeTblModel = new NodeTableModel(this.getTextColumns(), this.getSourceColumns());
        this._nodeTable.setModel((TableModel)((Object)this._nodeTblModel));
        TableColumn tableColumn = this._nodeTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new NewNodeEditor());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        this.jOverwriteDefaultStoplistCheckBox.setSelected(true);
        this.jOverwriteCustomStoplistCheckBox.setSelected(true);
    }

    public List<SourceColumn> getSourceColumns() {
        ArrayList<SourceColumn> arrayList = new ArrayList<SourceColumn>();
        List list = this._textNode.getTransformedAttributes().getMapTextTransformedSource();
        for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
            if (!textTransformationOutputAttributeType.isIsOutput()) continue;
            SourceColumn sourceColumn = new SourceColumn(textTransformationOutputAttributeType);
            arrayList.add(sourceColumn);
        }
        return arrayList;
    }

    public List<TextColumn> getTextColumns() {
        ArrayList<TextColumn> arrayList = new ArrayList<TextColumn>();
        for (MiningAttributeType miningAttributeType : this._metadataCopy.getMiningAttributes().getMiningAttribute()) {
            if (!DatabaseMetadataUtils.isTypeSupportedAsText(miningAttributeType.getDataType())) continue;
            TextColumn textColumn = new TextColumn(miningAttributeType);
            arrayList.add(textColumn);
        }
        return arrayList;
    }

    @Override
    public boolean doWork() {
        ArrayList<TextColumn> arrayList = new ArrayList<TextColumn>();
        ArrayList<SourceColumn> arrayList2 = new ArrayList<SourceColumn>();
        this._nodeTblModel.getMappingNodes(arrayList, arrayList2);
        for (int i = 0; i < arrayList2.size(); ++i) {
            SourceColumn sourceColumn = (SourceColumn)arrayList2.get(i);
            if (sourceColumn == null) continue;
            AbstractBuildNode.copyTextSettingsFromBuildText(this._textNode, sourceColumn.getData(), this._metadataCopy, ((TextColumn)arrayList.get(i)).getData(), this.jOverwriteDefaultStoplistCheckBox.isSelected(), this.jOverwriteCustomStoplistCheckBox.isSelected());
            this._dirty = true;
        }
        return true;
    }

    public BuildNodeType.Stoplists getStoplist() {
        return this._metadataCopy.getStoplists();
    }

    public TransformedAttributesType getTextAttributes() {
        return this._metadataCopy.getTextAttributes();
    }

    public MiningAttributes getMiningAttributes() {
        return this._metadataCopy.getMiningAttributes();
    }

    public Map<String, MiningAttributes> getModelMiningAttributes() {
        HashMap<String, MiningAttributes> hashMap;
        block16: {
            block21: {
                block20: {
                    Object object;
                    Object object22;
                    block19: {
                        block18: {
                            Object object3;
                            Object object42;
                            block17: {
                                Object object52;
                                block15: {
                                    Object object6;
                                    Object object7;
                                    Object object82;
                                    hashMap = new HashMap<String, MiningAttributes>();
                                    if (!(this._metadataCopy instanceof ClassificationBuildNodeType)) break block15;
                                    ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)this._metadataCopy;
                                    List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                    for (Object object82 : list) {
                                        hashMap.put(object82.getName(), object82.getInputMiningData().getMiningAttributes());
                                    }
                                    List list2 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                    object82 = list2.iterator();
                                    while (object82.hasNext()) {
                                        object7 = (ModelType)object82.next();
                                        hashMap.put(object7.getName(), object7.getInputMiningData().getMiningAttributes());
                                    }
                                    object82 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                    object7 = object82.iterator();
                                    while (object7.hasNext()) {
                                        object6 = (ModelType)object7.next();
                                        hashMap.put(object6.getName(), object6.getInputMiningData().getMiningAttributes());
                                    }
                                    object7 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                    object6 = object7.iterator();
                                    while (object6.hasNext()) {
                                        ModelType modelType = (ModelType)object6.next();
                                        hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                                    }
                                    break block16;
                                }
                                if (!(this._metadataCopy instanceof RegressionBuildNodeType)) break block17;
                                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)this._metadataCopy;
                                List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
                                for (Object object52 : list) {
                                    hashMap.put(object52.getName(), object52.getInputMiningData().getMiningAttributes());
                                }
                                List list3 = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
                                object52 = list3.iterator();
                                while (object52.hasNext()) {
                                    ModelType modelType = (ModelType)object52.next();
                                    hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                                }
                                break block16;
                            }
                            if (!(this._metadataCopy instanceof ClusteringBuildNodeType)) break block18;
                            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)this._metadataCopy;
                            List list = clusteringBuildNodeType.getModels().getExpectationMaximizationModel();
                            for (Object object42 : list) {
                                hashMap.put(object42.getName(), object42.getInputMiningData().getMiningAttributes());
                            }
                            List list4 = clusteringBuildNodeType.getModels().getKMeansModel();
                            object42 = list4.iterator();
                            while (object42.hasNext()) {
                                object3 = (ModelType)object42.next();
                                hashMap.put(object3.getName(), object3.getInputMiningData().getMiningAttributes());
                            }
                            object42 = clusteringBuildNodeType.getModels().getOClusterModel();
                            object3 = object42.iterator();
                            while (object3.hasNext()) {
                                ModelType modelType = (ModelType)object3.next();
                                hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                            }
                            break block16;
                        }
                        if (!(this._metadataCopy instanceof AssociationBuildNodeType)) break block19;
                        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)this._metadataCopy;
                        List list = associationBuildNodeType.getModels().getAprioriModel();
                        for (ModelType modelType : list) {
                            hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                        }
                        break block16;
                    }
                    if (!(this._metadataCopy instanceof FeatureExtractionBuildNodeType)) break block20;
                    FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)this._metadataCopy;
                    List list = featureExtractionBuildNodeType.getModels().getNonNegativeMatrixFactorModel();
                    for (Object object22 : list) {
                        hashMap.put(object22.getName(), object22.getInputMiningData().getMiningAttributes());
                    }
                    List list5 = featureExtractionBuildNodeType.getModels().getPCAModel();
                    object22 = list5.iterator();
                    while (object22.hasNext()) {
                        object = (ModelType)object22.next();
                        hashMap.put(object.getName(), object.getInputMiningData().getMiningAttributes());
                    }
                    object22 = featureExtractionBuildNodeType.getModels().getSVDModel();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        ModelType modelType = (ModelType)object.next();
                        hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                    }
                    break block16;
                }
                if (!(this._metadataCopy instanceof AnomalyDetectionBuildNodeType)) break block21;
                AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)this._metadataCopy;
                List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
                for (ModelType modelType : list) {
                    hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
                }
                break block16;
            }
            if (!(this._metadataCopy instanceof ExplicitFeatureExtractionBuildNodeType)) break block16;
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)this._metadataCopy;
            List list = explicitFeatureExtractionBuildNodeType.getModels().getExplicitSemanticAnalysisModel();
            for (ModelType modelType : list) {
                hashMap.put(modelType.getName(), modelType.getInputMiningData().getMiningAttributes());
            }
        }
        return hashMap;
    }

    private void initComponents() {
        this.jOverwriteDefaultStoplistCheckBox = new JCheckBox();
        this.jOverwriteCustomStoplistCheckBox = new JCheckBox();
        this.componentWithTitlebar = new ComponentWithTitlebar();
        this.jOverwriteDefaultStoplistCheckBox.setText("Overwrite Default Stoplist");
        this.jOverwriteCustomStoplistCheckBox.setText("Overwrite Custom Stoplist");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jOverwriteDefaultStoplistCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jOverwriteCustomStoplistCheckBox, -1, -1, Short.MAX_VALUE).addComponent((Component)this.componentWithTitlebar, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jOverwriteDefaultStoplistCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOverwriteCustomStoplistCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.componentWithTitlebar, -1, 193, Short.MAX_VALUE).addContainerGap()));
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SELECT_NODE_RESULT_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "select_build_text_result";
    }

    class NodeTableModel
    extends SimpleBaseTableModel {
        private static final int SOURCE_COLUMN = 0;
        private static final int TEXT_COLUMN = 1;
        private List<TextColumn> _textColumns = new ArrayList<TextColumn>();
        private List<NewNode> _newColumns = new ArrayList<NewNode>();
        private List<NewNode> _sourceColumns = new ArrayList<NewNode>();

        public NodeTableModel(List<TextColumn> list, List<SourceColumn> list2) {
            Collections.sort(list, ToStringComparator.getComparator());
            for (TextColumn object : list) {
                this._textColumns.add(object);
                String string = object.getData().getName();
                SourceColumn sourceColumn = null;
                for (int i = 0; i < list2.size(); ++i) {
                    SourceColumn sourceColumn2 = list2.get(i);
                    if (!sourceColumn2.getData().getSource().equals(string)) continue;
                    sourceColumn = sourceColumn2;
                }
                this._newColumns.add(new NewNode(sourceColumn));
            }
            Collections.sort(list2, ToStringComparator.getComparator());
            for (SourceColumn sourceColumn : list2) {
                this._sourceColumns.add(new NewNode(sourceColumn));
            }
            Vector vector = new Vector();
            vector.add(DialogsLrb.get("SELECT_NODE_RESULT_SOURCE_COL"));
            vector.add(DialogsLrb.get("SELECT_NODE_RESULT_TEXT_COL"));
            this.setColumnIdentifiers(vector);
            if (list == null) {
                this.setRowCount(0);
            } else {
                this.setRowCount(list.size());
            }
            this.setColumnCount(vector.size());
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 0) {
                return;
            }
            NewNode newNode = (NewNode)object;
            this._newColumns.set(n, newNode);
            if (newNode.getData() != null) {
                SelectNodeResultPanel.this._dirty = true;
            }
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (0 == n2) {
                object = this._newColumns.get(n);
            } else if (1 == n2) {
                object = this._textColumns.get(n);
            }
            return object;
        }

        public List<NewNode> getsourceColumns() {
            return this._sourceColumns;
        }

        public void getMappingNodes(List<TextColumn> list, List<SourceColumn> list2) {
            if (list != null && list2 != null) {
                list.clear();
                list2.clear();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    TextColumn textColumn = (TextColumn)this.getValueAt(i, 1);
                    NewNode newNode = (NewNode)this.getValueAt(i, 0);
                    list.add(textColumn);
                    list2.add(newNode.getData());
                }
            }
        }
    }

    private static class NewNode {
        private SourceColumn _newNode;

        public NewNode(SourceColumn sourceColumn) {
            this._newNode = sourceColumn;
        }

        public SourceColumn getData() {
            return this._newNode;
        }

        public String toString() {
            return this._newNode == null ? SELECT_MAPPING_NODE : this._newNode.toString();
        }
    }

    private static class TextColumn {
        private MiningAttributeType _data;

        public TextColumn(MiningAttributeType miningAttributeType) {
            this._data = miningAttributeType;
        }

        public MiningAttributeType getData() {
            return this._data;
        }

        public String toString() {
            return this._data == null ? "Unknown" : this._data.getName();
        }
    }

    private static class SourceColumn {
        private TextTransformationOutputAttributeType _data;

        public SourceColumn(TextTransformationOutputAttributeType textTransformationOutputAttributeType) {
            this._data = textTransformationOutputAttributeType;
        }

        public TextTransformationOutputAttributeType getData() {
            return this._data;
        }

        public String toString() {
            return this._data == null ? "Unknown" : this._data.getName();
        }
    }

    private static class NewNodeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        NewNode currentValue;
        JComboBox comboComponent = new JComboBox();
        protected static final String EDIT = "edit";

        public NewNodeEditor() {
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.currentValue = (NewNode)this.comboComponent.getSelectedItem();
                this.fireEditingStopped();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            NodeTableModel nodeTableModel = (NodeTableModel)((Object)jTable.getModel());
            List<NewNode> list = nodeTableModel.getsourceColumns();
            NewNode newNode = (NewNode)nodeTableModel.getValueAt(n, n2);
            this.comboComponent.removeAllItems();
            this.comboComponent.addItem(new NewNode(null));
            for (NewNode newNode2 : list) {
                this.comboComponent.addItem(newNode2);
                if (!newNode.toString().equals(newNode2.toString())) continue;
                newNode = newNode2;
            }
            this.comboComponent.setSelectedItem(newNode);
            return this.comboComponent;
        }
    }
}

