/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableColumnModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;

public class HeuristicsResultDetailsPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private String filter;
    private Map<String, ModelHeuristicRules> rules;
    private DataMinerTablePanel dataMinerTablePanel;

    public HeuristicsResultDetailsPanel(Map<String, ModelHeuristicRules> map, String string) {
        this.rules = map;
        this.filter = string;
        this.initComponents();
        if (map.isEmpty()) {
            this.dataMinerTablePanel.getTable().setNoEntryInstructionText(BuildEditorLrb.get("HEURISTIC_DETAILS_NO_DATA"));
        } else {
            this.initUI();
        }
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 780, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 378, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        TableModel tableModel = new TableModel();
        this.dataMinerTablePanel.getTable().setNoEntryInstructionText(BuildEditorLrb.get("HEURISTIC_DETAILS_NO_ENTRY"));
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 20);
        this.dataMinerTablePanel.getTable().setAutoResizeMode(3);
        this.dataMinerTablePanel.setup((javax.swing.table.TableModel)((Object)tableModel), BuildEditorLrb.get("HEURISTIC_DETAILS_TABLE_TITLE"), 1, true);
        this.dataMinerTablePanel.getTable().setSortColumn(0, true);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(1).setMaxWidth(300);
        if (this.filter != null) {
            this.dataMinerTablePanel.getSearchField().setText(this.filter);
            this.dataMinerTablePanel.trySearch();
        }
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return BuildEditorLrb.get("HEURISTIC_DETAILS_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public JComponent getContent() {
                return HeuristicsResultDetailsPanel.this;
            }

            @Override
            public int getButtonMask() {
                return 16;
            }
        };
    }

    private class TableModel
    extends SimpleBaseTableModel {
        private static final int NAME = 0;
        private static final int MODEL = 1;
        private final String[] columnNames = new String[]{BuildEditorLrb.get("HEURISTIC_DETAILS_COL_NAME"), BuildEditorLrb.get("HEURISTIC_DETAILS_COL_MODEL"), BuildEditorLrb.get("HEURISTIC_DETAILS_COL_RULES")};

        private TableModel() {
            int n = 0;
            for (Map.Entry<String, ModelHeuristicRules> object : HeuristicsResultDetailsPanel.this.rules.entrySet()) {
                n += object.getValue().modelRules.size();
            }
            Object[][] objectArray = new String[n][3];
            n = 0;
            for (Map.Entry<String, ModelHeuristicRules> entry : HeuristicsResultDetailsPanel.this.rules.entrySet()) {
                for (Map.Entry<String, String> entry2 : entry.getValue().modelRules.entrySet()) {
                    objectArray[n][0] = entry2.getKey();
                    objectArray[n][1] = entry.getKey();
                    objectArray[n][2] = entry2.getValue();
                    ++n;
                }
            }
            this.setDataVector(objectArray, this.columnNames);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

