/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.util.ArrayList;
import java.util.Vector;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SQLExpressionBuilderPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.PartitionPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;

public class ExpressionEditorPanel
extends SQLExpressionBuilderPanel {
    private PartitionPanel _parent;
    private boolean _isNew;
    private PropertyModel _model;

    public ExpressionEditorPanel(PartitionPanel partitionPanel, SQLContext sQLContext, PropertyModel propertyModel) {
        super(sQLContext);
        this._parent = partitionPanel;
        this._isNew = sQLContext.getSqlExpression() == null;
        this._model = propertyModel;
    }

    @Override
    protected String getStackSQLExpression(SQLContext sQLContext, String string) {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)sQLContext.getNode();
        return abstractBuildNode.getStackSQLExpression(sQLContext, string);
    }

    @Override
    protected void validateSQLExpression(String string, Vector<ColumnDataRow> vector) throws Exception {
        super.validateSQLExpression(string, vector);
        String string2 = vector.get(0).getDataType();
        if (!DatabaseMetadataUtils.isPartitionKeyDataTypeSupported(string2)) {
            String string3 = BuildEditorLrb.get("BUILD_PARTITION_EXPRESSION_UNSUPPORTED_DATATYPE");
            throw new Exception(string3);
        }
    }

    @Override
    protected String getDialogTitle() {
        return BuildEditorLrb.get("BUILD_PARTITION_EXPRESSION_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "build_partition";
    }

    public boolean isDirty() {
        return this.isExpressionDirty() || this.isOutputColumnsDirty();
    }

    @Override
    protected boolean doWork() {
        boolean bl = super.doWork();
        if (bl && this.isDirty()) {
            PartitionExpressionType partitionExpressionType = null;
            String string = super.getSqlExpression();
            Vector<ColumnDataRow> vector = super.getResultColumnInfo();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(super.getName());
            attributeType.setDataType(vector.get(0).getDataType());
            attributeType.setStatus(AttributeStatus.VALID);
            partitionExpressionType = new PartitionExpressionType();
            partitionExpressionType.setSQLExpression(string);
            partitionExpressionType.setPartitionAttribute(attributeType);
            if (this._isNew) {
                ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
                arrayList.add(partitionExpressionType);
                this._parent.addPartitionExpressions(arrayList);
            } else {
                this._parent.setPartitionExpression(partitionExpressionType);
            }
        }
        return bl;
    }
}

