/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.GenericTableCheckBoxLabel;
import oracle.dmt.dataminer.controls.GenericTableCheckBoxLabelTableModel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.comparator.PairComparator;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AbstractAggregationWizardPage;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardModel;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.FSMWizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.Pair;

public class AggregationWizardFunctionsPage
extends AbstractAggregationWizardPage
implements DataminerGUIPanel {
    private ComponentWithTitlebar<JComponent> jCatFunctionsComponent;
    private JLabel jLblChar;
    private JLabel jLblNumFunctions;
    private JLabel jLblTitle;
    private ComponentWithTitlebar<JComponent> jNumFunctionsComponent;
    private GenericTableCheckBoxLabel _jNumFunctionTable = new GenericTableCheckBoxLabel(0);
    private GenericTableCheckBoxLabel _jCharFunctionTable = new GenericTableCheckBoxLabel(0);
    private String[] _columnNames = new String[]{AggregateDialogsLrb.get("PI_AGGREGATE_GROUP_COLUMNS_FUNCTION_COLUMN")};
    private static final int FUNCTION = 0;

    public AggregationWizardFunctionsPage() {
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jNumFunctionsComponent = new ComponentWithTitlebar();
        this.jLblNumFunctions = new JLabel();
        this.jLblTitle = new JLabel();
        this.jLblChar = new JLabel();
        this.jCatFunctionsComponent = new ComponentWithTitlebar();
        this.jLblNumFunctions.setText("Numerical:");
        this.jLblTitle.setHorizontalAlignment(0);
        this.jLblTitle.setText("Select one or more functions to apply");
        this.jLblChar.setText("Character:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblTitle, -1, 404, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblChar, -2, 66, -2).addComponent(this.jLblNumFunctions, -2, 95, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 299, Short.MAX_VALUE))).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jNumFunctionsComponent, GroupLayout.Alignment.TRAILING, -1, 352, Short.MAX_VALUE).addComponent((Component)this.jCatFunctionsComponent, GroupLayout.Alignment.TRAILING, -1, 352, Short.MAX_VALUE)).addGap(32, 32, 32)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLblNumFunctions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.jNumFunctionsComponent, -1, 184, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLblChar).addGap(18, 18, 18).addComponent((Component)this.jCatFunctionsComponent, -1, 88, Short.MAX_VALUE).addGap(29, 29, 29)));
    }

    @Override
    public void initRes() {
        this.jLblTitle.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_TITLE"));
        this.jLblChar.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_CHARACTER"));
        this.jLblNumFunctions.setText(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_NUMERICAL"));
        this.jCatFunctionsComponent.setLabel(new JLabel(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_FUNCION")));
        this.jNumFunctionsComponent.setLabel(new JLabel(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_FUNCION")));
    }

    @Override
    public void initUI() {
        this.jNumFunctionsComponent.setComponent((JComponent)new JScrollPane((Component)((Object)this._jNumFunctionTable)));
        this.jCatFunctionsComponent.setComponent((JComponent)new JScrollPane((Component)((Object)this._jCharFunctionTable)));
        this._jNumFunctionTable.setFillsViewportHeight(true);
        this._jCharFunctionTable.setFillsViewportHeight(true);
        this._jNumFunctionTable.setModel(new NumericalFunctions());
        this._jNumFunctionTable.setSorted(true);
        this._jCharFunctionTable.setModel(new CharacterFunctions());
        this._jCharFunctionTable.setSorted(true);
    }

    @Override
    public String getPageDirtyKey() {
        return "functionsDirty";
    }

    @Override
    protected String getValidationMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_VALIDATION_MESSAGE");
    }

    @Override
    protected void onEntryAfterInit(TraversableContext traversableContext) {
        super.onEntryAfterInit(traversableContext);
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        FSMWizard fSMWizard = aggregationWizardModel.getWizard();
        fSMWizard.setMustFinish(true);
    }

    @Override
    protected String getValidationTitle() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_VALIDATE_TITLE");
    }

    @Override
    protected String getValidationFailedMessage() {
        return AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_PAGE_VALIDATION_FAILED");
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        Object object2;
        boolean bl = false;
        AggregationWizardModel aggregationWizardModel = this.getModel(this.getTraversableContext());
        GeneralFunctionsTableModel generalFunctionsTableModel = (GeneralFunctionsTableModel)this._jNumFunctionTable.getModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = generalFunctionsTableModel.getDataVector();
        for (Object object2 : vector) {
            if (!object2.getSecond().equals(Boolean.TRUE)) continue;
            arrayList.add(object2.getFirst().toString());
        }
        aggregationWizardModel.setSelectedNumericFunctions(arrayList);
        GeneralFunctionsTableModel generalFunctionsTableModel2 = (GeneralFunctionsTableModel)this._jCharFunctionTable.getModel();
        object2 = new ArrayList();
        vector = generalFunctionsTableModel2.getDataVector();
        for (Pair pair : vector) {
            if (!pair.getSecond().equals(Boolean.TRUE)) continue;
            object2.add(pair.getFirst().toString());
        }
        aggregationWizardModel.setSelectedCharFunctions((List<String>)object2);
        boolean bl2 = bl = !arrayList.isEmpty() || !object2.isEmpty();
        if (!bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_NO_FUNCTIONS"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_TITLE"), null);
        }
        return bl;
    }

    private class GeneralFunctionsTableModel
    extends SimpleBaseTableModel
    implements GenericTableCheckBoxLabelTableModel {
        private List<Pair> _functions;
        private Map<String, Pair> _functionsMap = new HashMap<String, Pair>();
        protected GenericTableCheckBoxLabel uiTable;

        GeneralFunctionsTableModel(List<String> list) {
            this._functions = new ArrayList<Pair>(list.size());
            for (String string : list) {
                Pair pair = new Pair((Object)string, (Object)false);
                this._functions.add(pair);
                this._functionsMap.put(string, pair);
            }
            this.setRowCount(this._functions.size());
            this.setColumnIdentifiers(AggregationWizardFunctionsPage.this._columnNames);
        }

        @Override
        public Pair getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            return this._functions.get(n);
        }

        @Override
        public int getRowCount() {
            return this._functions != null ? this._functions.size() : 0;
        }

        public Vector getDataVector() {
            return new Vector<Pair>(this._functions);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n != -1) {
                return;
            }
            int[] nArray = this.uiTable.getSelectedRowsInModel();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.fireTableStructureChanged();
            this.uiTable.setSelectedRowsInModel(nArray);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            Pair pair = null;
            if (n2 == 0) {
                pair = this.getValueAtCheckBoxColumn(n);
            } else assert (false) : "Out of bounds column when accessing items";
            return pair;
        }

        @Override
        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return PairComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }
    }

    private class CharacterFunctions
    extends GeneralFunctionsTableModel {
        CharacterFunctions() {
            super(DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions());
            this.uiTable = AggregationWizardFunctionsPage.this._jCharFunctionTable;
        }
    }

    private class NumericalFunctions
    extends GeneralFunctionsTableModel {
        NumericalFunctions() {
            super(DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions());
            this.uiTable = AggregationWizardFunctionsPage.this._jNumFunctionTable;
        }
    }
}

