/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditMainPanel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardFunctionsPage;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardModel;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregationWizardOutputNamesPage;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AggregationNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.ExceptionDialog;

public class AggregationWizard {
    private static final Logger theLogger = Logger.getLogger(AggregationWizard.class.getName());
    protected static final String STATE_FUNCTIONS = "functions";
    protected static final String STATE_COLUMNS = "columns";
    protected static final String STATE_SUB_GROUP_BY = "subGroupBy";
    protected static final String STATE_OUTPUT = "output";
    protected static final String dirty = "Dirty";
    protected static final String KEY_FUNCTIONS_PAGE_DIRTY = "functionsDirty";
    protected static final String KEY_COLUMNS_PAGE_DIRTY = "columnsDirty";
    protected static final String KEY_SUB_GROUP_BY_PAGE_DIRTY = "subGroupByDirty";
    protected static final String KEY_OUTPUT_PAGE_DIRTY = "outputDirty";
    protected Context _context;
    protected AggregationWizardModel _wizModel;
    protected Component _parent;
    private AggregationNode _thisNode;
    private AggregationNodeType _nodedata;
    private AbstractDataNode _parentNode;
    private ProgressBar progressBar;
    private boolean _fromPI = true;

    protected void initWizardModel() {
        this._wizModel = new AggregationWizardModel(this._parent, this._context, this._nodedata, this._parentNode);
    }

    private List<AttributeType> getColumnDetails(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = new AttributeType();
            String string = attributeType.getDataType();
            if (!DatabaseMetadataUtils.isKeyDataTypeSupported(string)) continue;
            attributeType2.setName(attributeType.getName());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setAlias(attributeType.getAlias());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            attributeType2.setStatus(attributeType.getStatus());
            arrayList.add(attributeType2);
        }
        return arrayList;
    }

    public boolean runWizard(final Component component, final Context context, final AggregationNode aggregationNode, final AggregationNodeType aggregationNodeType, final AbstractDataNode abstractDataNode, final boolean bl) {
        try {
            class CreateWizardTask
            implements Runnable {
                private WizardDialog wd;
                private FSMWizard wizard;

                CreateWizardTask() {
                }

                public FSMWizard getWizard() {
                    return this.wizard;
                }

                public WizardDialog getWizardDialog() {
                    return this.wd;
                }

                @Override
                public void run() {
                    AggregationWizard.this._context = context;
                    AggregationWizard.this._parent = component;
                    AggregationWizard.this._thisNode = aggregationNode;
                    AggregationWizard.this._nodedata = aggregationNodeType;
                    AggregationWizard.this._parentNode = abstractDataNode;
                    AggregationWizard.this._fromPI = bl;
                    AggregationWizard.this.initWizardModel();
                    FSMBuilder fSMBuilder = new FSMBuilder();
                    Step step = new Step(AggregateDialogsLrb.get("AGGREGATE_WIZ_FUNCTIONS_TITLE"), AggregationWizardFunctionsPage.class, "aggregation_wiz_functions");
                    fSMBuilder.newStartState(step, (Object)AggregationWizard.STATE_COLUMNS);
                    fSMBuilder.newState((Object)AggregationWizard.STATE_FUNCTIONS, step, (Object)AggregationWizard.STATE_COLUMNS);
                    step = new Step(AggregateDialogsLrb.get("AGGREGATE_WIZ_COLUMNS_TITLE"), AggregateEditAttributesPanel.class, new Class[]{Context.class, DataProvider.class, List.class, GroupingElementType.class, Boolean.class}, new Object[]{AggregationWizard.this._context, AggregationWizard.this._parentNode, AggregationWizard.this.getColumnDetails(AggregationWizard.this._parentNode.getAttributes().getAttribute()), new GroupingElementType(), Boolean.TRUE}, "aggregation_wiz_functions");
                    fSMBuilder.newState((Object)AggregationWizard.STATE_COLUMNS, step, (Object)AggregationWizard.STATE_SUB_GROUP_BY);
                    step = new Step(AggregateDialogsLrb.get("AGGREGATE_WIZ_SUB_GROUP_BY_TITLE"), AggregateEditMainPanel.class, new Class[]{Context.class, DataProvider.class, AggregationElementType.class, GroupingElementType.class, List.class, Boolean.class}, new Object[]{AggregationWizard.this._context, AggregationWizard.this._parentNode, new AggregationElementType(), AggregationWizard.this._nodedata.getGroupingElement(), AggregationWizard.this.getColumnDetails(AggregationWizard.this._parentNode.getAttributes().getAttribute()), Boolean.TRUE}, "aggregation_wiz_functions");
                    fSMBuilder.newState((Object)AggregationWizard.STATE_SUB_GROUP_BY, step, (Object)AggregationWizard.STATE_OUTPUT);
                    step = new Step(AggregateDialogsLrb.get("AGGREGATE_WIZ_OUT_NAMES_TITLE"), AggregationWizardOutputNamesPage.class, "aggregation_wiz_functions");
                    fSMBuilder.newFinalState((Object)AggregationWizard.STATE_OUTPUT, step);
                    try {
                        FSM fSM = fSMBuilder.getFSM();
                        Namespace namespace = new Namespace();
                        namespace.put("wizardModel", (Object)AggregationWizard.this._wizModel);
                        this.wizard = new FSMWizard(fSM, namespace);
                        AggregationWizard.this._wizModel.setWizard(this.wizard);
                        this.wizard.setWelcomePageAdded(false);
                        this.wizard.setFinishPageAdded(false);
                        this.wizard.setWizardTitle(AggregateDialogsLrb.get("AGGREGATE_WIZ_NAME"));
                        this.wizard.updateImage(DataMinerIcons.get(Icons.WIZARD_IMAGE).getImage());
                        this.wizard.setDefaultWizardSize(1);
                        this.wizard.setMustFinish(true);
                        Dialog dialog = DialogUtil.getAncestorDialog((Component)component);
                        if (dialog != null) {
                            this.wd = this.wizard.getDialog(dialog);
                        } else {
                            Frame frame = DialogUtil.getAncestorFrame((Component)component);
                            this.wd = this.wizard.getDialog(frame);
                        }
                    }
                    catch (FSMInvalidException fSMInvalidException) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)fSMInvalidException), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_TITLE"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_MSG"));
                    }
                    AggregationWizard.this.progressBar.setDoneStatus();
                }
            }
            CreateWizardTask createWizardTask = new CreateWizardTask();
            this.progressBar = new ProgressBar((Component)Ide.getMainWindow(), "", (Runnable)createWizardTask, true);
            this.progressBar.setCancelable(true);
            this.progressBar.start(AggregateDialogsLrb.get("AGGREGATE_WIZ_INIT_MSG"), "");
            this.progressBar.waitUntilDone();
            if (this.progressBar.hasUserCancelled()) {
                return false;
            }
            WizardDialog wizardDialog = createWizardTask.getWizardDialog();
            FSMWizard fSMWizard = createWizardTask.getWizard();
            fSMWizard.addCommitListener(new CommitListener(){

                public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
                }

                public void commit(ApplyEvent applyEvent) throws TraversalException {
                    AggregationWizard.this.getModel().close();
                    AggregationWizard.this.commit();
                }

                public void rollback(ApplyEvent applyEvent) {
                }

                public void cancel(ApplyEvent applyEvent) {
                    AggregationWizard.this.getModel().setWizardCancelled(true);
                    AggregationWizard.this.getModel().close();
                }
            });
            return WizardLauncher.runDialog((JDialog)wizardDialog);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
    }

    AggregationWizardModel getModel() {
        return this._wizModel;
    }

    protected void commit() {
        class CommitThread
        extends ProgressRunnable {
            CommitThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                boolean bl = true;
                if (!AggregationWizard.this._fromPI) {
                    AggregationElements aggregationElements = new AggregationElements();
                    aggregationElements.getAggregationElement().addAll(AggregationWizard.this._wizModel.getAggregationElements());
                    AggregationWizard.this._nodedata.setAggregationElements(aggregationElements);
                    return bl;
                }
                CommandProcessor.getInstance().beginTrans(AggregateDialogsLrb.get("AGGREGATE_NODE_PROPERTIES_TRANSACTION_NAME"));
                AggregationNodeType aggregationNodeType = new AggregationNodeType();
                aggregationNodeType.setAutoSpec(AggregationWizard.this._nodedata.getAutoSpec());
                AggregationElements aggregationElements = new AggregationElements();
                aggregationElements.getAggregationElement().addAll(AggregationWizard.this._wizModel.getAggregationElements());
                aggregationNodeType.setAggregationElements(aggregationElements);
                aggregationNodeType.setGroupingElement(AggregationWizard.this._nodedata.getGroupingElement());
                try {
                    ArrayList<Property> arrayList = new ArrayList<Property>();
                    arrayList.add(new Property("allAggregateNodeProperies", null, aggregationNodeType, null, null));
                    arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)AggregationWizard.this._thisNode.getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(AggregationWizard.this._thisNode, AggregationWizard.this._context, arrayList);
                    AggregationWizard.this._thisNode.validate(true);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_TITLE"), (String)AggregateDialogsLrb.get("EDIT_AGGREGATE_ELEMENTS_DIALOG_FAILURE_MSG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
                return bl;
            }
        }
        CommitThread commitThread = new CommitThread();
        commitThread.setTitle(AggregateDialogsLrb.get("AGGREGATE_WIZ_NAME"));
        commitThread.setMessage(AggregateDialogsLrb.get("AGGREGATE_WIZ_UPDATE"));
        try {
            commitThread.start(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_TITLE"), (String)AggregateDialogsLrb.get("AGGREGATE_WIZ_FAILURE_MSG"));
        }
    }
}

