/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.codegen.CodeGenPreferences;
import oracle.dmt.dataminer.workflow.codegen.CodeGenerator;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Version;

public class GenerateSQLScriptWizardModel
extends WizardModel {
    private static final Logger theLogger = Logger.getLogger(GenerateSQLScriptWizardModel.class.getName());
    private volatile boolean _wizardIsCancelled;
    private Context _context;
    private JPanel _parent;
    private CodeGenerator _codeGen;
    private Version _dbVersion;
    private String _workingDirectory;
    private String _scriptDirectory;
    private CodeGenPreferences _codeGenPrefences;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public GenerateSQLScriptWizardModel(JPanel jPanel, Context context, CodeGenerator codeGenerator) {
        String string;
        this._context = context;
        this._parent = jPanel;
        this._codeGen = codeGenerator;
        this._dbVersion = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        Preferences preferences = Preferences.getPreferences();
        this._codeGenPrefences = CodeGenPreferences.getInstance((PropertyStorage)preferences);
        this._workingDirectory = this._codeGenPrefences.getCodeLocation();
        if (this._workingDirectory == null || this._workingDirectory.isEmpty()) {
            this._workingDirectory = System.getProperty("user.dir");
        }
        this._scriptDirectory = string = this._codeGen.getWorkflow().getName();
        int n = 1;
        String string2 = this._workingDirectory + File.separator + this._scriptDirectory;
        File file = new File(string2);
        while (file.exists()) {
            this._scriptDirectory = string + "_" + n;
            string2 = this._workingDirectory + File.separator + this._scriptDirectory;
            file = new File(string2);
            ++n;
        }
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public CodeGenerator getCodeGen() {
        return this._codeGen;
    }

    public void setDbVersion(Version version) {
        this._dbVersion = version;
    }

    public Version getDbVersion() {
        return this._dbVersion;
    }

    public void setScriptDirectory(String string) {
        this._scriptDirectory = string;
    }

    public String getScriptDirectory() {
        return this._scriptDirectory;
    }

    public void setWorkingDirectory(String string) {
        this._workingDirectory = string;
        this._codeGenPrefences.setCodeLocation(string);
    }

    public String getWorkingDirectory() {
        return this._workingDirectory;
    }

    public JPanel getParent() {
        return this._parent;
    }
}

