/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.codegen;

import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FilterDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;

public class CodeTemplate {
    private static final String BASE_PATH = "/oracle/dmt/dataminer/workflow/codegen/res/";
    public static final String TAG_TARGET_DB_VERSION = "<TARGET_DB_VERSION>";
    public static final String TAG_TARGET_REPOS_VERSION = "<TARGET_REPOS_VERSION>";
    public static final String TAG_WORKFLOW_OUTPUT = "<WORKFLOW_OUTPUT>";
    public static final String TAG_DROP_EXISTING_OBJECTS = "<DROP_EXISTING_OBJECTS>";
    public static final String TAG_WORKFLOW_PARAMETER_LIST = "<PARAMETER_LIST>";
    public static final String TAG_WORKFLOW_SCRIPT_LIST = "<WORKFLOW_SCRIPTS>";
    public static final String TAG_WORKFLOW_NODE_ID = "<WORKFLOW_NODE_ID>";
    public static final String TAG_WORKFLOW_NODE_NAME = "<WORKFLOW_NODE_NAME>";
    public static final String TAG_WORKFLOW_NODE_TYPE = "<WORKFLOW_NODE_TYPE>";
    public static final String TAG_BUILD_MODEL_ID = "<BUILD_MODEL_ID>";
    public static final String TAG_BUILD_MODEL_TYPE = "<BUILD_MODEL_TYPE>";
    public static final String TAG_SQL_EXPRESSION = "<SQL_EXPRESSION>";
    public static final String TAG_PARALLEL_HINT = "<PARALLEL_HINT>";
    public static final String TAG_TABLE_PARALLEL_HINT = "<TABLE_PARALLEL_HINT>";
    public static final String TAG_CREATE_TABLE_SQL_EXPRESSION = "<CREATE_TABLE_SQL_EXPRESSION>";
    public static final String TAG_CREATE_VIEW_SQL_EXPRESSION = "<CREATE_VIEW_SQL_EXPRESSION>";
    public static final String TAG_CREATE_INDEX_SQL_EXPRESSION = "<CREATE_INDEX_SQL_EXPRESSION>";
    public static final String TAG_CREATE_TABLE_NAME = "<CREATE_TABLE_NAME>";
    public static final String TAG_CREATE_VIEW_NAME = "<CREATE_VIEW_NAME>";
    public static final String TAG_UPDATE_TABLE_NAME = "<UPDATE_TABLE_NAME>";
    public static final String TAG_UPDATE_TABLE_SQL_EXPRESSION = "<UPDATE_TABLE_SQL_EXPRESSION>";
    public static final String TAG_PURGE_PREVIOUS_SQL_EXPRESSION = "<PURGE_PREVIOUS_SQL_EXPRESSION>";
    public static final String TAG_INSERT_SQL_EXPRESSION = "<INSERT_SQL_EXPRESSION>";
    public static final String TAG_ALTER_SQL_EXPRESSION = "<ALTER_SQL_EXPRESSION>";
    public static final String TAG_OPTIONAL_CODE = "<OPTIONAL_CODE>";
    public static final String TAG_CREATE_STATS_VIEW_SQL_EXPRESSION = "<CREATE_STATS_VIEW_SQL_EXPRESSION>";
    public static final String TAG_POPULATE_STATS_TABLE_SQL_EXPRESSION = "<POPULATE_STATS_TABLE_SQL_EXPRESSION>";
    public static final String TAG_UPDATE_STATS_TABLE_DATE_SQL_EXPRESSION = "<UPDATE_STATS_TABLE_DATE_SQL_EXPRESSION>";
    public static final String TAG_UPDATE_STATS_TABLE_TS_TZ_SQL_EXPRESSION = "<UPDATE_STATS_TABLE_TS_TZ_SQL_EXPRESSION>";
    public static final String TAG_DROP_STATS_VIEW_SQL_EXPRESSION = "<DROP_STATS_VIEW_SQL_EXPRESSION>";
    public static final String TAG_CREATE_TEMP_INPUT_VIEW_SQL_EXPRESSION = "<CREATE_TEMP_INPUT_VIEW_SQL_EXPRESSION>";
    public static final String TAG_DROP_TEMP_INPUT_VIEW_SQL_EXPRESSION = "<DROP_TEMP_INPUT_VIEW_SQL_EXPRESSION>";
    public static final String TAG_HISTOGRAM_API_SQL_EXPRESSION = "<HISTOGRAM_API_SQL_EXPRESSION>";
    public static final String TAG_SERVER_CALL_SQL_EXPRESSION = "<SERVER_CALL_SQL_EXPRESSION>";
    public static final String HISTOGRAM_SAMPLE_SQL_EXPRESSION = "<HISTOGRAM_SAMPLE_SQL_EXPRESSION>";
    public static final String TAG_DROP_HISTOGRAM_SAMPLE_SQL_EXPRESSION = "<DROP_HISTOGRAM_SAMPLE_SQL_EXPRESSION>";
    public static final String TAG_SAMPLE_ALL_DATA_EXPRESSION = "<SAMPLE_ALL_DATA_EXPRESSION>";
    public static final String TAG_DROP_SAMPLE_SQL_EXPRESSION = "<DROP_SAMPLE_SQL_EXPRESSION>";
    public static final String TAG_PURGE_SQL_EXPRESSION = "<PURGE_SQL_EXPRESSION>";
    public static final String TAG_DROP_EXPLORE_DATA_TABLE = "<TAG_DROP_EXPLORE_DATA_TABLE>";
    public static final String TAG_SOURCE_NODE_ID = "<SOURCE_NODE_ID>";
    public static final String TAG_SOURCE_NODE_ID2 = "<SOURCE_NODE_ID2>";
    public static final String TAG_INPUT_DATA = "<INPUT_DATA>";
    public static final String TAG_BUILD_INPUT_ATTRIBUTES = "<BUILD_INPUT_ATTRIBUTES>";
    public static final String TAG_BUILD_TEST_DATA = "<BUILD_TEST_DATA>";
    public static final String TAG_BUILD_TEXT_SETTING = "<BUILD_TEXT_SETTING>";
    public static final String TAG_DATA_USAGE_ATTRIBUTES = "<DATA_USAGE_ATTRIBUTES>";
    public static final String TAG_DATA_USAGE_TRANSFORMATIONS = "<DATA_USAGE_TRANSFORMATIONS>";
    public static final String TAG_CASEID = "<CASEID>";
    public static final String TAG_TARGET = "<TARGET>";
    public static final String TAG_TARGET_DEFINITION = "<TARGET_DEFINITION>";
    public static final String TAG_TARGET_ASSIGNATION = "<TARGET_ASSIGNATION>";
    public static final String TAG_DATA_SPLIT_PERCENT = "<DATA_SPLIT_PERCENT>";
    public static final String TAG_BUILD_MODELS = "<BUILD_MODELS>";
    public static final String TAG_WEIGHTS_SETTING = "<WEIGHTS_SETTING>";
    public static final String TAG_BUILD_SETTING = "<BUILD_SETTING>";
    public static final String TAG_MODEL_NAME = "<MODEL_NAME>";
    public static final String TAG_COMMENT_MODEL = "<COMMENT_MODEL>";
    public static final String TAG_TEST_MODELS = "<TEST_MODELS>";
    public static final String TAG_COST_SETTING = "<COST_SETTING>";
    public static final String TAG_SCORE_CRITERION = "<SCORE_CRITERION>";
    public static final String TAG_COMPUTE_TOTAL_COST = "<COMPUTE_TOTAL_COST>";
    public static final String TAG_TEST_TARGET_VALUES = "<TEST_TARGET_VALUES>";
    public static final String TAG_GEN_LIFT_RESULT = "<GEN_LIFT_RESULT>";
    public static final String TAG_GEN_ROC_RESULT = "<GEN_ROC_RESULT>";
    public static final String TAG_TEST_APPLY_COST_OPTION = "<TEST_APPLY_COST_OPTION>";
    public static final String TAG_AI_RESULT = "<AI_RESULT>";
    public static final String TAG_RESIDUAL_PLOT = "<RESIDUAL_PLOT>";
    public static final String TAG_MINING_FUNCTION = "<MINING_FUNCTION>";
    public static final String TAG_COMPRESSION_METHOD = "<COMPRESSION_METHOD>";
    public static final String TAG_PRIORITY_LEVEL = "<PRIORITY_LEVEL>";
    public static final String TAG_MODEL_NAME_PARAM = "<MODEL_NAME_PARAM>";
    public static final String TAG_DATA_SOURCE_PARAM = "<DATA_SOURCE_PARAM>";
    public static final String GLM_ROW_DIAGNOSTICS_TABLE = "GLM Diagnostics Table";
    public static final String CHECK_SQL_SIZE_START = "_START_CHECK_SQL_SIZE_";
    public static final String CHECK_SQL_SIZE_END = "_END_CHECK_SQL_SIZE_";
    public static final String TEMPLATE_WORKFLOW_RUN = "workflow_run.sql";
    public static final String TEMPLATE_WORKFLOW_DROP = "workflow_drop.sql";
    public static final String TEMPLATE_WORKFLOW_DATA = "workflow_data.sql";
    public static final String TEMPLATE_WORKFLOW_TRANSFORM = "workflow_transform.sql";
    public static final String TEMPLATE_WORKFLOW_CREATETABLE = "workflow_create_table.sql";
    public static final String TEMPLATE_WORKFLOW_CREATEVIEW = "workflow_create_view.sql";
    public static final String TEMPLATE_WORKFLOW_UPDATETABLE = "workflow_update_table.sql";
    public static final String TEMPLATE_WORKFLOW_MODELDETAILS = "workflow_model_details.sql";
    public static final String TEMPLATE_WORKFLOW_EXPLORE = "workflow_explore.sql";
    public static final String TEMPLATE_WORKFLOW_TEXT = "workflow_text.sql";
    public static final String TEMPLATE_WORKFLOW_TEXT_REF = "workflow_text_ref.sql";
    public static final String TEMPLATE_WORKFLOW_ASSOC_BUILD = "workflow_generic_build.sql";
    public static final String TEMPLATE_WORKFLOW_ASSOC_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_CLASS_BUILD = "workflow_class_build.sql";
    public static final String TEMPLATE_WORKFLOW_CLASS_BUILD_MODEL = "workflow_class_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_CLASS_TEST_MODEL = "workflow_class_test_model.sql";
    public static final String TEMPLATE_WORKFLOW_CLASS_TEST_PART_MODEL = "workflow_class_test_part_model.sql";
    public static final String TEMPLATE_WORKFLOW_REGRESS_BUILD = "workflow_regress_build.sql";
    public static final String TEMPLATE_WORKFLOW_REGRESS_BUILD_MODEL = "workflow_regress_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_REGRESS_TEST_MODEL = "workflow_regress_test_model.sql";
    public static final String TEMPLATE_WORKFLOW_REGRESS_TEST_PART_MODEL = "workflow_regress_test_part_model.sql";
    public static final String TEMPLATE_WORKFLOW_ANOMALY_BUILD = "workflow_generic_build.sql";
    public static final String TEMPLATE_WORKFLOW_ANOMALY_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_CLUST_BUILD = "workflow_generic_build.sql";
    public static final String TEMPLATE_WORKFLOW_CLUST_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_FEAT_BUILD = "workflow_generic_build.sql";
    public static final String TEMPLATE_WORKFLOW_FEAT_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_ESA_BUILD = "workflow_generic_build.sql";
    public static final String TEMPLATE_WORKFLOW_ESA_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_R_BUILD = "workflow_r_build.sql";
    public static final String TEMPLATE_WORKFLOW_R_BUILD_MODEL = "workflow_r_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_GENERIC_BUILD_MODEL = "workflow_generic_build_model.sql";
    public static final String TEMPLATE_WORKFLOW_CLASS_TEST = "workflow_class_test.sql";
    public static final String TEMPLATE_WORKFLOW_REGRESS_TEST = "workflow_regress_test.sql";
    public static final String TEMPLATE_WORKFLOW_FILTER_COLUMN = "workflow_filter_column.sql";
    public static final String TEMPLATE_WORKFLOW_FILTER_COLUMN_DETAILS = "workflow_filter_column_details.sql";
    public static final String TEMPLATE_WORKFLOW_MODEL = "workflow_model.sql";
    public static final String TEMPLATE_WORKFLOW_GRAPH = "workflow_model.sql";
    public static final String TEMPLATE_WORKFLOW_SQLQUERY = "workflow_sqlquery.sql";
    private static volatile CodeTemplate _instance = null;

    private CodeTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodeTemplate getInstance() {
        if (_instance != null) return _instance;
        Class<CodeTemplate> clazz = CodeTemplate.class;
        synchronized (CodeTemplate.class) {
            if (_instance != null) return _instance;
            _instance = new CodeTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private static String createScriptTemplate(String string) {
        String string2 = BASE_PATH + string;
        return FileHelper.loadFile(string2);
    }

    public static String updateBodyTemplate(String string, String string2, String string3) {
        return StringUtils.getReplacedString((String)string, (String)string2, (String)(string3 == null ? "" : string3));
    }

    public String getTemplate(String string) {
        String string2 = CodeTemplate.createScriptTemplate(string);
        return string2;
    }

    public String getTemplate(Node node) throws Exception {
        String string = null;
        if (node instanceof BuildTextNodeRef) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_TEXT_REF);
        } else if (node instanceof AbstractTextNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_TEXT);
        } else if (node instanceof ModelNode) {
            string = CodeTemplate.createScriptTemplate("workflow_model.sql");
        } else if (node instanceof ColumnFilterNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_FILTER_COLUMN);
        } else if (node instanceof FilterDetailsDataNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_FILTER_COLUMN_DETAILS);
        } else if (node instanceof DataProfileNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_EXPLORE);
        } else if (node instanceof CreateTableNode) {
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)node.getData();
            string = createTableNodeType.isTable() ? CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_CREATETABLE) : CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_CREATEVIEW);
        } else if (node instanceof UpdateTableNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_UPDATETABLE);
        } else if (node instanceof ModelDetailsDataNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_MODELDETAILS);
        } else if (node instanceof SQLQueryNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_SQLQUERY);
        } else if (node instanceof GraphNode) {
            string = CodeTemplate.createScriptTemplate("workflow_model.sql");
        } else if (node instanceof AbstractTransformNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_TRANSFORM);
        } else if (node instanceof AbstractDataNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_DATA);
        } else if (node instanceof AssociationBuildNode) {
            string = CodeTemplate.createScriptTemplate("workflow_generic_build.sql");
        } else if (node instanceof ClassificationBuildNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_CLASS_BUILD);
        } else if (node instanceof RegressionBuildNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_REGRESS_BUILD);
        } else if (node instanceof AnomalyDetectionBuildNode) {
            string = CodeTemplate.createScriptTemplate("workflow_generic_build.sql");
        } else if (node instanceof ClusteringBuildNode) {
            string = CodeTemplate.createScriptTemplate("workflow_generic_build.sql");
        } else if (node instanceof FeatureExtractionBuildNode) {
            string = CodeTemplate.createScriptTemplate("workflow_generic_build.sql");
        } else if (node instanceof ExplicitFeatureExtractionBuildNode) {
            string = CodeTemplate.createScriptTemplate("workflow_generic_build.sql");
        } else if (node instanceof RBuildNode) {
            string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_R_BUILD);
        } else if (node instanceof TestNode) {
            TestNodeType testNodeType = (TestNodeType)node.getData();
            if (testNodeType.getTestModels().getMiningFunction() == MiningFunctionType.CLASSIFICATION) {
                string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_CLASS_TEST);
            }
            if (testNodeType.getTestModels().getMiningFunction() == MiningFunctionType.REGRESSION) {
                string = CodeTemplate.createScriptTemplate(TEMPLATE_WORKFLOW_REGRESS_TEST);
            }
        }
        return string;
    }

    public static String removeSectionFromTemplate(String string, String string2) {
        return StringUtils.removeSectionFromText((String)string, (String)string2);
    }
}

