/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.core.model.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.NodeNameValidator;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.Model;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelConsumer;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageType;
import oracle.dmt.dataminer.workflow.xmlschema.Messages;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class WorkflowUtils {
    private static final Logger theLogger = Logger.getLogger(WorkflowUtils.class.getName());
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    private static String _tableNamePrefix = "OUTPUT_";
    protected static final String ODMR_USER_WORKFLOW_MODELS = "ODMR_USER_WORKFLOW_MODELS";
    protected static final String MODEL_NAME = "NAME";

    public static WorkflowModel getWorkflowModel(WorkflowNode workflowNode) {
        IlvSDMEngine ilvSDMEngine = workflowNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public static WorkflowModel getWorkflowModel(IlvSDMEngine ilvSDMEngine) {
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        WorkflowModel workflowModel = WorkflowUtils.getFilteredModel(sDMUndoFilter);
        return workflowModel;
    }

    public static IlvPoint getViewPoint(AbstractNode abstractNode, IlvManagerView ilvManagerView) {
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic((Object)abstractNode, true);
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        IlvPoint ilvPoint = ilvGraphic.getCenter(ilvTransformer);
        return ilvPoint;
    }

    public static List<Object> getSelectedObjects(Context context) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        oracle.ide.model.Node node = context.getNode();
        if (node instanceof WorkflowNode) {
            IlvSDMEngine ilvSDMEngine = ((WorkflowNode)node).getEngine();
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    public static WorkflowModel getFilteredModel(SDMUndoFilter sDMUndoFilter) {
        IlvSDMModel ilvSDMModel = sDMUndoFilter.getFilteredModel();
        WorkflowModel workflowModel = (WorkflowModel)ilvSDMModel;
        return workflowModel;
    }

    public static String getTranslatedNodeStatus(NodeStatusType nodeStatusType) {
        String string = "unknown";
        if (nodeStatusType == null) {
            return string;
        }
        if (nodeStatusType.equals((Object)NodeStatusType.READY)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_READY");
        } else if (nodeStatusType.equals((Object)NodeStatusType.COMPLETE)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_COMPLETE");
        } else if (nodeStatusType.equals((Object)NodeStatusType.FAILURE)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_FAILURE");
        } else if (nodeStatusType.equals((Object)NodeStatusType.WARNING)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_WARNING");
        } else if (nodeStatusType.equals((Object)NodeStatusType.INVALID)) {
            string = WorkflowEditorLrb.get("NODE_STATUS_INVALID");
        }
        return string;
    }

    private static ModelNameGeneratingInfo getModelPrefixInfo(WorkflowProcess.Nodes nodes, String string, String string2) {
        ModelNameGeneratingInfo modelNameGeneratingInfo = new ModelNameGeneratingInfo();
        List<Object> list = null;
        if ("ALGO_R_USER_DEFINED".equals(string2)) {
            list = new ArrayList();
            for (RBuildNodeType rBuildNodeType : nodes.getRBuild()) {
                list.addAll(rBuildNodeType.getModels().getRModel());
            }
            switch (string) {
                case "CLASSIFICATION": {
                    modelNameGeneratingInfo.prefix = "R_CLAS";
                    break;
                }
                case "REGRESSION": {
                    modelNameGeneratingInfo.prefix = "R_REGR";
                    break;
                }
                case "CLUSTERING": {
                    modelNameGeneratingInfo.prefix = "R_CLUS";
                    break;
                }
                case "FEATURE_EXTRACTION": {
                    modelNameGeneratingInfo.prefix = "R_FE";
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } else if (string.equals("CLASSIFICATION")) {
            list = WorkflowUtils.findAlgorithmSpecificClassificationModels(nodes, string2);
            if (ServerConstants.Algorithm.isDT((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_DT";
            } else if (ServerConstants.Algorithm.isSVM((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_SVM";
            } else if (ServerConstants.Algorithm.isGLM((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_GLM";
            } else if (ServerConstants.Algorithm.isNB((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLAS_NB";
            }
        } else if (string.equals("REGRESSION")) {
            list = WorkflowUtils.findAlgorithmSpecificRegressionModels(nodes, string2);
            if (ServerConstants.Algorithm.isSVM((String)string2)) {
                modelNameGeneratingInfo.prefix = "REGR_SVM";
            } else if (ServerConstants.Algorithm.isGLM((String)string2)) {
                modelNameGeneratingInfo.prefix = "REGR_GLM";
            }
        } else if (string.equals("CLUSTERING")) {
            list = WorkflowUtils.findAlgorithmSpecificClusteringModels(nodes, string2);
            if (ServerConstants.Algorithm.isKM((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLUS_KM";
            } else if (ServerConstants.Algorithm.isOC((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLUS_OC";
            } else if (ServerConstants.Algorithm.isEM((String)string2)) {
                modelNameGeneratingInfo.prefix = "CLUS_EM";
            }
        } else if (string.equals("FEATURE_EXTRACTION")) {
            list = WorkflowUtils.findAlgorithmSpecificNMFModels(nodes, string2);
            if (ServerConstants.Algorithm.isSVD((String)string2)) {
                modelNameGeneratingInfo.prefix = "FEAT_SVD";
            } else if (ServerConstants.Algorithm.isPCA((String)string2)) {
                modelNameGeneratingInfo.prefix = "FEAT_PCA";
            } else if (ServerConstants.Algorithm.isNMF((String)string2)) {
                modelNameGeneratingInfo.prefix = "FEAT_NMF";
            } else if (ServerConstants.Algorithm.isNMF((String)string2)) {
                modelNameGeneratingInfo.prefix = "FEAT_NMF";
            } else if (ServerConstants.Algorithm.isESA((String)string2)) {
                modelNameGeneratingInfo.prefix = "FEAT_ESA";
            }
        } else if (string.equals("ANOMALY_DETECTION")) {
            list = WorkflowUtils.findAlgorithmSpecificAnomalyModels(nodes, string2);
            modelNameGeneratingInfo.prefix = "ANOM_SVM";
        } else if (string.equals("ASSOCIATION")) {
            list = WorkflowUtils.findAlgorithmSpecificARModels(nodes, string2);
            modelNameGeneratingInfo.prefix = "ASSOC_AP";
        } else {
            modelNameGeneratingInfo.prefix = "";
        }
        modelNameGeneratingInfo.modelStartingIndex = 0;
        modelNameGeneratingInfo.modelStartingIndex = list == null || list.isEmpty() ? 1 : list.size() + 1;
        return modelNameGeneratingInfo;
    }

    public static String getNewModelNameWfid(Context context, Collection<String> collection, String string, String string2) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        WorkflowProcess workflowProcess = ((Workflow)workflowNode.getRepositoryData()).getWorkflowProcess();
        WorkflowProcess.Nodes nodes = workflowProcess.getNodes();
        ModelNameGeneratingInfo modelNameGeneratingInfo = WorkflowUtils.getModelPrefixInfo(nodes, string, string2);
        Object object = modelNameGeneratingInfo.prefix + "_" + modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
        if (collection != null) {
            while (collection.contains(object)) {
                object = modelNameGeneratingInfo.prefix + "_" + ++modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
            }
        } else {
            Collection<String> collection2 = WorkflowUtils.getAllInMemoryModelNames(context);
            while (collection2.contains(object)) {
                object = modelNameGeneratingInfo.prefix + "_" + ++modelNameGeneratingInfo.modelStartingIndex + "_" + bigDecimal.intValue();
            }
        }
        object = WorkflowUtils.checkCreatedModelName(context, modelNameGeneratingInfo.prefix, modelNameGeneratingInfo.modelStartingIndex, bigDecimal.intValue(), collection);
        return object;
    }

    private static String getRenamedModelNamesWfid(Context context, String string, List<String> list, List<String> list2) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        int n = 0;
        String string2 = string;
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        Set<String> set = workflowModel.getAllMiningModels().keySet();
        Collection<String> collection = WorkflowUtils.getAllInMemoryModelNames(context);
        if (!workflowModel.isDuplicateBuildModelName(string2)) {
            collection.remove(string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(collection);
        arrayList.addAll(set);
        arrayList.addAll(list);
        arrayList.addAll(list2);
        boolean bl = false;
        if (string2.length() >= 22) {
            string = string.substring(0, string2.length() - 3);
        }
        while (!bl) {
            if (!arrayList.contains(string2)) {
                bl = true;
                continue;
            }
            string2 = WorkflowUtils.generateName(string, ++n, bigDecimal.intValue(), 25);
        }
        return string2;
    }

    private static String getNewModelNamesWfid(Context context, String string, String string2, List<String> list, List<String> list2) throws Exception {
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        WorkflowProcess workflowProcess = ((Workflow)workflowNode.getRepositoryData()).getWorkflowProcess();
        WorkflowProcess.Nodes nodes = workflowProcess.getNodes();
        ModelNameGeneratingInfo modelNameGeneratingInfo = WorkflowUtils.getModelPrefixInfo(nodes, string, string2);
        Collection<String> collection = WorkflowUtils.getAllInMemoryModelNames(context);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(list2);
        hashSet.addAll(list);
        hashSet.addAll(collection);
        String string3 = String.format("%s_%d_%d", modelNameGeneratingInfo.prefix, modelNameGeneratingInfo.modelStartingIndex, bigDecimal.intValue());
        while (hashSet.contains(string3)) {
            string3 = String.format("%s_%d_%d", modelNameGeneratingInfo.prefix, ++modelNameGeneratingInfo.modelStartingIndex, bigDecimal.intValue());
        }
        return string3;
    }

    public static String checkCreatedModelName(final Context context, final String string, int n, final int n2, final Collection<String> collection) {
        String string2 = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private String _modelName;
            private int _modelIndex;

            Worker() {
            }

            public String getModelName() {
                return this._modelName;
            }

            protected Object doWork() throws Exception {
                try {
                    ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                    ArrayList arrayList = new ArrayList();
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (arrayList.contains(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                    List<String> list = Model.getAllModelNames(connectionFolder);
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (list.contains(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                    this._modelName = WorkflowUtils.composeModelName(string, this._modelIndex, n2);
                    while (collection.contains(this._modelName)) {
                        this._modelName = WorkflowUtils.composeModelName(string, ++this._modelIndex, n2);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    throw exception;
                }
                return this._modelName;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker._modelIndex = n;
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                string2 = worker.getModelName();
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return string2;
    }

    private static String composeModelName(String string, int n, int n2) {
        return string + "_" + n + "_" + n2;
    }

    public static String getNewTableName(Context context, String string) throws Exception {
        String string2 = null;
        String string3 = string == null ? "" : string;
        int n = string3.length();
        if (n > 30) {
            throw new Exception("Unable to create table/view name. Prefix length greater than 30");
        }
        if (n == 0) {
            throw new Exception("Unable to create table/view name. Prefix length equal 0");
        }
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        String string4 = connectionFolder.getUserAccountName();
        boolean bl = true;
        int n2 = 1;
        Object object = string3;
        while (bl) {
            if (DatabaseMetadataUtils.dataSourceExists(connectionFolder, string4, (String)object)) {
                object = string3 + "_" + n2;
                ++n2;
                continue;
            }
            string2 = object;
            bl = false;
        }
        if (string2.length() > 30) {
            throw new Exception("Unable to generate a name under 30 characters.");
        }
        return string2;
    }

    private static List<ModelType> findAlgorithmSpecificARModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getAssociationBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (AssociationBuildNodeType associationBuildNodeType : list) {
            AssociationBuildNodeType.Models models = associationBuildNodeType.getModels();
            arrayList.addAll(models.getAprioriModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificAnomalyModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getAnomalyDetectionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType : list) {
            AnomalyDetectionBuildNodeType.Models models = anomalyDetectionBuildNodeType.getModels();
            arrayList.addAll(models.getAnomalyDetectionModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificNMFModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getFeatureExtractionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (FeatureExtractionBuildNodeType featureExtractionBuildNodeType : list) {
            FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
            arrayList.addAll(models.getNonNegativeMatrixFactorModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificClusteringModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getClusteringBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ClusteringBuildNodeType clusteringBuildNodeType : list) {
            ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isKM((String)string)) {
                arrayList.addAll(models.getKMeansModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isOC((String)string)) continue;
            arrayList.addAll(models.getOClusterModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificRegressionModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getRegressionBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (RegressionBuildNodeType regressionBuildNodeType : list) {
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isSVM((String)string)) {
                arrayList.addAll(models.getRSupportVectorMachineModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isGLM((String)string)) continue;
            arrayList.addAll(models.getRGeneralizedLinearModel());
        }
        return arrayList;
    }

    private static List<ModelType> findAlgorithmSpecificClassificationModels(WorkflowProcess.Nodes nodes, String string) {
        List list = nodes.getClassificationBuild();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        for (ClassificationBuildNodeType classificationBuildNodeType : list) {
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            if (ServerConstants.Algorithm.isDT((String)string)) {
                arrayList.addAll(models.getDecisionTreeModel());
                continue;
            }
            if (ServerConstants.Algorithm.isSVM((String)string)) {
                arrayList.addAll(models.getCSupportVectorMachineModel());
                continue;
            }
            if (ServerConstants.Algorithm.isGLM((String)string)) {
                arrayList.addAll(models.getCGeneralizedLinearModel());
                continue;
            }
            if (!ServerConstants.Algorithm.isNB((String)string)) continue;
            arrayList.addAll(models.getNaiveBayesModel());
        }
        return arrayList;
    }

    public static Map<String, RefModelType> refactorModels(Context context, List<RefModelType> list, WorkflowModel workflowModel, boolean bl) {
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        return WorkflowUtils.refactorModels(context, list, arrayList, workflowModel, bl);
    }

    public static Map<String, RefModelType> refactorModels(final Context context, final List<RefModelType> list, final List<ModelType> list2, final WorkflowModel workflowModel, final boolean bl) {
        Map<String, RefModelType> map = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private Map<String, RefModelType> _renamedModels = new HashMap<String, RefModelType>();

            Worker() {
            }

            public Map<String, RefModelType> getModels() {
                return this._renamedModels;
            }

            public Object doWork() throws Exception {
                ArrayList<String> arrayList = new ArrayList<String>();
                List<String> list3 = null;
                if (!bl) {
                    ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                    RefModelType refModelType = new ArrayList();
                    arrayList.addAll((Collection<String>)refModelType);
                    for (String string : list2) {
                        arrayList.add(string.getName());
                    }
                    list3 = Model.getAllModelNames(connectionFolder);
                }
                for (RefModelType refModelType : list) {
                    String string;
                    String string2 = refModelType.getName();
                    string = workflowModel.getNextNewIdString();
                    refModelType.setModelId(string);
                    if (!bl) {
                        String string3 = WorkflowUtils.getRenamedModelNamesWfid(context, string2, arrayList, list3);
                        refModelType.setName(string3);
                        if (!string3.equals(string2) && workflowModel.isRefactoring()) {
                            workflowModel.addRefactoredModelName(string2, string3);
                        }
                        arrayList.add(string3);
                    }
                    this._renamedModels.put(string2, refModelType);
                }
                return this._renamedModels;
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                worker.start(true);
            } else {
                worker.doWork();
            }
            if (!worker.isCanceled()) {
                map = worker.getModels();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        return map;
    }

    public static void refactorPostProcess(WorkflowModel workflowModel, Collection<Object> collection) {
        Map<String, String> map = workflowModel.getRefactoredTableNames();
        Map<String, String> map2 = workflowModel.getRefactoredModelNames();
        for (Object object : collection) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            TableType tableType;
            Object object8;
            Object object9;
            UpdateTableNodeType updateTableNodeType;
            AbstractNode abstractNode;
            if (object instanceof UpdateTableNode) {
                abstractNode = (UpdateTableNode)object;
                updateTableNodeType = (UpdateTableNodeType)abstractNode.getData();
                object9 = updateTableNodeType.getUpdateTargetTable().getName();
                object8 = map.get(object9);
                if (object8 == null) continue;
                tableType = (TableType)MetaDataHelper.copyMetadataObject(updateTableNodeType.getUpdateTargetTable());
                tableType.setName((String)object8);
                object7 = new HashMap();
                object7.put(tableType, workflowModel.generateNextDistinctName((String)object8));
                object6 = new HashMap<String, Object>();
                object6.put("targetTable", object7);
                object5 = (OdmrSDMUndoFilter)abstractNode.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object5)).prepareUndo(abstractNode, abstractNode.getContext(), UpdateTableNode.UPDATE_TABLE_PROPERTIES, object6);
                continue;
            }
            if (!(object instanceof ModelNode)) continue;
            abstractNode = (ModelNode)object;
            updateTableNodeType = (ModelNodeType)MetaDataHelper.copyMetadataObject(abstractNode.getData());
            object9 = new HashMap();
            object8 = ((AbstractModelNode)abstractNode).getOutputModels(false);
            tableType = object8.iterator();
            while (tableType.hasNext()) {
                object7 = (RefModelType)tableType.next();
                object6 = object7.getName();
                object5 = map2.get(object6);
                if (object5 != null) {
                    object7.setName((String)object5);
                }
                object9.put(object6, object7);
            }
            boolean bl = false;
            object7 = updateTableNodeType.getModels();
            object6 = object7.getModel();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (ModelNodeType.Models.Model)object5.next();
                object3 = object4.getName();
                object2 = map2.get(object3);
                if (object2 == null) continue;
                object4.setName((String)object2);
                bl = true;
            }
            if (!bl) continue;
            object5 = (OdmrSDMUndoFilter)abstractNode.getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object5)).prepareUndo(abstractNode, abstractNode.getContext(), "modelsGroup", object7);
            object4 = abstractNode.findChildNodes();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (AbstractNode)object3.next();
                if (object2 instanceof ModelConsumer) {
                    ((ModelConsumer)object2).refactorModelReferences((Node)object, (Map<String, RefModelType>)object9, false);
                }
                object2.refactor((Node)abstractNode, false);
            }
        }
    }

    public static List<String> getNewModelNames(final Context context, final String string, final List<String> list) {
        List<String> list2 = new ArrayList<String>();
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            private List<String> _modelNames = new ArrayList<String>();

            Worker() {
            }

            public List<String> getModelName() {
                return this._modelNames;
            }

            protected Object doWork() throws Exception {
                try {
                    ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    List<String> list2 = Model.getAllModelNames(connectionFolder);
                    for (String string3 : list) {
                        String string2 = WorkflowUtils.getNewModelNamesWfid(context, string, string3, arrayList, list2);
                        this._modelNames.add(string2);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    throw exception;
                }
                return this._modelNames;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                list2 = worker.getModelName();
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return list2;
    }

    public static Collection<String> getUserWorkflowTableNames(ConnectionManager connectionManager) throws SQLException {
        Connection connection = connectionManager.getConnection();
        try {
            OdmrWorkflow odmrWorkflow = new OdmrWorkflow(connection);
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[1];
            odmrWorkflow.wfGetAllTables(odmrObjectNamesArray);
            String[] stringArray = odmrObjectNamesArray[0].getArray();
            List<String> list = Arrays.asList(stringArray);
            return list;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    public static List<String> getUserWorkflowModelNames(ConnectionManager connectionManager) throws SQLException {
        Connection connection = connectionManager.getConnection();
        try {
            OdmrWorkflow odmrWorkflow = new OdmrWorkflow(connection);
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[1];
            odmrWorkflow.wfGetAllModels(odmrObjectNamesArray);
            String[] stringArray = odmrObjectNamesArray[0].getArray();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    public static boolean validateUserModelName(final Context context, final String string, Component component, final Collection<String> collection, final Collection<String> collection2) {
        class Worker
        extends ProgressRunnable {
            protected boolean isValid = true;
            protected String errorText;

            Worker() {
            }

            protected Object doWork() throws Exception {
                try {
                    if (collection.contains(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_WFCUR");
                        this.isValid = false;
                        return this.isValid;
                    }
                    ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
                    ArrayList arrayList = new ArrayList(collection2);
                    ArrayList arrayList2 = new ArrayList();
                    arrayList.addAll(arrayList2);
                    if (arrayList.contains(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_WFANY");
                        this.isValid = false;
                        return this.isValid;
                    }
                    List<String> list = Model.getAllModelNames(connectionFolder);
                    if (list.contains(string)) {
                        this.errorText = BuildEditorLrb.get("MODEL_NAME_IN_USE_PHYS");
                        this.isValid = false;
                        return this.isValid;
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    throw exception;
                }
                return this.isValid;
            }
        }
        Worker worker = new Worker();
        worker.setTitle(BuildEditorLrb.get("VALIDATE_MODEL_NAME"));
        worker.setMessage(BuildEditorLrb.get("VALIDATE_MODEL_NAME_DESCR"));
        worker.setCancelable(true);
        boolean bl = true;
        try {
            worker.start(true);
            if (!worker.isValid) {
                Component component2;
                Component component3 = component2 = component != null ? component : Ide.getMainWindow();
                if (worker.errorText.equals(BuildEditorLrb.get("MODEL_NAME_IN_USE_WFCUR"))) {
                    MessageDialog.error((Component)component2, (Object)worker.errorText, (String)BuildEditorLrb.get("MODEL_NAME_ERROR_TITLE"), null);
                    bl = false;
                } else {
                    bl = MessageDialog.confirm((Component)component2, (Object)worker.errorText, (String)BuildEditorLrb.get("MODEL_NAME_ERROR_TITLE"), null);
                }
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return bl;
    }

    public static boolean validateNodeName(AbstractNode abstractNode, String string, WorkflowModel workflowModel) {
        boolean bl = true;
        Collection<Object> collection = workflowModel.getObjectsCollection();
        for (Object object : collection) {
            if (!(object instanceof AbstractNode) || !((AbstractNode)object).getData().getName().equals(string) || abstractNode == object) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean validateWorkflowName(ConnectionManager connectionManager, String string, Context context) {
        boolean bl = true;
        String string2 = "";
        try {
            ProjectFolder projectFolder = ProjectFolder.getProjectFolder(context);
            if (string.length() == 0) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_EMPTY"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!WorkflowUtils.validateWorkflowNameLength(string)) {
                bl = false;
                string2 = MessageFormat.format(WorkflowLrb.get("WORKFLOW_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!WorkflowUtils.validateWorkflowNameHasNoSlash(string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_CONTAINS_SLASH"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!WorkflowUtils.validateWorkflowNameUnique(connectionManager, string, projectFolder.getId())) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_NOT_UNIQUE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!WorkflowUtils.validateWorkflowNameLengthAtDB(connectionManager, string)) {
                bl = false;
                string2 = MessageFormat.format(WorkflowLrb.get("WORKFLOW_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!NodeNameValidator.validate(string)) {
                bl = false;
                string2 = DataminerNavigatorLrb.get("INVALID_WORKFLOW_NAME");
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean validateWorkflowNameLength(String string) {
        return string.length() <= 30;
    }

    public static boolean validateWorkflowNameHasNoSlash(String string) {
        return string.indexOf("/") == -1;
    }

    public static boolean validateWorkflowNameLengthAtDB(ConnectionManager connectionManager, String string) {
        return StringUtils.checkStringDBLengthMax(string, connectionManager, 30, true);
    }

    public static boolean validateWorkflowNameUnique(ConnectionManager connectionManager, String string, BigDecimal bigDecimal) throws SQLException {
        List<String> list = Workflow.getWorkflowNames(connectionManager, bigDecimal);
        assert (list != null) : "Unexpected null pointer for project list.";
        return !list.contains(string);
    }

    public static boolean validateWorkflowComment(ConnectionManager connectionManager, String string) {
        boolean bl = true;
        String string2 = "";
        if (!WorkflowUtils.validateCommentLength(string)) {
            bl = false;
            string2 = MessageFormat.format(RepositoryLrb.get("COMMENT_TOO_LONG"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)RepositoryLrb.get("CREATE_WORKFLOW_ERROR_COMMENT"), null);
        } else if (!WorkflowUtils.validateCommentLengthAtDB(connectionManager, string)) {
            bl = false;
            string2 = MessageFormat.format(RepositoryLrb.get("COMMENT_TOO_LONG_BYTES"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)RepositoryLrb.get("CREATE_WORKFLOW_ERROR_COMMENT"), null);
        }
        return bl;
    }

    public static boolean validateCommentLength(String string) {
        return string.length() <= 4000;
    }

    public static boolean validateCommentLengthAtDB(ConnectionManager connectionManager, String string) {
        return StringUtils.checkStringDBLengthMaxLong(string, connectionManager, 4000);
    }

    public static final boolean validateDBObjectName(String string) {
        if (string == null) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (StringUtils.isDoubleQuotedString(string)) {
            string = StringUtils.trimDoubleQuotes(string);
        }
        return string.length() > 0 && StringUtils.containsNoDoubleQuotes(string) && !StringUtils.isDBReservedWord(string);
    }

    public static boolean areEqual(Object object, Object object2) {
        if (object instanceof Messages && object2 instanceof Messages) {
            Messages messages = (Messages)object;
            Messages messages2 = (Messages)object2;
            List list = messages.getMessage();
            List list2 = messages2.getMessage();
            if (list == null && list2 == null) {
                return true;
            }
            if (list.size() == 0 && list2.size() == 0) {
                return true;
            }
            if (list.size() == list2.size()) {
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    MessageType messageType = (MessageType)list.get(i);
                    MessageType messageType2 = (MessageType)list2.get(i);
                    if (!WorkflowUtils.areEqual(messageType.getDisplayValue(), messageType2.getDisplayValue()) || !WorkflowUtils.areEqual(messageType.getErrorDetail(), messageType2.getErrorDetail()) || !WorkflowUtils.areEqual(messageType.getId(), messageType2.getId())) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
        }
        return false;
    }

    public static boolean areEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        return string != null && string2 != null && string.equals(string2);
    }

    public static String getNewOutputTableNameWfid(Context context) throws Exception {
        String string = null;
        class Worker
        extends ProgressRunnable {
            private boolean _canceled;
            String _tableName;
            final /* synthetic */ Context val$ctx;

            Worker(Context context) {
                this.val$ctx = context;
            }

            public String getTableName() {
                return this._tableName;
            }

            protected Object doWork() throws Exception {
                WorkflowNode workflowNode = (WorkflowNode)this.val$ctx.getNode();
                BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
                assert (bigDecimal != null);
                int n = 1;
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                List<String> list = workflowModel.getAllOutputTableNames();
                this._tableName = _tableNamePrefix + (n += list.size()) + "_" + bigDecimal.intValue();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.val$ctx);
                String string = ConnectionFolder.getUserAccountName(this.val$ctx);
                string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
                boolean bl = false;
                while (!bl) {
                    Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connectionFolder, this.val$ctx);
                    while (collection.contains(this._tableName)) {
                        this._tableName = _tableNamePrefix + ++n + "_" + bigDecimal.intValue();
                    }
                    if (this._tableName.length() > 30) {
                        throw new Exception("Unable to generate a name under 30 characters.");
                    }
                    if (DatabaseMetadataUtils.dataSourceExists(connectionFolder, string, this._tableName)) continue;
                    bl = true;
                }
                return this._tableName;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public boolean isCanceled() {
                return this._canceled;
            }
        }
        Worker worker = new Worker(context);
        worker.setTitle(BuildEditorLrb.get("CREATE_NODE"));
        worker.setMessage(BuildEditorLrb.get("CREATE_NODE_DESCR"));
        worker.setCancelable(false);
        try {
            worker.start(true);
            if (!worker.isCanceled()) {
                string = worker.getTableName();
            }
        }
        catch (ProgressException progressException) {
            throw new Exception(progressException.getCause());
        }
        return string;
    }

    public static String getNewOutputTableNameWfidRefactor(String string, Context context) throws Exception {
        return WorkflowUtils.getNewOutputTableNameWfidRefactor(string, context, false, null);
    }

    public static String getNewOutputTableNameWfidRefactor(String string, Context context, boolean bl, AbstractNode abstractNode) throws Exception {
        int n;
        String string2 = string;
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BigDecimal bigDecimal = ((Workflow)workflowNode.getRepositoryData()).getId();
        assert (bigDecimal != null);
        int n2 = bigDecimal.intValue();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        boolean bl2 = SQLHelper.isExpandedObjNameEnabled(context);
        Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connectionFolder, context);
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        List<String> list = workflowModel.getAllOutputTableNames();
        int n3 = 1;
        for (String string3 : list) {
            n = WorkflowUtils.parseWFId(string3);
            if (n != n2) continue;
            n3 = Math.max(n3, WorkflowUtils.parseTableIndex(string3));
        }
        Object object = connectionFolder.getUserAccountName();
        object = StringUtils.isDoubleQuotedString((String)object) ? StringUtils.trimDoubleQuotes((String)object) : ((String)object).toUpperCase();
        boolean bl3 = false;
        while (!bl3) {
            boolean bl4;
            int n4 = n = collection.contains(string2) || list.contains(string2) ? 1 : 0;
            boolean bl5 = bl ? !WorkflowUtils.validateNodeName(abstractNode, string2, workflowModel) : (bl4 = false);
            while (n != 0 || bl4) {
                string2 = WorkflowUtils.generateName(string2, n3++, n2, bl2 ? 128 : 30);
                int n5 = n = collection.contains(string2) || list.contains(string2) ? 1 : 0;
                bl4 = bl ? !WorkflowUtils.validateNodeName(abstractNode, string2, workflowModel) : false;
            }
            if (DatabaseMetadataUtils.dataSourceExists(connectionFolder, (String)object, string2)) continue;
            bl3 = true;
        }
        return string2;
    }

    private static String generateName(String string, int n, int n2, int n3) throws Exception {
        int n4;
        Object object = string;
        int n5 = ((String)object).lastIndexOf("_");
        int n6 = ((String)object).lastIndexOf("_", n5 - 1);
        boolean bl = false;
        if (n6 != -1 && n5 != -1 && n6 != n5 && n5 == (n4 = ((String)object).indexOf("_", n6 + 1))) {
            int n7 = -1;
            int n8 = -1;
            String string2 = ((String)object).substring(n6 + 1, n5);
            try {
                n7 = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                theLogger.log(Level.FINEST, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            String string3 = ((String)object).substring(n5 + 1);
            try {
                n8 = Integer.decode(string3);
            }
            catch (NumberFormatException numberFormatException) {
                theLogger.log(Level.FINEST, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            if (n7 != -1 && n8 != -1) {
                bl = true;
            }
        }
        if (bl) {
            String string4 = ((String)object).substring(0, n6);
            if (((String)(object = string4 + "_" + n + "_" + n2)).length() > n3) {
                String string5 = string4;
                while (((String)object).length() > n3) {
                    if ((string5 = string4.substring(0, string5.length() - 1)).length() == 0) {
                        throw new Exception("Unable to generate a name under 30 characters.");
                    }
                    object = string5 + "_" + n + "_" + n2;
                }
            }
        } else {
            n4 = WorkflowUtils.getLastNumberIndex((String)object);
            if (n4 == -1) {
                object = (String)object + n;
            } else {
                String string6 = ((String)object).substring(0, n4);
                object = string6 + n;
            }
        }
        return object;
    }

    private static int getLastNumberIndex(String string) {
        int n = string.length() - 1;
        if (n == -1) {
            return -1;
        }
        int n2 = -1;
        boolean bl = true;
        while (bl) {
            String string2 = "" + string.charAt(n);
            try {
                Integer.decode(string2);
                n2 = n--;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return n2;
    }

    private static int parseTableIndex(String string) {
        int n;
        int n2 = -1;
        if (string != null && -1 != string.indexOf(_tableNamePrefix) && (n = string.lastIndexOf("_")) != -1) {
            String string2 = string.substring(_tableNamePrefix.length(), n);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        return n2;
    }

    private static int parseWFId(String string) {
        int n;
        int n2 = -1;
        if (string != null && -1 != string.indexOf(_tableNamePrefix) && (n = string.lastIndexOf("_")) != -1) {
            String string2 = string.substring(n + 1, string.length());
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        return n2;
    }

    public static Collection<String> getAllInMemoryModelNames(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<WorkflowEditor> collection = WorkflowUtils.getOpenWorkflowEditors();
        for (WorkflowEditor workflowEditor : collection) {
            URL uRL;
            URL uRL2 = workflowEditor.getContext().getNode().getURL();
            if (!DMURLFormatHelper.isSameConnection(uRL2, uRL = context.getNode().getURL())) continue;
            arrayList.addAll(workflowEditor.getWorkflowNode().getWorkflowModel().getAllMiningModels().keySet());
        }
        return arrayList;
    }

    public static Collection<String> getAllInMemoryTableNames(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<WorkflowEditor> collection = WorkflowUtils.getOpenWorkflowEditors();
        for (WorkflowEditor workflowEditor : collection) {
            URL uRL;
            URL uRL2 = workflowEditor.getContext().getNode().getURL();
            if (!DMURLFormatHelper.isSameConnection(uRL2, uRL = context.getNode().getURL())) continue;
            arrayList.addAll(workflowEditor.getWorkflowNode().getWorkflowModel().getAllOutputTableNames());
        }
        return arrayList;
    }

    private static Collection<WorkflowEditor> getOpenWorkflowEditors() {
        List list;
        EditorManager editorManager = EditorManager.getEditorManager();
        ArrayList<WorkflowEditor> arrayList = new ArrayList<WorkflowEditor>();
        if (!EventQueue.isDispatchThread()) {
            class GetEditors
            implements Runnable {
                private List openEditors;
                final /* synthetic */ EditorManager val$em;

                GetEditors(EditorManager editorManager) {
                    this.val$em = editorManager;
                }

                public List getOpenEditors() {
                    return this.openEditors;
                }

                @Override
                public void run() {
                    this.openEditors = this.val$em.getAllEditors();
                }
            }
            GetEditors getEditors = new GetEditors(editorManager);
            try {
                SwingUtilities.invokeAndWait(getEditors);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                return new ArrayList<WorkflowEditor>();
            }
            list = getEditors.getOpenEditors();
        } else {
            list = editorManager.getAllEditors();
        }
        for (Object e : list) {
            if (!(e instanceof WorkflowEditor)) continue;
            arrayList.add((WorkflowEditor)e);
        }
        return arrayList;
    }

    public static Collection<String> getAllKnownTableNames(ConnectionManager connectionManager, Context context) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(DatabaseMetadataUtils.getUserTablesAndViews(connectionManager));
        arrayList.addAll(WorkflowUtils.getAllInMemoryTableNames(context));
        return arrayList;
    }

    public static Collection<String> getInMemoryModelNames(WorkflowModel workflowModel, BuildNodeType buildNodeType) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(workflowModel.getAllMiningModels().keySet());
        if (buildNodeType != null) {
            treeSet.addAll(MetaDataHelper.getModelNames(buildNodeType));
        }
        return treeSet;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocusInWindow();
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                component2.requestFocusInWindow();
                return component2;
            }
        }
        if (component.isFocusable()) {
            component.requestFocusInWindow();
            return component;
        }
        return null;
    }

    private static class ModelNameGeneratingInfo {
        String prefix;
        int modelStartingIndex;

        private ModelNameGeneratingInfo() {
        }
    }
}

