/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.workflow.RefreshWFInputNodeRecord;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressBar;

public class RefreshWFInputDefThread
implements Runnable {
    private ProgressBar progressBar;
    private Context context;
    private boolean selectedNodesOnly;
    private List<RefreshWFInputNodeRecord> processedNodes = new ArrayList<RefreshWFInputNodeRecord>();
    private int maxRecordToProcess;

    public RefreshWFInputDefThread(Context context, List<RefreshWFInputNodeRecord> list) {
        this.context = context;
        this.processedNodes = list;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public void setSelectedNodesOnly(boolean bl) {
        this.selectedNodesOnly = bl;
    }

    public void setMaxRecordToProcess(int n) {
        this.maxRecordToProcess = n;
    }

    @Override
    public void run() {
        try {
            int n = 0;
            for (RefreshWFInputNodeRecord refreshWFInputNodeRecord : this.processedNodes) {
                List list;
                if (refreshWFInputNodeRecord.getNodeType().equals(RunManagerLrb.get("WORKFLOW_REFRESH_DATA_SOURCE_TYPE"))) {
                    list = DbMetadataUtils.getTableColumnDefinition((ConnectionManager)ConnectionFolder.getConnectionFolder(this.context), (String)refreshWFInputNodeRecord.getDataSourceSchema(), (String)refreshWFInputNodeRecord.getDataSourceTableName());
                    refreshWFInputNodeRecord.setTableCurrentAtts(list);
                } else if (refreshWFInputNodeRecord.getNodeType().equals(RunManagerLrb.get("WORKFLOW_REFRESH_SQL_QUERY_TYPE")) && refreshWFInputNodeRecord.getSQLQueryNode() != null) {
                    list = (Vector)refreshWFInputNodeRecord.getSQLQueryNode().getMetaData();
                    refreshWFInputNodeRecord.setTableCurrentAtts(list);
                }
                this.progressBar.updateProgress(RunManagerLrb.get("WORKFLOW_REFRESH_PROCESSING") + refreshWFInputNodeRecord.getName(), ++n + "/" + this.maxRecordToProcess);
            }
            this.progressBar.setDoneStatus();
        }
        catch (Exception exception) {
            throw new DataMinerException(exception);
        }
    }
}

